<?php

namespace PHPMaker2024\cidp24;

// Page object
$YesnoEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fyesnoedit" id="fyesnoedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { yesno: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fyesnoedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fyesnoedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["ChoiceCode", [fields.ChoiceCode.visible && fields.ChoiceCode.required ? ew.Validators.required(fields.ChoiceCode.caption) : null, ew.Validators.integer], fields.ChoiceCode.isInvalid],
            ["YesNo", [fields.YesNo.visible && fields.YesNo.required ? ew.Validators.required(fields.YesNo.caption) : null], fields.YesNo.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="yesno">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->ChoiceCode->Visible) { // ChoiceCode ?>
    <div id="r_ChoiceCode"<?= $Page->ChoiceCode->rowAttributes() ?>>
        <label id="elh_yesno_ChoiceCode" for="x_ChoiceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ChoiceCode->caption() ?><?= $Page->ChoiceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ChoiceCode->cellAttributes() ?>>
<span id="el_yesno_ChoiceCode">
<input type="<?= $Page->ChoiceCode->getInputTextType() ?>" name="x_ChoiceCode" id="x_ChoiceCode" data-table="yesno" data-field="x_ChoiceCode" value="<?= $Page->ChoiceCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ChoiceCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ChoiceCode->formatPattern()) ?>"<?= $Page->ChoiceCode->editAttributes() ?> aria-describedby="x_ChoiceCode_help">
<?= $Page->ChoiceCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ChoiceCode->getErrorMessage() ?></div>
<input type="hidden" data-table="yesno" data-field="x_ChoiceCode" data-hidden="1" data-old name="o_ChoiceCode" id="o_ChoiceCode" value="<?= HtmlEncode($Page->ChoiceCode->OldValue ?? $Page->ChoiceCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->YesNo->Visible) { // YesNo ?>
    <div id="r_YesNo"<?= $Page->YesNo->rowAttributes() ?>>
        <label id="elh_yesno_YesNo" for="x_YesNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->YesNo->caption() ?><?= $Page->YesNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->YesNo->cellAttributes() ?>>
<span id="el_yesno_YesNo">
<input type="<?= $Page->YesNo->getInputTextType() ?>" name="x_YesNo" id="x_YesNo" data-table="yesno" data-field="x_YesNo" value="<?= $Page->YesNo->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->YesNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->YesNo->formatPattern()) ?>"<?= $Page->YesNo->editAttributes() ?> aria-describedby="x_YesNo_help">
<?= $Page->YesNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->YesNo->getErrorMessage() ?></div>
<input type="hidden" data-table="yesno" data-field="x_YesNo" data-hidden="1" data-old name="o_YesNo" id="o_YesNo" value="<?= HtmlEncode($Page->YesNo->OldValue ?? $Page->YesNo->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fyesnoedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fyesnoedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("yesno");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
