<?php

namespace PHPMaker2024\cidp24;

// Page object
$VillageSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { village: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fvillagesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fvillagesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["Camp", [], fields.Camp.isInvalid],
            ["VillageCode", [ew.Validators.integer], fields.VillageCode.isInvalid],
            ["Village", [], fields.Village.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fvillagesearch" id="fvillagesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="village">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode" class="row"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_village_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProvinceCode" id="z_ProvinceCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProvinceCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_village_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fvillagesearch_x_ProvinceCode"
        <?php } ?>
        data-table="village"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fvillagesearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "fvillagesearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvillagesearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "fvillagesearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "fvillagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.village.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_village_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_village_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fvillagesearch_x_DistrictCode"
        data-table="village"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("fvillagesearch", function() {
    var options = { name: "x_DistrictCode", selectId: "fvillagesearch_x_DistrictCode" };
    if (fvillagesearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "fvillagesearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "fvillagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.village.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode" class="row"<?= $Page->CampCode->rowAttributes() ?>>
        <label for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_village_CampCode"><?= $Page->CampCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_CampCode" id="z_CampCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_village_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="fvillagesearch_x_CampCode"
        <?php } ?>
        data-table="village"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fvillagesearch", function() {
    var options = { name: "x_CampCode", selectId: "fvillagesearch_x_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvillagesearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "fvillagesearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "fvillagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.village.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
    <div id="r_Camp" class="row"<?= $Page->Camp->rowAttributes() ?>>
        <label for="x_Camp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_village_Camp"><?= $Page->Camp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Camp" id="z_Camp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Camp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_village_Camp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="village" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode" class="row"<?= $Page->VillageCode->rowAttributes() ?>>
        <label for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_village_VillageCode"><?= $Page->VillageCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VillageCode" id="z_VillageCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VillageCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_village_VillageCode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->VillageCode->getInputTextType() ?>" name="x_VillageCode" id="x_VillageCode" data-table="village" data-field="x_VillageCode" value="<?= $Page->VillageCode->EditValue ?>" placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->VillageCode->formatPattern()) ?>"<?= $Page->VillageCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
    <div id="r_Village" class="row"<?= $Page->Village->rowAttributes() ?>>
        <label for="x_Village" class="<?= $Page->LeftColumnClass ?>"><span id="elh_village_Village"><?= $Page->Village->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Village" id="z_Village" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Village->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_village_Village" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="village" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fvillagesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fvillagesearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fvillagesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("village");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
