<?php

namespace PHPMaker2024\cidp24;

// Page object
$TrainingAttendeePreview = &$Page;
?>
<script>
ew.deepAssign(ew.vars, { tables: { training_attendee: <?= JsonEncode($Page->toClientVar()) ?> } });
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php if ($Page->TotalRecords > 0) { ?>
<div class="card ew-grid <?= $Page->TableGridClass ?>"><!-- .card -->
<div class="card-header ew-grid-upper-panel ew-preview-upper-panel"><!-- .card-header -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-header -->
<div class="card-body ew-preview-middle-panel ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>"><!-- .card-body -->
<table class="<?= $Page->TableClass ?>"><!-- .table -->
    <thead><!-- Table header -->
        <tr class="ew-table-header">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
    <?php if (!$Page->TrainingRef->Sortable || !$Page->sortUrl($Page->TrainingRef)) { ?>
        <th class="<?= $Page->TrainingRef->headerCellClass() ?>"><?= $Page->TrainingRef->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->TrainingRef->headerCellClass() ?>"><div role="button" data-table="training_attendee" data-sort="<?= HtmlEncode($Page->TrainingRef->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->TrainingRef->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->TrainingRef->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->TrainingRef->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <?php if (!$Page->NRC->Sortable || !$Page->sortUrl($Page->NRC)) { ?>
        <th class="<?= $Page->NRC->headerCellClass() ?>"><?= $Page->NRC->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->NRC->headerCellClass() ?>"><div role="button" data-table="training_attendee" data-sort="<?= HtmlEncode($Page->NRC->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->NRC->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->NRC->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->NRC->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Evaluation->Visible) { // Evaluation ?>
    <?php if (!$Page->Evaluation->Sortable || !$Page->sortUrl($Page->Evaluation)) { ?>
        <th class="<?= $Page->Evaluation->headerCellClass() ?>"><?= $Page->Evaluation->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Evaluation->headerCellClass() ?>"><div role="button" data-table="training_attendee" data-sort="<?= HtmlEncode($Page->Evaluation->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Evaluation->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Evaluation->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Evaluation->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Rating->Visible) { // Rating ?>
    <?php if (!$Page->Rating->Sortable || !$Page->sortUrl($Page->Rating)) { ?>
        <th class="<?= $Page->Rating->headerCellClass() ?>"><?= $Page->Rating->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Rating->headerCellClass() ?>"><div role="button" data-table="training_attendee" data-sort="<?= HtmlEncode($Page->Rating->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Rating->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Rating->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Rating->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
        </tr>
    </thead>
    <tbody><!-- Table body -->
<?php
$Page->RecordCount = 0;
$Page->RowCount = 0;
while ($Page->fetch()) {
    // Init row class and style
    $Page->RecordCount++;
    $Page->RowCount++;
    $Page->CssStyle = "";
    $Page->loadListRowValues($Page->CurrentRow);

    // Render row
    $Page->RowType = RowType::PREVIEW; // Preview record
    $Page->resetAttributes();
    $Page->renderListRow();

    // Set up row attributes
    $Page->RowAttrs->merge([
        "data-rowindex" => $Page->RowCount,
        "class" => ($Page->RowCount % 2 != 1) ? "ew-table-alt-row" : "",

        // Add row attributes for expandable row
        "data-widget" => "expandable-table",
        "aria-expanded" => "false",
    ]);

    // Render list options
    $Page->renderListOptions();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
        <!-- TrainingRef -->
        <td<?= $Page->TrainingRef->cellAttributes() ?>>
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<?= $Page->TrainingRef->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <!-- NRC -->
        <td<?= $Page->NRC->cellAttributes() ?>>
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Evaluation->Visible) { // Evaluation ?>
        <!-- Evaluation -->
        <td<?= $Page->Evaluation->cellAttributes() ?>>
<span<?= $Page->Evaluation->viewAttributes() ?>>
<?= $Page->Evaluation->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Rating->Visible) { // Rating ?>
        <!-- Rating -->
        <td<?= $Page->Rating->cellAttributes() ?>>
<span<?= $Page->Rating->viewAttributes() ?>>
<?= $Page->Rating->getViewValue() ?></span>
</td>
<?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
} // while
?>
    </tbody>
</table><!-- /.table -->
</div><!-- /.card-body -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php } else { // No record ?>
<div class="card border-0"><!-- .card -->
<div class="ew-detail-count"><?= $Language->phrase("NoRecord") ?></div>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card -->
<?php } ?>
<?php
foreach ($Page->DetailCounts as $detailTblVar => $detailCount) {
?>
<div class="ew-detail-count d-none" data-table="<?= $detailTblVar ?>" data-count="<?= $detailCount ?>"><?= FormatInteger($detailCount) ?></div>
<?php
}
?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php
$Page->Recordset?->free();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
