<?php

namespace PHPMaker2024\cidp24;

// Page object
$TrainingAttendeeList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { training_attendee: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["TrainingRef", [fields.TrainingRef.visible && fields.TrainingRef.required ? ew.Validators.required(fields.TrainingRef.caption) : null, ew.Validators.integer], fields.TrainingRef.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["Evaluation", [fields.Evaluation.visible && fields.Evaluation.required ? ew.Validators.required(fields.Evaluation.caption) : null], fields.Evaluation.isInvalid],
            ["Rating", [fields.Rating.visible && fields.Rating.required ? ew.Validators.required(fields.Rating.caption) : null, ew.Validators.float], fields.Rating.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["TrainingRef",false],["NRC",false],["Evaluation",false],["Rating",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "training_course") {
    if ($Page->MasterRecordExists) {
        include_once "views/TrainingCourseMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ftraining_attendeesrch" id="ftraining_attendeesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ftraining_attendeesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { training_attendee: currentTable } });
var currentForm;
var ftraining_attendeesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ftraining_attendeesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ftraining_attendeesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ftraining_attendeesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ftraining_attendeesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ftraining_attendeesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="training_attendee">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "training_course" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="training_course">
<input type="hidden" name="fk_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_training_attendee" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_training_attendeelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
        <th data-name="TrainingRef" class="<?= $Page->TrainingRef->headerCellClass() ?>"><div id="elh_training_attendee_TrainingRef" class="training_attendee_TrainingRef"><?= $Page->renderFieldHeader($Page->TrainingRef) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_training_attendee_NRC" class="training_attendee_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->Evaluation->Visible) { // Evaluation ?>
        <th data-name="Evaluation" class="<?= $Page->Evaluation->headerCellClass() ?>"><div id="elh_training_attendee_Evaluation" class="training_attendee_Evaluation"><?= $Page->renderFieldHeader($Page->Evaluation) ?></div></th>
<?php } ?>
<?php if ($Page->Rating->Visible) { // Rating ?>
        <th data-name="Rating" class="<?= $Page->Rating->headerCellClass() ?>"><div id="elh_training_attendee_Rating" class="training_attendee_Rating"><?= $Page->renderFieldHeader($Page->Rating) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->TrainingRef->Visible) { // TrainingRef ?>
        <td data-name="TrainingRef"<?= $Page->TrainingRef->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->TrainingRef->getSessionValue() != "") { ?>
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TrainingRef->getDisplayValue($Page->TrainingRef->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_TrainingRef" name="x<?= $Page->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_TrainingRef" class="el_training_attendee_TrainingRef">
<input type="<?= $Page->TrainingRef->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TrainingRef" id="x<?= $Page->RowIndex ?>_TrainingRef" data-table="training_attendee" data-field="x_TrainingRef" value="<?= $Page->TrainingRef->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TrainingRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TrainingRef->formatPattern()) ?>"<?= $Page->TrainingRef->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TrainingRef->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TrainingRef" id="o<?= $Page->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_TrainingRef" class="el_training_attendee_TrainingRef">
<?php if ($Page->TrainingRef->getSessionValue() != "") { ?>
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TrainingRef->getDisplayValue($Page->TrainingRef->EditValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_TrainingRef" name="x<?= $Page->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Page->TrainingRef->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TrainingRef" id="x<?= $Page->RowIndex ?>_TrainingRef" data-table="training_attendee" data-field="x_TrainingRef" value="<?= $Page->TrainingRef->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TrainingRef->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TrainingRef->formatPattern()) ?>"<?= $Page->TrainingRef->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TrainingRef->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TrainingRef" id="o<?= $Page->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->OldValue ?? $Page->TrainingRef->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_TrainingRef" class="el_training_attendee_TrainingRef">
<span<?= $Page->TrainingRef->viewAttributes() ?>>
<?= $Page->TrainingRef->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="training_attendee" data-field="x_TrainingRef" data-hidden="1" name="x<?= $Page->RowIndex ?>_TrainingRef" id="x<?= $Page->RowIndex ?>_TrainingRef" value="<?= HtmlEncode($Page->TrainingRef->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_NRC" class="el_training_attendee_NRC">
    <select
        id="x<?= $Page->RowIndex ?>_NRC"
        name="x<?= $Page->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC"
        <?php } ?>
        data-table="training_attendee"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x{$Page->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_NRC", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_attendee.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_NRC" class="el_training_attendee_NRC">
    <select
        id="x<?= $Page->RowIndex ?>_NRC"
        name="x<?= $Page->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC"
        <?php } ?>
        data-table="training_attendee"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x{$Page->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_NRC", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_NRC", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.training_attendee.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue ?? $Page->NRC->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_NRC" class="el_training_attendee_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="training_attendee" data-field="x_NRC" data-hidden="1" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->Evaluation->Visible) { // Evaluation ?>
        <td data-name="Evaluation"<?= $Page->Evaluation->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_Evaluation" class="el_training_attendee_Evaluation">
<textarea data-table="training_attendee" data-field="x_Evaluation" name="x<?= $Page->RowIndex ?>_Evaluation" id="x<?= $Page->RowIndex ?>_Evaluation" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->Evaluation->getPlaceHolder()) ?>"<?= $Page->Evaluation->editAttributes() ?>><?= $Page->Evaluation->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Evaluation->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="training_attendee" data-field="x_Evaluation" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Evaluation" id="o<?= $Page->RowIndex ?>_Evaluation" value="<?= HtmlEncode($Page->Evaluation->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_Evaluation" class="el_training_attendee_Evaluation">
<textarea data-table="training_attendee" data-field="x_Evaluation" name="x<?= $Page->RowIndex ?>_Evaluation" id="x<?= $Page->RowIndex ?>_Evaluation" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->Evaluation->getPlaceHolder()) ?>"<?= $Page->Evaluation->editAttributes() ?>><?= $Page->Evaluation->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Evaluation->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_Evaluation" class="el_training_attendee_Evaluation">
<span<?= $Page->Evaluation->viewAttributes() ?>>
<?= $Page->Evaluation->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Rating->Visible) { // Rating ?>
        <td data-name="Rating"<?= $Page->Rating->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_Rating" class="el_training_attendee_Rating">
<input type="<?= $Page->Rating->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Rating" id="x<?= $Page->RowIndex ?>_Rating" data-table="training_attendee" data-field="x_Rating" value="<?= $Page->Rating->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Rating->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Rating->formatPattern()) ?>"<?= $Page->Rating->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Rating->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="training_attendee" data-field="x_Rating" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Rating" id="o<?= $Page->RowIndex ?>_Rating" value="<?= HtmlEncode($Page->Rating->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_Rating" class="el_training_attendee_Rating">
<input type="<?= $Page->Rating->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Rating" id="x<?= $Page->RowIndex ?>_Rating" data-table="training_attendee" data-field="x_Rating" value="<?= $Page->Rating->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Rating->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Rating->formatPattern()) ?>"<?= $Page->Rating->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Rating->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_training_attendee_Rating" class="el_training_attendee_Rating">
<span<?= $Page->Rating->viewAttributes() ?>>
<?= $Page->Rating->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("training_attendee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
