<?php

namespace PHPMaker2024\cidp24;

// Page object
$SupplierSummaryViewList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { supplier_summary_view: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
            "NurseryName": <?= $Page->NurseryName->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fsupplier_summary_viewsrch" id="fsupplier_summary_viewsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fsupplier_summary_viewsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { supplier_summary_view: currentTable } });
var currentForm;
var fsupplier_summary_viewsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fsupplier_summary_viewsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
            "NurseryName": <?= $Page->NurseryName->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fsupplier_summary_viewsrch_x_DistrictName"
            data-table="supplier_summary_view"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fsupplier_summary_viewsrch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fsupplier_summary_viewsrch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fsupplier_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.supplier_summary_view.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
<?php
if (!$Page->FarmingSeason->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmingSeason" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmingSeason->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmingSeason"
            name="x_FarmingSeason[]"
            class="form-control ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
            data-select2-id="fsupplier_summary_viewsrch_x_FarmingSeason"
            data-table="supplier_summary_view"
            data-field="x_FarmingSeason"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmingSeason->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmingSeason->editAttributes() ?>>
            <?= $Page->FarmingSeason->selectOptionListHtml("x_FarmingSeason", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fsupplier_summary_viewsrch", function() {
            var options = {
                name: "x_FarmingSeason",
                selectId: "fsupplier_summary_viewsrch_x_FarmingSeason",
                ajax: { id: "x_FarmingSeason", form: "fsupplier_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.supplier_summary_view.fields.FarmingSeason.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
<?php
if (!$Page->SeedType->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_SeedType" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->SeedType->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_SeedType"
            name="x_SeedType[]"
            class="form-control ew-select<?= $Page->SeedType->isInvalidClass() ?>"
            data-select2-id="fsupplier_summary_viewsrch_x_SeedType"
            data-table="supplier_summary_view"
            data-field="x_SeedType"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->SeedType->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->SeedType->editAttributes() ?>>
            <?= $Page->SeedType->selectOptionListHtml("x_SeedType", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fsupplier_summary_viewsrch", function() {
            var options = {
                name: "x_SeedType",
                selectId: "fsupplier_summary_viewsrch_x_SeedType",
                ajax: { id: "x_SeedType", form: "fsupplier_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.supplier_summary_view.fields.SeedType.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NurseryName->Visible) { // NurseryName ?>
<?php
if (!$Page->NurseryName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NurseryName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NurseryName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NurseryName"
            name="x_NurseryName[]"
            class="form-control ew-select<?= $Page->NurseryName->isInvalidClass() ?>"
            data-select2-id="fsupplier_summary_viewsrch_x_NurseryName"
            data-table="supplier_summary_view"
            data-field="x_NurseryName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NurseryName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NurseryName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NurseryName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NurseryName->editAttributes() ?>>
            <?= $Page->NurseryName->selectOptionListHtml("x_NurseryName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NurseryName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fsupplier_summary_viewsrch", function() {
            var options = {
                name: "x_NurseryName",
                selectId: "fsupplier_summary_viewsrch_x_NurseryName",
                ajax: { id: "x_NurseryName", form: "fsupplier_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.supplier_summary_view.fields.NurseryName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fsupplier_summary_viewsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fsupplier_summary_viewsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fsupplier_summary_viewsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fsupplier_summary_viewsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="supplier_summary_view">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_supplier_summary_view" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_supplier_summary_viewlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div id="elh_supplier_summary_view_DistrictName" class="supplier_summary_view_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { // NoOfBeneficiaries ?>
        <th data-name="NoOfBeneficiaries" class="<?= $Page->NoOfBeneficiaries->headerCellClass() ?>"><div id="elh_supplier_summary_view_NoOfBeneficiaries" class="supplier_summary_view_NoOfBeneficiaries"><?= $Page->renderFieldHeader($Page->NoOfBeneficiaries) ?></div></th>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { // Seedlings ?>
        <th data-name="Seedlings" class="<?= $Page->Seedlings->headerCellClass() ?>"><div id="elh_supplier_summary_view_Seedlings" class="supplier_summary_view_Seedlings"><?= $Page->renderFieldHeader($Page->Seedlings) ?></div></th>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div id="elh_supplier_summary_view_FarmingSeason" class="supplier_summary_view_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
        <th data-name="SeedType" class="<?= $Page->SeedType->headerCellClass() ?>"><div id="elh_supplier_summary_view_SeedType" class="supplier_summary_view_SeedType"><?= $Page->renderFieldHeader($Page->SeedType) ?></div></th>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { // NurseryName ?>
        <th data-name="NurseryName" class="<?= $Page->NurseryName->headerCellClass() ?>"><div id="elh_supplier_summary_view_NurseryName" class="supplier_summary_view_NurseryName"><?= $Page->renderFieldHeader($Page->NurseryName) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <td data-name="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_supplier_summary_view_DistrictName" class="el_supplier_summary_view_DistrictName">
<span<?= $Page->DistrictName->viewAttributes() ?>>
<?= $Page->DistrictName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NoOfBeneficiaries->Visible) { // NoOfBeneficiaries ?>
        <td data-name="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_supplier_summary_view_NoOfBeneficiaries" class="el_supplier_summary_view_NoOfBeneficiaries">
<span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>>
<?= $Page->NoOfBeneficiaries->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Seedlings->Visible) { // Seedlings ?>
        <td data-name="Seedlings"<?= $Page->Seedlings->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_supplier_summary_view_Seedlings" class="el_supplier_summary_view_Seedlings">
<span<?= $Page->Seedlings->viewAttributes() ?>>
<?= $Page->Seedlings->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_supplier_summary_view_FarmingSeason" class="el_supplier_summary_view_FarmingSeason">
<span<?= $Page->FarmingSeason->viewAttributes() ?>>
<?= $Page->FarmingSeason->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType"<?= $Page->SeedType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_supplier_summary_view_SeedType" class="el_supplier_summary_view_SeedType">
<span<?= $Page->SeedType->viewAttributes() ?>>
<?= $Page->SeedType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NurseryName->Visible) { // NurseryName ?>
        <td data-name="NurseryName"<?= $Page->NurseryName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_supplier_summary_view_NurseryName" class="el_supplier_summary_view_NurseryName">
<span<?= $Page->NurseryName->viewAttributes() ?>>
<?= $Page->NurseryName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("supplier_summary_view");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
