<?php

namespace PHPMaker2024\cidp24;

// Page object
$SecurityMatrixList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { security_matrix: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["UserCode", [fields.UserCode.visible && fields.UserCode.required ? ew.Validators.required(fields.UserCode.caption) : null, ew.Validators.integer], fields.UserCode.isInvalid],
            ["Security_number", [fields.Security_number.visible && fields.Security_number.required ? ew.Validators.required(fields.Security_number.caption) : null], fields.Security_number.isInvalid],
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["UserCode",false],["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "musers") {
    if ($Page->MasterRecordExists) {
        include_once "views/MusersMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="security_matrix">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "musers" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="musers">
<input type="hidden" name="fk_UserCode" value="<?= HtmlEncode($Page->UserCode->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_security_matrix" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_security_matrixlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->UserCode->Visible) { // UserCode ?>
        <th data-name="UserCode" class="<?= $Page->UserCode->headerCellClass() ?>"><div id="elh_security_matrix_UserCode" class="security_matrix_UserCode"><?= $Page->renderFieldHeader($Page->UserCode) ?></div></th>
<?php } ?>
<?php if ($Page->Security_number->Visible) { // Security_number ?>
        <th data-name="Security_number" class="<?= $Page->Security_number->headerCellClass() ?>"><div id="elh_security_matrix_Security_number" class="security_matrix_Security_number"><?= $Page->renderFieldHeader($Page->Security_number) ?></div></th>
<?php } ?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_security_matrix_ProvinceCode" class="security_matrix_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_security_matrix_DistrictCode" class="security_matrix_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_security_matrix_CampCode" class="security_matrix_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_security_matrix_VillageCode" class="security_matrix_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->UserCode->Visible) { // UserCode ?>
        <td data-name="UserCode"<?= $Page->UserCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->UserCode->getSessionValue() != "") { ?>
<span<?= $Page->UserCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->UserCode->getDisplayValue($Page->UserCode->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_UserCode" name="x<?= $Page->RowIndex ?>_UserCode" value="<?= HtmlEncode($Page->UserCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_UserCode" class="el_security_matrix_UserCode">
<input type="<?= $Page->UserCode->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_UserCode" id="x<?= $Page->RowIndex ?>_UserCode" data-table="security_matrix" data-field="x_UserCode" value="<?= $Page->UserCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->UserCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->UserCode->formatPattern()) ?>"<?= $Page->UserCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->UserCode->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="security_matrix" data-field="x_UserCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_UserCode" id="o<?= $Page->RowIndex ?>_UserCode" value="<?= HtmlEncode($Page->UserCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->UserCode->getSessionValue() != "") { ?>
<span<?= $Page->UserCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->UserCode->getDisplayValue($Page->UserCode->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_UserCode" name="x<?= $Page->RowIndex ?>_UserCode" value="<?= HtmlEncode($Page->UserCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_UserCode" class="el_security_matrix_UserCode">
<input type="<?= $Page->UserCode->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_UserCode" id="x<?= $Page->RowIndex ?>_UserCode" data-table="security_matrix" data-field="x_UserCode" value="<?= $Page->UserCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->UserCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->UserCode->formatPattern()) ?>"<?= $Page->UserCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->UserCode->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_UserCode" class="el_security_matrix_UserCode">
<span<?= $Page->UserCode->viewAttributes() ?>>
<?= $Page->UserCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Security_number->Visible) { // Security_number ?>
        <td data-name="Security_number"<?= $Page->Security_number->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_Security_number" class="el_security_matrix_Security_number"></span>
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Security_number" id="o<?= $Page->RowIndex ?>_Security_number" value="<?= HtmlEncode($Page->Security_number->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_Security_number" class="el_security_matrix_Security_number">
<span<?= $Page->Security_number->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->Security_number->getDisplayValue($Page->Security_number->EditValue))) ?>"></span>
<input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" name="x<?= $Page->RowIndex ?>_Security_number" id="x<?= $Page->RowIndex ?>_Security_number" value="<?= HtmlEncode($Page->Security_number->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_Security_number" class="el_security_matrix_Security_number">
<span<?= $Page->Security_number->viewAttributes() ?>>
<?= $Page->Security_number->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="security_matrix" data-field="x_Security_number" data-hidden="1" name="x<?= $Page->RowIndex ?>_Security_number" id="x<?= $Page->RowIndex ?>_Security_number" value="<?= HtmlEncode($Page->Security_number->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_ProvinceCode" class="el_security_matrix_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="security_matrix"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.security_matrix.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProvinceCode" id="o<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_ProvinceCode" class="el_security_matrix_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="security_matrix"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.security_matrix.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_ProvinceCode" class="el_security_matrix_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_DistrictCode" class="el_security_matrix_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        data-table="security_matrix"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" };
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_DistrictCode" class="el_security_matrix_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        data-table="security_matrix"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" };
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_DistrictCode" class="el_security_matrix_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_CampCode" class="el_security_matrix_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="security_matrix"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_CampCode" class="el_security_matrix_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="security_matrix"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_CampCode" class="el_security_matrix_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_VillageCode" class="el_security_matrix_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="security_matrix"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="security_matrix" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_VillageCode" class="el_security_matrix_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="security_matrix"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.security_matrix.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_security_matrix_VillageCode" class="el_security_matrix_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("security_matrix");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
