<?php

namespace PHPMaker2024\cidp24;

// Page object
$Season2021Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { season20_21: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fseason20_21search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fseason20_21search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["SerialNo", [ew.Validators.integer], fields.SerialNo.isInvalid],
            ["IPC", [], fields.IPC.isInvalid],
            ["PageNo", [ew.Validators.integer], fields.PageNo.isInvalid],
            ["Activity", [], fields.Activity.isInvalid],
            ["District", [], fields.District.isInvalid],
            ["Block", [], fields.Block.isInvalid],
            ["Camp", [], fields.Camp.isInvalid],
            ["NurseryArea", [], fields.NurseryArea.isInvalid],
            ["Zone", [], fields.Zone.isInvalid],
            ["ChiefArea", [], fields.ChiefArea.isInvalid],
            ["Date", [], fields.Date.isInvalid],
            ["Village", [], fields.Village.isInvalid],
            ["NameOfFarmer", [], fields.NameOfFarmer.isInvalid],
            ["YearOfBirth", [ew.Validators.integer], fields.YearOfBirth.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["SeedlingsReceived20_21", [ew.Validators.integer], fields.SeedlingsReceived20_21.isInvalid],
            ["FieldType", [], fields.FieldType.isInvalid],
            ["Contact", [], fields.Contact.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fseason20_21search" id="fseason20_21search" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("Season2021List")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="season20_21">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_season20_21_SerialNo" class="season20_21search"><span id="el_season20_21_SerialNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SerialNo->getInputTextType() ?>" name="x_SerialNo" id="x_SerialNo" data-table="season20_21" data-field="x_SerialNo" value="<?= $Page->SerialNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SerialNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SerialNo->formatPattern()) ?>"<?= $Page->SerialNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SerialNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_IPC" class="season20_21search"><span id="el_season20_21_IPC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IPC->getInputTextType() ?>" name="x_IPC" id="x_IPC" data-table="season20_21" data-field="x_IPC" value="<?= $Page->IPC->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->IPC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IPC->formatPattern()) ?>"<?= $Page->IPC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IPC->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_PageNo" class="season20_21search"><span id="el_season20_21_PageNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PageNo->getInputTextType() ?>" name="x_PageNo" id="x_PageNo" data-table="season20_21" data-field="x_PageNo" value="<?= $Page->PageNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PageNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PageNo->formatPattern()) ?>"<?= $Page->PageNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PageNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Activity" class="season20_21search"><span id="el_season20_21_Activity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Activity->getInputTextType() ?>" name="x_Activity" id="x_Activity" data-table="season20_21" data-field="x_Activity" value="<?= $Page->Activity->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Activity->formatPattern()) ?>"<?= $Page->Activity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_District" class="season20_21search"><span id="el_season20_21_District" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->District->getInputTextType() ?>" name="x_District" id="x_District" data-table="season20_21" data-field="x_District" value="<?= $Page->District->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->District->formatPattern()) ?>"<?= $Page->District->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->District->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Block" class="season20_21search"><span id="el_season20_21_Block" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Block->getInputTextType() ?>" name="x_Block" id="x_Block" data-table="season20_21" data-field="x_Block" value="<?= $Page->Block->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Block->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Block->formatPattern()) ?>"<?= $Page->Block->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Block->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Camp" class="season20_21search"><span id="el_season20_21_Camp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="season20_21" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_NurseryArea" class="season20_21search"><span id="el_season20_21_NurseryArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NurseryArea->getInputTextType() ?>" name="x_NurseryArea" id="x_NurseryArea" data-table="season20_21" data-field="x_NurseryArea" value="<?= $Page->NurseryArea->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NurseryArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NurseryArea->formatPattern()) ?>"<?= $Page->NurseryArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NurseryArea->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Zone" class="season20_21search"><span id="el_season20_21_Zone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Zone->getInputTextType() ?>" name="x_Zone" id="x_Zone" data-table="season20_21" data-field="x_Zone" value="<?= $Page->Zone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Zone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Zone->formatPattern()) ?>"<?= $Page->Zone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Zone->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_ChiefArea" class="season20_21search"><span id="el_season20_21_ChiefArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ChiefArea->getInputTextType() ?>" name="x_ChiefArea" id="x_ChiefArea" data-table="season20_21" data-field="x_ChiefArea" value="<?= $Page->ChiefArea->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ChiefArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ChiefArea->formatPattern()) ?>"<?= $Page->ChiefArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ChiefArea->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Date" class="season20_21search"><span id="el_season20_21_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date->getInputTextType() ?>" name="x_Date" id="x_Date" data-table="season20_21" data-field="x_Date" value="<?= $Page->Date->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date->formatPattern()) ?>"<?= $Page->Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Village" class="season20_21search"><span id="el_season20_21_Village" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="season20_21" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_NameOfFarmer" class="season20_21search"><span id="el_season20_21_NameOfFarmer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NameOfFarmer->getInputTextType() ?>" name="x_NameOfFarmer" id="x_NameOfFarmer" data-table="season20_21" data-field="x_NameOfFarmer" value="<?= $Page->NameOfFarmer->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NameOfFarmer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NameOfFarmer->formatPattern()) ?>"<?= $Page->NameOfFarmer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NameOfFarmer->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_YearOfBirth" class="season20_21search"><span id="el_season20_21_YearOfBirth" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->YearOfBirth->getInputTextType() ?>" name="x_YearOfBirth" id="x_YearOfBirth" data-table="season20_21" data-field="x_YearOfBirth" value="<?= $Page->YearOfBirth->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->YearOfBirth->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->YearOfBirth->formatPattern()) ?>"<?= $Page->YearOfBirth->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->YearOfBirth->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Gender" class="season20_21search"><span id="el_season20_21_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="season20_21" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_NRC" class="season20_21search"><span id="el_season20_21_NRC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="season20_21" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_SeedlingsReceived20_21" class="season20_21search"><span id="el_season20_21_SeedlingsReceived20_21" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsReceived20_21->getInputTextType() ?>" name="x_SeedlingsReceived20_21" id="x_SeedlingsReceived20_21" data-table="season20_21" data-field="x_SeedlingsReceived20_21" value="<?= $Page->SeedlingsReceived20_21->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived20_21->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived20_21->formatPattern()) ?>"<?= $Page->SeedlingsReceived20_21->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived20_21->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_FieldType" class="season20_21search"><span id="el_season20_21_FieldType" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FieldType->getInputTextType() ?>" name="x_FieldType" id="x_FieldType" data-table="season20_21" data-field="x_FieldType" value="<?= $Page->FieldType->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FieldType->formatPattern()) ?>"<?= $Page->FieldType->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season20_21_Contact" class="season20_21search"><span id="el_season20_21_Contact" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Contact->getInputTextType() ?>" name="x_Contact" id="x_Contact" data-table="season20_21" data-field="x_Contact" value="<?= $Page->Contact->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Contact->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Contact->formatPattern()) ?>"<?= $Page->Contact->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Contact->getErrorMessage(false) ?></div>
</span></template>
<div id="season20_21_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "SerialNo",
                type: "integer",
                label: currentTable.fields.SerialNo.caption,
                operators: currentTable.fields.SerialNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.SerialNo.validators),
                data: {
                    format: currentTable.fields.SerialNo.clientFormatPattern
                }
            },
            {
                id: "IPC",
                type: "string",
                label: currentTable.fields.IPC.caption,
                operators: currentTable.fields.IPC.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.IPC.validators),
                data: {
                    format: currentTable.fields.IPC.clientFormatPattern
                }
            },
            {
                id: "PageNo",
                type: "integer",
                label: currentTable.fields.PageNo.caption,
                operators: currentTable.fields.PageNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.PageNo.validators),
                data: {
                    format: currentTable.fields.PageNo.clientFormatPattern
                }
            },
            {
                id: "Activity",
                type: "string",
                label: currentTable.fields.Activity.caption,
                operators: currentTable.fields.Activity.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Activity.validators),
                data: {
                    format: currentTable.fields.Activity.clientFormatPattern
                }
            },
            {
                id: "District",
                type: "string",
                label: currentTable.fields.District.caption,
                operators: currentTable.fields.District.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.District.validators),
                data: {
                    format: currentTable.fields.District.clientFormatPattern
                }
            },
            {
                id: "Block",
                type: "string",
                label: currentTable.fields.Block.caption,
                operators: currentTable.fields.Block.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Block.validators),
                data: {
                    format: currentTable.fields.Block.clientFormatPattern
                }
            },
            {
                id: "Camp",
                type: "string",
                label: currentTable.fields.Camp.caption,
                operators: currentTable.fields.Camp.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Camp.validators),
                data: {
                    format: currentTable.fields.Camp.clientFormatPattern
                }
            },
            {
                id: "NurseryArea",
                type: "string",
                label: currentTable.fields.NurseryArea.caption,
                operators: currentTable.fields.NurseryArea.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.NurseryArea.validators),
                data: {
                    format: currentTable.fields.NurseryArea.clientFormatPattern
                }
            },
            {
                id: "Zone",
                type: "string",
                label: currentTable.fields.Zone.caption,
                operators: currentTable.fields.Zone.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Zone.validators),
                data: {
                    format: currentTable.fields.Zone.clientFormatPattern
                }
            },
            {
                id: "ChiefArea",
                type: "string",
                label: currentTable.fields.ChiefArea.caption,
                operators: currentTable.fields.ChiefArea.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.ChiefArea.validators),
                data: {
                    format: currentTable.fields.ChiefArea.clientFormatPattern
                }
            },
            {
                id: "Date",
                type: "string",
                label: currentTable.fields.Date.caption,
                operators: currentTable.fields.Date.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Date.validators),
                data: {
                    format: currentTable.fields.Date.clientFormatPattern
                }
            },
            {
                id: "Village",
                type: "string",
                label: currentTable.fields.Village.caption,
                operators: currentTable.fields.Village.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Village.validators),
                data: {
                    format: currentTable.fields.Village.clientFormatPattern
                }
            },
            {
                id: "NameOfFarmer",
                type: "string",
                label: currentTable.fields.NameOfFarmer.caption,
                operators: currentTable.fields.NameOfFarmer.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.NameOfFarmer.validators),
                data: {
                    format: currentTable.fields.NameOfFarmer.clientFormatPattern
                }
            },
            {
                id: "YearOfBirth",
                type: "integer",
                label: currentTable.fields.YearOfBirth.caption,
                operators: currentTable.fields.YearOfBirth.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.YearOfBirth.validators),
                data: {
                    format: currentTable.fields.YearOfBirth.clientFormatPattern
                }
            },
            {
                id: "Gender",
                type: "string",
                label: currentTable.fields.Gender.caption,
                operators: currentTable.fields.Gender.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Gender.validators),
                data: {
                    format: currentTable.fields.Gender.clientFormatPattern
                }
            },
            {
                id: "NRC",
                type: "string",
                label: currentTable.fields.NRC.caption,
                operators: currentTable.fields.NRC.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.NRC.validators),
                data: {
                    format: currentTable.fields.NRC.clientFormatPattern
                }
            },
            {
                id: "SeedlingsReceived20_21",
                type: "integer",
                label: currentTable.fields.SeedlingsReceived20_21.caption,
                operators: currentTable.fields.SeedlingsReceived20_21.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.SeedlingsReceived20_21.validators),
                data: {
                    format: currentTable.fields.SeedlingsReceived20_21.clientFormatPattern
                }
            },
            {
                id: "FieldType",
                type: "string",
                label: currentTable.fields.FieldType.caption,
                operators: currentTable.fields.FieldType.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.FieldType.validators),
                data: {
                    format: currentTable.fields.FieldType.clientFormatPattern
                }
            },
            {
                id: "Contact",
                type: "string",
                label: currentTable.fields.Contact.caption,
                operators: currentTable.fields.Contact.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason20_21search.fields.Contact.validators),
                data: {
                    format: currentTable.fields.Contact.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#season20_21_query_builder"),
        args = {},
        rules = ew.parseJson($("#fseason20_21search input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fseason20_21search").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fseason20_21search" formaction="<?= HtmlEncode(GetUrl("Season2021List")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fseason20_21search"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fseason20_21search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("season20_21");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
