<?php

namespace PHPMaker2024\cidp24;

// Page object
$Season2021List = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { season20_21: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "Activity": <?= $Page->Activity->toClientList($Page) ?>,
            "District": <?= $Page->District->toClientList($Page) ?>,
            "Block": <?= $Page->Block->toClientList($Page) ?>,
            "Camp": <?= $Page->Camp->toClientList($Page) ?>,
            "NurseryArea": <?= $Page->NurseryArea->toClientList($Page) ?>,
            "Zone": <?= $Page->Zone->toClientList($Page) ?>,
            "ChiefArea": <?= $Page->ChiefArea->toClientList($Page) ?>,
            "Village": <?= $Page->Village->toClientList($Page) ?>,
            "NameOfFarmer": <?= $Page->NameOfFarmer->toClientList($Page) ?>,
            "YearOfBirth": <?= $Page->YearOfBirth->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fseason20_21srch" id="fseason20_21srch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fseason20_21srch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { season20_21: currentTable } });
var currentForm;
var fseason20_21srch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fseason20_21srch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Activity": <?= $Page->Activity->toClientList($Page) ?>,
            "District": <?= $Page->District->toClientList($Page) ?>,
            "Block": <?= $Page->Block->toClientList($Page) ?>,
            "Camp": <?= $Page->Camp->toClientList($Page) ?>,
            "NurseryArea": <?= $Page->NurseryArea->toClientList($Page) ?>,
            "Zone": <?= $Page->Zone->toClientList($Page) ?>,
            "ChiefArea": <?= $Page->ChiefArea->toClientList($Page) ?>,
            "Village": <?= $Page->Village->toClientList($Page) ?>,
            "NameOfFarmer": <?= $Page->NameOfFarmer->toClientList($Page) ?>,
            "YearOfBirth": <?= $Page->YearOfBirth->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->Activity->Visible) { // Activity ?>
<?php
if (!$Page->Activity->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Activity" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Activity->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Activity"
            name="x_Activity[]"
            class="form-control ew-select<?= $Page->Activity->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_Activity"
            data-table="season20_21"
            data-field="x_Activity"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Activity->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Activity->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Activity->editAttributes() ?>>
            <?= $Page->Activity->selectOptionListHtml("x_Activity", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Activity->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_Activity",
                selectId: "fseason20_21srch_x_Activity",
                ajax: { id: "x_Activity", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.Activity.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
<?php
if (!$Page->District->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_District" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->District->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_District"
            name="x_District[]"
            class="form-control ew-select<?= $Page->District->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_District"
            data-table="season20_21"
            data-field="x_District"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->District->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->District->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->District->editAttributes() ?>>
            <?= $Page->District->selectOptionListHtml("x_District", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->District->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_District",
                selectId: "fseason20_21srch_x_District",
                ajax: { id: "x_District", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.District.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Block->Visible) { // Block ?>
<?php
if (!$Page->Block->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Block" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Block->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Block"
            name="x_Block[]"
            class="form-control ew-select<?= $Page->Block->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_Block"
            data-table="season20_21"
            data-field="x_Block"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Block->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Block->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Block->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Block->editAttributes() ?>>
            <?= $Page->Block->selectOptionListHtml("x_Block", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Block->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_Block",
                selectId: "fseason20_21srch_x_Block",
                ajax: { id: "x_Block", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.Block.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
<?php
if (!$Page->Camp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Camp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Camp->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Camp"
            name="x_Camp[]"
            class="form-control ew-select<?= $Page->Camp->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_Camp"
            data-table="season20_21"
            data-field="x_Camp"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Camp->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Camp->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Camp->editAttributes() ?>>
            <?= $Page->Camp->selectOptionListHtml("x_Camp", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Camp->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_Camp",
                selectId: "fseason20_21srch_x_Camp",
                ajax: { id: "x_Camp", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.Camp.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NurseryArea->Visible) { // NurseryArea ?>
<?php
if (!$Page->NurseryArea->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NurseryArea" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NurseryArea->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NurseryArea"
            name="x_NurseryArea[]"
            class="form-control ew-select<?= $Page->NurseryArea->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_NurseryArea"
            data-table="season20_21"
            data-field="x_NurseryArea"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NurseryArea->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NurseryArea->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NurseryArea->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NurseryArea->editAttributes() ?>>
            <?= $Page->NurseryArea->selectOptionListHtml("x_NurseryArea", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NurseryArea->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_NurseryArea",
                selectId: "fseason20_21srch_x_NurseryArea",
                ajax: { id: "x_NurseryArea", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.NurseryArea.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Zone->Visible) { // Zone ?>
<?php
if (!$Page->Zone->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Zone" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Zone->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Zone"
            name="x_Zone[]"
            class="form-control ew-select<?= $Page->Zone->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_Zone"
            data-table="season20_21"
            data-field="x_Zone"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Zone->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Zone->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Zone->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Zone->editAttributes() ?>>
            <?= $Page->Zone->selectOptionListHtml("x_Zone", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Zone->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_Zone",
                selectId: "fseason20_21srch_x_Zone",
                ajax: { id: "x_Zone", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.Zone.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ChiefArea->Visible) { // ChiefArea ?>
<?php
if (!$Page->ChiefArea->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ChiefArea" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ChiefArea->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ChiefArea"
            name="x_ChiefArea[]"
            class="form-control ew-select<?= $Page->ChiefArea->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_ChiefArea"
            data-table="season20_21"
            data-field="x_ChiefArea"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ChiefArea->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ChiefArea->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ChiefArea->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ChiefArea->editAttributes() ?>>
            <?= $Page->ChiefArea->selectOptionListHtml("x_ChiefArea", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ChiefArea->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_ChiefArea",
                selectId: "fseason20_21srch_x_ChiefArea",
                ajax: { id: "x_ChiefArea", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.ChiefArea.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
<?php
if (!$Page->Village->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Village" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Village->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Village"
            name="x_Village[]"
            class="form-control ew-select<?= $Page->Village->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_Village"
            data-table="season20_21"
            data-field="x_Village"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Village->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Village->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Village->editAttributes() ?>>
            <?= $Page->Village->selectOptionListHtml("x_Village", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Village->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_Village",
                selectId: "fseason20_21srch_x_Village",
                ajax: { id: "x_Village", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.Village.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NameOfFarmer->Visible) { // NameOfFarmer ?>
<?php
if (!$Page->NameOfFarmer->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NameOfFarmer" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NameOfFarmer->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NameOfFarmer"
            name="x_NameOfFarmer[]"
            class="form-control ew-select<?= $Page->NameOfFarmer->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_NameOfFarmer"
            data-table="season20_21"
            data-field="x_NameOfFarmer"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NameOfFarmer->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NameOfFarmer->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NameOfFarmer->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NameOfFarmer->editAttributes() ?>>
            <?= $Page->NameOfFarmer->selectOptionListHtml("x_NameOfFarmer", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NameOfFarmer->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_NameOfFarmer",
                selectId: "fseason20_21srch_x_NameOfFarmer",
                ajax: { id: "x_NameOfFarmer", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.NameOfFarmer.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->YearOfBirth->Visible) { // YearOfBirth ?>
<?php
if (!$Page->YearOfBirth->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_YearOfBirth" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->YearOfBirth->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_YearOfBirth"
            name="x_YearOfBirth[]"
            class="form-control ew-select<?= $Page->YearOfBirth->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_YearOfBirth"
            data-table="season20_21"
            data-field="x_YearOfBirth"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->YearOfBirth->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->YearOfBirth->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->YearOfBirth->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->YearOfBirth->editAttributes() ?>>
            <?= $Page->YearOfBirth->selectOptionListHtml("x_YearOfBirth", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->YearOfBirth->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_YearOfBirth",
                selectId: "fseason20_21srch_x_YearOfBirth",
                ajax: { id: "x_YearOfBirth", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.YearOfBirth.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_Gender"
            data-table="season20_21"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fseason20_21srch_x_Gender",
                ajax: { id: "x_Gender", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
<?php
if (!$Page->NRC->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NRC" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NRC->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NRC"
            name="x_NRC[]"
            class="form-control ew-select<?= $Page->NRC->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_NRC"
            data-table="season20_21"
            data-field="x_NRC"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NRC->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NRC->editAttributes() ?>>
            <?= $Page->NRC->selectOptionListHtml("x_NRC", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_NRC",
                selectId: "fseason20_21srch_x_NRC",
                ajax: { id: "x_NRC", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.NRC.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
<?php
if (!$Page->FieldType->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FieldType" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FieldType->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FieldType"
            name="x_FieldType[]"
            class="form-control ew-select<?= $Page->FieldType->isInvalidClass() ?>"
            data-select2-id="fseason20_21srch_x_FieldType"
            data-table="season20_21"
            data-field="x_FieldType"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FieldType->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FieldType->editAttributes() ?>>
            <?= $Page->FieldType->selectOptionListHtml("x_FieldType", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fseason20_21srch", function() {
            var options = {
                name: "x_FieldType",
                selectId: "fseason20_21srch_x_FieldType",
                ajax: { id: "x_FieldType", form: "fseason20_21srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.season20_21.fields.FieldType.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fseason20_21srch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fseason20_21srch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fseason20_21srch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fseason20_21srch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="season20_21">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_season20_21" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_season20_21list" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->SerialNo->Visible) { // SerialNo ?>
        <th data-name="SerialNo" class="<?= $Page->SerialNo->headerCellClass() ?>"><div id="elh_season20_21_SerialNo" class="season20_21_SerialNo"><?= $Page->renderFieldHeader($Page->SerialNo) ?></div></th>
<?php } ?>
<?php if ($Page->IPC->Visible) { // IPC ?>
        <th data-name="IPC" class="<?= $Page->IPC->headerCellClass() ?>"><div id="elh_season20_21_IPC" class="season20_21_IPC"><?= $Page->renderFieldHeader($Page->IPC) ?></div></th>
<?php } ?>
<?php if ($Page->PageNo->Visible) { // PageNo ?>
        <th data-name="PageNo" class="<?= $Page->PageNo->headerCellClass() ?>"><div id="elh_season20_21_PageNo" class="season20_21_PageNo"><?= $Page->renderFieldHeader($Page->PageNo) ?></div></th>
<?php } ?>
<?php if ($Page->Activity->Visible) { // Activity ?>
        <th data-name="Activity" class="<?= $Page->Activity->headerCellClass() ?>"><div id="elh_season20_21_Activity" class="season20_21_Activity"><?= $Page->renderFieldHeader($Page->Activity) ?></div></th>
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
        <th data-name="District" class="<?= $Page->District->headerCellClass() ?>"><div id="elh_season20_21_District" class="season20_21_District"><?= $Page->renderFieldHeader($Page->District) ?></div></th>
<?php } ?>
<?php if ($Page->Block->Visible) { // Block ?>
        <th data-name="Block" class="<?= $Page->Block->headerCellClass() ?>"><div id="elh_season20_21_Block" class="season20_21_Block"><?= $Page->renderFieldHeader($Page->Block) ?></div></th>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
        <th data-name="Camp" class="<?= $Page->Camp->headerCellClass() ?>"><div id="elh_season20_21_Camp" class="season20_21_Camp"><?= $Page->renderFieldHeader($Page->Camp) ?></div></th>
<?php } ?>
<?php if ($Page->NurseryArea->Visible) { // NurseryArea ?>
        <th data-name="NurseryArea" class="<?= $Page->NurseryArea->headerCellClass() ?>"><div id="elh_season20_21_NurseryArea" class="season20_21_NurseryArea"><?= $Page->renderFieldHeader($Page->NurseryArea) ?></div></th>
<?php } ?>
<?php if ($Page->Zone->Visible) { // Zone ?>
        <th data-name="Zone" class="<?= $Page->Zone->headerCellClass() ?>"><div id="elh_season20_21_Zone" class="season20_21_Zone"><?= $Page->renderFieldHeader($Page->Zone) ?></div></th>
<?php } ?>
<?php if ($Page->ChiefArea->Visible) { // ChiefArea ?>
        <th data-name="ChiefArea" class="<?= $Page->ChiefArea->headerCellClass() ?>"><div id="elh_season20_21_ChiefArea" class="season20_21_ChiefArea"><?= $Page->renderFieldHeader($Page->ChiefArea) ?></div></th>
<?php } ?>
<?php if ($Page->Date->Visible) { // Date ?>
        <th data-name="Date" class="<?= $Page->Date->headerCellClass() ?>"><div id="elh_season20_21_Date" class="season20_21_Date"><?= $Page->renderFieldHeader($Page->Date) ?></div></th>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
        <th data-name="Village" class="<?= $Page->Village->headerCellClass() ?>"><div id="elh_season20_21_Village" class="season20_21_Village"><?= $Page->renderFieldHeader($Page->Village) ?></div></th>
<?php } ?>
<?php if ($Page->NameOfFarmer->Visible) { // NameOfFarmer ?>
        <th data-name="NameOfFarmer" class="<?= $Page->NameOfFarmer->headerCellClass() ?>"><div id="elh_season20_21_NameOfFarmer" class="season20_21_NameOfFarmer"><?= $Page->renderFieldHeader($Page->NameOfFarmer) ?></div></th>
<?php } ?>
<?php if ($Page->YearOfBirth->Visible) { // YearOfBirth ?>
        <th data-name="YearOfBirth" class="<?= $Page->YearOfBirth->headerCellClass() ?>"><div id="elh_season20_21_YearOfBirth" class="season20_21_YearOfBirth"><?= $Page->renderFieldHeader($Page->YearOfBirth) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_season20_21_Gender" class="season20_21_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_season20_21_NRC" class="season20_21_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->SeedlingsReceived20_21->Visible) { // SeedlingsReceived20_21 ?>
        <th data-name="SeedlingsReceived20_21" class="<?= $Page->SeedlingsReceived20_21->headerCellClass() ?>"><div id="elh_season20_21_SeedlingsReceived20_21" class="season20_21_SeedlingsReceived20_21"><?= $Page->renderFieldHeader($Page->SeedlingsReceived20_21) ?></div></th>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
        <th data-name="FieldType" class="<?= $Page->FieldType->headerCellClass() ?>"><div id="elh_season20_21_FieldType" class="season20_21_FieldType"><?= $Page->renderFieldHeader($Page->FieldType) ?></div></th>
<?php } ?>
<?php if ($Page->Contact->Visible) { // Contact ?>
        <th data-name="Contact" class="<?= $Page->Contact->headerCellClass() ?>"><div id="elh_season20_21_Contact" class="season20_21_Contact"><?= $Page->renderFieldHeader($Page->Contact) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->SerialNo->Visible) { // SerialNo ?>
        <td data-name="SerialNo"<?= $Page->SerialNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_SerialNo" class="el_season20_21_SerialNo">
<span<?= $Page->SerialNo->viewAttributes() ?>>
<?= $Page->SerialNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->IPC->Visible) { // IPC ?>
        <td data-name="IPC"<?= $Page->IPC->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_IPC" class="el_season20_21_IPC">
<span<?= $Page->IPC->viewAttributes() ?>>
<?= $Page->IPC->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PageNo->Visible) { // PageNo ?>
        <td data-name="PageNo"<?= $Page->PageNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_PageNo" class="el_season20_21_PageNo">
<span<?= $Page->PageNo->viewAttributes() ?>>
<?= $Page->PageNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Activity->Visible) { // Activity ?>
        <td data-name="Activity"<?= $Page->Activity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Activity" class="el_season20_21_Activity">
<span<?= $Page->Activity->viewAttributes() ?>>
<?= $Page->Activity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->District->Visible) { // District ?>
        <td data-name="District"<?= $Page->District->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_District" class="el_season20_21_District">
<span<?= $Page->District->viewAttributes() ?>>
<?= $Page->District->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Block->Visible) { // Block ?>
        <td data-name="Block"<?= $Page->Block->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Block" class="el_season20_21_Block">
<span<?= $Page->Block->viewAttributes() ?>>
<?= $Page->Block->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Camp->Visible) { // Camp ?>
        <td data-name="Camp"<?= $Page->Camp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Camp" class="el_season20_21_Camp">
<span<?= $Page->Camp->viewAttributes() ?>>
<?= $Page->Camp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NurseryArea->Visible) { // NurseryArea ?>
        <td data-name="NurseryArea"<?= $Page->NurseryArea->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_NurseryArea" class="el_season20_21_NurseryArea">
<span<?= $Page->NurseryArea->viewAttributes() ?>>
<?= $Page->NurseryArea->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Zone->Visible) { // Zone ?>
        <td data-name="Zone"<?= $Page->Zone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Zone" class="el_season20_21_Zone">
<span<?= $Page->Zone->viewAttributes() ?>>
<?= $Page->Zone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ChiefArea->Visible) { // ChiefArea ?>
        <td data-name="ChiefArea"<?= $Page->ChiefArea->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_ChiefArea" class="el_season20_21_ChiefArea">
<span<?= $Page->ChiefArea->viewAttributes() ?>>
<?= $Page->ChiefArea->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Date->Visible) { // Date ?>
        <td data-name="Date"<?= $Page->Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Date" class="el_season20_21_Date">
<span<?= $Page->Date->viewAttributes() ?>>
<?= $Page->Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Village->Visible) { // Village ?>
        <td data-name="Village"<?= $Page->Village->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Village" class="el_season20_21_Village">
<span<?= $Page->Village->viewAttributes() ?>>
<?= $Page->Village->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NameOfFarmer->Visible) { // NameOfFarmer ?>
        <td data-name="NameOfFarmer"<?= $Page->NameOfFarmer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_NameOfFarmer" class="el_season20_21_NameOfFarmer">
<span<?= $Page->NameOfFarmer->viewAttributes() ?>>
<?= $Page->NameOfFarmer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->YearOfBirth->Visible) { // YearOfBirth ?>
        <td data-name="YearOfBirth"<?= $Page->YearOfBirth->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_YearOfBirth" class="el_season20_21_YearOfBirth">
<span<?= $Page->YearOfBirth->viewAttributes() ?>>
<?= $Page->YearOfBirth->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Gender" class="el_season20_21_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_NRC" class="el_season20_21_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SeedlingsReceived20_21->Visible) { // SeedlingsReceived20_21 ?>
        <td data-name="SeedlingsReceived20_21"<?= $Page->SeedlingsReceived20_21->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_SeedlingsReceived20_21" class="el_season20_21_SeedlingsReceived20_21">
<span<?= $Page->SeedlingsReceived20_21->viewAttributes() ?>>
<?= $Page->SeedlingsReceived20_21->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FieldType->Visible) { // FieldType ?>
        <td data-name="FieldType"<?= $Page->FieldType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_FieldType" class="el_season20_21_FieldType">
<span<?= $Page->FieldType->viewAttributes() ?>>
<?= $Page->FieldType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Contact->Visible) { // Contact ?>
        <td data-name="Contact"<?= $Page->Contact->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_season20_21_Contact" class="el_season20_21_Contact">
<span<?= $Page->Contact->viewAttributes() ?>>
<?= $Page->Contact->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("season20_21");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
