<?php

namespace PHPMaker2024\cidp24;

// Page object
$Season1920Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { season19_20: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fseason19_20search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fseason19_20search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["SerialNo", [ew.Validators.integer], fields.SerialNo.isInvalid],
            ["IPC", [], fields.IPC.isInvalid],
            ["PageNo", [ew.Validators.integer], fields.PageNo.isInvalid],
            ["Activity", [], fields.Activity.isInvalid],
            ["District", [], fields.District.isInvalid],
            ["Block", [], fields.Block.isInvalid],
            ["Camp", [], fields.Camp.isInvalid],
            ["NurseryArea", [], fields.NurseryArea.isInvalid],
            ["Zone", [], fields.Zone.isInvalid],
            ["ChiefArea", [], fields.ChiefArea.isInvalid],
            ["Date", [], fields.Date.isInvalid],
            ["Village", [], fields.Village.isInvalid],
            ["NameOfFarmer", [], fields.NameOfFarmer.isInvalid],
            ["YearOfBirth", [ew.Validators.integer], fields.YearOfBirth.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["Contact", [], fields.Contact.isInvalid],
            ["FieldType", [], fields.FieldType.isInvalid],
            ["SeedlingsReceived19_20", [ew.Validators.integer], fields.SeedlingsReceived19_20.isInvalid],
            ["Hectorage", [ew.Validators.float], fields.Hectorage.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fseason19_20search" id="fseason19_20search" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("Season1920List")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="season19_20">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_season19_20_SerialNo" class="season19_20search"><span id="el_season19_20_SerialNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SerialNo->getInputTextType() ?>" name="x_SerialNo" id="x_SerialNo" data-table="season19_20" data-field="x_SerialNo" value="<?= $Page->SerialNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SerialNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SerialNo->formatPattern()) ?>"<?= $Page->SerialNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SerialNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_IPC" class="season19_20search"><span id="el_season19_20_IPC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IPC->getInputTextType() ?>" name="x_IPC" id="x_IPC" data-table="season19_20" data-field="x_IPC" value="<?= $Page->IPC->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->IPC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IPC->formatPattern()) ?>"<?= $Page->IPC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IPC->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_PageNo" class="season19_20search"><span id="el_season19_20_PageNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PageNo->getInputTextType() ?>" name="x_PageNo" id="x_PageNo" data-table="season19_20" data-field="x_PageNo" value="<?= $Page->PageNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PageNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PageNo->formatPattern()) ?>"<?= $Page->PageNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PageNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Activity" class="season19_20search"><span id="el_season19_20_Activity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Activity->getInputTextType() ?>" name="x_Activity" id="x_Activity" data-table="season19_20" data-field="x_Activity" value="<?= $Page->Activity->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Activity->formatPattern()) ?>"<?= $Page->Activity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_District" class="season19_20search"><span id="el_season19_20_District" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->District->getInputTextType() ?>" name="x_District" id="x_District" data-table="season19_20" data-field="x_District" value="<?= $Page->District->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->District->formatPattern()) ?>"<?= $Page->District->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->District->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Block" class="season19_20search"><span id="el_season19_20_Block" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Block->getInputTextType() ?>" name="x_Block" id="x_Block" data-table="season19_20" data-field="x_Block" value="<?= $Page->Block->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Block->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Block->formatPattern()) ?>"<?= $Page->Block->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Block->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Camp" class="season19_20search"><span id="el_season19_20_Camp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="season19_20" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_NurseryArea" class="season19_20search"><span id="el_season19_20_NurseryArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NurseryArea->getInputTextType() ?>" name="x_NurseryArea" id="x_NurseryArea" data-table="season19_20" data-field="x_NurseryArea" value="<?= $Page->NurseryArea->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NurseryArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NurseryArea->formatPattern()) ?>"<?= $Page->NurseryArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NurseryArea->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Zone" class="season19_20search"><span id="el_season19_20_Zone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Zone->getInputTextType() ?>" name="x_Zone" id="x_Zone" data-table="season19_20" data-field="x_Zone" value="<?= $Page->Zone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Zone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Zone->formatPattern()) ?>"<?= $Page->Zone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Zone->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_ChiefArea" class="season19_20search"><span id="el_season19_20_ChiefArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ChiefArea->getInputTextType() ?>" name="x_ChiefArea" id="x_ChiefArea" data-table="season19_20" data-field="x_ChiefArea" value="<?= $Page->ChiefArea->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ChiefArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ChiefArea->formatPattern()) ?>"<?= $Page->ChiefArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ChiefArea->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Date" class="season19_20search"><span id="el_season19_20_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Date->getInputTextType() ?>" name="x_Date" id="x_Date" data-table="season19_20" data-field="x_Date" value="<?= $Page->Date->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Date->formatPattern()) ?>"<?= $Page->Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Date->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Village" class="season19_20search"><span id="el_season19_20_Village" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="season19_20" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_NameOfFarmer" class="season19_20search"><span id="el_season19_20_NameOfFarmer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NameOfFarmer->getInputTextType() ?>" name="x_NameOfFarmer" id="x_NameOfFarmer" data-table="season19_20" data-field="x_NameOfFarmer" value="<?= $Page->NameOfFarmer->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NameOfFarmer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NameOfFarmer->formatPattern()) ?>"<?= $Page->NameOfFarmer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NameOfFarmer->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_YearOfBirth" class="season19_20search"><span id="el_season19_20_YearOfBirth" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->YearOfBirth->getInputTextType() ?>" name="x_YearOfBirth" id="x_YearOfBirth" data-table="season19_20" data-field="x_YearOfBirth" value="<?= $Page->YearOfBirth->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->YearOfBirth->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->YearOfBirth->formatPattern()) ?>"<?= $Page->YearOfBirth->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->YearOfBirth->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Gender" class="season19_20search"><span id="el_season19_20_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="season19_20" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_NRC" class="season19_20search"><span id="el_season19_20_NRC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="season19_20" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Contact" class="season19_20search"><span id="el_season19_20_Contact" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Contact->getInputTextType() ?>" name="x_Contact" id="x_Contact" data-table="season19_20" data-field="x_Contact" value="<?= $Page->Contact->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Contact->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Contact->formatPattern()) ?>"<?= $Page->Contact->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Contact->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_FieldType" class="season19_20search"><span id="el_season19_20_FieldType" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FieldType->getInputTextType() ?>" name="x_FieldType" id="x_FieldType" data-table="season19_20" data-field="x_FieldType" value="<?= $Page->FieldType->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FieldType->formatPattern()) ?>"<?= $Page->FieldType->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_SeedlingsReceived19_20" class="season19_20search"><span id="el_season19_20_SeedlingsReceived19_20" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsReceived19_20->getInputTextType() ?>" name="x_SeedlingsReceived19_20" id="x_SeedlingsReceived19_20" data-table="season19_20" data-field="x_SeedlingsReceived19_20" value="<?= $Page->SeedlingsReceived19_20->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived19_20->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived19_20->formatPattern()) ?>"<?= $Page->SeedlingsReceived19_20->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived19_20->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_season19_20_Hectorage" class="season19_20search"><span id="el_season19_20_Hectorage" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Hectorage->getInputTextType() ?>" name="x_Hectorage" id="x_Hectorage" data-table="season19_20" data-field="x_Hectorage" value="<?= $Page->Hectorage->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Hectorage->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Hectorage->formatPattern()) ?>"<?= $Page->Hectorage->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Hectorage->getErrorMessage(false) ?></div>
</span></template>
<div id="season19_20_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "SerialNo",
                type: "integer",
                label: currentTable.fields.SerialNo.caption,
                operators: currentTable.fields.SerialNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.SerialNo.validators),
                data: {
                    format: currentTable.fields.SerialNo.clientFormatPattern
                }
            },
            {
                id: "IPC",
                type: "string",
                label: currentTable.fields.IPC.caption,
                operators: currentTable.fields.IPC.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.IPC.validators),
                data: {
                    format: currentTable.fields.IPC.clientFormatPattern
                }
            },
            {
                id: "PageNo",
                type: "integer",
                label: currentTable.fields.PageNo.caption,
                operators: currentTable.fields.PageNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.PageNo.validators),
                data: {
                    format: currentTable.fields.PageNo.clientFormatPattern
                }
            },
            {
                id: "Activity",
                type: "string",
                label: currentTable.fields.Activity.caption,
                operators: currentTable.fields.Activity.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Activity.validators),
                data: {
                    format: currentTable.fields.Activity.clientFormatPattern
                }
            },
            {
                id: "District",
                type: "string",
                label: currentTable.fields.District.caption,
                operators: currentTable.fields.District.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.District.validators),
                data: {
                    format: currentTable.fields.District.clientFormatPattern
                }
            },
            {
                id: "Block",
                type: "string",
                label: currentTable.fields.Block.caption,
                operators: currentTable.fields.Block.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Block.validators),
                data: {
                    format: currentTable.fields.Block.clientFormatPattern
                }
            },
            {
                id: "Camp",
                type: "string",
                label: currentTable.fields.Camp.caption,
                operators: currentTable.fields.Camp.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Camp.validators),
                data: {
                    format: currentTable.fields.Camp.clientFormatPattern
                }
            },
            {
                id: "NurseryArea",
                type: "string",
                label: currentTable.fields.NurseryArea.caption,
                operators: currentTable.fields.NurseryArea.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.NurseryArea.validators),
                data: {
                    format: currentTable.fields.NurseryArea.clientFormatPattern
                }
            },
            {
                id: "Zone",
                type: "string",
                label: currentTable.fields.Zone.caption,
                operators: currentTable.fields.Zone.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Zone.validators),
                data: {
                    format: currentTable.fields.Zone.clientFormatPattern
                }
            },
            {
                id: "ChiefArea",
                type: "string",
                label: currentTable.fields.ChiefArea.caption,
                operators: currentTable.fields.ChiefArea.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.ChiefArea.validators),
                data: {
                    format: currentTable.fields.ChiefArea.clientFormatPattern
                }
            },
            {
                id: "Date",
                type: "string",
                label: currentTable.fields.Date.caption,
                operators: currentTable.fields.Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Date.validators),
                data: {
                    format: currentTable.fields.Date.clientFormatPattern
                }
            },
            {
                id: "Village",
                type: "string",
                label: currentTable.fields.Village.caption,
                operators: currentTable.fields.Village.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Village.validators),
                data: {
                    format: currentTable.fields.Village.clientFormatPattern
                }
            },
            {
                id: "NameOfFarmer",
                type: "string",
                label: currentTable.fields.NameOfFarmer.caption,
                operators: currentTable.fields.NameOfFarmer.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.NameOfFarmer.validators),
                data: {
                    format: currentTable.fields.NameOfFarmer.clientFormatPattern
                }
            },
            {
                id: "YearOfBirth",
                type: "integer",
                label: currentTable.fields.YearOfBirth.caption,
                operators: currentTable.fields.YearOfBirth.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.YearOfBirth.validators),
                data: {
                    format: currentTable.fields.YearOfBirth.clientFormatPattern
                }
            },
            {
                id: "Gender",
                type: "string",
                label: currentTable.fields.Gender.caption,
                operators: currentTable.fields.Gender.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Gender.validators),
                data: {
                    format: currentTable.fields.Gender.clientFormatPattern
                }
            },
            {
                id: "NRC",
                type: "string",
                label: currentTable.fields.NRC.caption,
                operators: currentTable.fields.NRC.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.NRC.validators),
                data: {
                    format: currentTable.fields.NRC.clientFormatPattern
                }
            },
            {
                id: "Contact",
                type: "string",
                label: currentTable.fields.Contact.caption,
                operators: currentTable.fields.Contact.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Contact.validators),
                data: {
                    format: currentTable.fields.Contact.clientFormatPattern
                }
            },
            {
                id: "FieldType",
                type: "string",
                label: currentTable.fields.FieldType.caption,
                operators: currentTable.fields.FieldType.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.FieldType.validators),
                data: {
                    format: currentTable.fields.FieldType.clientFormatPattern
                }
            },
            {
                id: "SeedlingsReceived19_20",
                type: "integer",
                label: currentTable.fields.SeedlingsReceived19_20.caption,
                operators: currentTable.fields.SeedlingsReceived19_20.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.SeedlingsReceived19_20.validators),
                data: {
                    format: currentTable.fields.SeedlingsReceived19_20.clientFormatPattern
                }
            },
            {
                id: "Hectorage",
                type: "double",
                label: currentTable.fields.Hectorage.caption,
                operators: currentTable.fields.Hectorage.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fseason19_20search.fields.Hectorage.validators),
                data: {
                    format: currentTable.fields.Hectorage.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#season19_20_query_builder"),
        args = {},
        rules = ew.parseJson($("#fseason19_20search input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fseason19_20search").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fseason19_20search" formaction="<?= HtmlEncode(GetUrl("Season1920List")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fseason19_20search"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fseason19_20search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("season19_20");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
