<?php

namespace PHPMaker2024\cidp24;

// Page object
$QuarterRefView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
<form name="fquarter_refview" id="fquarter_refview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { quarter_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fquarter_refview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fquarter_refview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="quarter_ref">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->QuarterCode->Visible) { // QuarterCode ?>
    <tr id="r_QuarterCode"<?= $Page->QuarterCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_quarter_ref_QuarterCode"><?= $Page->QuarterCode->caption() ?></span></td>
        <td data-name="QuarterCode"<?= $Page->QuarterCode->cellAttributes() ?>>
<span id="el_quarter_ref_QuarterCode">
<span<?= $Page->QuarterCode->viewAttributes() ?>>
<?= $Page->QuarterCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->QuarterName->Visible) { // QuarterName ?>
    <tr id="r_QuarterName"<?= $Page->QuarterName->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_quarter_ref_QuarterName"><?= $Page->QuarterName->caption() ?></span></td>
        <td data-name="QuarterName"<?= $Page->QuarterName->cellAttributes() ?>>
<span id="el_quarter_ref_QuarterName">
<span<?= $Page->QuarterName->viewAttributes() ?>>
<?= $Page->QuarterName->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->QuarterShort->Visible) { // QuarterShort ?>
    <tr id="r_QuarterShort"<?= $Page->QuarterShort->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_quarter_ref_QuarterShort"><?= $Page->QuarterShort->caption() ?></span></td>
        <td data-name="QuarterShort"<?= $Page->QuarterShort->cellAttributes() ?>>
<span id="el_quarter_ref_QuarterShort">
<span<?= $Page->QuarterShort->viewAttributes() ?>>
<?= $Page->QuarterShort->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
