<?php

namespace PHPMaker2024\cidp24;

// Page object
$ProvinceAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { province: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fprovinceadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprovinceadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null, ew.Validators.integer], fields.ProvinceCode.isInvalid],
            ["ProvinceName", [fields.ProvinceName.visible && fields.ProvinceName.required ? ew.Validators.required(fields.ProvinceName.caption) : null], fields.ProvinceName.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprovinceadd" id="fprovinceadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="province">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_province_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_province_ProvinceCode">
<input type="<?= $Page->ProvinceCode->getInputTextType() ?>" name="x_ProvinceCode" id="x_ProvinceCode" data-table="province" data-field="x_ProvinceCode" value="<?= $Page->ProvinceCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProvinceCode->formatPattern()) ?>"<?= $Page->ProvinceCode->editAttributes() ?> aria-describedby="x_ProvinceCode_help">
<?= $Page->ProvinceCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ProvinceName->Visible) { // ProvinceName ?>
    <div id="r_ProvinceName"<?= $Page->ProvinceName->rowAttributes() ?>>
        <label id="elh_province_ProvinceName" for="x_ProvinceName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceName->caption() ?><?= $Page->ProvinceName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceName->cellAttributes() ?>>
<span id="el_province_ProvinceName">
<input type="<?= $Page->ProvinceName->getInputTextType() ?>" name="x_ProvinceName" id="x_ProvinceName" data-table="province" data-field="x_ProvinceName" value="<?= $Page->ProvinceName->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->ProvinceName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProvinceName->formatPattern()) ?>"<?= $Page->ProvinceName->editAttributes() ?> aria-describedby="x_ProvinceName_help">
<?= $Page->ProvinceName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProvinceName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("district", explode(",", $Page->getCurrentDetailTable())) && $district->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("district", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "DistrictGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprovinceadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprovinceadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("province");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
