<?php

namespace PHPMaker2024\cidp24;

// Page object
$ProductionViewList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_view: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fproduction_viewsrch" id="fproduction_viewsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fproduction_viewsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_view: currentTable } });
var currentForm;
var fproduction_viewsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduction_viewsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fproduction_viewsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fproduction_viewsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fproduction_viewsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fproduction_viewsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_view">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_production_view" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_production_viewlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <th data-name="FarmerName" class="<?= $Page->FarmerName->headerCellClass() ?>"><div id="elh_production_view_FarmerName" class="production_view_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_production_view_NRC" class="production_view_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
        <th data-name="DOB" class="<?= $Page->DOB->headerCellClass() ?>"><div id="elh_production_view_DOB" class="production_view_DOB"><?= $Page->renderFieldHeader($Page->DOB) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_production_view_Gender" class="production_view_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
        <th data-name="Age" class="<?= $Page->Age->headerCellClass() ?>"><div id="elh_production_view_Age" class="production_view_Age"><?= $Page->renderFieldHeader($Page->Age) ?></div></th>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div id="elh_production_view_FarmNo" class="production_view_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
        <th data-name="FieldType" class="<?= $Page->FieldType->headerCellClass() ?>"><div id="elh_production_view_FieldType" class="production_view_FieldType"><?= $Page->renderFieldHeader($Page->FieldType) ?></div></th>
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
        <th data-name="Ownership" class="<?= $Page->Ownership->headerCellClass() ?>"><div id="elh_production_view_Ownership" class="production_view_Ownership"><?= $Page->renderFieldHeader($Page->Ownership) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { // FarmSize ?>
        <th data-name="FarmSize" class="<?= $Page->FarmSize->headerCellClass() ?>"><div id="elh_production_view_FarmSize" class="production_view_FarmSize"><?= $Page->renderFieldHeader($Page->FarmSize) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
        <th data-name="FarmSizeEstimated" class="<?= $Page->FarmSizeEstimated->headerCellClass() ?>"><div id="elh_production_view_FarmSizeEstimated" class="production_view_FarmSizeEstimated"><?= $Page->renderFieldHeader($Page->FarmSizeEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div id="elh_production_view_TreesPlantedEstimated" class="production_view_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
        <th data-name="FarmSizeVerified" class="<?= $Page->FarmSizeVerified->headerCellClass() ?>"><div id="elh_production_view_FarmSizeVerified" class="production_view_FarmSizeVerified"><?= $Page->renderFieldHeader($Page->FarmSizeVerified) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div id="elh_production_view_TreesPlantedVerified" class="production_view_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <th data-name="MaritalStatus" class="<?= $Page->MaritalStatus->headerCellClass() ?>"><div id="elh_production_view_MaritalStatus" class="production_view_MaritalStatus"><?= $Page->renderFieldHeader($Page->MaritalStatus) ?></div></th>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
        <th data-name="PhoneNo" class="<?= $Page->PhoneNo->headerCellClass() ?>"><div id="elh_production_view_PhoneNo" class="production_view_PhoneNo"><?= $Page->renderFieldHeader($Page->PhoneNo) ?></div></th>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Page->_Email->headerCellClass() ?>"><div id="elh_production_view__Email" class="production_view__Email"><?= $Page->renderFieldHeader($Page->_Email) ?></div></th>
<?php } ?>
<?php if ($Page->Dependants->Visible) { // Dependants ?>
        <th data-name="Dependants" class="<?= $Page->Dependants->headerCellClass() ?>"><div id="elh_production_view_Dependants" class="production_view_Dependants"><?= $Page->renderFieldHeader($Page->Dependants) ?></div></th>
<?php } ?>
<?php if ($Page->MaleChildren->Visible) { // MaleChildren ?>
        <th data-name="MaleChildren" class="<?= $Page->MaleChildren->headerCellClass() ?>"><div id="elh_production_view_MaleChildren" class="production_view_MaleChildren"><?= $Page->renderFieldHeader($Page->MaleChildren) ?></div></th>
<?php } ?>
<?php if ($Page->FemaleChildren->Visible) { // FemaleChildren ?>
        <th data-name="FemaleChildren" class="<?= $Page->FemaleChildren->headerCellClass() ?>"><div id="elh_production_view_FemaleChildren" class="production_view_FemaleChildren"><?= $Page->renderFieldHeader($Page->FemaleChildren) ?></div></th>
<?php } ?>
<?php if ($Page->HouseholdHead->Visible) { // HouseholdHead ?>
        <th data-name="HouseholdHead" class="<?= $Page->HouseholdHead->headerCellClass() ?>"><div id="elh_production_view_HouseholdHead" class="production_view_HouseholdHead"><?= $Page->renderFieldHeader($Page->HouseholdHead) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
        <th data-name="FarmerOrg" class="<?= $Page->FarmerOrg->headerCellClass() ?>"><div id="elh_production_view_FarmerOrg" class="production_view_FarmerOrg"><?= $Page->renderFieldHeader($Page->FarmerOrg) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <th data-name="FarmerOrgPosition" class="<?= $Page->FarmerOrgPosition->headerCellClass() ?>"><div id="elh_production_view_FarmerOrgPosition" class="production_view_FarmerOrgPosition"><?= $Page->renderFieldHeader($Page->FarmerOrgPosition) ?></div></th>
<?php } ?>
<?php if ($Page->JoiningDate->Visible) { // JoiningDate ?>
        <th data-name="JoiningDate" class="<?= $Page->JoiningDate->headerCellClass() ?>"><div id="elh_production_view_JoiningDate" class="production_view_JoiningDate"><?= $Page->renderFieldHeader($Page->JoiningDate) ?></div></th>
<?php } ?>
<?php if ($Page->CampName->Visible) { // CampName ?>
        <th data-name="CampName" class="<?= $Page->CampName->headerCellClass() ?>"><div id="elh_production_view_CampName" class="production_view_CampName"><?= $Page->renderFieldHeader($Page->CampName) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div id="elh_production_view_DistrictName" class="production_view_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
<?php } ?>
<?php if ($Page->SeasonYear->Visible) { // SeasonYear ?>
        <th data-name="SeasonYear" class="<?= $Page->SeasonYear->headerCellClass() ?>"><div id="elh_production_view_SeasonYear" class="production_view_SeasonYear"><?= $Page->renderFieldHeader($Page->SeasonYear) ?></div></th>
<?php } ?>
<?php if ($Page->CashewProduced->Visible) { // CashewProduced ?>
        <th data-name="CashewProduced" class="<?= $Page->CashewProduced->headerCellClass() ?>"><div id="elh_production_view_CashewProduced" class="production_view_CashewProduced"><?= $Page->renderFieldHeader($Page->CashewProduced) ?></div></th>
<?php } ?>
<?php if ($Page->AmountRealised->Visible) { // AmountRealised ?>
        <th data-name="AmountRealised" class="<?= $Page->AmountRealised->headerCellClass() ?>"><div id="elh_production_view_AmountRealised" class="production_view_AmountRealised"><?= $Page->renderFieldHeader($Page->AmountRealised) ?></div></th>
<?php } ?>
<?php if ($Page->SoldTo->Visible) { // SoldTo ?>
        <th data-name="SoldTo" class="<?= $Page->SoldTo->headerCellClass() ?>"><div id="elh_production_view_SoldTo" class="production_view_SoldTo"><?= $Page->renderFieldHeader($Page->SoldTo) ?></div></th>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
        <th data-name="Comments" class="<?= $Page->Comments->headerCellClass() ?>"><div id="elh_production_view_Comments" class="production_view_Comments"><?= $Page->renderFieldHeader($Page->Comments) ?></div></th>
<?php } ?>
<?php if ($Page->Longitude->Visible) { // Longitude ?>
        <th data-name="Longitude" class="<?= $Page->Longitude->headerCellClass() ?>"><div id="elh_production_view_Longitude" class="production_view_Longitude"><?= $Page->renderFieldHeader($Page->Longitude) ?></div></th>
<?php } ?>
<?php if ($Page->Latitude->Visible) { // Latitude ?>
        <th data-name="Latitude" class="<?= $Page->Latitude->headerCellClass() ?>"><div id="elh_production_view_Latitude" class="production_view_Latitude"><?= $Page->renderFieldHeader($Page->Latitude) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <td data-name="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmerName" class="el_production_view_FarmerName">
<span<?= $Page->FarmerName->viewAttributes() ?>>
<?= $Page->FarmerName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_NRC" class="el_production_view_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DOB->Visible) { // DOB ?>
        <td data-name="DOB"<?= $Page->DOB->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_DOB" class="el_production_view_DOB">
<span<?= $Page->DOB->viewAttributes() ?>>
<?= $Page->DOB->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Gender" class="el_production_view_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Age->Visible) { // Age ?>
        <td data-name="Age"<?= $Page->Age->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Age" class="el_production_view_Age">
<span<?= $Page->Age->viewAttributes() ?>>
<?= $Page->Age->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmNo" class="el_production_view_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FieldType->Visible) { // FieldType ?>
        <td data-name="FieldType"<?= $Page->FieldType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FieldType" class="el_production_view_FieldType">
<span<?= $Page->FieldType->viewAttributes() ?>>
<?= $Page->FieldType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Ownership->Visible) { // Ownership ?>
        <td data-name="Ownership"<?= $Page->Ownership->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Ownership" class="el_production_view_Ownership">
<span<?= $Page->Ownership->viewAttributes() ?>>
<?= $Page->Ownership->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSize->Visible) { // FarmSize ?>
        <td data-name="FarmSize"<?= $Page->FarmSize->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmSize" class="el_production_view_FarmSize">
<span<?= $Page->FarmSize->viewAttributes() ?>>
<?= $Page->FarmSize->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
        <td data-name="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmSizeEstimated" class="el_production_view_FarmSizeEstimated">
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <td data-name="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_TreesPlantedEstimated" class="el_production_view_TreesPlantedEstimated">
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
        <td data-name="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmSizeVerified" class="el_production_view_FarmSizeVerified">
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <td data-name="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_TreesPlantedVerified" class="el_production_view_TreesPlantedVerified">
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <td data-name="MaritalStatus"<?= $Page->MaritalStatus->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_MaritalStatus" class="el_production_view_MaritalStatus">
<span<?= $Page->MaritalStatus->viewAttributes() ?>>
<?= $Page->MaritalStatus->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
        <td data-name="PhoneNo"<?= $Page->PhoneNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_PhoneNo" class="el_production_view_PhoneNo">
<span<?= $Page->PhoneNo->viewAttributes() ?>>
<?= $Page->PhoneNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Page->_Email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view__Email" class="el_production_view__Email">
<span<?= $Page->_Email->viewAttributes() ?>>
<?= $Page->_Email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Dependants->Visible) { // Dependants ?>
        <td data-name="Dependants"<?= $Page->Dependants->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Dependants" class="el_production_view_Dependants">
<span<?= $Page->Dependants->viewAttributes() ?>>
<?= $Page->Dependants->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->MaleChildren->Visible) { // MaleChildren ?>
        <td data-name="MaleChildren"<?= $Page->MaleChildren->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_MaleChildren" class="el_production_view_MaleChildren">
<span<?= $Page->MaleChildren->viewAttributes() ?>>
<?= $Page->MaleChildren->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FemaleChildren->Visible) { // FemaleChildren ?>
        <td data-name="FemaleChildren"<?= $Page->FemaleChildren->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FemaleChildren" class="el_production_view_FemaleChildren">
<span<?= $Page->FemaleChildren->viewAttributes() ?>>
<?= $Page->FemaleChildren->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->HouseholdHead->Visible) { // HouseholdHead ?>
        <td data-name="HouseholdHead"<?= $Page->HouseholdHead->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_HouseholdHead" class="el_production_view_HouseholdHead">
<span<?= $Page->HouseholdHead->viewAttributes() ?>>
<?= $Page->HouseholdHead->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
        <td data-name="FarmerOrg"<?= $Page->FarmerOrg->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmerOrg" class="el_production_view_FarmerOrg">
<span<?= $Page->FarmerOrg->viewAttributes() ?>>
<?= $Page->FarmerOrg->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <td data-name="FarmerOrgPosition"<?= $Page->FarmerOrgPosition->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_FarmerOrgPosition" class="el_production_view_FarmerOrgPosition">
<span<?= $Page->FarmerOrgPosition->viewAttributes() ?>>
<?= $Page->FarmerOrgPosition->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->JoiningDate->Visible) { // JoiningDate ?>
        <td data-name="JoiningDate"<?= $Page->JoiningDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_JoiningDate" class="el_production_view_JoiningDate">
<span<?= $Page->JoiningDate->viewAttributes() ?>>
<?= $Page->JoiningDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CampName->Visible) { // CampName ?>
        <td data-name="CampName"<?= $Page->CampName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_CampName" class="el_production_view_CampName">
<span<?= $Page->CampName->viewAttributes() ?>>
<?= $Page->CampName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <td data-name="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_DistrictName" class="el_production_view_DistrictName">
<span<?= $Page->DistrictName->viewAttributes() ?>>
<?= $Page->DistrictName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SeasonYear->Visible) { // SeasonYear ?>
        <td data-name="SeasonYear"<?= $Page->SeasonYear->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_SeasonYear" class="el_production_view_SeasonYear">
<span<?= $Page->SeasonYear->viewAttributes() ?>>
<?= $Page->SeasonYear->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CashewProduced->Visible) { // CashewProduced ?>
        <td data-name="CashewProduced"<?= $Page->CashewProduced->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_CashewProduced" class="el_production_view_CashewProduced">
<span<?= $Page->CashewProduced->viewAttributes() ?>>
<?= $Page->CashewProduced->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->AmountRealised->Visible) { // AmountRealised ?>
        <td data-name="AmountRealised"<?= $Page->AmountRealised->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_AmountRealised" class="el_production_view_AmountRealised">
<span<?= $Page->AmountRealised->viewAttributes() ?>>
<?= $Page->AmountRealised->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SoldTo->Visible) { // SoldTo ?>
        <td data-name="SoldTo"<?= $Page->SoldTo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_SoldTo" class="el_production_view_SoldTo">
<span<?= $Page->SoldTo->viewAttributes() ?>>
<?= $Page->SoldTo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Comments->Visible) { // Comments ?>
        <td data-name="Comments"<?= $Page->Comments->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Comments" class="el_production_view_Comments">
<span<?= $Page->Comments->viewAttributes() ?>>
<?= $Page->Comments->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Longitude->Visible) { // Longitude ?>
        <td data-name="Longitude"<?= $Page->Longitude->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Longitude" class="el_production_view_Longitude">
<span<?= $Page->Longitude->viewAttributes() ?>>
<?= $Page->Longitude->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Latitude->Visible) { // Latitude ?>
        <td data-name="Latitude"<?= $Page->Latitude->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_view_Latitude" class="el_production_view_Latitude">
<span<?= $Page->Latitude->viewAttributes() ?>>
<?= $Page->Latitude->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_view");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
