<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("ProductionSalesGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fproduction_salesgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { production_sales: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduction_salesgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["SeasonYear", [fields.SeasonYear.visible && fields.SeasonYear.required ? ew.Validators.required(fields.SeasonYear.caption) : null], fields.SeasonYear.isInvalid],
            ["CashewProduced", [fields.CashewProduced.visible && fields.CashewProduced.required ? ew.Validators.required(fields.CashewProduced.caption) : null, ew.Validators.float], fields.CashewProduced.isInvalid],
            ["AmountRealised", [fields.AmountRealised.visible && fields.AmountRealised.required ? ew.Validators.required(fields.AmountRealised.caption) : null, ew.Validators.float], fields.AmountRealised.isInvalid],
            ["SoldTo", [fields.SoldTo.visible && fields.SoldTo.required ? ew.Validators.required(fields.SoldTo.caption) : null], fields.SoldTo.isInvalid],
            ["Comments", [fields.Comments.visible && fields.Comments.required ? ew.Validators.required(fields.Comments.caption) : null], fields.Comments.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["FarmNo",false],["NRC",false],["SeasonYear",false],["CashewProduced",false],["AmountRealised",false],["SoldTo",false],["Comments",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "SeasonYear": <?= $Grid->SeasonYear->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fproduction_salesgrid" class="ew-form ew-list-form">
<div id="gmp_production_sales" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_production_salesgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Grid->FarmNo->headerCellClass() ?>"><div id="elh_production_sales_FarmNo" class="production_sales_FarmNo"><?= $Grid->renderFieldHeader($Grid->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_production_sales_NRC" class="production_sales_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->SeasonYear->Visible) { // SeasonYear ?>
        <th data-name="SeasonYear" class="<?= $Grid->SeasonYear->headerCellClass() ?>"><div id="elh_production_sales_SeasonYear" class="production_sales_SeasonYear"><?= $Grid->renderFieldHeader($Grid->SeasonYear) ?></div></th>
<?php } ?>
<?php if ($Grid->CashewProduced->Visible) { // CashewProduced ?>
        <th data-name="CashewProduced" class="<?= $Grid->CashewProduced->headerCellClass() ?>"><div id="elh_production_sales_CashewProduced" class="production_sales_CashewProduced"><?= $Grid->renderFieldHeader($Grid->CashewProduced) ?></div></th>
<?php } ?>
<?php if ($Grid->AmountRealised->Visible) { // AmountRealised ?>
        <th data-name="AmountRealised" class="<?= $Grid->AmountRealised->headerCellClass() ?>"><div id="elh_production_sales_AmountRealised" class="production_sales_AmountRealised"><?= $Grid->renderFieldHeader($Grid->AmountRealised) ?></div></th>
<?php } ?>
<?php if ($Grid->SoldTo->Visible) { // SoldTo ?>
        <th data-name="SoldTo" class="<?= $Grid->SoldTo->headerCellClass() ?>"><div id="elh_production_sales_SoldTo" class="production_sales_SoldTo"><?= $Grid->renderFieldHeader($Grid->SoldTo) ?></div></th>
<?php } ?>
<?php if ($Grid->Comments->Visible) { // Comments ?>
        <th data-name="Comments" class="<?= $Grid->Comments->headerCellClass() ?>"><div id="elh_production_sales_Comments" class="production_sales_Comments"><?= $Grid->renderFieldHeader($Grid->Comments) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Grid->FarmNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->FarmNo->getSessionValue() != "") { ?>
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmNo->getDisplayValue($Grid->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_FarmNo" name="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_FarmNo" class="el_production_sales_FarmNo">
<input type="<?= $Grid->FarmNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" data-table="production_sales" data-field="x_FarmNo" value="<?= $Grid->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmNo->formatPattern()) ?>"<?= $Grid->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmNo" id="o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_FarmNo" class="el_production_sales_FarmNo">
<?php if ($Grid->FarmNo->getSessionValue() != "") { ?>
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmNo->getDisplayValue($Grid->FarmNo->EditValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_FarmNo" name="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Grid->FarmNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" data-table="production_sales" data-field="x_FarmNo" value="<?= $Grid->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmNo->formatPattern()) ?>"<?= $Grid->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmNo->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmNo" id="o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue ?? $Grid->FarmNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_FarmNo" class="el_production_sales_FarmNo">
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<?= $Grid->FarmNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_FarmNo" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_FarmNo" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_FarmNo" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_FarmNo" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="production_sales" data-field="x_FarmNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->NRC->getSessionValue() != "") { ?>
<span<?= $Grid->NRC->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->NRC->getDisplayValue($Grid->NRC->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_NRC" name="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_NRC" class="el_production_sales_NRC">
<input type="<?= $Grid->NRC->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" data-table="production_sales" data-field="x_NRC" value="<?= $Grid->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_NRC" class="el_production_sales_NRC">
<?php if ($Grid->NRC->getSessionValue() != "") { ?>
<span<?= $Grid->NRC->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->NRC->getDisplayValue($Grid->NRC->EditValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_NRC" name="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Grid->NRC->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" data-table="production_sales" data-field="x_NRC" value="<?= $Grid->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue ?? $Grid->NRC->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_NRC" class="el_production_sales_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_NRC" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_NRC" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_NRC" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_NRC" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="production_sales" data-field="x_NRC" data-hidden="1" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->SeasonYear->Visible) { // SeasonYear ?>
        <td data-name="SeasonYear"<?= $Grid->SeasonYear->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_SeasonYear" class="el_production_sales_SeasonYear">
    <select
        id="x<?= $Grid->RowIndex ?>_SeasonYear"
        name="x<?= $Grid->RowIndex ?>_SeasonYear"
        class="form-select ew-select<?= $Grid->SeasonYear->isInvalidClass() ?>"
        <?php if (!$Grid->SeasonYear->IsNativeSelect) { ?>
        data-select2-id="fproduction_salesgrid_x<?= $Grid->RowIndex ?>_SeasonYear"
        <?php } ?>
        data-table="production_sales"
        data-field="x_SeasonYear"
        data-value-separator="<?= $Grid->SeasonYear->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SeasonYear->getPlaceHolder()) ?>"
        <?= $Grid->SeasonYear->editAttributes() ?>>
        <?= $Grid->SeasonYear->selectOptionListHtml("x{$Grid->RowIndex}_SeasonYear") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SeasonYear->getErrorMessage() ?></div>
<?= $Grid->SeasonYear->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SeasonYear") ?>
<?php if (!$Grid->SeasonYear->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_salesgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SeasonYear", selectId: "fproduction_salesgrid_x<?= $Grid->RowIndex ?>_SeasonYear" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_salesgrid.lists.SeasonYear?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SeasonYear", form: "fproduction_salesgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SeasonYear", form: "fproduction_salesgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_sales.fields.SeasonYear.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="production_sales" data-field="x_SeasonYear" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SeasonYear" id="o<?= $Grid->RowIndex ?>_SeasonYear" value="<?= HtmlEncode($Grid->SeasonYear->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_SeasonYear" class="el_production_sales_SeasonYear">
    <select
        id="x<?= $Grid->RowIndex ?>_SeasonYear"
        name="x<?= $Grid->RowIndex ?>_SeasonYear"
        class="form-select ew-select<?= $Grid->SeasonYear->isInvalidClass() ?>"
        <?php if (!$Grid->SeasonYear->IsNativeSelect) { ?>
        data-select2-id="fproduction_salesgrid_x<?= $Grid->RowIndex ?>_SeasonYear"
        <?php } ?>
        data-table="production_sales"
        data-field="x_SeasonYear"
        data-value-separator="<?= $Grid->SeasonYear->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SeasonYear->getPlaceHolder()) ?>"
        <?= $Grid->SeasonYear->editAttributes() ?>>
        <?= $Grid->SeasonYear->selectOptionListHtml("x{$Grid->RowIndex}_SeasonYear") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SeasonYear->getErrorMessage() ?></div>
<?= $Grid->SeasonYear->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SeasonYear") ?>
<?php if (!$Grid->SeasonYear->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_salesgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SeasonYear", selectId: "fproduction_salesgrid_x<?= $Grid->RowIndex ?>_SeasonYear" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_salesgrid.lists.SeasonYear?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SeasonYear", form: "fproduction_salesgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SeasonYear", form: "fproduction_salesgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_sales.fields.SeasonYear.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_SeasonYear" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SeasonYear" id="o<?= $Grid->RowIndex ?>_SeasonYear" value="<?= HtmlEncode($Grid->SeasonYear->OldValue ?? $Grid->SeasonYear->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_SeasonYear" class="el_production_sales_SeasonYear">
<span<?= $Grid->SeasonYear->viewAttributes() ?>>
<?= $Grid->SeasonYear->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_SeasonYear" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_SeasonYear" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_SeasonYear" value="<?= HtmlEncode($Grid->SeasonYear->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_SeasonYear" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_SeasonYear" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_SeasonYear" value="<?= HtmlEncode($Grid->SeasonYear->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="production_sales" data-field="x_SeasonYear" data-hidden="1" name="x<?= $Grid->RowIndex ?>_SeasonYear" id="x<?= $Grid->RowIndex ?>_SeasonYear" value="<?= HtmlEncode($Grid->SeasonYear->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->CashewProduced->Visible) { // CashewProduced ?>
        <td data-name="CashewProduced"<?= $Grid->CashewProduced->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_CashewProduced" class="el_production_sales_CashewProduced">
<input type="<?= $Grid->CashewProduced->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_CashewProduced" id="x<?= $Grid->RowIndex ?>_CashewProduced" data-table="production_sales" data-field="x_CashewProduced" value="<?= $Grid->CashewProduced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->CashewProduced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->CashewProduced->formatPattern()) ?>"<?= $Grid->CashewProduced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->CashewProduced->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="production_sales" data-field="x_CashewProduced" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CashewProduced" id="o<?= $Grid->RowIndex ?>_CashewProduced" value="<?= HtmlEncode($Grid->CashewProduced->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_CashewProduced" class="el_production_sales_CashewProduced">
<input type="<?= $Grid->CashewProduced->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_CashewProduced" id="x<?= $Grid->RowIndex ?>_CashewProduced" data-table="production_sales" data-field="x_CashewProduced" value="<?= $Grid->CashewProduced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->CashewProduced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->CashewProduced->formatPattern()) ?>"<?= $Grid->CashewProduced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->CashewProduced->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_CashewProduced" class="el_production_sales_CashewProduced">
<span<?= $Grid->CashewProduced->viewAttributes() ?>>
<?= $Grid->CashewProduced->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_CashewProduced" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_CashewProduced" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_CashewProduced" value="<?= HtmlEncode($Grid->CashewProduced->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_CashewProduced" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_CashewProduced" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_CashewProduced" value="<?= HtmlEncode($Grid->CashewProduced->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AmountRealised->Visible) { // AmountRealised ?>
        <td data-name="AmountRealised"<?= $Grid->AmountRealised->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_AmountRealised" class="el_production_sales_AmountRealised">
<input type="<?= $Grid->AmountRealised->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AmountRealised" id="x<?= $Grid->RowIndex ?>_AmountRealised" data-table="production_sales" data-field="x_AmountRealised" value="<?= $Grid->AmountRealised->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AmountRealised->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AmountRealised->formatPattern()) ?>"<?= $Grid->AmountRealised->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AmountRealised->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="production_sales" data-field="x_AmountRealised" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AmountRealised" id="o<?= $Grid->RowIndex ?>_AmountRealised" value="<?= HtmlEncode($Grid->AmountRealised->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_AmountRealised" class="el_production_sales_AmountRealised">
<input type="<?= $Grid->AmountRealised->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AmountRealised" id="x<?= $Grid->RowIndex ?>_AmountRealised" data-table="production_sales" data-field="x_AmountRealised" value="<?= $Grid->AmountRealised->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AmountRealised->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AmountRealised->formatPattern()) ?>"<?= $Grid->AmountRealised->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AmountRealised->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_AmountRealised" class="el_production_sales_AmountRealised">
<span<?= $Grid->AmountRealised->viewAttributes() ?>>
<?= $Grid->AmountRealised->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_AmountRealised" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_AmountRealised" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_AmountRealised" value="<?= HtmlEncode($Grid->AmountRealised->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_AmountRealised" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_AmountRealised" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_AmountRealised" value="<?= HtmlEncode($Grid->AmountRealised->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->SoldTo->Visible) { // SoldTo ?>
        <td data-name="SoldTo"<?= $Grid->SoldTo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_SoldTo" class="el_production_sales_SoldTo">
<input type="<?= $Grid->SoldTo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_SoldTo" id="x<?= $Grid->RowIndex ?>_SoldTo" data-table="production_sales" data-field="x_SoldTo" value="<?= $Grid->SoldTo->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->SoldTo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->SoldTo->formatPattern()) ?>"<?= $Grid->SoldTo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->SoldTo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="production_sales" data-field="x_SoldTo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SoldTo" id="o<?= $Grid->RowIndex ?>_SoldTo" value="<?= HtmlEncode($Grid->SoldTo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_SoldTo" class="el_production_sales_SoldTo">
<input type="<?= $Grid->SoldTo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_SoldTo" id="x<?= $Grid->RowIndex ?>_SoldTo" data-table="production_sales" data-field="x_SoldTo" value="<?= $Grid->SoldTo->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->SoldTo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->SoldTo->formatPattern()) ?>"<?= $Grid->SoldTo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->SoldTo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_SoldTo" class="el_production_sales_SoldTo">
<span<?= $Grid->SoldTo->viewAttributes() ?>>
<?= $Grid->SoldTo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_SoldTo" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_SoldTo" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_SoldTo" value="<?= HtmlEncode($Grid->SoldTo->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_SoldTo" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_SoldTo" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_SoldTo" value="<?= HtmlEncode($Grid->SoldTo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Comments->Visible) { // Comments ?>
        <td data-name="Comments"<?= $Grid->Comments->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_Comments" class="el_production_sales_Comments">
<textarea data-table="production_sales" data-field="x_Comments" name="x<?= $Grid->RowIndex ?>_Comments" id="x<?= $Grid->RowIndex ?>_Comments" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->Comments->getPlaceHolder()) ?>"<?= $Grid->Comments->editAttributes() ?>><?= $Grid->Comments->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->Comments->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="production_sales" data-field="x_Comments" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Comments" id="o<?= $Grid->RowIndex ?>_Comments" value="<?= HtmlEncode($Grid->Comments->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_Comments" class="el_production_sales_Comments">
<textarea data-table="production_sales" data-field="x_Comments" name="x<?= $Grid->RowIndex ?>_Comments" id="x<?= $Grid->RowIndex ?>_Comments" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->Comments->getPlaceHolder()) ?>"<?= $Grid->Comments->editAttributes() ?>><?= $Grid->Comments->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->Comments->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_production_sales_Comments" class="el_production_sales_Comments">
<span<?= $Grid->Comments->viewAttributes() ?>>
<?= $Grid->Comments->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="production_sales" data-field="x_Comments" data-hidden="1" name="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_Comments" id="fproduction_salesgrid$x<?= $Grid->RowIndex ?>_Comments" value="<?= HtmlEncode($Grid->Comments->FormValue) ?>">
<input type="hidden" data-table="production_sales" data-field="x_Comments" data-hidden="1" data-old name="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_Comments" id="fproduction_salesgrid$o<?= $Grid->RowIndex ?>_Comments" value="<?= HtmlEncode($Grid->Comments->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fproduction_salesgrid","load"], () => fproduction_salesgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fproduction_salesgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_sales");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
