<?php

namespace PHPMaker2024\cidp24;

// Page object
$ProductionSalesEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fproduction_salesedit" id="fproduction_salesedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_sales: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fproduction_salesedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduction_salesedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["SeasonYear", [fields.SeasonYear.visible && fields.SeasonYear.required ? ew.Validators.required(fields.SeasonYear.caption) : null], fields.SeasonYear.isInvalid],
            ["CashewProduced", [fields.CashewProduced.visible && fields.CashewProduced.required ? ew.Validators.required(fields.CashewProduced.caption) : null, ew.Validators.float], fields.CashewProduced.isInvalid],
            ["AmountRealised", [fields.AmountRealised.visible && fields.AmountRealised.required ? ew.Validators.required(fields.AmountRealised.caption) : null, ew.Validators.float], fields.AmountRealised.isInvalid],
            ["SoldTo", [fields.SoldTo.visible && fields.SoldTo.required ? ew.Validators.required(fields.SoldTo.caption) : null], fields.SoldTo.isInvalid],
            ["Comments", [fields.Comments.visible && fields.Comments.required ? ew.Validators.required(fields.Comments.caption) : null], fields.Comments.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "SeasonYear": <?= $Page->SeasonYear->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_sales">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "farm") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farm">
<input type="hidden" name="fk_FarmNo" value="<?= HtmlEncode($Page->FarmNo->getSessionValue()) ?>">
<input type="hidden" name="fk_NRC" value="<?= HtmlEncode($Page->NRC->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <div id="r_FarmNo"<?= $Page->FarmNo->rowAttributes() ?>>
        <label id="elh_production_sales_FarmNo" for="x_FarmNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmNo->caption() ?><?= $Page->FarmNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmNo->cellAttributes() ?>>
<span id="el_production_sales_FarmNo">
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->EditValue))) ?>"></span>
<input type="hidden" id="x_FarmNo" name="x_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="production_sales" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?> aria-describedby="x_FarmNo_help">
<?= $Page->FarmNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_FarmNo" data-hidden="1" data-old name="o_FarmNo" id="o_FarmNo" value="<?= HtmlEncode($Page->FarmNo->OldValue ?? $Page->FarmNo->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_production_sales_NRC" for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_production_sales_NRC">
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->NRC->getDisplayValue($Page->NRC->EditValue))) ?>"></span>
<input type="hidden" id="x_NRC" name="x_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="production_sales" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_NRC" data-hidden="1" data-old name="o_NRC" id="o_NRC" value="<?= HtmlEncode($Page->NRC->OldValue ?? $Page->NRC->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SeasonYear->Visible) { // SeasonYear ?>
    <div id="r_SeasonYear"<?= $Page->SeasonYear->rowAttributes() ?>>
        <label id="elh_production_sales_SeasonYear" for="x_SeasonYear" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeasonYear->caption() ?><?= $Page->SeasonYear->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeasonYear->cellAttributes() ?>>
<span id="el_production_sales_SeasonYear">
    <select
        id="x_SeasonYear"
        name="x_SeasonYear"
        class="form-select ew-select<?= $Page->SeasonYear->isInvalidClass() ?>"
        <?php if (!$Page->SeasonYear->IsNativeSelect) { ?>
        data-select2-id="fproduction_salesedit_x_SeasonYear"
        <?php } ?>
        data-table="production_sales"
        data-field="x_SeasonYear"
        data-value-separator="<?= $Page->SeasonYear->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeasonYear->getPlaceHolder()) ?>"
        <?= $Page->SeasonYear->editAttributes() ?>>
        <?= $Page->SeasonYear->selectOptionListHtml("x_SeasonYear") ?>
    </select>
    <?= $Page->SeasonYear->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SeasonYear->getErrorMessage() ?></div>
<?= $Page->SeasonYear->Lookup->getParamTag($Page, "p_x_SeasonYear") ?>
<?php if (!$Page->SeasonYear->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_salesedit", function() {
    var options = { name: "x_SeasonYear", selectId: "fproduction_salesedit_x_SeasonYear" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_salesedit.lists.SeasonYear?.lookupOptions.length) {
        options.data = { id: "x_SeasonYear", form: "fproduction_salesedit" };
    } else {
        options.ajax = { id: "x_SeasonYear", form: "fproduction_salesedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_sales.fields.SeasonYear.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<input type="hidden" data-table="production_sales" data-field="x_SeasonYear" data-hidden="1" data-old name="o_SeasonYear" id="o_SeasonYear" value="<?= HtmlEncode($Page->SeasonYear->OldValue ?? $Page->SeasonYear->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CashewProduced->Visible) { // CashewProduced ?>
    <div id="r_CashewProduced"<?= $Page->CashewProduced->rowAttributes() ?>>
        <label id="elh_production_sales_CashewProduced" for="x_CashewProduced" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CashewProduced->caption() ?><?= $Page->CashewProduced->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CashewProduced->cellAttributes() ?>>
<span id="el_production_sales_CashewProduced">
<input type="<?= $Page->CashewProduced->getInputTextType() ?>" name="x_CashewProduced" id="x_CashewProduced" data-table="production_sales" data-field="x_CashewProduced" value="<?= $Page->CashewProduced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->CashewProduced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->CashewProduced->formatPattern()) ?>"<?= $Page->CashewProduced->editAttributes() ?> aria-describedby="x_CashewProduced_help">
<?= $Page->CashewProduced->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->CashewProduced->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AmountRealised->Visible) { // AmountRealised ?>
    <div id="r_AmountRealised"<?= $Page->AmountRealised->rowAttributes() ?>>
        <label id="elh_production_sales_AmountRealised" for="x_AmountRealised" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AmountRealised->caption() ?><?= $Page->AmountRealised->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AmountRealised->cellAttributes() ?>>
<span id="el_production_sales_AmountRealised">
<input type="<?= $Page->AmountRealised->getInputTextType() ?>" name="x_AmountRealised" id="x_AmountRealised" data-table="production_sales" data-field="x_AmountRealised" value="<?= $Page->AmountRealised->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountRealised->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountRealised->formatPattern()) ?>"<?= $Page->AmountRealised->editAttributes() ?> aria-describedby="x_AmountRealised_help">
<?= $Page->AmountRealised->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AmountRealised->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SoldTo->Visible) { // SoldTo ?>
    <div id="r_SoldTo"<?= $Page->SoldTo->rowAttributes() ?>>
        <label id="elh_production_sales_SoldTo" for="x_SoldTo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SoldTo->caption() ?><?= $Page->SoldTo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SoldTo->cellAttributes() ?>>
<span id="el_production_sales_SoldTo">
<input type="<?= $Page->SoldTo->getInputTextType() ?>" name="x_SoldTo" id="x_SoldTo" data-table="production_sales" data-field="x_SoldTo" value="<?= $Page->SoldTo->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->SoldTo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SoldTo->formatPattern()) ?>"<?= $Page->SoldTo->editAttributes() ?> aria-describedby="x_SoldTo_help">
<?= $Page->SoldTo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->SoldTo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
    <div id="r_Comments"<?= $Page->Comments->rowAttributes() ?>>
        <label id="elh_production_sales_Comments" for="x_Comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Comments->caption() ?><?= $Page->Comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Comments->cellAttributes() ?>>
<span id="el_production_sales_Comments">
<textarea data-table="production_sales" data-field="x_Comments" name="x_Comments" id="x_Comments" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->Comments->getPlaceHolder()) ?>"<?= $Page->Comments->editAttributes() ?> aria-describedby="x_Comments_help"><?= $Page->Comments->EditValue ?></textarea>
<?= $Page->Comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduction_salesedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduction_salesedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_sales");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
