<?php

namespace PHPMaker2024\cidp24;

// Page object
$PlantingMaterialsEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fplanting_materialsedit" id="fplanting_materialsedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { planting_materials: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fplanting_materialsedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fplanting_materialsedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["MaterialCode", [fields.MaterialCode.visible && fields.MaterialCode.required ? ew.Validators.required(fields.MaterialCode.caption) : null], fields.MaterialCode.isInvalid],
            ["PlantingMaterials", [fields.PlantingMaterials.visible && fields.PlantingMaterials.required ? ew.Validators.required(fields.PlantingMaterials.caption) : null], fields.PlantingMaterials.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="planting_materials">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->MaterialCode->Visible) { // MaterialCode ?>
    <div id="r_MaterialCode"<?= $Page->MaterialCode->rowAttributes() ?>>
        <label id="elh_planting_materials_MaterialCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MaterialCode->caption() ?><?= $Page->MaterialCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MaterialCode->cellAttributes() ?>>
<span id="el_planting_materials_MaterialCode">
<span<?= $Page->MaterialCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->MaterialCode->getDisplayValue($Page->MaterialCode->EditValue))) ?>"></span>
<input type="hidden" data-table="planting_materials" data-field="x_MaterialCode" data-hidden="1" name="x_MaterialCode" id="x_MaterialCode" value="<?= HtmlEncode($Page->MaterialCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlantingMaterials->Visible) { // PlantingMaterials ?>
    <div id="r_PlantingMaterials"<?= $Page->PlantingMaterials->rowAttributes() ?>>
        <label id="elh_planting_materials_PlantingMaterials" for="x_PlantingMaterials" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlantingMaterials->caption() ?><?= $Page->PlantingMaterials->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlantingMaterials->cellAttributes() ?>>
<span id="el_planting_materials_PlantingMaterials">
<input type="<?= $Page->PlantingMaterials->getInputTextType() ?>" name="x_PlantingMaterials" id="x_PlantingMaterials" data-table="planting_materials" data-field="x_PlantingMaterials" value="<?= $Page->PlantingMaterials->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PlantingMaterials->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantingMaterials->formatPattern()) ?>"<?= $Page->PlantingMaterials->editAttributes() ?> aria-describedby="x_PlantingMaterials_help">
<?= $Page->PlantingMaterials->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlantingMaterials->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fplanting_materialsedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fplanting_materialsedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("planting_materials");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
