<?php

namespace PHPMaker2024\cidp24;

// Page object
$MonthRefEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fmonth_refedit" id="fmonth_refedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { month_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fmonth_refedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmonth_refedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["MonthCode", [fields.MonthCode.visible && fields.MonthCode.required ? ew.Validators.required(fields.MonthCode.caption) : null, ew.Validators.integer], fields.MonthCode.isInvalid],
            ["MonthName", [fields.MonthName.visible && fields.MonthName.required ? ew.Validators.required(fields.MonthName.caption) : null], fields.MonthName.isInvalid],
            ["MonthShort", [fields.MonthShort.visible && fields.MonthShort.required ? ew.Validators.required(fields.MonthShort.caption) : null], fields.MonthShort.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="month_ref">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->MonthCode->Visible) { // MonthCode ?>
    <div id="r_MonthCode"<?= $Page->MonthCode->rowAttributes() ?>>
        <label id="elh_month_ref_MonthCode" for="x_MonthCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MonthCode->caption() ?><?= $Page->MonthCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MonthCode->cellAttributes() ?>>
<span id="el_month_ref_MonthCode">
<input type="<?= $Page->MonthCode->getInputTextType() ?>" name="x_MonthCode" id="x_MonthCode" data-table="month_ref" data-field="x_MonthCode" value="<?= $Page->MonthCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->MonthCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MonthCode->formatPattern()) ?>"<?= $Page->MonthCode->editAttributes() ?> aria-describedby="x_MonthCode_help">
<?= $Page->MonthCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->MonthCode->getErrorMessage() ?></div>
<input type="hidden" data-table="month_ref" data-field="x_MonthCode" data-hidden="1" data-old name="o_MonthCode" id="o_MonthCode" value="<?= HtmlEncode($Page->MonthCode->OldValue ?? $Page->MonthCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MonthName->Visible) { // MonthName ?>
    <div id="r_MonthName"<?= $Page->MonthName->rowAttributes() ?>>
        <label id="elh_month_ref_MonthName" for="x_MonthName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MonthName->caption() ?><?= $Page->MonthName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MonthName->cellAttributes() ?>>
<span id="el_month_ref_MonthName">
<input type="<?= $Page->MonthName->getInputTextType() ?>" name="x_MonthName" id="x_MonthName" data-table="month_ref" data-field="x_MonthName" value="<?= $Page->MonthName->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->MonthName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MonthName->formatPattern()) ?>"<?= $Page->MonthName->editAttributes() ?> aria-describedby="x_MonthName_help">
<?= $Page->MonthName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->MonthName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MonthShort->Visible) { // MonthShort ?>
    <div id="r_MonthShort"<?= $Page->MonthShort->rowAttributes() ?>>
        <label id="elh_month_ref_MonthShort" for="x_MonthShort" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MonthShort->caption() ?><?= $Page->MonthShort->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MonthShort->cellAttributes() ?>>
<span id="el_month_ref_MonthShort">
<input type="<?= $Page->MonthShort->getInputTextType() ?>" name="x_MonthShort" id="x_MonthShort" data-table="month_ref" data-field="x_MonthShort" value="<?= $Page->MonthShort->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Page->MonthShort->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MonthShort->formatPattern()) ?>"<?= $Page->MonthShort->editAttributes() ?> aria-describedby="x_MonthShort_help">
<?= $Page->MonthShort->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->MonthShort->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmonth_refedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmonth_refedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("month_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
