<?php

namespace PHPMaker2024\cidp24;

// Page object
$GrantBeneficiarySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { grant_beneficiary: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fgrant_beneficiarysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgrant_beneficiarysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["GrantNo", [ew.Validators.integer], fields.GrantNo.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["AmountDisbursed", [ew.Validators.float], fields.AmountDisbursed.isInvalid],
            ["ApplicationDate", [ew.Validators.datetime(fields.ApplicationDate.clientFormatPattern)], fields.ApplicationDate.isInvalid],
            ["AmountAppliedFor", [ew.Validators.float], fields.AmountAppliedFor.isInvalid],
            ["ReplyDate", [ew.Validators.datetime(fields.ReplyDate.clientFormatPattern)], fields.ReplyDate.isInvalid],
            ["Approved", [], fields.Approved.isInvalid],
            ["ReasonsForRejection", [], fields.ReasonsForRejection.isInvalid],
            ["Purpose", [], fields.Purpose.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "Approved": <?= $Page->Approved->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgrant_beneficiarysearch" id="fgrant_beneficiarysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="grant_beneficiary">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->GrantNo->Visible) { // GrantNo ?>
    <div id="r_GrantNo" class="row"<?= $Page->GrantNo->rowAttributes() ?>>
        <label for="x_GrantNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_GrantNo"><?= $Page->GrantNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_GrantNo" id="z_GrantNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GrantNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_GrantNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GrantNo->getInputTextType() ?>" name="x_GrantNo" id="x_GrantNo" data-table="grant_beneficiary" data-field="x_GrantNo" value="<?= $Page->GrantNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->GrantNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GrantNo->formatPattern()) ?>"<?= $Page->GrantNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GrantNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_NRC" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="grant_beneficiary" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fgrant_beneficiarysearch", function() {
    fgrant_beneficiarysearch.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.grant_beneficiary.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AmountDisbursed->Visible) { // AmountDisbursed ?>
    <div id="r_AmountDisbursed" class="row"<?= $Page->AmountDisbursed->rowAttributes() ?>>
        <label for="x_AmountDisbursed" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_AmountDisbursed"><?= $Page->AmountDisbursed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_AmountDisbursed" id="z_AmountDisbursed" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AmountDisbursed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_AmountDisbursed" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AmountDisbursed->getInputTextType() ?>" name="x_AmountDisbursed" id="x_AmountDisbursed" data-table="grant_beneficiary" data-field="x_AmountDisbursed" value="<?= $Page->AmountDisbursed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountDisbursed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountDisbursed->formatPattern()) ?>"<?= $Page->AmountDisbursed->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AmountDisbursed->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ApplicationDate->Visible) { // ApplicationDate ?>
    <div id="r_ApplicationDate" class="row"<?= $Page->ApplicationDate->rowAttributes() ?>>
        <label for="x_ApplicationDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_ApplicationDate"><?= $Page->ApplicationDate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ApplicationDate" id="z_ApplicationDate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ApplicationDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_ApplicationDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ApplicationDate->getInputTextType() ?>" name="x_ApplicationDate" id="x_ApplicationDate" data-table="grant_beneficiary" data-field="x_ApplicationDate" value="<?= $Page->ApplicationDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ApplicationDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ApplicationDate->formatPattern()) ?>"<?= $Page->ApplicationDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ApplicationDate->getErrorMessage(false) ?></div>
<?php if (!$Page->ApplicationDate->ReadOnly && !$Page->ApplicationDate->Disabled && !isset($Page->ApplicationDate->EditAttrs["readonly"]) && !isset($Page->ApplicationDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiarysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiarysearch", "x_ApplicationDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
    <div id="r_AmountAppliedFor" class="row"<?= $Page->AmountAppliedFor->rowAttributes() ?>>
        <label for="x_AmountAppliedFor" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_AmountAppliedFor"><?= $Page->AmountAppliedFor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_AmountAppliedFor" id="z_AmountAppliedFor" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AmountAppliedFor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_AmountAppliedFor" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AmountAppliedFor->getInputTextType() ?>" name="x_AmountAppliedFor" id="x_AmountAppliedFor" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" value="<?= $Page->AmountAppliedFor->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountAppliedFor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountAppliedFor->formatPattern()) ?>"<?= $Page->AmountAppliedFor->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AmountAppliedFor->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ReplyDate->Visible) { // ReplyDate ?>
    <div id="r_ReplyDate" class="row"<?= $Page->ReplyDate->rowAttributes() ?>>
        <label for="x_ReplyDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_ReplyDate"><?= $Page->ReplyDate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ReplyDate" id="z_ReplyDate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ReplyDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_ReplyDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ReplyDate->getInputTextType() ?>" name="x_ReplyDate" id="x_ReplyDate" data-table="grant_beneficiary" data-field="x_ReplyDate" value="<?= $Page->ReplyDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ReplyDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReplyDate->formatPattern()) ?>"<?= $Page->ReplyDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReplyDate->getErrorMessage(false) ?></div>
<?php if (!$Page->ReplyDate->ReadOnly && !$Page->ReplyDate->Disabled && !isset($Page->ReplyDate->EditAttrs["readonly"]) && !isset($Page->ReplyDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiarysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiarysearch", "x_ReplyDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Approved->Visible) { // Approved ?>
    <div id="r_Approved" class="row"<?= $Page->Approved->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_Approved"><?= $Page->Approved->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Approved" id="z_Approved" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Approved->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_Approved" class="ew-search-field ew-search-field-single">
<template id="tp_x_Approved">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="grant_beneficiary" data-field="x_Approved" name="x_Approved" id="x_Approved"<?= $Page->Approved->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_Approved" class="ew-item-list"></div>
<selection-list hidden
    id="x_Approved"
    name="x_Approved"
    value="<?= HtmlEncode($Page->Approved->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_Approved"
    data-target="dsl_x_Approved"
    data-repeatcolumn="5"
    class="form-control<?= $Page->Approved->isInvalidClass() ?>"
    data-table="grant_beneficiary"
    data-field="x_Approved"
    data-value-separator="<?= $Page->Approved->displayValueSeparatorAttribute() ?>"
    <?= $Page->Approved->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->Approved->getErrorMessage(false) ?></div>
<?= $Page->Approved->Lookup->getParamTag($Page, "p_x_Approved") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
    <div id="r_ReasonsForRejection" class="row"<?= $Page->ReasonsForRejection->rowAttributes() ?>>
        <label for="x_ReasonsForRejection" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_ReasonsForRejection"><?= $Page->ReasonsForRejection->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ReasonsForRejection" id="z_ReasonsForRejection" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ReasonsForRejection->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_ReasonsForRejection" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ReasonsForRejection->getInputTextType() ?>" name="x_ReasonsForRejection" id="x_ReasonsForRejection" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" value="<?= $Page->ReasonsForRejection->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->ReasonsForRejection->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReasonsForRejection->formatPattern()) ?>"<?= $Page->ReasonsForRejection->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReasonsForRejection->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Purpose->Visible) { // Purpose ?>
    <div id="r_Purpose" class="row"<?= $Page->Purpose->rowAttributes() ?>>
        <label for="x_Purpose" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grant_beneficiary_Purpose"><?= $Page->Purpose->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Purpose" id="z_Purpose" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Purpose->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grant_beneficiary_Purpose" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Purpose->getInputTextType() ?>" name="x_Purpose" id="x_Purpose" data-table="grant_beneficiary" data-field="x_Purpose" value="<?= $Page->Purpose->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Purpose->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Purpose->formatPattern()) ?>"<?= $Page->Purpose->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Purpose->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgrant_beneficiarysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgrant_beneficiarysearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fgrant_beneficiarysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("grant_beneficiary");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
