<?php

namespace PHPMaker2024\cidp24;

// Page object
$GrantBeneficiaryAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { grant_beneficiary: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fgrant_beneficiaryadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgrant_beneficiaryadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["GrantNo", [fields.GrantNo.visible && fields.GrantNo.required ? ew.Validators.required(fields.GrantNo.caption) : null, ew.Validators.integer], fields.GrantNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["AmountDisbursed", [fields.AmountDisbursed.visible && fields.AmountDisbursed.required ? ew.Validators.required(fields.AmountDisbursed.caption) : null, ew.Validators.float], fields.AmountDisbursed.isInvalid],
            ["ApplicationDate", [fields.ApplicationDate.visible && fields.ApplicationDate.required ? ew.Validators.required(fields.ApplicationDate.caption) : null, ew.Validators.datetime(fields.ApplicationDate.clientFormatPattern)], fields.ApplicationDate.isInvalid],
            ["AmountAppliedFor", [fields.AmountAppliedFor.visible && fields.AmountAppliedFor.required ? ew.Validators.required(fields.AmountAppliedFor.caption) : null, ew.Validators.float], fields.AmountAppliedFor.isInvalid],
            ["ReplyDate", [fields.ReplyDate.visible && fields.ReplyDate.required ? ew.Validators.required(fields.ReplyDate.caption) : null, ew.Validators.datetime(fields.ReplyDate.clientFormatPattern)], fields.ReplyDate.isInvalid],
            ["Approved", [fields.Approved.visible && fields.Approved.required ? ew.Validators.required(fields.Approved.caption) : null], fields.Approved.isInvalid],
            ["ReasonsForRejection", [fields.ReasonsForRejection.visible && fields.ReasonsForRejection.required ? ew.Validators.required(fields.ReasonsForRejection.caption) : null], fields.ReasonsForRejection.isInvalid],
            ["Purpose", [fields.Purpose.visible && fields.Purpose.required ? ew.Validators.required(fields.Purpose.caption) : null], fields.Purpose.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "Approved": <?= $Page->Approved->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgrant_beneficiaryadd" id="fgrant_beneficiaryadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="grant_beneficiary">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "grant") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="grant">
<input type="hidden" name="fk_GrantNo" value="<?= HtmlEncode($Page->GrantNo->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->GrantNo->Visible) { // GrantNo ?>
    <div id="r_GrantNo"<?= $Page->GrantNo->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_GrantNo" for="x_GrantNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GrantNo->caption() ?><?= $Page->GrantNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GrantNo->cellAttributes() ?>>
<?php if ($Page->GrantNo->getSessionValue() != "") { ?>
<span<?= $Page->GrantNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->GrantNo->getDisplayValue($Page->GrantNo->ViewValue))) ?>"></span>
<input type="hidden" id="x_GrantNo" name="x_GrantNo" value="<?= HtmlEncode($Page->GrantNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_grant_beneficiary_GrantNo">
<input type="<?= $Page->GrantNo->getInputTextType() ?>" name="x_GrantNo" id="x_GrantNo" data-table="grant_beneficiary" data-field="x_GrantNo" value="<?= $Page->GrantNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->GrantNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GrantNo->formatPattern()) ?>"<?= $Page->GrantNo->editAttributes() ?> aria-describedby="x_GrantNo_help">
<?= $Page->GrantNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GrantNo->getErrorMessage() ?></div>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_grant_beneficiary_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
</span>
<selection-list hidden class="form-control" data-table="grant_beneficiary" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("fgrant_beneficiaryadd", function() {
    fgrant_beneficiaryadd.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.grant_beneficiary.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AmountDisbursed->Visible) { // AmountDisbursed ?>
    <div id="r_AmountDisbursed"<?= $Page->AmountDisbursed->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_AmountDisbursed" for="x_AmountDisbursed" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AmountDisbursed->caption() ?><?= $Page->AmountDisbursed->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AmountDisbursed->cellAttributes() ?>>
<span id="el_grant_beneficiary_AmountDisbursed">
<input type="<?= $Page->AmountDisbursed->getInputTextType() ?>" name="x_AmountDisbursed" id="x_AmountDisbursed" data-table="grant_beneficiary" data-field="x_AmountDisbursed" value="<?= $Page->AmountDisbursed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountDisbursed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountDisbursed->formatPattern()) ?>"<?= $Page->AmountDisbursed->editAttributes() ?> aria-describedby="x_AmountDisbursed_help">
<?= $Page->AmountDisbursed->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AmountDisbursed->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ApplicationDate->Visible) { // ApplicationDate ?>
    <div id="r_ApplicationDate"<?= $Page->ApplicationDate->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_ApplicationDate" for="x_ApplicationDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ApplicationDate->caption() ?><?= $Page->ApplicationDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ApplicationDate->cellAttributes() ?>>
<span id="el_grant_beneficiary_ApplicationDate">
<input type="<?= $Page->ApplicationDate->getInputTextType() ?>" name="x_ApplicationDate" id="x_ApplicationDate" data-table="grant_beneficiary" data-field="x_ApplicationDate" value="<?= $Page->ApplicationDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ApplicationDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ApplicationDate->formatPattern()) ?>"<?= $Page->ApplicationDate->editAttributes() ?> aria-describedby="x_ApplicationDate_help">
<?= $Page->ApplicationDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ApplicationDate->getErrorMessage() ?></div>
<?php if (!$Page->ApplicationDate->ReadOnly && !$Page->ApplicationDate->Disabled && !isset($Page->ApplicationDate->EditAttrs["readonly"]) && !isset($Page->ApplicationDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiaryadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiaryadd", "x_ApplicationDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
    <div id="r_AmountAppliedFor"<?= $Page->AmountAppliedFor->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_AmountAppliedFor" for="x_AmountAppliedFor" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AmountAppliedFor->caption() ?><?= $Page->AmountAppliedFor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AmountAppliedFor->cellAttributes() ?>>
<span id="el_grant_beneficiary_AmountAppliedFor">
<input type="<?= $Page->AmountAppliedFor->getInputTextType() ?>" name="x_AmountAppliedFor" id="x_AmountAppliedFor" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" value="<?= $Page->AmountAppliedFor->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AmountAppliedFor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AmountAppliedFor->formatPattern()) ?>"<?= $Page->AmountAppliedFor->editAttributes() ?> aria-describedby="x_AmountAppliedFor_help">
<?= $Page->AmountAppliedFor->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AmountAppliedFor->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ReplyDate->Visible) { // ReplyDate ?>
    <div id="r_ReplyDate"<?= $Page->ReplyDate->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_ReplyDate" for="x_ReplyDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ReplyDate->caption() ?><?= $Page->ReplyDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ReplyDate->cellAttributes() ?>>
<span id="el_grant_beneficiary_ReplyDate">
<input type="<?= $Page->ReplyDate->getInputTextType() ?>" name="x_ReplyDate" id="x_ReplyDate" data-table="grant_beneficiary" data-field="x_ReplyDate" value="<?= $Page->ReplyDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ReplyDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReplyDate->formatPattern()) ?>"<?= $Page->ReplyDate->editAttributes() ?> aria-describedby="x_ReplyDate_help">
<?= $Page->ReplyDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ReplyDate->getErrorMessage() ?></div>
<?php if (!$Page->ReplyDate->ReadOnly && !$Page->ReplyDate->Disabled && !isset($Page->ReplyDate->EditAttrs["readonly"]) && !isset($Page->ReplyDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiaryadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiaryadd", "x_ReplyDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Approved->Visible) { // Approved ?>
    <div id="r_Approved"<?= $Page->Approved->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_Approved" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Approved->caption() ?><?= $Page->Approved->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Approved->cellAttributes() ?>>
<span id="el_grant_beneficiary_Approved">
<template id="tp_x_Approved">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="grant_beneficiary" data-field="x_Approved" name="x_Approved" id="x_Approved"<?= $Page->Approved->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_Approved" class="ew-item-list"></div>
<selection-list hidden
    id="x_Approved"
    name="x_Approved"
    value="<?= HtmlEncode($Page->Approved->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_Approved"
    data-target="dsl_x_Approved"
    data-repeatcolumn="5"
    class="form-control<?= $Page->Approved->isInvalidClass() ?>"
    data-table="grant_beneficiary"
    data-field="x_Approved"
    data-value-separator="<?= $Page->Approved->displayValueSeparatorAttribute() ?>"
    <?= $Page->Approved->editAttributes() ?>></selection-list>
<?= $Page->Approved->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Approved->getErrorMessage() ?></div>
<?= $Page->Approved->Lookup->getParamTag($Page, "p_x_Approved") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
    <div id="r_ReasonsForRejection"<?= $Page->ReasonsForRejection->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_ReasonsForRejection" for="x_ReasonsForRejection" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ReasonsForRejection->caption() ?><?= $Page->ReasonsForRejection->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ReasonsForRejection->cellAttributes() ?>>
<span id="el_grant_beneficiary_ReasonsForRejection">
<input type="<?= $Page->ReasonsForRejection->getInputTextType() ?>" name="x_ReasonsForRejection" id="x_ReasonsForRejection" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" value="<?= $Page->ReasonsForRejection->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->ReasonsForRejection->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReasonsForRejection->formatPattern()) ?>"<?= $Page->ReasonsForRejection->editAttributes() ?> aria-describedby="x_ReasonsForRejection_help">
<?= $Page->ReasonsForRejection->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ReasonsForRejection->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Purpose->Visible) { // Purpose ?>
    <div id="r_Purpose"<?= $Page->Purpose->rowAttributes() ?>>
        <label id="elh_grant_beneficiary_Purpose" for="x_Purpose" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Purpose->caption() ?><?= $Page->Purpose->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Purpose->cellAttributes() ?>>
<span id="el_grant_beneficiary_Purpose">
<input type="<?= $Page->Purpose->getInputTextType() ?>" name="x_Purpose" id="x_Purpose" data-table="grant_beneficiary" data-field="x_Purpose" value="<?= $Page->Purpose->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Purpose->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Purpose->formatPattern()) ?>"<?= $Page->Purpose->editAttributes() ?> aria-describedby="x_Purpose_help">
<?= $Page->Purpose->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Purpose->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgrant_beneficiaryadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgrant_beneficiaryadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("grant_beneficiary");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
