<?php

namespace PHPMaker2024\cidp24;

// Page object
$GoodsReceivedNoteAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { goods_received_note: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fgoods_received_noteadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgoods_received_noteadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["SupplierCode", [fields.SupplierCode.visible && fields.SupplierCode.required ? ew.Validators.required(fields.SupplierCode.caption) : null, ew.Validators.integer], fields.SupplierCode.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["District", [fields.District.visible && fields.District.required ? ew.Validators.required(fields.District.caption) : null], fields.District.isInvalid],
            ["FarmingSeason", [fields.FarmingSeason.visible && fields.FarmingSeason.required ? ew.Validators.required(fields.FarmingSeason.caption) : null], fields.FarmingSeason.isInvalid],
            ["SeedlingsReceived", [fields.SeedlingsReceived.visible && fields.SeedlingsReceived.required ? ew.Validators.required(fields.SeedlingsReceived.caption) : null, ew.Validators.float], fields.SeedlingsReceived.isInvalid],
            ["SeedsReceived", [fields.SeedsReceived.visible && fields.SeedsReceived.required ? ew.Validators.required(fields.SeedsReceived.caption) : null, ew.Validators.float], fields.SeedsReceived.isInvalid],
            ["SeedType", [fields.SeedType.visible && fields.SeedType.required ? ew.Validators.required(fields.SeedType.caption) : null], fields.SeedType.isInvalid],
            ["GoodsDescription", [fields.GoodsDescription.visible && fields.GoodsDescription.required ? ew.Validators.required(fields.GoodsDescription.caption) : null], fields.GoodsDescription.isInvalid],
            ["DateReceived", [fields.DateReceived.visible && fields.DateReceived.required ? ew.Validators.required(fields.DateReceived.caption) : null, ew.Validators.datetime(fields.DateReceived.clientFormatPattern)], fields.DateReceived.isInvalid],
            ["ReceivedBy", [fields.ReceivedBy.visible && fields.ReceivedBy.required ? ew.Validators.required(fields.ReceivedBy.caption) : null], fields.ReceivedBy.isInvalid],
            ["AuthorizedBy", [fields.AuthorizedBy.visible && fields.AuthorizedBy.required ? ew.Validators.required(fields.AuthorizedBy.caption) : null], fields.AuthorizedBy.isInvalid],
            ["GoodsReceived", [fields.GoodsReceived.visible && fields.GoodsReceived.required ? ew.Validators.required(fields.GoodsReceived.caption) : null], fields.GoodsReceived.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "SupplierCode": <?= $Page->SupplierCode->toClientList($Page) ?>,
            "District": <?= $Page->District->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgoods_received_noteadd" id="fgoods_received_noteadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="goods_received_note">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
    <div id="r_SupplierCode"<?= $Page->SupplierCode->rowAttributes() ?>>
        <label id="elh_goods_received_note_SupplierCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SupplierCode->caption() ?><?= $Page->SupplierCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SupplierCode->cellAttributes() ?>>
<span id="el_goods_received_note_SupplierCode">
    <select
        id="x_SupplierCode"
        name="x_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="fgoods_received_noteadd_x_SupplierCode"
        data-table="goods_received_note"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x_SupplierCode") ?>
    </select>
    <?= $Page->SupplierCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage() ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x_SupplierCode") ?>
<script>
loadjs.ready("fgoods_received_noteadd", function() {
    var options = { name: "x_SupplierCode", selectId: "fgoods_received_noteadd_x_SupplierCode" };
    if (fgoods_received_noteadd.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x_SupplierCode", form: "fgoods_received_noteadd" };
    } else {
        options.ajax = { id: "x_SupplierCode", form: "fgoods_received_noteadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN"<?= $Page->GRN->rowAttributes() ?>>
        <label id="elh_goods_received_note_GRN" for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GRN->caption() ?><?= $Page->GRN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GRN->cellAttributes() ?>>
<span id="el_goods_received_note_GRN">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x_GRN" id="x_GRN" data-table="goods_received_note" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?> aria-describedby="x_GRN_help">
<?= $Page->GRN->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
    <div id="r_District"<?= $Page->District->rowAttributes() ?>>
        <label id="elh_goods_received_note_District" for="x_District" class="<?= $Page->LeftColumnClass ?>"><?= $Page->District->caption() ?><?= $Page->District->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->District->cellAttributes() ?>>
<span id="el_goods_received_note_District">
    <select
        id="x_District"
        name="x_District"
        class="form-control ew-select<?= $Page->District->isInvalidClass() ?>"
        data-select2-id="fgoods_received_noteadd_x_District"
        data-table="goods_received_note"
        data-field="x_District"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->District->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->District->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>"
        <?= $Page->District->editAttributes() ?>>
        <?= $Page->District->selectOptionListHtml("x_District") ?>
    </select>
    <?= $Page->District->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->District->getErrorMessage() ?></div>
<?= $Page->District->Lookup->getParamTag($Page, "p_x_District") ?>
<script>
loadjs.ready("fgoods_received_noteadd", function() {
    var options = { name: "x_District", selectId: "fgoods_received_noteadd_x_District" };
    if (fgoods_received_noteadd.lists.District?.lookupOptions.length) {
        options.data = { id: "x_District", form: "fgoods_received_noteadd" };
    } else {
        options.ajax = { id: "x_District", form: "fgoods_received_noteadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.District.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
    <div id="r_FarmingSeason"<?= $Page->FarmingSeason->rowAttributes() ?>>
        <label id="elh_goods_received_note_FarmingSeason" for="x_FarmingSeason" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmingSeason->caption() ?><?= $Page->FarmingSeason->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmingSeason->cellAttributes() ?>>
<span id="el_goods_received_note_FarmingSeason">
    <select
        id="x_FarmingSeason"
        name="x_FarmingSeason"
        class="form-control ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        data-select2-id="fgoods_received_noteadd_x_FarmingSeason"
        data-table="goods_received_note"
        data-field="x_FarmingSeason"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmingSeason->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x_FarmingSeason") ?>
    </select>
    <?= $Page->FarmingSeason->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage() ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x_FarmingSeason") ?>
<script>
loadjs.ready("fgoods_received_noteadd", function() {
    var options = { name: "x_FarmingSeason", selectId: "fgoods_received_noteadd_x_FarmingSeason" };
    if (fgoods_received_noteadd.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x_FarmingSeason", form: "fgoods_received_noteadd" };
    } else {
        options.ajax = { id: "x_FarmingSeason", form: "fgoods_received_noteadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.FarmingSeason.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SeedlingsReceived->Visible) { // SeedlingsReceived ?>
    <div id="r_SeedlingsReceived"<?= $Page->SeedlingsReceived->rowAttributes() ?>>
        <label id="elh_goods_received_note_SeedlingsReceived" for="x_SeedlingsReceived" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeedlingsReceived->caption() ?><?= $Page->SeedlingsReceived->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeedlingsReceived->cellAttributes() ?>>
<span id="el_goods_received_note_SeedlingsReceived">
<input type="<?= $Page->SeedlingsReceived->getInputTextType() ?>" name="x_SeedlingsReceived" id="x_SeedlingsReceived" data-table="goods_received_note" data-field="x_SeedlingsReceived" value="<?= $Page->SeedlingsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived->formatPattern()) ?>"<?= $Page->SeedlingsReceived->editAttributes() ?> aria-describedby="x_SeedlingsReceived_help">
<?= $Page->SeedlingsReceived->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SeedsReceived->Visible) { // SeedsReceived ?>
    <div id="r_SeedsReceived"<?= $Page->SeedsReceived->rowAttributes() ?>>
        <label id="elh_goods_received_note_SeedsReceived" for="x_SeedsReceived" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeedsReceived->caption() ?><?= $Page->SeedsReceived->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeedsReceived->cellAttributes() ?>>
<span id="el_goods_received_note_SeedsReceived">
<input type="<?= $Page->SeedsReceived->getInputTextType() ?>" name="x_SeedsReceived" id="x_SeedsReceived" data-table="goods_received_note" data-field="x_SeedsReceived" value="<?= $Page->SeedsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedsReceived->formatPattern()) ?>"<?= $Page->SeedsReceived->editAttributes() ?> aria-describedby="x_SeedsReceived_help">
<?= $Page->SeedsReceived->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->SeedsReceived->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
    <div id="r_SeedType"<?= $Page->SeedType->rowAttributes() ?>>
        <label id="elh_goods_received_note_SeedType" for="x_SeedType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeedType->caption() ?><?= $Page->SeedType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeedType->cellAttributes() ?>>
<span id="el_goods_received_note_SeedType">
    <select
        id="x_SeedType"
        name="x_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="fgoods_received_noteadd_x_SeedType"
        <?php } ?>
        data-table="goods_received_note"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x_SeedType") ?>
    </select>
    <?= $Page->SeedType->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("fgoods_received_noteadd", function() {
    var options = { name: "x_SeedType", selectId: "fgoods_received_noteadd_x_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgoods_received_noteadd.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x_SeedType", form: "fgoods_received_noteadd" };
    } else {
        options.ajax = { id: "x_SeedType", form: "fgoods_received_noteadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.goods_received_note.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GoodsDescription->Visible) { // GoodsDescription ?>
    <div id="r_GoodsDescription"<?= $Page->GoodsDescription->rowAttributes() ?>>
        <label id="elh_goods_received_note_GoodsDescription" for="x_GoodsDescription" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GoodsDescription->caption() ?><?= $Page->GoodsDescription->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GoodsDescription->cellAttributes() ?>>
<span id="el_goods_received_note_GoodsDescription">
<input type="<?= $Page->GoodsDescription->getInputTextType() ?>" name="x_GoodsDescription" id="x_GoodsDescription" data-table="goods_received_note" data-field="x_GoodsDescription" value="<?= $Page->GoodsDescription->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GoodsDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GoodsDescription->formatPattern()) ?>"<?= $Page->GoodsDescription->editAttributes() ?> aria-describedby="x_GoodsDescription_help">
<?= $Page->GoodsDescription->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GoodsDescription->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DateReceived->Visible) { // DateReceived ?>
    <div id="r_DateReceived"<?= $Page->DateReceived->rowAttributes() ?>>
        <label id="elh_goods_received_note_DateReceived" for="x_DateReceived" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DateReceived->caption() ?><?= $Page->DateReceived->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DateReceived->cellAttributes() ?>>
<span id="el_goods_received_note_DateReceived">
<input type="<?= $Page->DateReceived->getInputTextType() ?>" name="x_DateReceived" id="x_DateReceived" data-table="goods_received_note" data-field="x_DateReceived" value="<?= $Page->DateReceived->EditValue ?>" placeholder="<?= HtmlEncode($Page->DateReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateReceived->formatPattern()) ?>"<?= $Page->DateReceived->editAttributes() ?> aria-describedby="x_DateReceived_help">
<?= $Page->DateReceived->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DateReceived->getErrorMessage() ?></div>
<?php if (!$Page->DateReceived->ReadOnly && !$Page->DateReceived->Disabled && !isset($Page->DateReceived->EditAttrs["readonly"]) && !isset($Page->DateReceived->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgoods_received_noteadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgoods_received_noteadd", "x_DateReceived", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ReceivedBy->Visible) { // ReceivedBy ?>
    <div id="r_ReceivedBy"<?= $Page->ReceivedBy->rowAttributes() ?>>
        <label id="elh_goods_received_note_ReceivedBy" for="x_ReceivedBy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ReceivedBy->caption() ?><?= $Page->ReceivedBy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ReceivedBy->cellAttributes() ?>>
<span id="el_goods_received_note_ReceivedBy">
<input type="<?= $Page->ReceivedBy->getInputTextType() ?>" name="x_ReceivedBy" id="x_ReceivedBy" data-table="goods_received_note" data-field="x_ReceivedBy" value="<?= $Page->ReceivedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ReceivedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReceivedBy->formatPattern()) ?>"<?= $Page->ReceivedBy->editAttributes() ?> aria-describedby="x_ReceivedBy_help">
<?= $Page->ReceivedBy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ReceivedBy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AuthorizedBy->Visible) { // AuthorizedBy ?>
    <div id="r_AuthorizedBy"<?= $Page->AuthorizedBy->rowAttributes() ?>>
        <label id="elh_goods_received_note_AuthorizedBy" for="x_AuthorizedBy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AuthorizedBy->caption() ?><?= $Page->AuthorizedBy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AuthorizedBy->cellAttributes() ?>>
<span id="el_goods_received_note_AuthorizedBy">
<input type="<?= $Page->AuthorizedBy->getInputTextType() ?>" name="x_AuthorizedBy" id="x_AuthorizedBy" data-table="goods_received_note" data-field="x_AuthorizedBy" value="<?= $Page->AuthorizedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorizedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorizedBy->formatPattern()) ?>"<?= $Page->AuthorizedBy->editAttributes() ?> aria-describedby="x_AuthorizedBy_help">
<?= $Page->AuthorizedBy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AuthorizedBy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->GoodsReceived->Visible) { // GoodsReceived ?>
    <div id="r_GoodsReceived"<?= $Page->GoodsReceived->rowAttributes() ?>>
        <label id="elh_goods_received_note_GoodsReceived" for="x_GoodsReceived" class="<?= $Page->LeftColumnClass ?>"><?= $Page->GoodsReceived->caption() ?><?= $Page->GoodsReceived->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->GoodsReceived->cellAttributes() ?>>
<span id="el_goods_received_note_GoodsReceived">
<textarea data-table="goods_received_note" data-field="x_GoodsReceived" name="x_GoodsReceived" id="x_GoodsReceived" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->GoodsReceived->getPlaceHolder()) ?>"<?= $Page->GoodsReceived->editAttributes() ?> aria-describedby="x_GoodsReceived_help"><?= $Page->GoodsReceived->EditValue ?></textarea>
<?= $Page->GoodsReceived->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->GoodsReceived->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgoods_received_noteadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgoods_received_noteadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("goods_received_note");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
