<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmsReportSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Farms_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<a id="top"></a>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<form name="fFarms_Reportsrch" id="fFarms_Reportsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fFarms_Reportsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Farms_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
var fFarms_Reportsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fFarms_Reportsrch")
        .setPageId("summary")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Age": <?= $Page->Age->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "Province": <?= $Page->Province->toClientList($Page) ?>,
            "District": <?= $Page->District->toClientList($Page) ?>,
            "CampName": <?= $Page->CampName->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->Age->Visible) { // Age ?>
<?php
if (!$Page->Age->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Age" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Age->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Age"
            name="x_Age[]"
            class="form-control ew-select<?= $Page->Age->isInvalidClass() ?>"
            data-select2-id="fFarms_Reportsrch_x_Age"
            data-table="Farms_Report"
            data-field="x_Age"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Age->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Age->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Age->editAttributes() ?>>
            <?= $Page->Age->selectOptionListHtml("x_Age", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fFarms_Reportsrch", function() {
            var options = {
                name: "x_Age",
                selectId: "fFarms_Reportsrch_x_Age",
                ajax: { id: "x_Age", form: "fFarms_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Farms_Report.fields.Age.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fFarms_Reportsrch_x_Gender"
            data-table="Farms_Report"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fFarms_Reportsrch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fFarms_Reportsrch_x_Gender",
                ajax: { id: "x_Gender", form: "fFarms_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Farms_Report.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Province->Visible) { // Province ?>
<?php
if (!$Page->Province->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Province" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Province->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Province"
            name="x_Province[]"
            class="form-control ew-select<?= $Page->Province->isInvalidClass() ?>"
            data-select2-id="fFarms_Reportsrch_x_Province"
            data-table="Farms_Report"
            data-field="x_Province"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Province->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Province->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Province->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Province->editAttributes() ?>>
            <?= $Page->Province->selectOptionListHtml("x_Province", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Province->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fFarms_Reportsrch", function() {
            var options = {
                name: "x_Province",
                selectId: "fFarms_Reportsrch_x_Province",
                ajax: { id: "x_Province", form: "fFarms_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Farms_Report.fields.Province.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
<?php
if (!$Page->District->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_District" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->District->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_District"
            name="x_District[]"
            class="form-control ew-select<?= $Page->District->isInvalidClass() ?>"
            data-select2-id="fFarms_Reportsrch_x_District"
            data-table="Farms_Report"
            data-field="x_District"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->District->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->District->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->District->editAttributes() ?>>
            <?= $Page->District->selectOptionListHtml("x_District", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->District->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fFarms_Reportsrch", function() {
            var options = {
                name: "x_District",
                selectId: "fFarms_Reportsrch_x_District",
                ajax: { id: "x_District", form: "fFarms_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Farms_Report.fields.District.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->CampName->Visible) { // CampName ?>
<?php
if (!$Page->CampName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_CampName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->CampName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_CampName"
            name="x_CampName[]"
            class="form-control ew-select<?= $Page->CampName->isInvalidClass() ?>"
            data-select2-id="fFarms_Reportsrch_x_CampName"
            data-table="Farms_Report"
            data-field="x_CampName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->CampName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->CampName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->CampName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->CampName->editAttributes() ?>>
            <?= $Page->CampName->selectOptionListHtml("x_CampName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->CampName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fFarms_Reportsrch", function() {
            var options = {
                name: "x_CampName",
                selectId: "fFarms_Reportsrch_x_CampName",
                ajax: { id: "x_CampName", form: "fFarms_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Farms_Report.fields.CampName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ($Page->ShowReport) { ?>
<!-- Summary report (begin) -->
<main class="report-summary<?= ($Page->TotalGroups == 0) ? " ew-no-record" : "" ?>">
<?php
while ($Page->GroupCount <= count($Page->GroupRecords) && $Page->GroupCount <= $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if ($Page->GroupCount > 1) { ?>
</tbody>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?= $Page->PageBreakHtml ?>
<?php } ?>
<div class="<?= $Page->ReportContainerClass ?>">
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<!-- Report grid (begin) -->
<div id="gmp_Farms_Report" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>">
<table class="<?= $Page->TableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->Province->Visible) { ?>
    <?php if ($Page->Province->ShowGroupHeaderAsRow) { ?>
    <th data-name="Province"<?= $Page->Province->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->Province->groupToggleIcon() ?></th>
    <?php } else { ?>
    <th data-name="Province" class="<?= $Page->Province->headerCellClass() ?>"><div class="Farms_Report_Province"><?= $Page->renderFieldHeader($Page->Province) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
    <?php if ($Page->District->ShowGroupHeaderAsRow) { ?>
    <th data-name="District">&nbsp;</th>
    <?php } else { ?>
    <th data-name="District" class="<?= $Page->District->headerCellClass() ?>"><div class="Farms_Report_District"><?= $Page->renderFieldHeader($Page->District) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
    <th data-name="CampName">&nbsp;</th>
    <?php } else { ?>
    <th data-name="CampName" class="<?= $Page->CampName->headerCellClass() ?>"><div class="Farms_Report_CampName"><?= $Page->renderFieldHeader($Page->CampName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Age->Visible) { ?>
    <?php if ($Page->Age->ShowGroupHeaderAsRow) { ?>
    <th data-name="Age">&nbsp;</th>
    <?php } else { ?>
    <th data-name="Age" class="<?= $Page->Age->headerCellClass() ?>"><div class="Farms_Report_Age"><?= $Page->renderFieldHeader($Page->Age) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
    <?php if ($Page->Gender->ShowGroupHeaderAsRow) { ?>
    <th data-name="Gender">&nbsp;</th>
    <?php } else { ?>
    <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div class="Farms_Report_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { ?>
    <th data-name="NumberOfFields" class="<?= $Page->NumberOfFields->headerCellClass() ?>"><div class="Farms_Report_NumberOfFields"><?= $Page->renderFieldHeader($Page->NumberOfFields) ?></div></th>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { ?>
    <th data-name="EstimatedTotalSize" class="<?= $Page->EstimatedTotalSize->headerCellClass() ?>"><div class="Farms_Report_EstimatedTotalSize"><?= $Page->renderFieldHeader($Page->EstimatedTotalSize) ?></div></th>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { ?>
    <th data-name="VerifiedSize" class="<?= $Page->VerifiedSize->headerCellClass() ?>"><div class="Farms_Report_VerifiedSize"><?= $Page->renderFieldHeader($Page->VerifiedSize) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
    <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div class="Farms_Report_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
    <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div class="Farms_Report_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php

    // Build detail SQL
    $where = DetailFilterSql($Page->Province, $Page->getSqlFirstGroupField(), $Page->Province->groupValue(), $Page->Dbid);
    AddFilter($Page->PageFirstGroupFilter, $where, "OR");
    AddFilter($where, $Page->Filter);
    $sql = $Page->buildReportSql($Page->getSqlSelect(), $Page->getSqlFrom(), $Page->getSqlWhere(), $Page->getSqlGroupBy(), $Page->getSqlHaving(), $Page->getSqlOrderBy(), $where, $Page->Sort);
    $rs = $sql->executeQuery();
    $Page->DetailRecords = $rs?->fetchAll() ?? [];
    $Page->DetailRecordCount = count($Page->DetailRecords);

    // Load detail records
    $Page->Province->Records = &$Page->DetailRecords;
    $Page->Province->LevelBreak = true; // Set field level break
        $Page->GroupCounter[1] = $Page->GroupCount;
        $Page->Province->getCnt($Page->Province->Records); // Get record count
?>
<?php if ($Page->Province->Visible && $Page->Province->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 1;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->Province->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="Province" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?= $Page->Province->cellAttributes() ?>>
            <span class="ew-summary-caption Farms_Report_Province"><?= $Page->renderFieldHeader($Page->Province) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->Province->viewAttributes() ?>><?= $Page->Province->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Province->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->District->getDistinctValues($Page->Province->Records, $Page->District->getSort());
    $Page->setGroupCount(count($Page->District->DistinctValues), $Page->GroupCounter[1]);
    $Page->GroupCounter[2] = 0; // Init group count index
    foreach ($Page->District->DistinctValues as $District) { // Load records for this distinct value
        $Page->District->setGroupValue($District); // Set group value
        $Page->District->getDistinctRecords($Page->Province->Records, $Page->District->groupValue());
        $Page->District->LevelBreak = true; // Set field level break
        $Page->GroupCounter[2]++;
        $Page->District->getCnt($Page->District->Records); // Get record count
?>
<?php if ($Page->District->Visible && $Page->District->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->District->setDbValue($District); // Set current value for District
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 2;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->District->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="District" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 2) ?>"<?= $Page->District->cellAttributes() ?>>
            <span class="ew-summary-caption Farms_Report_District"><?= $Page->renderFieldHeader($Page->District) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->District->viewAttributes() ?>><?= $Page->District->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->District->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->CampName->getDistinctValues($Page->District->Records, $Page->CampName->getSort());
    $Page->setGroupCount(count($Page->CampName->DistinctValues), $Page->GroupCounter[1], $Page->GroupCounter[2]);
    $Page->GroupCounter[3] = 0; // Init group count index
    foreach ($Page->CampName->DistinctValues as $CampName) { // Load records for this distinct value
        $Page->CampName->setGroupValue($CampName); // Set group value
        $Page->CampName->getDistinctRecords($Page->District->Records, $Page->CampName->groupValue());
        $Page->CampName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[3]++;
        $Page->CampName->getCnt($Page->CampName->Records); // Get record count
?>
<?php if ($Page->CampName->Visible && $Page->CampName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->CampName->setDbValue($CampName); // Set current value for CampName
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 3;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->CampName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="CampName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 3) ?>"<?= $Page->CampName->cellAttributes() ?>>
            <span class="ew-summary-caption Farms_Report_CampName"><?= $Page->renderFieldHeader($Page->CampName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->CampName->viewAttributes() ?>><?= $Page->CampName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->Age->getDistinctValues($Page->CampName->Records, $Page->Age->getSort());
    $Page->setGroupCount(count($Page->Age->DistinctValues), $Page->GroupCounter[1], $Page->GroupCounter[2], $Page->GroupCounter[3]);
    $Page->GroupCounter[4] = 0; // Init group count index
    foreach ($Page->Age->DistinctValues as $Age) { // Load records for this distinct value
        $Page->Age->setGroupValue($Age); // Set group value
        $Page->Age->getDistinctRecords($Page->CampName->Records, $Page->Age->groupValue());
        $Page->Age->LevelBreak = true; // Set field level break
        $Page->GroupCounter[4]++;
        $Page->Age->getCnt($Page->Age->Records); // Get record count
?>
<?php if ($Page->Age->Visible && $Page->Age->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->Age->setDbValue($Age); // Set current value for Age
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 4;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Age->Visible) { ?>
        <td data-field="Age"<?= $Page->Age->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->Age->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="Age" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 4) ?>"<?= $Page->Age->cellAttributes() ?>>
            <span class="ew-summary-caption Farms_Report_Age"><?= $Page->renderFieldHeader($Page->Age) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->Age->viewAttributes() ?>><?= $Page->Age->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Age->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->Gender->getDistinctValues($Page->Age->Records, $Page->Gender->getSort());
    $Page->setGroupCount(count($Page->Gender->DistinctValues), $Page->GroupCounter[1], $Page->GroupCounter[2], $Page->GroupCounter[3], $Page->GroupCounter[4]);
    $Page->GroupCounter[5] = 0; // Init group count index
    foreach ($Page->Gender->DistinctValues as $Gender) { // Load records for this distinct value
        $Page->Gender->setGroupValue($Gender); // Set group value
        $Page->Gender->getDistinctRecords($Page->Age->Records, $Page->Gender->groupValue());
        $Page->Gender->LevelBreak = true; // Set field level break
        $Page->GroupCounter[5]++;
        $Page->Gender->getCnt($Page->Gender->Records); // Get record count
        $Page->setGroupCount($Page->Gender->Count, $Page->GroupCounter[1], $Page->GroupCounter[2], $Page->GroupCounter[3], $Page->GroupCounter[4], $Page->GroupCounter[5]);
?>
<?php if ($Page->Gender->Visible && $Page->Gender->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->Gender->setDbValue($Gender); // Set current value for Gender
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 5;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Age->Visible) { ?>
        <td data-field="Age"<?= $Page->Age->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
        <td data-field="Gender"<?= $Page->Gender->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->Gender->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="Gender" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 5) ?>"<?= $Page->Gender->cellAttributes() ?>>
            <span class="ew-summary-caption Farms_Report_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->Gender->viewAttributes() ?>><?= $Page->Gender->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Gender->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
        $Page->RecordCount = 0; // Reset record count
        foreach ($Page->Gender->Records as $record) {
            $Page->RecordCount++;
            $Page->RecordIndex++;
            $Page->loadRowValues($record);
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = RowType::DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
    <?php if ($Page->Province->ShowGroupHeaderAsRow) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>><span<?= $Page->Province->viewAttributes() ?>><?= $Page->Province->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
    <?php if ($Page->District->ShowGroupHeaderAsRow) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>><span<?= $Page->District->viewAttributes() ?>><?= $Page->District->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>><span<?= $Page->CampName->viewAttributes() ?>><?= $Page->CampName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Age->Visible) { ?>
    <?php if ($Page->Age->ShowGroupHeaderAsRow) { ?>
        <td data-field="Age"<?= $Page->Age->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="Age"<?= $Page->Age->cellAttributes() ?>><span<?= $Page->Age->viewAttributes() ?>><?= $Page->Age->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
    <?php if ($Page->Gender->ShowGroupHeaderAsRow) { ?>
        <td data-field="Gender"<?= $Page->Gender->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="Gender"<?= $Page->Gender->cellAttributes() ?>><span<?= $Page->Gender->viewAttributes() ?>><?= $Page->Gender->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { ?>
        <td data-field="NumberOfFields"<?= $Page->NumberOfFields->cellAttributes() ?>>
<span<?= $Page->NumberOfFields->viewAttributes() ?>>
<?= $Page->NumberOfFields->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { ?>
        <td data-field="EstimatedTotalSize"<?= $Page->EstimatedTotalSize->cellAttributes() ?>>
<span<?= $Page->EstimatedTotalSize->viewAttributes() ?>>
<?= $Page->EstimatedTotalSize->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { ?>
        <td data-field="VerifiedSize"<?= $Page->VerifiedSize->cellAttributes() ?>>
<span<?= $Page->VerifiedSize->viewAttributes() ?>>
<?= $Page->VerifiedSize->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
    }
    } // End group level 4
    } // End group level 3
    } // End group level 2
?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php
    $Page->NumberOfFields->getSum($Page->District->Records, false); // Get Sum
    $Page->EstimatedTotalSize->getSum($Page->District->Records, false); // Get Sum
    $Page->VerifiedSize->getSum($Page->District->Records, false); // Get Sum
    $Page->TreesPlantedEstimated->getSum($Page->District->Records, false); // Get Sum
    $Page->TreesPlantedVerified->getSum($Page->District->Records, false); // Get Sum
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GROUP;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowGroupLevel = 2;
    $Page->renderRow();
?>
<?php if ($Page->District->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
    <?php if ($Page->Province->ShowGroupHeaderAsRow) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 1) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Province->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->District->Visible) { ?>
    <?php if ($Page->District->ShowGroupHeaderAsRow) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 2) { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="District"<?= $Page->District->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->District->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
        <td data-field="CampName"<?= $Page->District->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 3) { ?>
        <td data-field="CampName"<?= $Page->District->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="CampName"<?= $Page->District->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Age->Visible) { ?>
    <?php if ($Page->Age->ShowGroupHeaderAsRow) { ?>
        <td data-field="Age"<?= $Page->District->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 4) { ?>
        <td data-field="Age"<?= $Page->District->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="Age"<?= $Page->District->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Age->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
    <?php if ($Page->Gender->ShowGroupHeaderAsRow) { ?>
        <td data-field="Gender"<?= $Page->District->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 5) { ?>
        <td data-field="Gender"<?= $Page->District->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="Gender"<?= $Page->District->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Gender->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { ?>
        <td data-field="NumberOfFields"<?= $Page->District->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->NumberOfFields->viewAttributes() ?>><?= $Page->NumberOfFields->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { ?>
        <td data-field="EstimatedTotalSize"<?= $Page->District->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->EstimatedTotalSize->viewAttributes() ?>><?= $Page->EstimatedTotalSize->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { ?>
        <td data-field="VerifiedSize"<?= $Page->District->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->VerifiedSize->viewAttributes() ?>><?= $Page->VerifiedSize->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->District->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->District->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->SubGroupColumnCount + $Page->DetailColumnCount > 0) { ?>
        <td colspan="<?= ($Page->SubGroupColumnCount + $Page->DetailColumnCount) ?>"<?= $Page->District->cellAttributes() ?>><?= str_replace(["%v", "%c"], [$Page->District->GroupViewValue, $Page->District->caption()], $Language->phrase("RptSumHead")) ?> <span class="ew-dir-ltr">(<?= FormatNumber($Page->District->Count, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
    </tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->Province->Visible) { ?>
        <td data-field="Province"<?= $Page->Province->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= ($Page->GroupColumnCount - 1) ?>"<?= $Page->District->cellAttributes() ?>><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { ?>
        <td data-field="NumberOfFields"<?= $Page->NumberOfFields->cellAttributes() ?>>
<span<?= $Page->NumberOfFields->viewAttributes() ?>>
<?= $Page->NumberOfFields->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { ?>
        <td data-field="EstimatedTotalSize"<?= $Page->EstimatedTotalSize->cellAttributes() ?>>
<span<?= $Page->EstimatedTotalSize->viewAttributes() ?>>
<?= $Page->EstimatedTotalSize->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { ?>
        <td data-field="VerifiedSize"<?= $Page->VerifiedSize->cellAttributes() ?>>
<span<?= $Page->VerifiedSize->viewAttributes() ?>>
<?= $Page->VerifiedSize->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
<?php } ?>
<?php
    } // End group level 1
?>
<?php

    // Next group
    $Page->loadGroupRowValues();

    // Show header if page break
    if ($Page->isExport()) {
        $Page->ShowHeader = ($Page->ExportPageBreakCount == 0) ? false : ($Page->GroupCount % $Page->ExportPageBreakCount == 0);
    }

    // Page_Breaking server event
    if ($Page->ShowHeader) {
        $Page->pageBreaking($Page->ShowHeader, $Page->PageBreakHtml);
    }
    $Page->GroupCount++;
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GRAND;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->Province->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"></td>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { ?>
        <td data-field="NumberOfFields"<?= $Page->NumberOfFields->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->NumberOfFields->viewAttributes() ?>><?= $Page->NumberOfFields->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { ?>
        <td data-field="EstimatedTotalSize"<?= $Page->EstimatedTotalSize->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->EstimatedTotalSize->viewAttributes() ?>><?= $Page->EstimatedTotalSize->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { ?>
        <td data-field="VerifiedSize"<?= $Page->VerifiedSize->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->VerifiedSize->viewAttributes() ?>><?= $Page->VerifiedSize->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { ?>
        <td data-field="NumberOfFields"<?= $Page->NumberOfFields->cellAttributes() ?>>
<span<?= $Page->NumberOfFields->viewAttributes() ?>>
<?= $Page->NumberOfFields->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { ?>
        <td data-field="EstimatedTotalSize"<?= $Page->EstimatedTotalSize->cellAttributes() ?>>
<span<?= $Page->EstimatedTotalSize->viewAttributes() ?>>
<?= $Page->EstimatedTotalSize->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { ?>
        <td data-field="VerifiedSize"<?= $Page->VerifiedSize->cellAttributes() ?>>
<span<?= $Page->VerifiedSize->viewAttributes() ?>>
<?= $Page->VerifiedSize->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
</main>
<!-- /.report-summary -->
<!-- Summary report (end) -->
<?php } ?>
</div>
<!-- /.ew-report -->
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
