<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmersExtraList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farmers_extra: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarmers_extrasrch" id="ffarmers_extrasrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarmers_extrasrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farmers_extra: currentTable } });
var currentForm;
var ffarmers_extrasrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarmers_extrasrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarmers_extrasrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarmers_extrasrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarmers_extrasrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarmers_extrasrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farmers_extra">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_farmers_extra" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farmers_extralist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farmers_extra_ProvinceCode" class="farmers_extra_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farmers_extra_DistrictCode" class="farmers_extra_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farmers_extra_CampCode" class="farmers_extra_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farmers_extra_VillageCode" class="farmers_extra_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_farmers_extra_FarmerNo" class="farmers_extra_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farmers_extra_NRC" class="farmers_extra_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <th data-name="FarmerName" class="<?= $Page->FarmerName->headerCellClass() ?>"><div id="elh_farmers_extra_FarmerName" class="farmers_extra_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerType->Visible) { // FarmerType ?>
        <th data-name="FarmerType" class="<?= $Page->FarmerType->headerCellClass() ?>"><div id="elh_farmers_extra_FarmerType" class="farmers_extra_FarmerType"><?= $Page->renderFieldHeader($Page->FarmerType) ?></div></th>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
        <th data-name="DOB" class="<?= $Page->DOB->headerCellClass() ?>"><div id="elh_farmers_extra_DOB" class="farmers_extra_DOB"><?= $Page->renderFieldHeader($Page->DOB) ?></div></th>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
        <th data-name="Age" class="<?= $Page->Age->headerCellClass() ?>"><div id="elh_farmers_extra_Age" class="farmers_extra_Age"><?= $Page->renderFieldHeader($Page->Age) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_farmers_extra_Gender" class="farmers_extra_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <th data-name="MaritalStatus" class="<?= $Page->MaritalStatus->headerCellClass() ?>"><div id="elh_farmers_extra_MaritalStatus" class="farmers_extra_MaritalStatus"><?= $Page->renderFieldHeader($Page->MaritalStatus) ?></div></th>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
        <th data-name="PhoneNo" class="<?= $Page->PhoneNo->headerCellClass() ?>"><div id="elh_farmers_extra_PhoneNo" class="farmers_extra_PhoneNo"><?= $Page->renderFieldHeader($Page->PhoneNo) ?></div></th>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Page->_Email->headerCellClass() ?>"><div id="elh_farmers_extra__Email" class="farmers_extra__Email"><?= $Page->renderFieldHeader($Page->_Email) ?></div></th>
<?php } ?>
<?php if ($Page->Dependants->Visible) { // Dependants ?>
        <th data-name="Dependants" class="<?= $Page->Dependants->headerCellClass() ?>"><div id="elh_farmers_extra_Dependants" class="farmers_extra_Dependants"><?= $Page->renderFieldHeader($Page->Dependants) ?></div></th>
<?php } ?>
<?php if ($Page->MaleChildren->Visible) { // MaleChildren ?>
        <th data-name="MaleChildren" class="<?= $Page->MaleChildren->headerCellClass() ?>"><div id="elh_farmers_extra_MaleChildren" class="farmers_extra_MaleChildren"><?= $Page->renderFieldHeader($Page->MaleChildren) ?></div></th>
<?php } ?>
<?php if ($Page->FemaleChildren->Visible) { // FemaleChildren ?>
        <th data-name="FemaleChildren" class="<?= $Page->FemaleChildren->headerCellClass() ?>"><div id="elh_farmers_extra_FemaleChildren" class="farmers_extra_FemaleChildren"><?= $Page->renderFieldHeader($Page->FemaleChildren) ?></div></th>
<?php } ?>
<?php if ($Page->HouseholdHead->Visible) { // HouseholdHead ?>
        <th data-name="HouseholdHead" class="<?= $Page->HouseholdHead->headerCellClass() ?>"><div id="elh_farmers_extra_HouseholdHead" class="farmers_extra_HouseholdHead"><?= $Page->renderFieldHeader($Page->HouseholdHead) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
        <th data-name="FarmerOrg" class="<?= $Page->FarmerOrg->headerCellClass() ?>"><div id="elh_farmers_extra_FarmerOrg" class="farmers_extra_FarmerOrg"><?= $Page->renderFieldHeader($Page->FarmerOrg) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <th data-name="FarmerOrgPosition" class="<?= $Page->FarmerOrgPosition->headerCellClass() ?>"><div id="elh_farmers_extra_FarmerOrgPosition" class="farmers_extra_FarmerOrgPosition"><?= $Page->renderFieldHeader($Page->FarmerOrgPosition) ?></div></th>
<?php } ?>
<?php if ($Page->JoiningDate->Visible) { // JoiningDate ?>
        <th data-name="JoiningDate" class="<?= $Page->JoiningDate->headerCellClass() ?>"><div id="elh_farmers_extra_JoiningDate" class="farmers_extra_JoiningDate"><?= $Page->renderFieldHeader($Page->JoiningDate) ?></div></th>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
        <th data-name="Comments" class="<?= $Page->Comments->headerCellClass() ?>"><div id="elh_farmers_extra_Comments" class="farmers_extra_Comments"><?= $Page->renderFieldHeader($Page->Comments) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_ProvinceCode" class="el_farmers_extra_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_DistrictCode" class="el_farmers_extra_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_CampCode" class="el_farmers_extra_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_VillageCode" class="el_farmers_extra_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_FarmerNo" class="el_farmers_extra_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_NRC" class="el_farmers_extra_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <td data-name="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_FarmerName" class="el_farmers_extra_FarmerName">
<span<?= $Page->FarmerName->viewAttributes() ?>>
<?= $Page->FarmerName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerType->Visible) { // FarmerType ?>
        <td data-name="FarmerType"<?= $Page->FarmerType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_FarmerType" class="el_farmers_extra_FarmerType">
<span<?= $Page->FarmerType->viewAttributes() ?>>
<?= $Page->FarmerType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DOB->Visible) { // DOB ?>
        <td data-name="DOB"<?= $Page->DOB->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_DOB" class="el_farmers_extra_DOB">
<span<?= $Page->DOB->viewAttributes() ?>>
<?= $Page->DOB->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Age->Visible) { // Age ?>
        <td data-name="Age"<?= $Page->Age->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_Age" class="el_farmers_extra_Age">
<span<?= $Page->Age->viewAttributes() ?>>
<?= $Page->Age->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_Gender" class="el_farmers_extra_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <td data-name="MaritalStatus"<?= $Page->MaritalStatus->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_MaritalStatus" class="el_farmers_extra_MaritalStatus">
<span<?= $Page->MaritalStatus->viewAttributes() ?>>
<?= $Page->MaritalStatus->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
        <td data-name="PhoneNo"<?= $Page->PhoneNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_PhoneNo" class="el_farmers_extra_PhoneNo">
<span<?= $Page->PhoneNo->viewAttributes() ?>>
<?= $Page->PhoneNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Page->_Email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra__Email" class="el_farmers_extra__Email">
<span<?= $Page->_Email->viewAttributes() ?>>
<?= $Page->_Email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Dependants->Visible) { // Dependants ?>
        <td data-name="Dependants"<?= $Page->Dependants->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_Dependants" class="el_farmers_extra_Dependants">
<span<?= $Page->Dependants->viewAttributes() ?>>
<?= $Page->Dependants->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->MaleChildren->Visible) { // MaleChildren ?>
        <td data-name="MaleChildren"<?= $Page->MaleChildren->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_MaleChildren" class="el_farmers_extra_MaleChildren">
<span<?= $Page->MaleChildren->viewAttributes() ?>>
<?= $Page->MaleChildren->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FemaleChildren->Visible) { // FemaleChildren ?>
        <td data-name="FemaleChildren"<?= $Page->FemaleChildren->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_FemaleChildren" class="el_farmers_extra_FemaleChildren">
<span<?= $Page->FemaleChildren->viewAttributes() ?>>
<?= $Page->FemaleChildren->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->HouseholdHead->Visible) { // HouseholdHead ?>
        <td data-name="HouseholdHead"<?= $Page->HouseholdHead->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_HouseholdHead" class="el_farmers_extra_HouseholdHead">
<span<?= $Page->HouseholdHead->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->HouseholdHead->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
        <td data-name="FarmerOrg"<?= $Page->FarmerOrg->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_FarmerOrg" class="el_farmers_extra_FarmerOrg">
<span<?= $Page->FarmerOrg->viewAttributes() ?>>
<?= $Page->FarmerOrg->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <td data-name="FarmerOrgPosition"<?= $Page->FarmerOrgPosition->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_FarmerOrgPosition" class="el_farmers_extra_FarmerOrgPosition">
<span<?= $Page->FarmerOrgPosition->viewAttributes() ?>>
<?= $Page->FarmerOrgPosition->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->JoiningDate->Visible) { // JoiningDate ?>
        <td data-name="JoiningDate"<?= $Page->JoiningDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_JoiningDate" class="el_farmers_extra_JoiningDate">
<span<?= $Page->JoiningDate->viewAttributes() ?>>
<?= $Page->JoiningDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Comments->Visible) { // Comments ?>
        <td data-name="Comments"<?= $Page->Comments->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmers_extra_Comments" class="el_farmers_extra_Comments">
<span<?= $Page->Comments->viewAttributes() ?>>
<?= $Page->Comments->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farmers_extra");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
