<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farmer: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffarmersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarmersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["FarmerNo", [ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["FarmerName", [], fields.FarmerName.isInvalid],
            ["FarmerType", [ew.Validators.integer], fields.FarmerType.isInvalid],
            ["DOB", [], fields.DOB.isInvalid],
            ["Age", [ew.Validators.float], fields.Age.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["MaritalStatus", [], fields.MaritalStatus.isInvalid],
            ["PhoneNo", [], fields.PhoneNo.isInvalid],
            ["_Email", [], fields._Email.isInvalid],
            ["Dependants", [ew.Validators.integer], fields.Dependants.isInvalid],
            ["MaleChildren", [ew.Validators.integer], fields.MaleChildren.isInvalid],
            ["FemaleChildren", [ew.Validators.integer], fields.FemaleChildren.isInvalid],
            ["HouseholdHead", [], fields.HouseholdHead.isInvalid],
            ["FarmerOrg", [], fields.FarmerOrg.isInvalid],
            ["FarmerOrgPosition", [], fields.FarmerOrgPosition.isInvalid],
            ["JoiningDate", [ew.Validators.datetime(fields.JoiningDate.clientFormatPattern)], fields.JoiningDate.isInvalid],
            ["Comments", [], fields.Comments.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "FarmerType": <?= $Page->FarmerType->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
            "HouseholdHead": <?= $Page->HouseholdHead->toClientList($Page) ?>,
            "FarmerOrg": <?= $Page->FarmerOrg->toClientList($Page) ?>,
            "FarmerOrgPosition": <?= $Page->FarmerOrgPosition->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarmersearch" id="ffarmersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farmer">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode" class="row"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProvinceCode" id="z_ProvinceCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProvinceCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmersearch_x_ProvinceCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarmersearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmersearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarmersearch_x_DistrictCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarmersearch_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmersearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode" class="row"<?= $Page->CampCode->rowAttributes() ?>>
        <label for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_CampCode"><?= $Page->CampCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_CampCode" id="z_CampCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmersearch_x_CampCode"
        data-table="farmer"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_CampCode", selectId: "ffarmersearch_x_CampCode" };
    if (ffarmersearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode" class="row"<?= $Page->VillageCode->rowAttributes() ?>>
        <label for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_VillageCode"><?= $Page->VillageCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VillageCode" id="z_VillageCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VillageCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmersearch_x_VillageCode"
        data-table="farmer"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_VillageCode", selectId: "ffarmersearch_x_VillageCode" };
    if (ffarmersearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
    <div id="r_FarmerNo" class="row"<?= $Page->FarmerNo->rowAttributes() ?>>
        <label for="x_FarmerNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_FarmerNo"><?= $Page->FarmerNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmerNo" id="z_FarmerNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_FarmerNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x_FarmerNo" id="x_FarmerNo" data-table="farmer" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_NRC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="farmer" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
    <div id="r_FarmerName" class="row"<?= $Page->FarmerName->rowAttributes() ?>>
        <label for="x_FarmerName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_FarmerName"><?= $Page->FarmerName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FarmerName" id="z_FarmerName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_FarmerName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x_FarmerName" id="x_FarmerName" data-table="farmer" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerType->Visible) { // FarmerType ?>
    <div id="r_FarmerType" class="row"<?= $Page->FarmerType->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_FarmerType"><?= $Page->FarmerType->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmerType" id="z_FarmerType" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerType->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_FarmerType" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->FarmerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_FarmerType" class="ew-auto-suggest">
    <input type="<?= $Page->FarmerType->getInputTextType() ?>" class="form-control" name="sv_x_FarmerType" id="sv_x_FarmerType" value="<?= RemoveHtml($Page->FarmerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerType->formatPattern()) ?>"<?= $Page->FarmerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farmer" data-field="x_FarmerType" data-input="sv_x_FarmerType" data-value-separator="<?= $Page->FarmerType->displayValueSeparatorAttribute() ?>" name="x_FarmerType" id="x_FarmerType" value="<?= HtmlEncode($Page->FarmerType->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->FarmerType->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffarmersearch", function() {
    ffarmersearch.createAutoSuggest(Object.assign({"id":"x_FarmerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->FarmerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farmer.fields.FarmerType.autoSuggestOptions));
});
</script>
<?= $Page->FarmerType->Lookup->getParamTag($Page, "p_x_FarmerType") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
    <div id="r_DOB" class="row"<?= $Page->DOB->rowAttributes() ?>>
        <label for="x_DOB" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_DOB"><?= $Page->DOB->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DOB" id="z_DOB" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DOB->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_DOB" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x_DOB" id="x_DOB" data-table="farmer" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
    <div id="r_Age" class="row"<?= $Page->Age->rowAttributes() ?>>
        <label for="x_Age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_Age"><?= $Page->Age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Age" id="z_Age" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_Age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x_Age" id="x_Age" data-table="farmer" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_Gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="ffarmersearch_x_Gender"
        <?php } ?>
        data-table="farmer"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_Gender", selectId: "ffarmersearch_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmersearch.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_Gender", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
    <div id="r_MaritalStatus" class="row"<?= $Page->MaritalStatus->rowAttributes() ?>>
        <label for="x_MaritalStatus" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_MaritalStatus"><?= $Page->MaritalStatus->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_MaritalStatus" id="z_MaritalStatus" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->MaritalStatus->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_MaritalStatus" class="ew-search-field ew-search-field-single">
    <select
        id="x_MaritalStatus"
        name="x_MaritalStatus"
        class="form-select ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="ffarmersearch_x_MaritalStatus"
        <?php } ?>
        data-table="farmer"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Page->MaritalStatus->editAttributes() ?>>
        <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage(false) ?></div>
<?= $Page->MaritalStatus->Lookup->getParamTag($Page, "p_x_MaritalStatus") ?>
<?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_MaritalStatus", selectId: "ffarmersearch_x_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmersearch.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x_MaritalStatus", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_MaritalStatus", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
    <div id="r_PhoneNo" class="row"<?= $Page->PhoneNo->rowAttributes() ?>>
        <label for="x_PhoneNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_PhoneNo"><?= $Page->PhoneNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PhoneNo" id="z_PhoneNo" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PhoneNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_PhoneNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PhoneNo->getInputTextType() ?>" name="x_PhoneNo" id="x_PhoneNo" data-table="farmer" data-field="x_PhoneNo" value="<?= $Page->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PhoneNo->formatPattern()) ?>"<?= $Page->PhoneNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PhoneNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email" class="row"<?= $Page->_Email->rowAttributes() ?>>
        <label for="x__Email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer__Email"><?= $Page->_Email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__Email" id="z__Email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer__Email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="farmer" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Dependants->Visible) { // Dependants ?>
    <div id="r_Dependants" class="row"<?= $Page->Dependants->rowAttributes() ?>>
        <label for="x_Dependants" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_Dependants"><?= $Page->Dependants->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Dependants" id="z_Dependants" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Dependants->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_Dependants" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Dependants->getInputTextType() ?>" name="x_Dependants" id="x_Dependants" data-table="farmer" data-field="x_Dependants" value="<?= $Page->Dependants->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Dependants->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Dependants->formatPattern()) ?>"<?= $Page->Dependants->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Dependants->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->MaleChildren->Visible) { // MaleChildren ?>
    <div id="r_MaleChildren" class="row"<?= $Page->MaleChildren->rowAttributes() ?>>
        <label for="x_MaleChildren" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_MaleChildren"><?= $Page->MaleChildren->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_MaleChildren" id="z_MaleChildren" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->MaleChildren->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_MaleChildren" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->MaleChildren->getInputTextType() ?>" name="x_MaleChildren" id="x_MaleChildren" data-table="farmer" data-field="x_MaleChildren" value="<?= $Page->MaleChildren->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->MaleChildren->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MaleChildren->formatPattern()) ?>"<?= $Page->MaleChildren->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->MaleChildren->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FemaleChildren->Visible) { // FemaleChildren ?>
    <div id="r_FemaleChildren" class="row"<?= $Page->FemaleChildren->rowAttributes() ?>>
        <label for="x_FemaleChildren" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_FemaleChildren"><?= $Page->FemaleChildren->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FemaleChildren" id="z_FemaleChildren" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FemaleChildren->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_FemaleChildren" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FemaleChildren->getInputTextType() ?>" name="x_FemaleChildren" id="x_FemaleChildren" data-table="farmer" data-field="x_FemaleChildren" value="<?= $Page->FemaleChildren->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FemaleChildren->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FemaleChildren->formatPattern()) ?>"<?= $Page->FemaleChildren->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FemaleChildren->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->HouseholdHead->Visible) { // HouseholdHead ?>
    <div id="r_HouseholdHead" class="row"<?= $Page->HouseholdHead->rowAttributes() ?>>
        <label for="x_HouseholdHead" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_HouseholdHead"><?= $Page->HouseholdHead->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_HouseholdHead" id="z_HouseholdHead" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->HouseholdHead->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_HouseholdHead" class="ew-search-field ew-search-field-single">
    <select
        id="x_HouseholdHead"
        name="x_HouseholdHead"
        class="form-select ew-select<?= $Page->HouseholdHead->isInvalidClass() ?>"
        <?php if (!$Page->HouseholdHead->IsNativeSelect) { ?>
        data-select2-id="ffarmersearch_x_HouseholdHead"
        <?php } ?>
        data-table="farmer"
        data-field="x_HouseholdHead"
        data-value-separator="<?= $Page->HouseholdHead->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->HouseholdHead->getPlaceHolder()) ?>"
        <?= $Page->HouseholdHead->editAttributes() ?>>
        <?= $Page->HouseholdHead->selectOptionListHtml("x_HouseholdHead") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->HouseholdHead->getErrorMessage(false) ?></div>
<?= $Page->HouseholdHead->Lookup->getParamTag($Page, "p_x_HouseholdHead") ?>
<?php if (!$Page->HouseholdHead->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_HouseholdHead", selectId: "ffarmersearch_x_HouseholdHead" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmersearch.lists.HouseholdHead?.lookupOptions.length) {
        options.data = { id: "x_HouseholdHead", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_HouseholdHead", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.HouseholdHead.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
    <div id="r_FarmerOrg" class="row"<?= $Page->FarmerOrg->rowAttributes() ?>>
        <label for="x_FarmerOrg" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_FarmerOrg"><?= $Page->FarmerOrg->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FarmerOrg" id="z_FarmerOrg" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerOrg->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_FarmerOrg" class="ew-search-field ew-search-field-single">
    <select
        id="x_FarmerOrg"
        name="x_FarmerOrg"
        class="form-control ew-select<?= $Page->FarmerOrg->isInvalidClass() ?>"
        data-select2-id="ffarmersearch_x_FarmerOrg"
        data-table="farmer"
        data-field="x_FarmerOrg"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerOrg->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmerOrg->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrg->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrg->editAttributes() ?>>
        <?= $Page->FarmerOrg->selectOptionListHtml("x_FarmerOrg") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmerOrg->getErrorMessage(false) ?></div>
<?= $Page->FarmerOrg->Lookup->getParamTag($Page, "p_x_FarmerOrg") ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_FarmerOrg", selectId: "ffarmersearch_x_FarmerOrg" };
    if (ffarmersearch.lists.FarmerOrg?.lookupOptions.length) {
        options.data = { id: "x_FarmerOrg", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_FarmerOrg", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.FarmerOrg.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
    <div id="r_FarmerOrgPosition" class="row"<?= $Page->FarmerOrgPosition->rowAttributes() ?>>
        <label for="x_FarmerOrgPosition" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_FarmerOrgPosition"><?= $Page->FarmerOrgPosition->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FarmerOrgPosition" id="z_FarmerOrgPosition" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerOrgPosition->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_FarmerOrgPosition" class="ew-search-field ew-search-field-single">
    <select
        id="x_FarmerOrgPosition"
        name="x_FarmerOrgPosition"
        class="form-select ew-select<?= $Page->FarmerOrgPosition->isInvalidClass() ?>"
        <?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
        data-select2-id="ffarmersearch_x_FarmerOrgPosition"
        <?php } ?>
        data-table="farmer"
        data-field="x_FarmerOrgPosition"
        data-value-separator="<?= $Page->FarmerOrgPosition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrgPosition->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrgPosition->editAttributes() ?>>
        <?= $Page->FarmerOrgPosition->selectOptionListHtml("x_FarmerOrgPosition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmerOrgPosition->getErrorMessage(false) ?></div>
<?= $Page->FarmerOrgPosition->Lookup->getParamTag($Page, "p_x_FarmerOrgPosition") ?>
<?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmersearch", function() {
    var options = { name: "x_FarmerOrgPosition", selectId: "ffarmersearch_x_FarmerOrgPosition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmersearch.lists.FarmerOrgPosition?.lookupOptions.length) {
        options.data = { id: "x_FarmerOrgPosition", form: "ffarmersearch" };
    } else {
        options.ajax = { id: "x_FarmerOrgPosition", form: "ffarmersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.FarmerOrgPosition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->JoiningDate->Visible) { // JoiningDate ?>
    <div id="r_JoiningDate" class="row"<?= $Page->JoiningDate->rowAttributes() ?>>
        <label for="x_JoiningDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_JoiningDate"><?= $Page->JoiningDate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_JoiningDate" id="z_JoiningDate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->JoiningDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_JoiningDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->JoiningDate->getInputTextType() ?>" name="x_JoiningDate" id="x_JoiningDate" data-table="farmer" data-field="x_JoiningDate" value="<?= $Page->JoiningDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->JoiningDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->JoiningDate->formatPattern()) ?>"<?= $Page->JoiningDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->JoiningDate->getErrorMessage(false) ?></div>
<?php if (!$Page->JoiningDate->ReadOnly && !$Page->JoiningDate->Disabled && !isset($Page->JoiningDate->EditAttrs["readonly"]) && !isset($Page->JoiningDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarmersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarmersearch", "x_JoiningDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
    <div id="r_Comments" class="row"<?= $Page->Comments->rowAttributes() ?>>
        <label for="x_Comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farmer_Comments"><?= $Page->Comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Comments" id="z_Comments" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farmer_Comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Comments->getInputTextType() ?>" name="x_Comments" id="x_Comments" data-table="farmer" data-field="x_Comments" value="<?= $Page->Comments->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Comments->formatPattern()) ?>"<?= $Page->Comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarmersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarmersearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ffarmersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farmer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
