<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("FarmerOrganisationGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ffarmer_organisationgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { farmer_organisation: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarmer_organisationgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["OrgCode", [fields.OrgCode.visible && fields.OrgCode.required ? ew.Validators.required(fields.OrgCode.caption) : null, ew.Validators.integer], fields.OrgCode.isInvalid],
            ["FarmerOrganisation", [fields.FarmerOrganisation.visible && fields.FarmerOrganisation.required ? ew.Validators.required(fields.FarmerOrganisation.caption) : null], fields.FarmerOrganisation.isInvalid],
            ["FOType", [fields.FOType.visible && fields.FOType.required ? ew.Validators.required(fields.FOType.caption) : null], fields.FOType.isInvalid],
            ["PhysicalAddress", [fields.PhysicalAddress.visible && fields.PhysicalAddress.required ? ew.Validators.required(fields.PhysicalAddress.caption) : null], fields.PhysicalAddress.isInvalid],
            ["PostalAddress", [fields.PostalAddress.visible && fields.PostalAddress.required ? ew.Validators.required(fields.PostalAddress.caption) : null], fields.PostalAddress.isInvalid],
            ["Phone", [fields.Phone.visible && fields.Phone.required ? ew.Validators.required(fields.Phone.caption) : null], fields.Phone.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["ID", [fields.ID.visible && fields.ID.required ? ew.Validators.required(fields.ID.caption) : null], fields.ID.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["OrgCode",false],["FarmerOrganisation",false],["FOType",false],["PhysicalAddress",false],["PostalAddress",false],["Phone",false],["_Email",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "FOType": <?= $Grid->FOType->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ffarmer_organisationgrid" class="ew-form ew-list-form">
<div id="gmp_farmer_organisation" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_farmer_organisationgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_farmer_organisation_ProvinceCode" class="farmer_organisation_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_farmer_organisation_DistrictCode" class="farmer_organisation_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->OrgCode->Visible) { // OrgCode ?>
        <th data-name="OrgCode" class="<?= $Grid->OrgCode->headerCellClass() ?>"><div id="elh_farmer_organisation_OrgCode" class="farmer_organisation_OrgCode"><?= $Grid->renderFieldHeader($Grid->OrgCode) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerOrganisation->Visible) { // FarmerOrganisation ?>
        <th data-name="FarmerOrganisation" class="<?= $Grid->FarmerOrganisation->headerCellClass() ?>"><div id="elh_farmer_organisation_FarmerOrganisation" class="farmer_organisation_FarmerOrganisation"><?= $Grid->renderFieldHeader($Grid->FarmerOrganisation) ?></div></th>
<?php } ?>
<?php if ($Grid->FOType->Visible) { // FOType ?>
        <th data-name="FOType" class="<?= $Grid->FOType->headerCellClass() ?>"><div id="elh_farmer_organisation_FOType" class="farmer_organisation_FOType"><?= $Grid->renderFieldHeader($Grid->FOType) ?></div></th>
<?php } ?>
<?php if ($Grid->PhysicalAddress->Visible) { // PhysicalAddress ?>
        <th data-name="PhysicalAddress" class="<?= $Grid->PhysicalAddress->headerCellClass() ?>"><div id="elh_farmer_organisation_PhysicalAddress" class="farmer_organisation_PhysicalAddress"><?= $Grid->renderFieldHeader($Grid->PhysicalAddress) ?></div></th>
<?php } ?>
<?php if ($Grid->PostalAddress->Visible) { // PostalAddress ?>
        <th data-name="PostalAddress" class="<?= $Grid->PostalAddress->headerCellClass() ?>"><div id="elh_farmer_organisation_PostalAddress" class="farmer_organisation_PostalAddress"><?= $Grid->renderFieldHeader($Grid->PostalAddress) ?></div></th>
<?php } ?>
<?php if ($Grid->Phone->Visible) { // Phone ?>
        <th data-name="Phone" class="<?= $Grid->Phone->headerCellClass() ?>"><div id="elh_farmer_organisation_Phone" class="farmer_organisation_Phone"><?= $Grid->renderFieldHeader($Grid->Phone) ?></div></th>
<?php } ?>
<?php if ($Grid->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Grid->_Email->headerCellClass() ?>"><div id="elh_farmer_organisation__Email" class="farmer_organisation__Email"><?= $Grid->renderFieldHeader($Grid->_Email) ?></div></th>
<?php } ?>
<?php if ($Grid->ID->Visible) { // ID ?>
        <th data-name="ID" class="<?= $Grid->ID->headerCellClass() ?>"><div id="elh_farmer_organisation_ID" class="farmer_organisation_ID"><?= $Grid->renderFieldHeader($Grid->ID) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_ProvinceCode" class="el_farmer_organisation_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farmer_organisation"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmer_organisationgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmer_organisationgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmer_organisationgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmer_organisationgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer_organisation.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_ProvinceCode" class="el_farmer_organisation_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farmer_organisation"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmer_organisationgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmer_organisationgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmer_organisationgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmer_organisationgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer_organisation.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_ProvinceCode" class="el_farmer_organisation_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_ProvinceCode" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_ProvinceCode" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_DistrictCode" class="el_farmer_organisation_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farmer_organisation"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmer_organisationgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmer_organisationgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmer_organisationgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmer_organisationgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer_organisation.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_DistrictCode" class="el_farmer_organisation_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farmer_organisation"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmer_organisationgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmer_organisationgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmer_organisationgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmer_organisationgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer_organisation.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_DistrictCode" class="el_farmer_organisation_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_DistrictCode" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_DistrictCode" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->OrgCode->Visible) { // OrgCode ?>
        <td data-name="OrgCode"<?= $Grid->OrgCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_OrgCode" class="el_farmer_organisation_OrgCode">
<input type="<?= $Grid->OrgCode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_OrgCode" id="x<?= $Grid->RowIndex ?>_OrgCode" data-table="farmer_organisation" data-field="x_OrgCode" value="<?= $Grid->OrgCode->EditValue ?>" placeholder="<?= HtmlEncode($Grid->OrgCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->OrgCode->formatPattern()) ?>"<?= $Grid->OrgCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->OrgCode->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x_OrgCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_OrgCode" id="o<?= $Grid->RowIndex ?>_OrgCode" value="<?= HtmlEncode($Grid->OrgCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_OrgCode" class="el_farmer_organisation_OrgCode">
<input type="<?= $Grid->OrgCode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_OrgCode" id="x<?= $Grid->RowIndex ?>_OrgCode" data-table="farmer_organisation" data-field="x_OrgCode" value="<?= $Grid->OrgCode->EditValue ?>" placeholder="<?= HtmlEncode($Grid->OrgCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->OrgCode->formatPattern()) ?>"<?= $Grid->OrgCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->OrgCode->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_OrgCode" class="el_farmer_organisation_OrgCode">
<span<?= $Grid->OrgCode->viewAttributes() ?>>
<?= $Grid->OrgCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_OrgCode" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_OrgCode" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_OrgCode" value="<?= HtmlEncode($Grid->OrgCode->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_OrgCode" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_OrgCode" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_OrgCode" value="<?= HtmlEncode($Grid->OrgCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerOrganisation->Visible) { // FarmerOrganisation ?>
        <td data-name="FarmerOrganisation"<?= $Grid->FarmerOrganisation->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_FarmerOrganisation" class="el_farmer_organisation_FarmerOrganisation">
<input type="<?= $Grid->FarmerOrganisation->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerOrganisation" id="x<?= $Grid->RowIndex ?>_FarmerOrganisation" data-table="farmer_organisation" data-field="x_FarmerOrganisation" value="<?= $Grid->FarmerOrganisation->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->FarmerOrganisation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerOrganisation->formatPattern()) ?>"<?= $Grid->FarmerOrganisation->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerOrganisation->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x_FarmerOrganisation" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerOrganisation" id="o<?= $Grid->RowIndex ?>_FarmerOrganisation" value="<?= HtmlEncode($Grid->FarmerOrganisation->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_FarmerOrganisation" class="el_farmer_organisation_FarmerOrganisation">
<input type="<?= $Grid->FarmerOrganisation->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerOrganisation" id="x<?= $Grid->RowIndex ?>_FarmerOrganisation" data-table="farmer_organisation" data-field="x_FarmerOrganisation" value="<?= $Grid->FarmerOrganisation->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->FarmerOrganisation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerOrganisation->formatPattern()) ?>"<?= $Grid->FarmerOrganisation->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerOrganisation->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_FarmerOrganisation" class="el_farmer_organisation_FarmerOrganisation">
<span<?= $Grid->FarmerOrganisation->viewAttributes() ?>>
<?= $Grid->FarmerOrganisation->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_FarmerOrganisation" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_FarmerOrganisation" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_FarmerOrganisation" value="<?= HtmlEncode($Grid->FarmerOrganisation->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_FarmerOrganisation" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_FarmerOrganisation" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_FarmerOrganisation" value="<?= HtmlEncode($Grid->FarmerOrganisation->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FOType->Visible) { // FOType ?>
        <td data-name="FOType"<?= $Grid->FOType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_FOType" class="el_farmer_organisation_FOType">
    <select
        id="x<?= $Grid->RowIndex ?>_FOType"
        name="x<?= $Grid->RowIndex ?>_FOType"
        class="form-select ew-select<?= $Grid->FOType->isInvalidClass() ?>"
        <?php if (!$Grid->FOType->IsNativeSelect) { ?>
        data-select2-id="ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_FOType"
        <?php } ?>
        data-table="farmer_organisation"
        data-field="x_FOType"
        data-value-separator="<?= $Grid->FOType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FOType->getPlaceHolder()) ?>"
        <?= $Grid->FOType->editAttributes() ?>>
        <?= $Grid->FOType->selectOptionListHtml("x{$Grid->RowIndex}_FOType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FOType->getErrorMessage() ?></div>
<?= $Grid->FOType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FOType") ?>
<?php if (!$Grid->FOType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmer_organisationgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FOType", selectId: "ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_FOType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmer_organisationgrid.lists.FOType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FOType", form: "ffarmer_organisationgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FOType", form: "ffarmer_organisationgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer_organisation.fields.FOType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x_FOType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FOType" id="o<?= $Grid->RowIndex ?>_FOType" value="<?= HtmlEncode($Grid->FOType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_FOType" class="el_farmer_organisation_FOType">
    <select
        id="x<?= $Grid->RowIndex ?>_FOType"
        name="x<?= $Grid->RowIndex ?>_FOType"
        class="form-select ew-select<?= $Grid->FOType->isInvalidClass() ?>"
        <?php if (!$Grid->FOType->IsNativeSelect) { ?>
        data-select2-id="ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_FOType"
        <?php } ?>
        data-table="farmer_organisation"
        data-field="x_FOType"
        data-value-separator="<?= $Grid->FOType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FOType->getPlaceHolder()) ?>"
        <?= $Grid->FOType->editAttributes() ?>>
        <?= $Grid->FOType->selectOptionListHtml("x{$Grid->RowIndex}_FOType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FOType->getErrorMessage() ?></div>
<?= $Grid->FOType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FOType") ?>
<?php if (!$Grid->FOType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmer_organisationgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FOType", selectId: "ffarmer_organisationgrid_x<?= $Grid->RowIndex ?>_FOType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmer_organisationgrid.lists.FOType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FOType", form: "ffarmer_organisationgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FOType", form: "ffarmer_organisationgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer_organisation.fields.FOType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_FOType" class="el_farmer_organisation_FOType">
<span<?= $Grid->FOType->viewAttributes() ?>>
<?= $Grid->FOType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_FOType" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_FOType" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_FOType" value="<?= HtmlEncode($Grid->FOType->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_FOType" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_FOType" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_FOType" value="<?= HtmlEncode($Grid->FOType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PhysicalAddress->Visible) { // PhysicalAddress ?>
        <td data-name="PhysicalAddress"<?= $Grid->PhysicalAddress->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_PhysicalAddress" class="el_farmer_organisation_PhysicalAddress">
<input type="<?= $Grid->PhysicalAddress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PhysicalAddress" id="x<?= $Grid->RowIndex ?>_PhysicalAddress" data-table="farmer_organisation" data-field="x_PhysicalAddress" value="<?= $Grid->PhysicalAddress->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->PhysicalAddress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PhysicalAddress->formatPattern()) ?>"<?= $Grid->PhysicalAddress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PhysicalAddress->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x_PhysicalAddress" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PhysicalAddress" id="o<?= $Grid->RowIndex ?>_PhysicalAddress" value="<?= HtmlEncode($Grid->PhysicalAddress->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_PhysicalAddress" class="el_farmer_organisation_PhysicalAddress">
<input type="<?= $Grid->PhysicalAddress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PhysicalAddress" id="x<?= $Grid->RowIndex ?>_PhysicalAddress" data-table="farmer_organisation" data-field="x_PhysicalAddress" value="<?= $Grid->PhysicalAddress->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->PhysicalAddress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PhysicalAddress->formatPattern()) ?>"<?= $Grid->PhysicalAddress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PhysicalAddress->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_PhysicalAddress" class="el_farmer_organisation_PhysicalAddress">
<span<?= $Grid->PhysicalAddress->viewAttributes() ?>>
<?= $Grid->PhysicalAddress->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_PhysicalAddress" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_PhysicalAddress" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_PhysicalAddress" value="<?= HtmlEncode($Grid->PhysicalAddress->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_PhysicalAddress" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_PhysicalAddress" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_PhysicalAddress" value="<?= HtmlEncode($Grid->PhysicalAddress->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PostalAddress->Visible) { // PostalAddress ?>
        <td data-name="PostalAddress"<?= $Grid->PostalAddress->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_PostalAddress" class="el_farmer_organisation_PostalAddress">
<input type="<?= $Grid->PostalAddress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PostalAddress" id="x<?= $Grid->RowIndex ?>_PostalAddress" data-table="farmer_organisation" data-field="x_PostalAddress" value="<?= $Grid->PostalAddress->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->PostalAddress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PostalAddress->formatPattern()) ?>"<?= $Grid->PostalAddress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PostalAddress->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x_PostalAddress" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PostalAddress" id="o<?= $Grid->RowIndex ?>_PostalAddress" value="<?= HtmlEncode($Grid->PostalAddress->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_PostalAddress" class="el_farmer_organisation_PostalAddress">
<input type="<?= $Grid->PostalAddress->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PostalAddress" id="x<?= $Grid->RowIndex ?>_PostalAddress" data-table="farmer_organisation" data-field="x_PostalAddress" value="<?= $Grid->PostalAddress->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->PostalAddress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PostalAddress->formatPattern()) ?>"<?= $Grid->PostalAddress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PostalAddress->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_PostalAddress" class="el_farmer_organisation_PostalAddress">
<span<?= $Grid->PostalAddress->viewAttributes() ?>>
<?= $Grid->PostalAddress->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_PostalAddress" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_PostalAddress" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_PostalAddress" value="<?= HtmlEncode($Grid->PostalAddress->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_PostalAddress" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_PostalAddress" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_PostalAddress" value="<?= HtmlEncode($Grid->PostalAddress->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Phone->Visible) { // Phone ?>
        <td data-name="Phone"<?= $Grid->Phone->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_Phone" class="el_farmer_organisation_Phone">
<input type="<?= $Grid->Phone->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Phone" id="x<?= $Grid->RowIndex ?>_Phone" data-table="farmer_organisation" data-field="x_Phone" value="<?= $Grid->Phone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Phone->formatPattern()) ?>"<?= $Grid->Phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Phone->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x_Phone" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Phone" id="o<?= $Grid->RowIndex ?>_Phone" value="<?= HtmlEncode($Grid->Phone->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_Phone" class="el_farmer_organisation_Phone">
<input type="<?= $Grid->Phone->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Phone" id="x<?= $Grid->RowIndex ?>_Phone" data-table="farmer_organisation" data-field="x_Phone" value="<?= $Grid->Phone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Phone->formatPattern()) ?>"<?= $Grid->Phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Phone->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_Phone" class="el_farmer_organisation_Phone">
<span<?= $Grid->Phone->viewAttributes() ?>>
<?= $Grid->Phone->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_Phone" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_Phone" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_Phone" value="<?= HtmlEncode($Grid->Phone->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_Phone" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_Phone" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_Phone" value="<?= HtmlEncode($Grid->Phone->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Grid->_Email->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation__Email" class="el_farmer_organisation__Email">
<input type="<?= $Grid->_Email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__Email" id="x<?= $Grid->RowIndex ?>__Email" data-table="farmer_organisation" data-field="x__Email" value="<?= $Grid->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_Email->formatPattern()) ?>"<?= $Grid->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_Email->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer_organisation" data-field="x__Email" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__Email" id="o<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation__Email" class="el_farmer_organisation__Email">
<input type="<?= $Grid->_Email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__Email" id="x<?= $Grid->RowIndex ?>__Email" data-table="farmer_organisation" data-field="x__Email" value="<?= $Grid->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_Email->formatPattern()) ?>"<?= $Grid->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_Email->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation__Email" class="el_farmer_organisation__Email">
<span<?= $Grid->_Email->viewAttributes() ?>>
<?= $Grid->_Email->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x__Email" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>__Email" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x__Email" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>__Email" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ID->Visible) { // ID ?>
        <td data-name="ID"<?= $Grid->ID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_ID" class="el_farmer_organisation_ID"></span>
<input type="hidden" data-table="farmer_organisation" data-field="x_ID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ID" id="o<?= $Grid->RowIndex ?>_ID" value="<?= HtmlEncode($Grid->ID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_ID" class="el_farmer_organisation_ID">
<span<?= $Grid->ID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ID->getDisplayValue($Grid->ID->EditValue))) ?>"></span>
<input type="hidden" data-table="farmer_organisation" data-field="x_ID" data-hidden="1" name="x<?= $Grid->RowIndex ?>_ID" id="x<?= $Grid->RowIndex ?>_ID" value="<?= HtmlEncode($Grid->ID->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_organisation_ID" class="el_farmer_organisation_ID">
<span<?= $Grid->ID->viewAttributes() ?>>
<?= $Grid->ID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer_organisation" data-field="x_ID" data-hidden="1" name="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_ID" id="ffarmer_organisationgrid$x<?= $Grid->RowIndex ?>_ID" value="<?= HtmlEncode($Grid->ID->FormValue) ?>">
<input type="hidden" data-table="farmer_organisation" data-field="x_ID" data-hidden="1" data-old name="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_ID" id="ffarmer_organisationgrid$o<?= $Grid->RowIndex ?>_ID" value="<?= HtmlEncode($Grid->ID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farmer_organisation" data-field="x_ID" data-hidden="1" name="x<?= $Grid->RowIndex ?>_ID" id="x<?= $Grid->RowIndex ?>_ID" value="<?= HtmlEncode($Grid->ID->CurrentValue) ?>">
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ffarmer_organisationgrid","load"], () => ffarmer_organisationgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ffarmer_organisationgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farmer_organisation");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
