<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
<form name="ffarmview" id="ffarmview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var ffarmview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarmview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <tr id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span></td>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_farm_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <tr id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_DistrictCode"><?= $Page->DistrictCode->caption() ?></span></td>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_farm_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <tr id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_CampCode"><?= $Page->CampCode->caption() ?></span></td>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<span id="el_farm_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <tr id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_VillageCode"><?= $Page->VillageCode->caption() ?></span></td>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el_farm_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <tr id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_NRC"><?= $Page->NRC->caption() ?></span></td>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<span id="el_farm_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <tr id="r_FarmNo"<?= $Page->FarmNo->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_FarmNo"><?= $Page->FarmNo->caption() ?></span></td>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<span id="el_farm_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<div id="mp_farm_FarmNo"
    class="ew-map"
    style="width: 256px; height: 256px;"
    data-ext="googlemaps"
    data-use-single-map="false"
    data-use-marker-clusterer="false"
    data-single-map-height="512"
    data-geocoding-delay="250"
    data-show-map-on-top="true"
    data-show-all-markers="true"
    data-latitude="<?= HtmlEncode($Page->Latitude->CurrentValue) ?>"
    data-longitude="<?= HtmlEncode($Page->Longitude->CurrentValue) ?>"
    data-type="ROADMAP"
    data-zoom="8"
></div>
<span class="ew-map-value"><?= $Page->FarmNo->ViewValue ?></span>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
    <tr id="r_FieldType"<?= $Page->FieldType->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_FieldType"><?= $Page->FieldType->caption() ?></span></td>
        <td data-name="FieldType"<?= $Page->FieldType->cellAttributes() ?>>
<span id="el_farm_FieldType">
<span<?= $Page->FieldType->viewAttributes() ?>>
<?= $Page->FieldType->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
    <tr id="r_Ownership"<?= $Page->Ownership->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_Ownership"><?= $Page->Ownership->caption() ?></span></td>
        <td data-name="Ownership"<?= $Page->Ownership->cellAttributes() ?>>
<span id="el_farm_Ownership">
<span<?= $Page->Ownership->viewAttributes() ?>>
<?= $Page->Ownership->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
    <tr id="r_SeedlingsAllocated"<?= $Page->SeedlingsAllocated->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_SeedlingsAllocated"><?= $Page->SeedlingsAllocated->caption() ?></span></td>
        <td data-name="SeedlingsAllocated"<?= $Page->SeedlingsAllocated->cellAttributes() ?>>
<span id="el_farm_SeedlingsAllocated">
<span<?= $Page->SeedlingsAllocated->viewAttributes() ?>>
<?= $Page->SeedlingsAllocated->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
    <tr id="r_TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_TreesPlantedEstimated"><?= $Page->TreesPlantedEstimated->caption() ?></span></td>
        <td data-name="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span id="el_farm_TreesPlantedEstimated">
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
    <tr id="r_FarmSizeEstimated"<?= $Page->FarmSizeEstimated->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_FarmSizeEstimated"><?= $Page->FarmSizeEstimated->caption() ?></span></td>
        <td data-name="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span id="el_farm_FarmSizeEstimated">
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
    <tr id="r_FarmSizeVerified"<?= $Page->FarmSizeVerified->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_FarmSizeVerified"><?= $Page->FarmSizeVerified->caption() ?></span></td>
        <td data-name="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span id="el_farm_FarmSizeVerified">
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
    <tr id="r_TreesPlantedVerified"<?= $Page->TreesPlantedVerified->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_TreesPlantedVerified"><?= $Page->TreesPlantedVerified->caption() ?></span></td>
        <td data-name="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span id="el_farm_TreesPlantedVerified">
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
    <tr id="r_SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_SourcesOfSeedlings"><?= $Page->SourcesOfSeedlings->caption() ?></span></td>
        <td data-name="SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<span id="el_farm_SourcesOfSeedlings">
<span<?= $Page->SourcesOfSeedlings->viewAttributes() ?>>
<?= $Page->SourcesOfSeedlings->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->InspecationReport->Visible) { // InspecationReport ?>
    <tr id="r_InspecationReport"<?= $Page->InspecationReport->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_InspecationReport"><?= $Page->InspecationReport->caption() ?></span></td>
        <td data-name="InspecationReport"<?= $Page->InspecationReport->cellAttributes() ?>>
<span id="el_farm_InspecationReport">
<span<?= $Page->InspecationReport->viewAttributes() ?>>
<?= $Page->InspecationReport->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ClearedLand->Visible) { // ClearedLand ?>
    <tr id="r_ClearedLand"<?= $Page->ClearedLand->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_ClearedLand"><?= $Page->ClearedLand->caption() ?></span></td>
        <td data-name="ClearedLand"<?= $Page->ClearedLand->cellAttributes() ?>>
<span id="el_farm_ClearedLand">
<span<?= $Page->ClearedLand->viewAttributes() ?>>
<?= $Page->ClearedLand->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->OldTrees->Visible) { // OldTrees ?>
    <tr id="r_OldTrees"<?= $Page->OldTrees->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_OldTrees"><?= $Page->OldTrees->caption() ?></span></td>
        <td data-name="OldTrees"<?= $Page->OldTrees->cellAttributes() ?>>
<span id="el_farm_OldTrees">
<span<?= $Page->OldTrees->viewAttributes() ?>>
<?= $Page->OldTrees->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { // FarmSize ?>
    <tr id="r_FarmSize"<?= $Page->FarmSize->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_FarmSize"><?= $Page->FarmSize->caption() ?></span></td>
        <td data-name="FarmSize"<?= $Page->FarmSize->cellAttributes() ?>>
<span id="el_farm_FarmSize">
<span<?= $Page->FarmSize->viewAttributes() ?>>
<?= $Page->FarmSize->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Latitude->Visible) { // Latitude ?>
    <tr id="r_Latitude"<?= $Page->Latitude->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_Latitude"><?= $Page->Latitude->caption() ?></span></td>
        <td data-name="Latitude"<?= $Page->Latitude->cellAttributes() ?>>
<span id="el_farm_Latitude">
<span<?= $Page->Latitude->viewAttributes() ?>>
<?= $Page->Latitude->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Longitude->Visible) { // Longitude ?>
    <tr id="r_Longitude"<?= $Page->Longitude->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_farm_Longitude"><?= $Page->Longitude->caption() ?></span></td>
        <td data-name="Longitude"<?= $Page->Longitude->cellAttributes() ?>>
<span id="el_farm_Longitude">
<span<?= $Page->Longitude->viewAttributes() ?>>
<?= $Page->Longitude->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<?php
    $Page->DetailPages->ValidKeys = explode(",", $Page->getCurrentDetailTable());
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav<?= $Page->DetailPages->containerClasses() ?>" id="details_Page"><!-- tabs -->
    <ul class="<?= $Page->DetailPages->navClasses() ?>" role="tablist"><!-- .nav -->
<?php
    if (in_array("farm_seed_allocate", explode(",", $Page->getCurrentDetailTable())) && $farm_seed_allocate->DetailView) {
?>
        <li class="nav-item"><button class="<?= $Page->DetailPages->navLinkClasses("farm_seed_allocate") ?><?= $Page->DetailPages->activeClasses("farm_seed_allocate") ?>" data-bs-target="#tab_farm_seed_allocate" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_farm_seed_allocate" aria-selected="<?= JsonEncode($Page->DetailPages->isActive("farm_seed_allocate")) ?>"><?= $Language->tablePhrase("farm_seed_allocate", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("farm_seed_allocate")->Count, $Language->phrase("DetailCount"))) ?></button></li>
<?php
    }
?>
<?php
    if (in_array("farm_inspection", explode(",", $Page->getCurrentDetailTable())) && $farm_inspection->DetailView) {
?>
        <li class="nav-item"><button class="<?= $Page->DetailPages->navLinkClasses("farm_inspection") ?><?= $Page->DetailPages->activeClasses("farm_inspection") ?>" data-bs-target="#tab_farm_inspection" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_farm_inspection" aria-selected="<?= JsonEncode($Page->DetailPages->isActive("farm_inspection")) ?>"><?= $Language->tablePhrase("farm_inspection", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("farm_inspection")->Count, $Language->phrase("DetailCount"))) ?></button></li>
<?php
    }
?>
<?php
    if (in_array("production_sales", explode(",", $Page->getCurrentDetailTable())) && $production_sales->DetailView) {
?>
        <li class="nav-item"><button class="<?= $Page->DetailPages->navLinkClasses("production_sales") ?><?= $Page->DetailPages->activeClasses("production_sales") ?>" data-bs-target="#tab_production_sales" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_production_sales" aria-selected="<?= JsonEncode($Page->DetailPages->isActive("production_sales")) ?>"><?= $Language->tablePhrase("production_sales", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("production_sales")->Count, $Language->phrase("DetailCount"))) ?></button></li>
<?php
    }
?>
    </ul><!-- /.nav -->
    <div class="<?= $Page->DetailPages->tabContentClasses() ?>"><!-- .tab-content -->
<?php
    if (in_array("farm_seed_allocate", explode(",", $Page->getCurrentDetailTable())) && $farm_seed_allocate->DetailView) {
?>
        <div class="<?= $Page->DetailPages->tabPaneClasses("farm_seed_allocate") ?><?= $Page->DetailPages->activeClasses("farm_seed_allocate") ?>" id="tab_farm_seed_allocate" role="tabpanel"><!-- page* -->
<?php include_once "FarmSeedAllocateGrid.php" ?>
        </div><!-- /page* -->
<?php } ?>
<?php
    if (in_array("farm_inspection", explode(",", $Page->getCurrentDetailTable())) && $farm_inspection->DetailView) {
?>
        <div class="<?= $Page->DetailPages->tabPaneClasses("farm_inspection") ?><?= $Page->DetailPages->activeClasses("farm_inspection") ?>" id="tab_farm_inspection" role="tabpanel"><!-- page* -->
<?php include_once "FarmInspectionGrid.php" ?>
        </div><!-- /page* -->
<?php } ?>
<?php
    if (in_array("production_sales", explode(",", $Page->getCurrentDetailTable())) && $production_sales->DetailView) {
?>
        <div class="<?= $Page->DetailPages->tabPaneClasses("production_sales") ?><?= $Page->DetailPages->activeClasses("production_sales") ?>" id="tab_production_sales" role="tabpanel"><!-- page* -->
<?php include_once "ProductionSalesGrid.php" ?>
        </div><!-- /page* -->
<?php } ?>
    </div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
