<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffarmsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarmsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["FarmNo", [ew.Validators.integer], fields.FarmNo.isInvalid],
            ["FieldType", [], fields.FieldType.isInvalid],
            ["Ownership", [], fields.Ownership.isInvalid],
            ["SeedlingsAllocated", [ew.Validators.float], fields.SeedlingsAllocated.isInvalid],
            ["TreesPlantedEstimated", [ew.Validators.float], fields.TreesPlantedEstimated.isInvalid],
            ["FarmSizeEstimated", [ew.Validators.float], fields.FarmSizeEstimated.isInvalid],
            ["FarmSizeVerified", [ew.Validators.float], fields.FarmSizeVerified.isInvalid],
            ["TreesPlantedVerified", [ew.Validators.float], fields.TreesPlantedVerified.isInvalid],
            ["SourcesOfSeedlings", [], fields.SourcesOfSeedlings.isInvalid],
            ["InspecationReport", [], fields.InspecationReport.isInvalid],
            ["ClearedLand", [], fields.ClearedLand.isInvalid],
            ["OldTrees", [], fields.OldTrees.isInvalid],
            ["FarmSize", [], fields.FarmSize.isInvalid],
            ["Latitude", [ew.Validators.float], fields.Latitude.isInvalid],
            ["Longitude", [ew.Validators.float], fields.Longitude.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
            "Ownership": <?= $Page->Ownership->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarmsearch" id="ffarmsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode" class="row"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProvinceCode" id="z_ProvinceCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProvinceCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarmsearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="ffarmsearch_x_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarmsearch_x_DistrictCode" };
    if (ffarmsearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode" class="row"<?= $Page->CampCode->rowAttributes() ?>>
        <label for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_CampCode"><?= $Page->CampCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_CampCode" id="z_CampCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmsearch_x_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_CampCode", selectId: "ffarmsearch_x_CampCode" };
    if (ffarmsearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode" class="row"<?= $Page->VillageCode->rowAttributes() ?>>
        <label for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_VillageCode"><?= $Page->VillageCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VillageCode" id="z_VillageCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VillageCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmsearch_x_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_VillageCode", selectId: "ffarmsearch_x_VillageCode" };
    if (ffarmsearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_NRC" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffarmsearch", function() {
    ffarmsearch.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <div id="r_FarmNo" class="row"<?= $Page->FarmNo->rowAttributes() ?>>
        <label for="x_FarmNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_FarmNo"><?= $Page->FarmNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmNo" id="z_FarmNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_FarmNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="farm" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
    <div id="r_FieldType" class="row"<?= $Page->FieldType->rowAttributes() ?>>
        <label for="x_FieldType" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_FieldType"><?= $Page->FieldType->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FieldType" id="z_FieldType" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FieldType->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_FieldType" class="ew-search-field ew-search-field-single">
    <select
        id="x_FieldType"
        name="x_FieldType"
        class="form-select ew-select<?= $Page->FieldType->isInvalidClass() ?>"
        <?php if (!$Page->FieldType->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
        <?= $Page->FieldType->editAttributes() ?>>
        <?= $Page->FieldType->selectOptionListHtml("x_FieldType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage(false) ?></div>
<?= $Page->FieldType->Lookup->getParamTag($Page, "p_x_FieldType") ?>
<?php if (!$Page->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_FieldType", selectId: "ffarmsearch_x_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x_FieldType", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_FieldType", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
    <div id="r_Ownership" class="row"<?= $Page->Ownership->rowAttributes() ?>>
        <label for="x_Ownership" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_Ownership"><?= $Page->Ownership->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Ownership" id="z_Ownership" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Ownership->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_Ownership" class="ew-search-field ew-search-field-single">
    <select
        id="x_Ownership"
        name="x_Ownership"
        class="form-select ew-select<?= $Page->Ownership->isInvalidClass() ?>"
        <?php if (!$Page->Ownership->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Page->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Ownership->getPlaceHolder()) ?>"
        <?= $Page->Ownership->editAttributes() ?>>
        <?= $Page->Ownership->selectOptionListHtml("x_Ownership") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Ownership->getErrorMessage(false) ?></div>
<?= $Page->Ownership->Lookup->getParamTag($Page, "p_x_Ownership") ?>
<?php if (!$Page->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_Ownership", selectId: "ffarmsearch_x_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x_Ownership", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_Ownership", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
    <div id="r_SeedlingsAllocated" class="row"<?= $Page->SeedlingsAllocated->rowAttributes() ?>>
        <label for="x_SeedlingsAllocated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_SeedlingsAllocated"><?= $Page->SeedlingsAllocated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SeedlingsAllocated" id="z_SeedlingsAllocated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedlingsAllocated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_SeedlingsAllocated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsAllocated->getInputTextType() ?>" name="x_SeedlingsAllocated" id="x_SeedlingsAllocated" data-table="farm" data-field="x_SeedlingsAllocated" value="<?= $Page->SeedlingsAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsAllocated->formatPattern()) ?>"<?= $Page->SeedlingsAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsAllocated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
    <div id="r_TreesPlantedEstimated" class="row"<?= $Page->TreesPlantedEstimated->rowAttributes() ?>>
        <label for="x_TreesPlantedEstimated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_TreesPlantedEstimated"><?= $Page->TreesPlantedEstimated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TreesPlantedEstimated" id="z_TreesPlantedEstimated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_TreesPlantedEstimated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesPlantedEstimated->getInputTextType() ?>" name="x_TreesPlantedEstimated" id="x_TreesPlantedEstimated" data-table="farm" data-field="x_TreesPlantedEstimated" value="<?= $Page->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedEstimated->formatPattern()) ?>"<?= $Page->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedEstimated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
    <div id="r_FarmSizeEstimated" class="row"<?= $Page->FarmSizeEstimated->rowAttributes() ?>>
        <label for="x_FarmSizeEstimated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_FarmSizeEstimated"><?= $Page->FarmSizeEstimated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmSizeEstimated" id="z_FarmSizeEstimated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_FarmSizeEstimated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmSizeEstimated->getInputTextType() ?>" name="x_FarmSizeEstimated" id="x_FarmSizeEstimated" data-table="farm" data-field="x_FarmSizeEstimated" value="<?= $Page->FarmSizeEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmSizeEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSizeEstimated->formatPattern()) ?>"<?= $Page->FarmSizeEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmSizeEstimated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
    <div id="r_FarmSizeVerified" class="row"<?= $Page->FarmSizeVerified->rowAttributes() ?>>
        <label for="x_FarmSizeVerified" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_FarmSizeVerified"><?= $Page->FarmSizeVerified->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmSizeVerified" id="z_FarmSizeVerified" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmSizeVerified->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_FarmSizeVerified" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmSizeVerified->getInputTextType() ?>" name="x_FarmSizeVerified" id="x_FarmSizeVerified" data-table="farm" data-field="x_FarmSizeVerified" value="<?= $Page->FarmSizeVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmSizeVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSizeVerified->formatPattern()) ?>"<?= $Page->FarmSizeVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmSizeVerified->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
    <div id="r_TreesPlantedVerified" class="row"<?= $Page->TreesPlantedVerified->rowAttributes() ?>>
        <label for="x_TreesPlantedVerified" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_TreesPlantedVerified"><?= $Page->TreesPlantedVerified->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TreesPlantedVerified" id="z_TreesPlantedVerified" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_TreesPlantedVerified" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesPlantedVerified->getInputTextType() ?>" name="x_TreesPlantedVerified" id="x_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Page->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedVerified->formatPattern()) ?>"<?= $Page->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedVerified->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
    <div id="r_SourcesOfSeedlings" class="row"<?= $Page->SourcesOfSeedlings->rowAttributes() ?>>
        <label for="x_SourcesOfSeedlings" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_SourcesOfSeedlings"><?= $Page->SourcesOfSeedlings->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SourcesOfSeedlings" id="z_SourcesOfSeedlings" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_SourcesOfSeedlings" class="ew-search-field ew-search-field-single">
    <select
        id="x_SourcesOfSeedlings"
        name="x_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage(false) ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_SourcesOfSeedlings", selectId: "ffarmsearch_x_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x_SourcesOfSeedlings", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_SourcesOfSeedlings", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->InspecationReport->Visible) { // InspecationReport ?>
    <div id="r_InspecationReport" class="row"<?= $Page->InspecationReport->rowAttributes() ?>>
        <label for="x_InspecationReport" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_InspecationReport"><?= $Page->InspecationReport->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_InspecationReport" id="z_InspecationReport" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->InspecationReport->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_InspecationReport" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InspecationReport->getInputTextType() ?>" name="x_InspecationReport" id="x_InspecationReport" data-table="farm" data-field="x_InspecationReport" value="<?= $Page->InspecationReport->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->InspecationReport->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspecationReport->formatPattern()) ?>"<?= $Page->InspecationReport->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InspecationReport->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClearedLand->Visible) { // ClearedLand ?>
    <div id="r_ClearedLand" class="row"<?= $Page->ClearedLand->rowAttributes() ?>>
        <label for="x_ClearedLand" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_ClearedLand"><?= $Page->ClearedLand->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ClearedLand" id="z_ClearedLand" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClearedLand->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_ClearedLand" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClearedLand->getInputTextType() ?>" name="x_ClearedLand" id="x_ClearedLand" data-table="farm" data-field="x_ClearedLand" value="<?= $Page->ClearedLand->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ClearedLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearedLand->formatPattern()) ?>"<?= $Page->ClearedLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClearedLand->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OldTrees->Visible) { // OldTrees ?>
    <div id="r_OldTrees" class="row"<?= $Page->OldTrees->rowAttributes() ?>>
        <label for="x_OldTrees" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_OldTrees"><?= $Page->OldTrees->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_OldTrees" id="z_OldTrees" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OldTrees->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_OldTrees" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OldTrees->getInputTextType() ?>" name="x_OldTrees" id="x_OldTrees" data-table="farm" data-field="x_OldTrees" value="<?= $Page->OldTrees->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->OldTrees->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OldTrees->formatPattern()) ?>"<?= $Page->OldTrees->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OldTrees->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { // FarmSize ?>
    <div id="r_FarmSize" class="row"<?= $Page->FarmSize->rowAttributes() ?>>
        <label for="x_FarmSize" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_FarmSize"><?= $Page->FarmSize->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FarmSize" id="z_FarmSize" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmSize->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_FarmSize" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmSize->getInputTextType() ?>" name="x_FarmSize" id="x_FarmSize" data-table="farm" data-field="x_FarmSize" value="<?= $Page->FarmSize->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmSize->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSize->formatPattern()) ?>"<?= $Page->FarmSize->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmSize->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Latitude->Visible) { // Latitude ?>
    <div id="r_Latitude" class="row"<?= $Page->Latitude->rowAttributes() ?>>
        <label for="x_Latitude" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_Latitude"><?= $Page->Latitude->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Latitude" id="z_Latitude" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Latitude->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_Latitude" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Latitude->getInputTextType() ?>" name="x_Latitude" id="x_Latitude" data-table="farm" data-field="x_Latitude" value="<?= $Page->Latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Latitude->formatPattern()) ?>"<?= $Page->Latitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Latitude->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Longitude->Visible) { // Longitude ?>
    <div id="r_Longitude" class="row"<?= $Page->Longitude->rowAttributes() ?>>
        <label for="x_Longitude" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_Longitude"><?= $Page->Longitude->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Longitude" id="z_Longitude" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Longitude->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_Longitude" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Longitude->getInputTextType() ?>" name="x_Longitude" id="x_Longitude" data-table="farm" data-field="x_Longitude" value="<?= $Page->Longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Longitude->formatPattern()) ?>"<?= $Page->Longitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Longitude->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarmsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarmsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ffarmsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
