<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmOpenBalList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_open_bal: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null, ew.Validators.integer], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["TransNo", [fields.TransNo.visible && fields.TransNo.required ? ew.Validators.required(fields.TransNo.caption) : null], fields.TransNo.isInvalid],
            ["TreesPlanted", [fields.TreesPlanted.visible && fields.TreesPlanted.required ? ew.Validators.required(fields.TreesPlanted.caption) : null, ew.Validators.float], fields.TreesPlanted.isInvalid],
            ["SeedType", [fields.SeedType.visible && fields.SeedType.required ? ew.Validators.required(fields.SeedType.caption) : null], fields.SeedType.isInvalid],
            ["SourcesOfSeedlings", [fields.SourcesOfSeedlings.visible && fields.SourcesOfSeedlings.required ? ew.Validators.required(fields.SourcesOfSeedlings.caption) : null], fields.SourcesOfSeedlings.isInvalid],
            ["TransDate", [fields.TransDate.visible && fields.TransDate.required ? ew.Validators.required(fields.TransDate.caption) : null, ew.Validators.datetime(fields.TransDate.clientFormatPattern)], fields.TransDate.isInvalid],
            ["PreparedBy", [fields.PreparedBy.visible && fields.PreparedBy.required ? ew.Validators.required(fields.PreparedBy.caption) : null], fields.PreparedBy.isInvalid],
            ["AuthorisedBy", [fields.AuthorisedBy.visible && fields.AuthorisedBy.required ? ew.Validators.required(fields.AuthorisedBy.caption) : null], fields.AuthorisedBy.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerNo",false],["FarmNo",false],["TreesPlanted",false],["SeedType",false],["SourcesOfSeedlings",false],["TransDate",false],["PreparedBy",false],["AuthorisedBy",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarm_open_balsrch" id="ffarm_open_balsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarm_open_balsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_open_bal: currentTable } });
var currentForm;
var ffarm_open_balsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarm_open_balsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarm_open_balsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarm_open_balsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarm_open_balsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarm_open_balsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_open_bal">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_farm_open_bal" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farm_open_ballist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_open_bal_ProvinceCode" class="farm_open_bal_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farm_open_bal_DistrictCode" class="farm_open_bal_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farm_open_bal_CampCode" class="farm_open_bal_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farm_open_bal_VillageCode" class="farm_open_bal_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farm_open_bal_NRC" class="farm_open_bal_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_farm_open_bal_FarmerNo" class="farm_open_bal_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div id="elh_farm_open_bal_FarmNo" class="farm_open_bal_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Page->TransNo->Visible) { // TransNo ?>
        <th data-name="TransNo" class="<?= $Page->TransNo->headerCellClass() ?>"><div id="elh_farm_open_bal_TransNo" class="farm_open_bal_TransNo"><?= $Page->renderFieldHeader($Page->TransNo) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlanted->Visible) { // TreesPlanted ?>
        <th data-name="TreesPlanted" class="<?= $Page->TreesPlanted->headerCellClass() ?>"><div id="elh_farm_open_bal_TreesPlanted" class="farm_open_bal_TreesPlanted"><?= $Page->renderFieldHeader($Page->TreesPlanted) ?></div></th>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
        <th data-name="SeedType" class="<?= $Page->SeedType->headerCellClass() ?>"><div id="elh_farm_open_bal_SeedType" class="farm_open_bal_SeedType"><?= $Page->renderFieldHeader($Page->SeedType) ?></div></th>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <th data-name="SourcesOfSeedlings" class="<?= $Page->SourcesOfSeedlings->headerCellClass() ?>"><div id="elh_farm_open_bal_SourcesOfSeedlings" class="farm_open_bal_SourcesOfSeedlings"><?= $Page->renderFieldHeader($Page->SourcesOfSeedlings) ?></div></th>
<?php } ?>
<?php if ($Page->TransDate->Visible) { // TransDate ?>
        <th data-name="TransDate" class="<?= $Page->TransDate->headerCellClass() ?>"><div id="elh_farm_open_bal_TransDate" class="farm_open_bal_TransDate"><?= $Page->renderFieldHeader($Page->TransDate) ?></div></th>
<?php } ?>
<?php if ($Page->PreparedBy->Visible) { // PreparedBy ?>
        <th data-name="PreparedBy" class="<?= $Page->PreparedBy->headerCellClass() ?>"><div id="elh_farm_open_bal_PreparedBy" class="farm_open_bal_PreparedBy"><?= $Page->renderFieldHeader($Page->PreparedBy) ?></div></th>
<?php } ?>
<?php if ($Page->AuthorisedBy->Visible) { // AuthorisedBy ?>
        <th data-name="AuthorisedBy" class="<?= $Page->AuthorisedBy->headerCellClass() ?>"><div id="elh_farm_open_bal_AuthorisedBy" class="farm_open_bal_AuthorisedBy"><?= $Page->renderFieldHeader($Page->AuthorisedBy) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_ProvinceCode" class="el_farm_open_bal_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProvinceCode" id="o<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_ProvinceCode" class="el_farm_open_bal_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_ProvinceCode" class="el_farm_open_bal_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_DistrictCode" class="el_farm_open_bal_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_DistrictCode" class="el_farm_open_bal_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_DistrictCode" class="el_farm_open_bal_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_CampCode" class="el_farm_open_bal_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_CampCode" class="el_farm_open_bal_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_CampCode" class="el_farm_open_bal_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_VillageCode" class="el_farm_open_bal_VillageCode">
<input type="<?= $Page->VillageCode->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_VillageCode" id="x<?= $Page->RowIndex ?>_VillageCode" data-table="farm_open_bal" data-field="x_VillageCode" value="<?= $Page->VillageCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->VillageCode->formatPattern()) ?>"<?= $Page->VillageCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_VillageCode" class="el_farm_open_bal_VillageCode">
<input type="<?= $Page->VillageCode->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_VillageCode" id="x<?= $Page->RowIndex ?>_VillageCode" data-table="farm_open_bal" data-field="x_VillageCode" value="<?= $Page->VillageCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->VillageCode->formatPattern()) ?>"<?= $Page->VillageCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_VillageCode" class="el_farm_open_bal_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_NRC" class="el_farm_open_bal_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_open_bal" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_open_bal.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_NRC" class="el_farm_open_bal_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_open_bal" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_open_bal.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_NRC" class="el_farm_open_bal_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_FarmerNo" class="el_farm_open_bal_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" data-table="farm_open_bal" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerNo" id="o<?= $Page->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Page->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_FarmerNo" class="el_farm_open_bal_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" data-table="farm_open_bal" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_FarmerNo" class="el_farm_open_bal_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_FarmNo" class="el_farm_open_bal_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmNo" id="x<?= $Page->RowIndex ?>_FarmNo" data-table="farm_open_bal" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmNo" id="o<?= $Page->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Page->FarmNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_FarmNo" class="el_farm_open_bal_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmNo" id="x<?= $Page->RowIndex ?>_FarmNo" data-table="farm_open_bal" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_FarmNo" class="el_farm_open_bal_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TransNo->Visible) { // TransNo ?>
        <td data-name="TransNo"<?= $Page->TransNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TransNo" class="el_farm_open_bal_TransNo"></span>
<input type="hidden" data-table="farm_open_bal" data-field="x_TransNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TransNo" id="o<?= $Page->RowIndex ?>_TransNo" value="<?= HtmlEncode($Page->TransNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TransNo" class="el_farm_open_bal_TransNo">
<span<?= $Page->TransNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->TransNo->getDisplayValue($Page->TransNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farm_open_bal" data-field="x_TransNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_TransNo" id="x<?= $Page->RowIndex ?>_TransNo" value="<?= HtmlEncode($Page->TransNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TransNo" class="el_farm_open_bal_TransNo">
<span<?= $Page->TransNo->viewAttributes() ?>>
<?= $Page->TransNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farm_open_bal" data-field="x_TransNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_TransNo" id="x<?= $Page->RowIndex ?>_TransNo" value="<?= HtmlEncode($Page->TransNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->TreesPlanted->Visible) { // TreesPlanted ?>
        <td data-name="TreesPlanted"<?= $Page->TreesPlanted->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TreesPlanted" class="el_farm_open_bal_TreesPlanted">
<input type="<?= $Page->TreesPlanted->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesPlanted" id="x<?= $Page->RowIndex ?>_TreesPlanted" data-table="farm_open_bal" data-field="x_TreesPlanted" value="<?= $Page->TreesPlanted->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlanted->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlanted->formatPattern()) ?>"<?= $Page->TreesPlanted->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlanted->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_TreesPlanted" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TreesPlanted" id="o<?= $Page->RowIndex ?>_TreesPlanted" value="<?= HtmlEncode($Page->TreesPlanted->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TreesPlanted" class="el_farm_open_bal_TreesPlanted">
<input type="<?= $Page->TreesPlanted->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesPlanted" id="x<?= $Page->RowIndex ?>_TreesPlanted" data-table="farm_open_bal" data-field="x_TreesPlanted" value="<?= $Page->TreesPlanted->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlanted->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlanted->formatPattern()) ?>"<?= $Page->TreesPlanted->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlanted->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TreesPlanted" class="el_farm_open_bal_TreesPlanted">
<span<?= $Page->TreesPlanted->viewAttributes() ?>>
<?= $Page->TreesPlanted->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType"<?= $Page->SeedType->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_SeedType" class="el_farm_open_bal_SeedType">
    <select
        id="x<?= $Page->RowIndex ?>_SeedType"
        name="x<?= $Page->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x{$Page->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SeedType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_SeedType" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SeedType" id="o<?= $Page->RowIndex ?>_SeedType" value="<?= HtmlEncode($Page->SeedType->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_SeedType" class="el_farm_open_bal_SeedType">
    <select
        id="x<?= $Page->RowIndex ?>_SeedType"
        name="x<?= $Page->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x{$Page->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SeedType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_SeedType" class="el_farm_open_bal_SeedType">
<span<?= $Page->SeedType->viewAttributes() ?>>
<?= $Page->SeedType->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_SourcesOfSeedlings" class="el_farm_open_bal_SourcesOfSeedlings">
    <select
        id="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        name="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x{$Page->RowIndex}_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_SourcesOfSeedlings" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SourcesOfSeedlings" id="o<?= $Page->RowIndex ?>_SourcesOfSeedlings" value="<?= HtmlEncode($Page->SourcesOfSeedlings->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_SourcesOfSeedlings" class="el_farm_open_bal_SourcesOfSeedlings">
    <select
        id="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        name="x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_open_bal"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x{$Page->RowIndex}_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SourcesOfSeedlings", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_open_bal.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_SourcesOfSeedlings" class="el_farm_open_bal_SourcesOfSeedlings">
<span<?= $Page->SourcesOfSeedlings->viewAttributes() ?>>
<?= $Page->SourcesOfSeedlings->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TransDate->Visible) { // TransDate ?>
        <td data-name="TransDate"<?= $Page->TransDate->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TransDate" class="el_farm_open_bal_TransDate">
<input type="<?= $Page->TransDate->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TransDate" id="x<?= $Page->RowIndex ?>_TransDate" data-table="farm_open_bal" data-field="x_TransDate" value="<?= $Page->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransDate->formatPattern()) ?>"<?= $Page->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TransDate->getErrorMessage() ?></div>
<?php if (!$Page->TransDate->ReadOnly && !$Page->TransDate->Disabled && !isset($Page->TransDate->EditAttrs["readonly"]) && !isset($Page->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_TransDate" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TransDate" id="o<?= $Page->RowIndex ?>_TransDate" value="<?= HtmlEncode($Page->TransDate->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TransDate" class="el_farm_open_bal_TransDate">
<input type="<?= $Page->TransDate->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TransDate" id="x<?= $Page->RowIndex ?>_TransDate" data-table="farm_open_bal" data-field="x_TransDate" value="<?= $Page->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransDate->formatPattern()) ?>"<?= $Page->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TransDate->getErrorMessage() ?></div>
<?php if (!$Page->TransDate->ReadOnly && !$Page->TransDate->Disabled && !isset($Page->TransDate->EditAttrs["readonly"]) && !isset($Page->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_TransDate" class="el_farm_open_bal_TransDate">
<span<?= $Page->TransDate->viewAttributes() ?>>
<?= $Page->TransDate->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->PreparedBy->Visible) { // PreparedBy ?>
        <td data-name="PreparedBy"<?= $Page->PreparedBy->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_PreparedBy" class="el_farm_open_bal_PreparedBy">
<input type="<?= $Page->PreparedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PreparedBy" id="x<?= $Page->RowIndex ?>_PreparedBy" data-table="farm_open_bal" data-field="x_PreparedBy" value="<?= $Page->PreparedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PreparedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PreparedBy->formatPattern()) ?>"<?= $Page->PreparedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PreparedBy->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_PreparedBy" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_PreparedBy" id="o<?= $Page->RowIndex ?>_PreparedBy" value="<?= HtmlEncode($Page->PreparedBy->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_PreparedBy" class="el_farm_open_bal_PreparedBy">
<input type="<?= $Page->PreparedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PreparedBy" id="x<?= $Page->RowIndex ?>_PreparedBy" data-table="farm_open_bal" data-field="x_PreparedBy" value="<?= $Page->PreparedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PreparedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PreparedBy->formatPattern()) ?>"<?= $Page->PreparedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PreparedBy->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_PreparedBy" class="el_farm_open_bal_PreparedBy">
<span<?= $Page->PreparedBy->viewAttributes() ?>>
<?= $Page->PreparedBy->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->AuthorisedBy->Visible) { // AuthorisedBy ?>
        <td data-name="AuthorisedBy"<?= $Page->AuthorisedBy->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_AuthorisedBy" class="el_farm_open_bal_AuthorisedBy">
<input type="<?= $Page->AuthorisedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AuthorisedBy" id="x<?= $Page->RowIndex ?>_AuthorisedBy" data-table="farm_open_bal" data-field="x_AuthorisedBy" value="<?= $Page->AuthorisedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorisedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorisedBy->formatPattern()) ?>"<?= $Page->AuthorisedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorisedBy->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_open_bal" data-field="x_AuthorisedBy" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_AuthorisedBy" id="o<?= $Page->RowIndex ?>_AuthorisedBy" value="<?= HtmlEncode($Page->AuthorisedBy->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_AuthorisedBy" class="el_farm_open_bal_AuthorisedBy">
<input type="<?= $Page->AuthorisedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AuthorisedBy" id="x<?= $Page->RowIndex ?>_AuthorisedBy" data-table="farm_open_bal" data-field="x_AuthorisedBy" value="<?= $Page->AuthorisedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorisedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorisedBy->formatPattern()) ?>"<?= $Page->AuthorisedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorisedBy->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_open_bal_AuthorisedBy" class="el_farm_open_bal_AuthorisedBy">
<span<?= $Page->AuthorisedBy->viewAttributes() ?>>
<?= $Page->AuthorisedBy->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_open_bal");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
