<?php

namespace PHPMaker2024\cidp24;

// Page object
$DiseaseAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { disease: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fdiseaseadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fdiseaseadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["DiseasePresence", [fields.DiseasePresence.visible && fields.DiseasePresence.required ? ew.Validators.required(fields.DiseasePresence.caption) : null], fields.DiseasePresence.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fdiseaseadd" id="fdiseaseadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="disease">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->DiseasePresence->Visible) { // DiseasePresence ?>
    <div id="r_DiseasePresence"<?= $Page->DiseasePresence->rowAttributes() ?>>
        <label id="elh_disease_DiseasePresence" for="x_DiseasePresence" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DiseasePresence->caption() ?><?= $Page->DiseasePresence->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DiseasePresence->cellAttributes() ?>>
<span id="el_disease_DiseasePresence">
<input type="<?= $Page->DiseasePresence->getInputTextType() ?>" name="x_DiseasePresence" id="x_DiseasePresence" data-table="disease" data-field="x_DiseasePresence" value="<?= $Page->DiseasePresence->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->DiseasePresence->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DiseasePresence->formatPattern()) ?>"<?= $Page->DiseasePresence->editAttributes() ?> aria-describedby="x_DiseasePresence_help">
<?= $Page->DiseasePresence->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DiseasePresence->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fdiseaseadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fdiseaseadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("disease");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
