<?php

namespace PHPMaker2024\cidp24;

// Page object
$CurrentRefList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { current_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.js?v=24.7.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.js?v=24.7.6",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.7.6"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="current_ref">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_current_ref" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_current_reflist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ID->Visible) { // ID ?>
        <th data-name="ID" class="<?= $Page->ID->headerCellClass() ?>"><div id="elh_current_ref_ID" class="current_ref_ID"><?= $Page->renderFieldHeader($Page->ID) ?></div></th>
<?php } ?>
<?php if ($Page->PlanYear->Visible) { // PlanYear ?>
        <th data-name="PlanYear" class="<?= $Page->PlanYear->headerCellClass() ?>"><div id="elh_current_ref_PlanYear" class="current_ref_PlanYear"><?= $Page->renderFieldHeader($Page->PlanYear) ?></div></th>
<?php } ?>
<?php if ($Page->PlanMonth->Visible) { // PlanMonth ?>
        <th data-name="PlanMonth" class="<?= $Page->PlanMonth->headerCellClass() ?>"><div id="elh_current_ref_PlanMonth" class="current_ref_PlanMonth"><?= $Page->renderFieldHeader($Page->PlanMonth) ?></div></th>
<?php } ?>
<?php if ($Page->DaysAfterMonthEnd->Visible) { // DaysAfterMonthEnd ?>
        <th data-name="DaysAfterMonthEnd" class="<?= $Page->DaysAfterMonthEnd->headerCellClass() ?>"><div id="elh_current_ref_DaysAfterMonthEnd" class="current_ref_DaysAfterMonthEnd"><?= $Page->renderFieldHeader($Page->DaysAfterMonthEnd) ?></div></th>
<?php } ?>
<?php if ($Page->PlanClosingDate->Visible) { // PlanClosingDate ?>
        <th data-name="PlanClosingDate" class="<?= $Page->PlanClosingDate->headerCellClass() ?>"><div id="elh_current_ref_PlanClosingDate" class="current_ref_PlanClosingDate"><?= $Page->renderFieldHeader($Page->PlanClosingDate) ?></div></th>
<?php } ?>
<?php if ($Page->CurrentMonthClosingDate->Visible) { // CurrentMonthClosingDate ?>
        <th data-name="CurrentMonthClosingDate" class="<?= $Page->CurrentMonthClosingDate->headerCellClass() ?>"><div id="elh_current_ref_CurrentMonthClosingDate" class="current_ref_CurrentMonthClosingDate"><?= $Page->renderFieldHeader($Page->CurrentMonthClosingDate) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ID->Visible) { // ID ?>
        <td data-name="ID"<?= $Page->ID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_current_ref_ID" class="el_current_ref_ID">
<span<?= $Page->ID->viewAttributes() ?>>
<?= $Page->ID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanYear->Visible) { // PlanYear ?>
        <td data-name="PlanYear"<?= $Page->PlanYear->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_current_ref_PlanYear" class="el_current_ref_PlanYear">
<span<?= $Page->PlanYear->viewAttributes() ?>>
<?= $Page->PlanYear->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanMonth->Visible) { // PlanMonth ?>
        <td data-name="PlanMonth"<?= $Page->PlanMonth->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_current_ref_PlanMonth" class="el_current_ref_PlanMonth">
<span<?= $Page->PlanMonth->viewAttributes() ?>>
<?= $Page->PlanMonth->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DaysAfterMonthEnd->Visible) { // DaysAfterMonthEnd ?>
        <td data-name="DaysAfterMonthEnd"<?= $Page->DaysAfterMonthEnd->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_current_ref_DaysAfterMonthEnd" class="el_current_ref_DaysAfterMonthEnd">
<span<?= $Page->DaysAfterMonthEnd->viewAttributes() ?>>
<?= $Page->DaysAfterMonthEnd->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanClosingDate->Visible) { // PlanClosingDate ?>
        <td data-name="PlanClosingDate"<?= $Page->PlanClosingDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_current_ref_PlanClosingDate" class="el_current_ref_PlanClosingDate">
<span<?= $Page->PlanClosingDate->viewAttributes() ?>>
<?= $Page->PlanClosingDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CurrentMonthClosingDate->Visible) { // CurrentMonthClosingDate ?>
        <td data-name="CurrentMonthClosingDate"<?= $Page->CurrentMonthClosingDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_current_ref_CurrentMonthClosingDate" class="el_current_ref_CurrentMonthClosingDate">
<span<?= $Page->CurrentMonthClosingDate->viewAttributes() ?>>
<?= $Page->CurrentMonthClosingDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("current_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
