<?php

namespace PHPMaker2024\cidp24;

// Page object
$CurrencyEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fcurrencyedit" id="fcurrencyedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { currency: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fcurrencyedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcurrencyedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["currency_code", [fields.currency_code.visible && fields.currency_code.required ? ew.Validators.required(fields.currency_code.caption) : null], fields.currency_code.isInvalid],
            ["currency_name", [fields.currency_name.visible && fields.currency_name.required ? ew.Validators.required(fields.currency_name.caption) : null], fields.currency_name.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="currency">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->currency_code->Visible) { // currency_code ?>
    <div id="r_currency_code"<?= $Page->currency_code->rowAttributes() ?>>
        <label id="elh_currency_currency_code" for="x_currency_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency_code->caption() ?><?= $Page->currency_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency_code->cellAttributes() ?>>
<span id="el_currency_currency_code">
<input type="<?= $Page->currency_code->getInputTextType() ?>" name="x_currency_code" id="x_currency_code" data-table="currency" data-field="x_currency_code" value="<?= $Page->currency_code->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->currency_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_code->formatPattern()) ?>"<?= $Page->currency_code->editAttributes() ?> aria-describedby="x_currency_code_help">
<?= $Page->currency_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->currency_code->getErrorMessage() ?></div>
<input type="hidden" data-table="currency" data-field="x_currency_code" data-hidden="1" data-old name="o_currency_code" id="o_currency_code" value="<?= HtmlEncode($Page->currency_code->OldValue ?? $Page->currency_code->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency_name->Visible) { // currency_name ?>
    <div id="r_currency_name"<?= $Page->currency_name->rowAttributes() ?>>
        <label id="elh_currency_currency_name" for="x_currency_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency_name->caption() ?><?= $Page->currency_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency_name->cellAttributes() ?>>
<span id="el_currency_currency_name">
<input type="<?= $Page->currency_name->getInputTextType() ?>" name="x_currency_name" id="x_currency_name" data-table="currency" data-field="x_currency_name" value="<?= $Page->currency_name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->currency_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_name->formatPattern()) ?>"<?= $Page->currency_name->editAttributes() ?> aria-describedby="x_currency_name_help">
<?= $Page->currency_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->currency_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcurrencyedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcurrencyedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("currency");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
