<?php

namespace PHPMaker2024\cidp24;

// Page object
$CampView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
<form name="fcampview" id="fcampview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { camp: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fcampview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcampview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="camp">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <tr id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_camp_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span></td>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_camp_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <tr id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_camp_DistrictCode"><?= $Page->DistrictCode->caption() ?></span></td>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_camp_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <tr id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_camp_CampCode"><?= $Page->CampCode->caption() ?></span></td>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<span id="el_camp_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->CampName->Visible) { // CampName ?>
    <tr id="r_CampName"<?= $Page->CampName->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_camp_CampName"><?= $Page->CampName->caption() ?></span></td>
        <td data-name="CampName"<?= $Page->CampName->cellAttributes() ?>>
<span id="el_camp_CampName">
<span<?= $Page->CampName->viewAttributes() ?>>
<?= $Page->CampName->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php
    if (in_array("village", explode(",", $Page->getCurrentDetailTable())) && $village->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("village", "TblCaption") ?>&nbsp;<?= str_replace("%s", "blue", str_replace("%c", Container("village")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "VillageGrid.php" ?>
<?php } ?>
</form>
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
