<?php

namespace PHPMaker2024\cidp24;

// Page object
$AwpAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { awp: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fawpadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fawpadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["Component", [fields.Component.visible && fields.Component.required ? ew.Validators.required(fields.Component.caption) : null], fields.Component.isInvalid],
            ["Subcomponent", [fields.Subcomponent.visible && fields.Subcomponent.required ? ew.Validators.required(fields.Subcomponent.caption) : null], fields.Subcomponent.isInvalid],
            ["InvestmentCost", [fields.InvestmentCost.visible && fields.InvestmentCost.required ? ew.Validators.required(fields.InvestmentCost.caption) : null], fields.InvestmentCost.isInvalid],
            ["Type", [fields.Type.visible && fields.Type.required ? ew.Validators.required(fields.Type.caption) : null], fields.Type.isInvalid],
            ["CategoryofExpenditure", [fields.CategoryofExpenditure.visible && fields.CategoryofExpenditure.required ? ew.Validators.required(fields.CategoryofExpenditure.caption) : null], fields.CategoryofExpenditure.isInvalid],
            ["Activity", [fields.Activity.visible && fields.Activity.required ? ew.Validators.required(fields.Activity.caption) : null], fields.Activity.isInvalid],
            ["Implementer", [fields.Implementer.visible && fields.Implementer.required ? ew.Validators.required(fields.Implementer.caption) : null], fields.Implementer.isInvalid],
            ["Indicator", [fields.Indicator.visible && fields.Indicator.required ? ew.Validators.required(fields.Indicator.caption) : null], fields.Indicator.isInvalid],
            ["ProjectTarget", [fields.ProjectTarget.visible && fields.ProjectTarget.required ? ew.Validators.required(fields.ProjectTarget.caption) : null, ew.Validators.float], fields.ProjectTarget.isInvalid],
            ["_2017Target", [fields._2017Target.visible && fields._2017Target.required ? ew.Validators.required(fields._2017Target.caption) : null, ew.Validators.float], fields._2017Target.isInvalid],
            ["ProjectBudget", [fields.ProjectBudget.visible && fields.ProjectBudget.required ? ew.Validators.required(fields.ProjectBudget.caption) : null, ew.Validators.float], fields.ProjectBudget.isInvalid],
            ["StartMonth", [fields.StartMonth.visible && fields.StartMonth.required ? ew.Validators.required(fields.StartMonth.caption) : null], fields.StartMonth.isInvalid],
            ["EndMonth", [fields.EndMonth.visible && fields.EndMonth.required ? ew.Validators.required(fields.EndMonth.caption) : null], fields.EndMonth.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "StartMonth": <?= $Page->StartMonth->toClientList($Page) ?>,
            "EndMonth": <?= $Page->EndMonth->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fawpadd" id="fawpadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="awp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->Component->Visible) { // Component ?>
    <div id="r_Component"<?= $Page->Component->rowAttributes() ?>>
        <label id="elh_awp_Component" for="x_Component" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Component->caption() ?><?= $Page->Component->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Component->cellAttributes() ?>>
<span id="el_awp_Component">
<textarea data-table="awp" data-field="x_Component" name="x_Component" id="x_Component" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Component->getPlaceHolder()) ?>"<?= $Page->Component->editAttributes() ?> aria-describedby="x_Component_help"><?= $Page->Component->EditValue ?></textarea>
<?= $Page->Component->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Component->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Subcomponent->Visible) { // Sub component ?>
    <div id="r_Subcomponent"<?= $Page->Subcomponent->rowAttributes() ?>>
        <label id="elh_awp_Subcomponent" for="x_Subcomponent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Subcomponent->caption() ?><?= $Page->Subcomponent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Subcomponent->cellAttributes() ?>>
<span id="el_awp_Subcomponent">
<textarea data-table="awp" data-field="x_Subcomponent" name="x_Subcomponent" id="x_Subcomponent" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Subcomponent->getPlaceHolder()) ?>"<?= $Page->Subcomponent->editAttributes() ?> aria-describedby="x_Subcomponent_help"><?= $Page->Subcomponent->EditValue ?></textarea>
<?= $Page->Subcomponent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Subcomponent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->InvestmentCost->Visible) { // Investment Cost ?>
    <div id="r_InvestmentCost"<?= $Page->InvestmentCost->rowAttributes() ?>>
        <label id="elh_awp_InvestmentCost" for="x_InvestmentCost" class="<?= $Page->LeftColumnClass ?>"><?= $Page->InvestmentCost->caption() ?><?= $Page->InvestmentCost->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->InvestmentCost->cellAttributes() ?>>
<span id="el_awp_InvestmentCost">
<input type="<?= $Page->InvestmentCost->getInputTextType() ?>" name="x_InvestmentCost" id="x_InvestmentCost" data-table="awp" data-field="x_InvestmentCost" value="<?= $Page->InvestmentCost->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->InvestmentCost->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InvestmentCost->formatPattern()) ?>"<?= $Page->InvestmentCost->editAttributes() ?> aria-describedby="x_InvestmentCost_help">
<?= $Page->InvestmentCost->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->InvestmentCost->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Type->Visible) { // Type ?>
    <div id="r_Type"<?= $Page->Type->rowAttributes() ?>>
        <label id="elh_awp_Type" for="x_Type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Type->caption() ?><?= $Page->Type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Type->cellAttributes() ?>>
<span id="el_awp_Type">
<input type="<?= $Page->Type->getInputTextType() ?>" name="x_Type" id="x_Type" data-table="awp" data-field="x_Type" value="<?= $Page->Type->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Type->formatPattern()) ?>"<?= $Page->Type->editAttributes() ?> aria-describedby="x_Type_help">
<?= $Page->Type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CategoryofExpenditure->Visible) { // Category of Expenditure ?>
    <div id="r_CategoryofExpenditure"<?= $Page->CategoryofExpenditure->rowAttributes() ?>>
        <label id="elh_awp_CategoryofExpenditure" for="x_CategoryofExpenditure" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CategoryofExpenditure->caption() ?><?= $Page->CategoryofExpenditure->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CategoryofExpenditure->cellAttributes() ?>>
<span id="el_awp_CategoryofExpenditure">
<textarea data-table="awp" data-field="x_CategoryofExpenditure" name="x_CategoryofExpenditure" id="x_CategoryofExpenditure" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->CategoryofExpenditure->getPlaceHolder()) ?>"<?= $Page->CategoryofExpenditure->editAttributes() ?> aria-describedby="x_CategoryofExpenditure_help"><?= $Page->CategoryofExpenditure->EditValue ?></textarea>
<?= $Page->CategoryofExpenditure->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->CategoryofExpenditure->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Activity->Visible) { // Activity ?>
    <div id="r_Activity"<?= $Page->Activity->rowAttributes() ?>>
        <label id="elh_awp_Activity" for="x_Activity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Activity->caption() ?><?= $Page->Activity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Activity->cellAttributes() ?>>
<span id="el_awp_Activity">
<textarea data-table="awp" data-field="x_Activity" name="x_Activity" id="x_Activity" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>"<?= $Page->Activity->editAttributes() ?> aria-describedby="x_Activity_help"><?= $Page->Activity->EditValue ?></textarea>
<?= $Page->Activity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Implementer->Visible) { // Implementer ?>
    <div id="r_Implementer"<?= $Page->Implementer->rowAttributes() ?>>
        <label id="elh_awp_Implementer" for="x_Implementer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Implementer->caption() ?><?= $Page->Implementer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Implementer->cellAttributes() ?>>
<span id="el_awp_Implementer">
<input type="<?= $Page->Implementer->getInputTextType() ?>" name="x_Implementer" id="x_Implementer" data-table="awp" data-field="x_Implementer" value="<?= $Page->Implementer->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Implementer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Implementer->formatPattern()) ?>"<?= $Page->Implementer->editAttributes() ?> aria-describedby="x_Implementer_help">
<?= $Page->Implementer->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Implementer->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Indicator->Visible) { // Indicator ?>
    <div id="r_Indicator"<?= $Page->Indicator->rowAttributes() ?>>
        <label id="elh_awp_Indicator" for="x_Indicator" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Indicator->caption() ?><?= $Page->Indicator->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Indicator->cellAttributes() ?>>
<span id="el_awp_Indicator">
<input type="<?= $Page->Indicator->getInputTextType() ?>" name="x_Indicator" id="x_Indicator" data-table="awp" data-field="x_Indicator" value="<?= $Page->Indicator->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Indicator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Indicator->formatPattern()) ?>"<?= $Page->Indicator->editAttributes() ?> aria-describedby="x_Indicator_help">
<?= $Page->Indicator->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Indicator->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ProjectTarget->Visible) { // Project Target ?>
    <div id="r_ProjectTarget"<?= $Page->ProjectTarget->rowAttributes() ?>>
        <label id="elh_awp_ProjectTarget" for="x_ProjectTarget" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProjectTarget->caption() ?><?= $Page->ProjectTarget->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProjectTarget->cellAttributes() ?>>
<span id="el_awp_ProjectTarget">
<input type="<?= $Page->ProjectTarget->getInputTextType() ?>" name="x_ProjectTarget" id="x_ProjectTarget" data-table="awp" data-field="x_ProjectTarget" value="<?= $Page->ProjectTarget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectTarget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectTarget->formatPattern()) ?>"<?= $Page->ProjectTarget->editAttributes() ?> aria-describedby="x_ProjectTarget_help">
<?= $Page->ProjectTarget->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProjectTarget->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_2017Target->Visible) { // 2017 Target ?>
    <div id="r__2017Target"<?= $Page->_2017Target->rowAttributes() ?>>
        <label id="elh_awp__2017Target" for="x__2017Target" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_2017Target->caption() ?><?= $Page->_2017Target->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_2017Target->cellAttributes() ?>>
<span id="el_awp__2017Target">
<input type="<?= $Page->_2017Target->getInputTextType() ?>" name="x__2017Target" id="x__2017Target" data-table="awp" data-field="x__2017Target" value="<?= $Page->_2017Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2017Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2017Target->formatPattern()) ?>"<?= $Page->_2017Target->editAttributes() ?> aria-describedby="x__2017Target_help">
<?= $Page->_2017Target->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_2017Target->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ProjectBudget->Visible) { // Project Budget ?>
    <div id="r_ProjectBudget"<?= $Page->ProjectBudget->rowAttributes() ?>>
        <label id="elh_awp_ProjectBudget" for="x_ProjectBudget" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProjectBudget->caption() ?><?= $Page->ProjectBudget->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProjectBudget->cellAttributes() ?>>
<span id="el_awp_ProjectBudget">
<input type="<?= $Page->ProjectBudget->getInputTextType() ?>" name="x_ProjectBudget" id="x_ProjectBudget" data-table="awp" data-field="x_ProjectBudget" value="<?= $Page->ProjectBudget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectBudget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectBudget->formatPattern()) ?>"<?= $Page->ProjectBudget->editAttributes() ?> aria-describedby="x_ProjectBudget_help">
<?= $Page->ProjectBudget->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProjectBudget->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->StartMonth->Visible) { // StartMonth ?>
    <div id="r_StartMonth"<?= $Page->StartMonth->rowAttributes() ?>>
        <label id="elh_awp_StartMonth" for="x_StartMonth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->StartMonth->caption() ?><?= $Page->StartMonth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->StartMonth->cellAttributes() ?>>
<span id="el_awp_StartMonth">
    <select
        id="x_StartMonth"
        name="x_StartMonth"
        class="form-select ew-select<?= $Page->StartMonth->isInvalidClass() ?>"
        <?php if (!$Page->StartMonth->IsNativeSelect) { ?>
        data-select2-id="fawpadd_x_StartMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_StartMonth"
        data-value-separator="<?= $Page->StartMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->StartMonth->getPlaceHolder()) ?>"
        <?= $Page->StartMonth->editAttributes() ?>>
        <?= $Page->StartMonth->selectOptionListHtml("x_StartMonth") ?>
    </select>
    <?= $Page->StartMonth->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->StartMonth->getErrorMessage() ?></div>
<?= $Page->StartMonth->Lookup->getParamTag($Page, "p_x_StartMonth") ?>
<?php if (!$Page->StartMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("fawpadd", function() {
    var options = { name: "x_StartMonth", selectId: "fawpadd_x_StartMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fawpadd.lists.StartMonth?.lookupOptions.length) {
        options.data = { id: "x_StartMonth", form: "fawpadd" };
    } else {
        options.ajax = { id: "x_StartMonth", form: "fawpadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.StartMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->EndMonth->Visible) { // EndMonth ?>
    <div id="r_EndMonth"<?= $Page->EndMonth->rowAttributes() ?>>
        <label id="elh_awp_EndMonth" for="x_EndMonth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->EndMonth->caption() ?><?= $Page->EndMonth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->EndMonth->cellAttributes() ?>>
<span id="el_awp_EndMonth">
    <select
        id="x_EndMonth"
        name="x_EndMonth"
        class="form-select ew-select<?= $Page->EndMonth->isInvalidClass() ?>"
        <?php if (!$Page->EndMonth->IsNativeSelect) { ?>
        data-select2-id="fawpadd_x_EndMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_EndMonth"
        data-value-separator="<?= $Page->EndMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->EndMonth->getPlaceHolder()) ?>"
        <?= $Page->EndMonth->editAttributes() ?>>
        <?= $Page->EndMonth->selectOptionListHtml("x_EndMonth") ?>
    </select>
    <?= $Page->EndMonth->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->EndMonth->getErrorMessage() ?></div>
<?= $Page->EndMonth->Lookup->getParamTag($Page, "p_x_EndMonth") ?>
<?php if (!$Page->EndMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("fawpadd", function() {
    var options = { name: "x_EndMonth", selectId: "fawpadd_x_EndMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fawpadd.lists.EndMonth?.lookupOptions.length) {
        options.data = { id: "x_EndMonth", form: "fawpadd" };
    } else {
        options.ajax = { id: "x_EndMonth", form: "fawpadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.EndMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fawpadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fawpadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("awp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
