<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "training_course" table
 */
#[Entity]
#[Table(name: "training_course")]
class TrainingCourse extends AbstractEntity
{
    public static array $propertyNames = [
        'TrainingRef' => 'trainingRef',
        'TrainingType' => 'trainingType',
        'StartDate' => 'startDate',
        'EndDate' => 'endDate',
        'Institution' => 'institution',
        'Subject' => 'subject',
        'Facilitators' => 'facilitators',
        'TrainingContent' => 'trainingContent',
    ];

    #[Id]
    #[Column(name: "TrainingRef", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $trainingRef;

    #[Column(name: "TrainingType", type: "boolean", nullable: true)]
    private ?bool $trainingType;

    #[Column(name: "StartDate", type: "date", nullable: true)]
    private ?DateTime $startDate;

    #[Column(name: "EndDate", type: "date", nullable: true)]
    private ?DateTime $endDate;

    #[Column(name: "Institution", type: "string", nullable: true)]
    private ?string $institution;

    #[Column(name: "Subject", type: "string", nullable: true)]
    private ?string $subject;

    #[Column(name: "Facilitators", type: "string", nullable: true)]
    private ?string $facilitators;

    #[Column(name: "TrainingContent", type: "string", nullable: true)]
    private ?string $trainingContent;

    public function getTrainingRef(): int
    {
        return $this->trainingRef;
    }

    public function setTrainingRef(int $value): static
    {
        $this->trainingRef = $value;
        return $this;
    }

    public function getTrainingType(): ?bool
    {
        return $this->trainingType;
    }

    public function setTrainingType(?bool $value): static
    {
        $this->trainingType = $value;
        return $this;
    }

    public function getStartDate(): ?DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(?DateTime $value): static
    {
        $this->startDate = $value;
        return $this;
    }

    public function getEndDate(): ?DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(?DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }

    public function getInstitution(): ?string
    {
        return HtmlDecode($this->institution);
    }

    public function setInstitution(?string $value): static
    {
        $this->institution = RemoveXss($value);
        return $this;
    }

    public function getSubject(): ?string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(?string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getFacilitators(): ?string
    {
        return HtmlDecode($this->facilitators);
    }

    public function setFacilitators(?string $value): static
    {
        $this->facilitators = RemoveXss($value);
        return $this;
    }

    public function getTrainingContent(): ?string
    {
        return HtmlDecode($this->trainingContent);
    }

    public function setTrainingContent(?string $value): static
    {
        $this->trainingContent = RemoveXss($value);
        return $this;
    }
}
