<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "security_matrix" table
 */
#[Entity]
#[Table(name: "security_matrix")]
class SecurityMatrix extends AbstractEntity
{
    public static array $propertyNames = [
        'UserCode' => 'userCode',
        'PeriodCode' => 'periodCode',
        'Security_number' => 'securityNumber',
        'ValidFrom' => 'validFrom',
        'ValidTo' => 'validTo',
        'ApproveLevel' => 'approveLevel',
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'CampCode' => 'campCode',
        'VillageCode' => 'villageCode',
    ];

    #[Column(name: "UserCode", type: "integer")]
    private int $userCode;

    #[Column(name: "PeriodCode", type: "integer", nullable: true)]
    private ?int $periodCode;

    #[Id]
    #[Column(name: "Security_number", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $securityNumber;

    #[Column(name: "ValidFrom", type: "datetime")]
    private DateTime $validFrom;

    #[Column(name: "ValidTo", type: "datetime", nullable: true)]
    private ?DateTime $validTo;

    #[Column(name: "ApproveLevel", type: "smallint", nullable: true)]
    private ?int $approveLevel;

    #[Column(name: "ProvinceCode", type: "boolean")]
    private bool $provinceCode;

    #[Column(name: "DistrictCode", type: "boolean", nullable: true)]
    private ?bool $districtCode;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    public function getUserCode(): int
    {
        return $this->userCode;
    }

    public function setUserCode(int $value): static
    {
        $this->userCode = $value;
        return $this;
    }

    public function getPeriodCode(): ?int
    {
        return $this->periodCode;
    }

    public function setPeriodCode(?int $value): static
    {
        $this->periodCode = $value;
        return $this;
    }

    public function getSecurityNumber(): int
    {
        return $this->securityNumber;
    }

    public function setSecurityNumber(int $value): static
    {
        $this->securityNumber = $value;
        return $this;
    }

    public function getValidFrom(): DateTime
    {
        return $this->validFrom;
    }

    public function setValidFrom(DateTime $value): static
    {
        $this->validFrom = $value;
        return $this;
    }

    public function getValidTo(): ?DateTime
    {
        return $this->validTo;
    }

    public function setValidTo(?DateTime $value): static
    {
        $this->validTo = $value;
        return $this;
    }

    public function getApproveLevel(): ?int
    {
        return $this->approveLevel;
    }

    public function setApproveLevel(?int $value): static
    {
        $this->approveLevel = $value;
        return $this;
    }

    public function getProvinceCode(): bool
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(bool $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): ?bool
    {
        return $this->districtCode;
    }

    public function setDistrictCode(?bool $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }
}
