<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "nursery_ownership" table
 */
#[Entity]
#[Table(name: "nursery_ownership")]
class NurseryOwnership extends AbstractEntity
{
    public static array $propertyNames = [
        'NurseryOwnershipCode' => 'nurseryOwnershipCode',
        'NurseryOwnership' => 'nurseryOwnership',
    ];

    #[Id]
    #[Column(name: "NurseryOwnershipCode", type: "boolean", unique: true)]
    #[GeneratedValue]
    private bool $nurseryOwnershipCode;

    #[Column(name: "NurseryOwnership", type: "string", nullable: true)]
    private ?string $nurseryOwnership;

    public function getNurseryOwnershipCode(): bool
    {
        return $this->nurseryOwnershipCode;
    }

    public function setNurseryOwnershipCode(bool $value): static
    {
        $this->nurseryOwnershipCode = $value;
        return $this;
    }

    public function getNurseryOwnership(): ?string
    {
        return HtmlDecode($this->nurseryOwnership);
    }

    public function setNurseryOwnership(?string $value): static
    {
        $this->nurseryOwnership = RemoveXss($value);
        return $this;
    }
}
