<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "facilitator" table
 */
#[Entity]
#[Table(name: "facilitator")]
class Facilitator extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'CampCode' => 'campCode',
        'VillageCode' => 'villageCode',
        'FacilitatorNo' => 'facilitatorNo',
        'NRC' => 'nrc',
        'FacilitatorName' => 'facilitatorName',
        'DOB' => 'dob',
        'Gender' => 'gender',
        'MaritalStatus' => 'maritalStatus',
        'PhoneNo' => 'phoneNo',
        'Email' => 'email',
        'Qualifications' => 'qualifications',
    ];

    #[Column(name: "ProvinceCode", type: "integer", nullable: true)]
    private ?int $provinceCode = 0;

    #[Column(name: "DistrictCode", type: "integer", nullable: true)]
    private ?int $districtCode = 0;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Id]
    #[Column(name: "FacilitatorNo", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $facilitatorNo;

    #[Column(name: "NRC", type: "string", unique: true, nullable: true)]
    private ?string $nrc;

    #[Column(name: "FacilitatorName", type: "string", nullable: true)]
    private ?string $facilitatorName;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(name: "Gender", type: "string")]
    private string $gender;

    #[Column(name: "MaritalStatus", type: "boolean", nullable: true)]
    private ?bool $maritalStatus;

    #[Column(name: "PhoneNo", type: "string", nullable: true)]
    private ?string $phoneNo;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "Qualifications", type: "string", nullable: true)]
    private ?string $qualifications;

    public function getProvinceCode(): ?int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(?int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): ?int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(?int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getFacilitatorNo(): int
    {
        return $this->facilitatorNo;
    }

    public function setFacilitatorNo(int $value): static
    {
        $this->facilitatorNo = $value;
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFacilitatorName(): ?string
    {
        return HtmlDecode($this->facilitatorName);
    }

    public function setFacilitatorName(?string $value): static
    {
        $this->facilitatorName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getGender(): string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?bool
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?bool $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return HtmlDecode($this->phoneNo);
    }

    public function setPhoneNo(?string $value): static
    {
        $this->phoneNo = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getQualifications(): ?string
    {
        return HtmlDecode($this->qualifications);
    }

    public function setQualifications(?string $value): static
    {
        $this->qualifications = RemoveXss($value);
        return $this;
    }
}
