<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "district" table
 */
#[Entity]
#[Table(name: "district")]
class District extends AbstractEntity
{
    public static array $propertyNames = [
        'DistrictCode' => 'districtCode',
        'ProvinceCode' => 'provinceCode',
        'DistrictName' => 'districtName',
    ];

    #[Id]
    #[Column(name: "DistrictCode", type: "boolean", unique: true)]
    private bool $districtCode;

    #[Column(name: "ProvinceCode", type: "boolean", nullable: true)]
    private ?bool $provinceCode;

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    public function getDistrictCode(): bool
    {
        return $this->districtCode;
    }

    public function setDistrictCode(bool $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getProvinceCode(): ?bool
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(?bool $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }
}
