<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "disease" table
 */
#[Entity]
#[Table(name: "disease")]
class Disease extends AbstractEntity
{
    public static array $propertyNames = [
        'DiseasePresence' => 'diseasePresence',
    ];

    #[Column(name: "DiseasePresence", type: "string")]
    private string $diseasePresence;

    public function getDiseasePresence(): string
    {
        return HtmlDecode($this->diseasePresence);
    }

    public function setDiseasePresence(string $value): static
    {
        $this->diseasePresence = RemoveXss($value);
        return $this;
    }
}
