<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "currency" table
 */
#[Entity]
#[Table(name: "currency")]
class Currency extends AbstractEntity
{
    public static array $propertyNames = [
        'currency_code' => 'currencyCode',
        'currency_name' => 'currencyName',
    ];

    #[Id]
    #[Column(name: "currency_code", type: "string", unique: true)]
    private string $currencyCode;

    #[Column(name: "currency_name", type: "string", nullable: true)]
    private ?string $currencyName;

    public function getCurrencyCode(): string
    {
        return $this->currencyCode;
    }

    public function setCurrencyCode(string $value): static
    {
        $this->currencyCode = $value;
        return $this;
    }

    public function getCurrencyName(): ?string
    {
        return HtmlDecode($this->currencyName);
    }

    public function setCurrencyName(?string $value): static
    {
        $this->currencyName = RemoveXss($value);
        return $this;
    }
}
