<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "cidp_data" table
 */
#[Entity]
#[Table(name: "cidp_data")]
class CidpDatum extends AbstractEntity
{
    public static array $propertyNames = [
        'DistrictCode' => 'districtCode',
        'DistrictName' => 'districtName',
        'GRNCode' => 'grnCode',
        'GRN' => 'grn',
        'SupplierCode' => 'supplierCode',
        'Supplier' => 'supplier',
        'CampCode' => 'campCode',
        'Camp' => 'camp',
        'VillageCode' => 'villageCode',
        'Village' => 'village',
        'NRC' => 'nrc',
        'FarmerName' => 'farmerName',
        'DOB' => 'dob',
        'Age' => 'age',
        'Group' => 'group',
        'Gender' => 'gender',
        'Seedlings' => 'seedlings',
        'Seeds' => 'seeds',
        'Type' => 'type',
        'DateAllocated' => 'dateAllocated',
        'ID' => 'id',
    ];

    #[Column(name: "DistrictCode", type: "boolean", nullable: true)]
    private ?bool $districtCode;

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "GRNCode", type: "string", nullable: true)]
    private ?string $grnCode;

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(name: "SupplierCode", type: "integer", nullable: true)]
    private ?int $supplierCode;

    #[Column(name: "Supplier", type: "string", nullable: true)]
    private ?string $supplier;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "Camp", type: "string", nullable: true)]
    private ?string $camp;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Column(name: "Village", type: "string", nullable: true)]
    private ?string $village;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "FarmerName", type: "string", nullable: true)]
    private ?string $farmerName;

    #[Column(name: "DOB", type: "string", nullable: true)]
    private ?string $dob;

    #[Column(name: "Age", type: "float", nullable: true)]
    private ?float $age;

    #[Column(name: "`Group`", type: "string", nullable: true)]
    private ?string $group;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "Seedlings", type: "float", nullable: true)]
    private ?float $seedlings;

    #[Column(name: "Seeds", type: "float", nullable: true)]
    private ?float $seeds;

    #[Column(name: "Type", type: "string", nullable: true)]
    private ?string $type;

    #[Column(name: "DateAllocated", type: "string", nullable: true)]
    private ?string $dateAllocated;

    #[Id]
    #[Column(name: "ID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    public function getDistrictCode(): ?bool
    {
        return $this->districtCode;
    }

    public function setDistrictCode(?bool $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getGrnCode(): ?string
    {
        return HtmlDecode($this->grnCode);
    }

    public function setGrnCode(?string $value): static
    {
        $this->grnCode = RemoveXss($value);
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getSupplierCode(): ?int
    {
        return $this->supplierCode;
    }

    public function setSupplierCode(?int $value): static
    {
        $this->supplierCode = $value;
        return $this;
    }

    public function getSupplier(): ?string
    {
        return HtmlDecode($this->supplier);
    }

    public function setSupplier(?string $value): static
    {
        $this->supplier = RemoveXss($value);
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getCamp(): ?string
    {
        return HtmlDecode($this->camp);
    }

    public function setCamp(?string $value): static
    {
        $this->camp = RemoveXss($value);
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getVillage(): ?string
    {
        return HtmlDecode($this->village);
    }

    public function setVillage(?string $value): static
    {
        $this->village = RemoveXss($value);
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): ?string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(?string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?string
    {
        return HtmlDecode($this->dob);
    }

    public function setDob(?string $value): static
    {
        $this->dob = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?float
    {
        return $this->age;
    }

    public function setAge(?float $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getGroup(): ?string
    {
        return HtmlDecode($this->group);
    }

    public function setGroup(?string $value): static
    {
        $this->group = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getSeedlings(): ?float
    {
        return $this->seedlings;
    }

    public function setSeedlings(?float $value): static
    {
        $this->seedlings = $value;
        return $this;
    }

    public function getSeeds(): ?float
    {
        return $this->seeds;
    }

    public function setSeeds(?float $value): static
    {
        $this->seeds = $value;
        return $this;
    }

    public function getType(): ?string
    {
        return HtmlDecode($this->type);
    }

    public function setType(?string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getDateAllocated(): ?string
    {
        return HtmlDecode($this->dateAllocated);
    }

    public function setDateAllocated(?string $value): static
    {
        $this->dateAllocated = RemoveXss($value);
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }
}
