<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "camp" table
 */
#[Entity]
#[Table(name: "camp")]
class Camp extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'CampCode' => 'campCode',
        'CampName' => 'campName',
    ];

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode = 0;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode = 0;

    #[Id]
    #[Column(name: "CampCode", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $campCode;

    #[Column(name: "CampName", type: "string", nullable: true)]
    private ?string $campName;

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): int
    {
        return $this->campCode;
    }

    public function setCampCode(int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getCampName(): ?string
    {
        return HtmlDecode($this->campName);
    }

    public function setCampName(?string $value): static
    {
        $this->campName = RemoveXss($value);
        return $this;
    }
}
