<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for seed_allocate_view
 */
class SeedAllocateView extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $DistrictName;
    public $CampName;
    public $Village;
    public $FieldType;
    public $Ownership;
    public $FarmSize;
    public $FarmSizeEstimated;
    public $TreesPlantedEstimated;
    public $FarmSizeVerified;
    public $TreesPlantedVerified;
    public $FarmNo;
    public $TransNo;
    public $GRN;
    public $TreesAllocated;
    public $FarmingSeason;
    public $SeedType;
    public $SourcesOfSeedlings;
    public $TransDate;
    public $PreparedBy;
    public $AuthorisedBy;
    public $NRC;
    public $FarmerName;
    public $DOB;
    public $Age;
    public $Gender;
    public $MaritalStatus;
    public $PhoneNo;
    public $_Email;
    public $Dependants;
    public $MaleChildren;
    public $FemaleChildren;
    public $HouseholdHead;
    public $FarmerOrg;
    public $FarmerOrgPosition;
    public $JoiningDate;
    public $NurseryName;
    public $NurseryType;
    public $NurseryOwnership;
    public $NumberOfMembers;
    public $Longitude;
    public $Latitude;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "seed_allocate_view";
        $this->TableName = 'seed_allocate_view';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "seed_allocate_view";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // DistrictName
        $this->DistrictName = new DbField(
            $this, // Table
            'x_DistrictName', // Variable name
            'DistrictName', // Name
            '`DistrictName`', // Expression
            '`DistrictName`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictName->InputTextType = "text";
        $this->DistrictName->Nullable = false; // NOT NULL field
        $this->DistrictName->Required = true; // Required field
        $this->DistrictName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['DistrictName'] = &$this->DistrictName;

        // CampName
        $this->CampName = new DbField(
            $this, // Table
            'x_CampName', // Variable name
            'CampName', // Name
            '`CampName`', // Expression
            '`CampName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CampName->InputTextType = "text";
        $this->CampName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampName'] = &$this->CampName;

        // Village
        $this->Village = new DbField(
            $this, // Table
            'x_Village', // Variable name
            'Village', // Name
            '`Village`', // Expression
            '`Village`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Village`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Village->InputTextType = "text";
        $this->Village->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Village'] = &$this->Village;

        // FieldType
        $this->FieldType = new DbField(
            $this, // Table
            'x_FieldType', // Variable name
            'FieldType', // Name
            '`FieldType`', // Expression
            '`FieldType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FieldType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FieldType->InputTextType = "text";
        $this->FieldType->Raw = true;
        $this->FieldType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FieldType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FieldType'] = &$this->FieldType;

        // Ownership
        $this->Ownership = new DbField(
            $this, // Table
            'x_Ownership', // Variable name
            'Ownership', // Name
            '`Ownership`', // Expression
            '`Ownership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Ownership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Ownership->InputTextType = "text";
        $this->Ownership->Raw = true;
        $this->Ownership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Ownership->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Ownership'] = &$this->Ownership;

        // FarmSize
        $this->FarmSize = new DbField(
            $this, // Table
            'x_FarmSize', // Variable name
            'FarmSize', // Name
            '`FarmSize`', // Expression
            '`FarmSize`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSize`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSize->InputTextType = "text";
        $this->FarmSize->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSize'] = &$this->FarmSize;

        // FarmSizeEstimated
        $this->FarmSizeEstimated = new DbField(
            $this, // Table
            'x_FarmSizeEstimated', // Variable name
            'FarmSizeEstimated', // Name
            '`FarmSizeEstimated`', // Expression
            '`FarmSizeEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeEstimated->InputTextType = "text";
        $this->FarmSizeEstimated->Raw = true;
        $this->FarmSizeEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSizeEstimated'] = &$this->FarmSizeEstimated;

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated = new DbField(
            $this, // Table
            'x_TreesPlantedEstimated', // Variable name
            'TreesPlantedEstimated', // Name
            '`TreesPlantedEstimated`', // Expression
            '`TreesPlantedEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedEstimated->InputTextType = "text";
        $this->TreesPlantedEstimated->Raw = true;
        $this->TreesPlantedEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesPlantedEstimated'] = &$this->TreesPlantedEstimated;

        // FarmSizeVerified
        $this->FarmSizeVerified = new DbField(
            $this, // Table
            'x_FarmSizeVerified', // Variable name
            'FarmSizeVerified', // Name
            '`FarmSizeVerified`', // Expression
            '`FarmSizeVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeVerified->InputTextType = "text";
        $this->FarmSizeVerified->Raw = true;
        $this->FarmSizeVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSizeVerified'] = &$this->FarmSizeVerified;

        // TreesPlantedVerified
        $this->TreesPlantedVerified = new DbField(
            $this, // Table
            'x_TreesPlantedVerified', // Variable name
            'TreesPlantedVerified', // Name
            '`TreesPlantedVerified`', // Expression
            '`TreesPlantedVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedVerified->InputTextType = "text";
        $this->TreesPlantedVerified->Raw = true;
        $this->TreesPlantedVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesPlantedVerified'] = &$this->TreesPlantedVerified;

        // FarmNo
        $this->FarmNo = new DbField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->IsAutoIncrement = true; // Autoincrement field
        $this->FarmNo->IsPrimaryKey = true; // Primary key field
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // TransNo
        $this->TransNo = new DbField(
            $this, // Table
            'x_TransNo', // Variable name
            'TransNo', // Name
            '`TransNo`', // Expression
            '`TransNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TransNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->TransNo->InputTextType = "text";
        $this->TransNo->Raw = true;
        $this->TransNo->IsAutoIncrement = true; // Autoincrement field
        $this->TransNo->IsPrimaryKey = true; // Primary key field
        $this->TransNo->Nullable = false; // NOT NULL field
        $this->TransNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->TransNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['TransNo'] = &$this->TransNo;

        // GRN
        $this->GRN = new DbField(
            $this, // Table
            'x_GRN', // Variable name
            'GRN', // Name
            '`GRN`', // Expression
            '`GRN`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`GRN`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->GRN->InputTextType = "text";
        $this->GRN->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['GRN'] = &$this->GRN;

        // TreesAllocated
        $this->TreesAllocated = new DbField(
            $this, // Table
            'x_TreesAllocated', // Variable name
            'TreesAllocated', // Name
            '`TreesAllocated`', // Expression
            '`TreesAllocated`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesAllocated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesAllocated->InputTextType = "text";
        $this->TreesAllocated->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesAllocated'] = &$this->TreesAllocated;

        // FarmingSeason
        $this->FarmingSeason = new DbField(
            $this, // Table
            'x_FarmingSeason', // Variable name
            'FarmingSeason', // Name
            '`FarmingSeason`', // Expression
            '`FarmingSeason`', // Basic search expression
            18, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmingSeason`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmingSeason->InputTextType = "text";
        $this->FarmingSeason->Raw = true;
        $this->FarmingSeason->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmingSeason->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmingSeason'] = &$this->FarmingSeason;

        // SeedType
        $this->SeedType = new DbField(
            $this, // Table
            'x_SeedType', // Variable name
            'SeedType', // Name
            '`SeedType`', // Expression
            '`SeedType`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedType->InputTextType = "text";
        $this->SeedType->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedType'] = &$this->SeedType;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings = new DbField(
            $this, // Table
            'x_SourcesOfSeedlings', // Variable name
            'SourcesOfSeedlings', // Name
            '`SourcesOfSeedlings`', // Expression
            '`SourcesOfSeedlings`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SourcesOfSeedlings`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SourcesOfSeedlings->InputTextType = "text";
        $this->SourcesOfSeedlings->Raw = true;
        $this->SourcesOfSeedlings->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SourcesOfSeedlings->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SourcesOfSeedlings'] = &$this->SourcesOfSeedlings;

        // TransDate
        $this->TransDate = new DbField(
            $this, // Table
            'x_TransDate', // Variable name
            'TransDate', // Name
            '`TransDate`', // Expression
            CastDateFieldForLike("`TransDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`TransDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TransDate->InputTextType = "text";
        $this->TransDate->Raw = true;
        $this->TransDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->TransDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TransDate'] = &$this->TransDate;

        // PreparedBy
        $this->PreparedBy = new DbField(
            $this, // Table
            'x_PreparedBy', // Variable name
            'PreparedBy', // Name
            '`PreparedBy`', // Expression
            '`PreparedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PreparedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PreparedBy->InputTextType = "text";
        $this->PreparedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PreparedBy'] = &$this->PreparedBy;

        // AuthorisedBy
        $this->AuthorisedBy = new DbField(
            $this, // Table
            'x_AuthorisedBy', // Variable name
            'AuthorisedBy', // Name
            '`AuthorisedBy`', // Expression
            '`AuthorisedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AuthorisedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AuthorisedBy->InputTextType = "text";
        $this->AuthorisedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['AuthorisedBy'] = &$this->AuthorisedBy;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->Nullable = false; // NOT NULL field
        $this->NRC->Required = true; // Required field
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerName
        $this->FarmerName = new DbField(
            $this, // Table
            'x_FarmerName', // Variable name
            'FarmerName', // Name
            '`FarmerName`', // Expression
            '`FarmerName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerName->InputTextType = "text";
        $this->FarmerName->Nullable = false; // NOT NULL field
        $this->FarmerName->Required = true; // Required field
        $this->FarmerName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['FarmerName'] = &$this->FarmerName;

        // DOB
        $this->DOB = new DbField(
            $this, // Table
            'x_DOB', // Variable name
            'DOB', // Name
            '`DOB`', // Expression
            CastDateFieldForLike("`DOB`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`DOB`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DOB->InputTextType = "text";
        $this->DOB->Raw = true;
        $this->DOB->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->DOB->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['DOB'] = &$this->DOB;

        // Age
        $this->Age = new DbField(
            $this, // Table
            'x_Age', // Variable name
            'Age', // Name
            '`Age`', // Expression
            '`Age`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Age->InputTextType = "text";
        $this->Age->Raw = true;
        $this->Age->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Age'] = &$this->Age;

        // Gender
        $this->Gender = new DbField(
            $this, // Table
            'x_Gender', // Variable name
            'Gender', // Name
            '`Gender`', // Expression
            '`Gender`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Gender->InputTextType = "text";
        $this->Gender->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Gender'] = &$this->Gender;

        // MaritalStatus
        $this->MaritalStatus = new DbField(
            $this, // Table
            'x_MaritalStatus', // Variable name
            'MaritalStatus', // Name
            '`MaritalStatus`', // Expression
            '`MaritalStatus`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaritalStatus`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaritalStatus->InputTextType = "text";
        $this->MaritalStatus->Raw = true;
        $this->MaritalStatus->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaritalStatus->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['MaritalStatus'] = &$this->MaritalStatus;

        // PhoneNo
        $this->PhoneNo = new DbField(
            $this, // Table
            'x_PhoneNo', // Variable name
            'PhoneNo', // Name
            '`PhoneNo`', // Expression
            '`PhoneNo`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PhoneNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PhoneNo->InputTextType = "text";
        $this->PhoneNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PhoneNo'] = &$this->PhoneNo;

        // Email
        $this->_Email = new DbField(
            $this, // Table
            'x__Email', // Variable name
            'Email', // Name
            '`Email`', // Expression
            '`Email`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Email->InputTextType = "text";
        $this->_Email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Email'] = &$this->_Email;

        // Dependants
        $this->Dependants = new DbField(
            $this, // Table
            'x_Dependants', // Variable name
            'Dependants', // Name
            '`Dependants`', // Expression
            '`Dependants`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Dependants`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Dependants->InputTextType = "text";
        $this->Dependants->Raw = true;
        $this->Dependants->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Dependants->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Dependants'] = &$this->Dependants;

        // MaleChildren
        $this->MaleChildren = new DbField(
            $this, // Table
            'x_MaleChildren', // Variable name
            'MaleChildren', // Name
            '`MaleChildren`', // Expression
            '`MaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaleChildren->InputTextType = "text";
        $this->MaleChildren->Raw = true;
        $this->MaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['MaleChildren'] = &$this->MaleChildren;

        // FemaleChildren
        $this->FemaleChildren = new DbField(
            $this, // Table
            'x_FemaleChildren', // Variable name
            'FemaleChildren', // Name
            '`FemaleChildren`', // Expression
            '`FemaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FemaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FemaleChildren->InputTextType = "text";
        $this->FemaleChildren->Raw = true;
        $this->FemaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FemaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FemaleChildren'] = &$this->FemaleChildren;

        // HouseholdHead
        $this->HouseholdHead = new DbField(
            $this, // Table
            'x_HouseholdHead', // Variable name
            'HouseholdHead', // Name
            '`HouseholdHead`', // Expression
            '`HouseholdHead`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HouseholdHead`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->HouseholdHead->InputTextType = "text";
        $this->HouseholdHead->Raw = true;
        $this->HouseholdHead->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->HouseholdHead->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['HouseholdHead'] = &$this->HouseholdHead;

        // FarmerOrg
        $this->FarmerOrg = new DbField(
            $this, // Table
            'x_FarmerOrg', // Variable name
            'FarmerOrg', // Name
            '`FarmerOrg`', // Expression
            '`FarmerOrg`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrg->InputTextType = "text";
        $this->FarmerOrg->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerOrg'] = &$this->FarmerOrg;

        // FarmerOrgPosition
        $this->FarmerOrgPosition = new DbField(
            $this, // Table
            'x_FarmerOrgPosition', // Variable name
            'FarmerOrgPosition', // Name
            '`FarmerOrgPosition`', // Expression
            '`FarmerOrgPosition`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrgPosition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrgPosition->InputTextType = "text";
        $this->FarmerOrgPosition->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerOrgPosition'] = &$this->FarmerOrgPosition;

        // JoiningDate
        $this->JoiningDate = new DbField(
            $this, // Table
            'x_JoiningDate', // Variable name
            'JoiningDate', // Name
            '`JoiningDate`', // Expression
            CastDateFieldForLike("`JoiningDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`JoiningDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->JoiningDate->InputTextType = "text";
        $this->JoiningDate->Raw = true;
        $this->JoiningDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->JoiningDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['JoiningDate'] = &$this->JoiningDate;

        // NurseryName
        $this->NurseryName = new DbField(
            $this, // Table
            'x_NurseryName', // Variable name
            'NurseryName', // Name
            '`NurseryName`', // Expression
            '`NurseryName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryName->InputTextType = "text";
        $this->NurseryName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryName'] = &$this->NurseryName;

        // NurseryType
        $this->NurseryType = new DbField(
            $this, // Table
            'x_NurseryType', // Variable name
            'NurseryType', // Name
            '`NurseryType`', // Expression
            '`NurseryType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryType->InputTextType = "text";
        $this->NurseryType->Raw = true;
        $this->NurseryType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NurseryType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryType'] = &$this->NurseryType;

        // NurseryOwnership
        $this->NurseryOwnership = new DbField(
            $this, // Table
            'x_NurseryOwnership', // Variable name
            'NurseryOwnership', // Name
            '`NurseryOwnership`', // Expression
            '`NurseryOwnership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryOwnership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryOwnership->InputTextType = "text";
        $this->NurseryOwnership->Raw = true;
        $this->NurseryOwnership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NurseryOwnership->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryOwnership'] = &$this->NurseryOwnership;

        // NumberOfMembers
        $this->NumberOfMembers = new DbField(
            $this, // Table
            'x_NumberOfMembers', // Variable name
            'NumberOfMembers', // Name
            '`NumberOfMembers`', // Expression
            '`NumberOfMembers`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NumberOfMembers`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NumberOfMembers->InputTextType = "text";
        $this->NumberOfMembers->Raw = true;
        $this->NumberOfMembers->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NumberOfMembers->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['NumberOfMembers'] = &$this->NumberOfMembers;

        // Longitude
        $this->Longitude = new DbField(
            $this, // Table
            'x_Longitude', // Variable name
            'Longitude', // Name
            '`Longitude`', // Expression
            '`Longitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Longitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Longitude->InputTextType = "text";
        $this->Longitude->Raw = true;
        $this->Longitude->Nullable = false; // NOT NULL field
        $this->Longitude->Required = true; // Required field
        $this->Longitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Longitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Longitude'] = &$this->Longitude;

        // Latitude
        $this->Latitude = new DbField(
            $this, // Table
            'x_Latitude', // Variable name
            'Latitude', // Name
            '`Latitude`', // Expression
            '`Latitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Latitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Latitude->InputTextType = "text";
        $this->Latitude->Raw = true;
        $this->Latitude->Nullable = false; // NOT NULL field
        $this->Latitude->Required = true; // Required field
        $this->Latitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Latitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Latitude'] = &$this->Latitude;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "seed_allocate_view";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->FarmNo->setDbValue($conn->lastInsertId());
            $rs['FarmNo'] = $this->FarmNo->DbValue;
            $this->TransNo->setDbValue($conn->lastInsertId());
            $rs['TransNo'] = $this->TransNo->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['FarmNo']) && !EmptyValue($this->FarmNo->CurrentValue)) {
                $rs['FarmNo'] = $this->FarmNo->CurrentValue;
            }
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['TransNo']) && !EmptyValue($this->TransNo->CurrentValue)) {
                $rs['TransNo'] = $this->TransNo->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('FarmNo', $rs)) {
                AddFilter($where, QuotedName('FarmNo', $this->Dbid) . '=' . QuotedValue($rs['FarmNo'], $this->FarmNo->DataType, $this->Dbid));
            }
            if (array_key_exists('TransNo', $rs)) {
                AddFilter($where, QuotedName('TransNo', $this->Dbid) . '=' . QuotedValue($rs['TransNo'], $this->TransNo->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->DistrictName->DbValue = $row['DistrictName'];
        $this->CampName->DbValue = $row['CampName'];
        $this->Village->DbValue = $row['Village'];
        $this->FieldType->DbValue = $row['FieldType'];
        $this->Ownership->DbValue = $row['Ownership'];
        $this->FarmSize->DbValue = $row['FarmSize'];
        $this->FarmSizeEstimated->DbValue = $row['FarmSizeEstimated'];
        $this->TreesPlantedEstimated->DbValue = $row['TreesPlantedEstimated'];
        $this->FarmSizeVerified->DbValue = $row['FarmSizeVerified'];
        $this->TreesPlantedVerified->DbValue = $row['TreesPlantedVerified'];
        $this->FarmNo->DbValue = $row['FarmNo'];
        $this->TransNo->DbValue = $row['TransNo'];
        $this->GRN->DbValue = $row['GRN'];
        $this->TreesAllocated->DbValue = $row['TreesAllocated'];
        $this->FarmingSeason->DbValue = $row['FarmingSeason'];
        $this->SeedType->DbValue = $row['SeedType'];
        $this->SourcesOfSeedlings->DbValue = $row['SourcesOfSeedlings'];
        $this->TransDate->DbValue = $row['TransDate'];
        $this->PreparedBy->DbValue = $row['PreparedBy'];
        $this->AuthorisedBy->DbValue = $row['AuthorisedBy'];
        $this->NRC->DbValue = $row['NRC'];
        $this->FarmerName->DbValue = $row['FarmerName'];
        $this->DOB->DbValue = $row['DOB'];
        $this->Age->DbValue = $row['Age'];
        $this->Gender->DbValue = $row['Gender'];
        $this->MaritalStatus->DbValue = $row['MaritalStatus'];
        $this->PhoneNo->DbValue = $row['PhoneNo'];
        $this->_Email->DbValue = $row['Email'];
        $this->Dependants->DbValue = $row['Dependants'];
        $this->MaleChildren->DbValue = $row['MaleChildren'];
        $this->FemaleChildren->DbValue = $row['FemaleChildren'];
        $this->HouseholdHead->DbValue = $row['HouseholdHead'];
        $this->FarmerOrg->DbValue = $row['FarmerOrg'];
        $this->FarmerOrgPosition->DbValue = $row['FarmerOrgPosition'];
        $this->JoiningDate->DbValue = $row['JoiningDate'];
        $this->NurseryName->DbValue = $row['NurseryName'];
        $this->NurseryType->DbValue = $row['NurseryType'];
        $this->NurseryOwnership->DbValue = $row['NurseryOwnership'];
        $this->NumberOfMembers->DbValue = $row['NumberOfMembers'];
        $this->Longitude->DbValue = $row['Longitude'];
        $this->Latitude->DbValue = $row['Latitude'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`FarmNo` = @FarmNo@ AND `TransNo` = @TransNo@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->FarmNo->CurrentValue : $this->FarmNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $val = $current ? $this->TransNo->CurrentValue : $this->TransNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 2) {
            if ($current) {
                $this->FarmNo->CurrentValue = $keys[0];
            } else {
                $this->FarmNo->OldValue = $keys[0];
            }
            if ($current) {
                $this->TransNo->CurrentValue = $keys[1];
            } else {
                $this->TransNo->OldValue = $keys[1];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('FarmNo', $row) ? $row['FarmNo'] : null;
        } else {
            $val = !EmptyValue($this->FarmNo->OldValue) && !$current ? $this->FarmNo->OldValue : $this->FarmNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@FarmNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        if (is_array($row)) {
            $val = array_key_exists('TransNo', $row) ? $row['TransNo'] : null;
        } else {
            $val = !EmptyValue($this->TransNo->OldValue) && !$current ? $this->TransNo->OldValue : $this->TransNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@TransNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("SeedAllocateViewList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "SeedAllocateViewView" => $Language->phrase("View"),
            "SeedAllocateViewEdit" => $Language->phrase("Edit"),
            "SeedAllocateViewAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "SeedAllocateViewList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "SeedAllocateViewView",
            Config("API_ADD_ACTION") => "SeedAllocateViewAdd",
            Config("API_EDIT_ACTION") => "SeedAllocateViewEdit",
            Config("API_DELETE_ACTION") => "SeedAllocateViewDelete",
            Config("API_LIST_ACTION") => "SeedAllocateViewList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "SeedAllocateViewList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("SeedAllocateViewView", $parm);
        } else {
            $url = $this->keyUrl("SeedAllocateViewView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "SeedAllocateViewAdd?" . $parm;
        } else {
            $url = "SeedAllocateViewAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("SeedAllocateViewEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("SeedAllocateViewList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("SeedAllocateViewAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("SeedAllocateViewList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("SeedAllocateViewDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"FarmNo\":" . VarToJson($this->FarmNo->CurrentValue, "number");
        $json .= ",\"TransNo\":" . VarToJson($this->TransNo->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->FarmNo->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->FarmNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($this->TransNo->CurrentValue !== null) {
            $url .= $this->RouteCompositeKeySeparator . $this->encodeKeyValue($this->TransNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
            for ($i = 0; $i < $cnt; $i++) {
                $arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
            }
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 1))) // Other API
                : []; // Non-API
            if (($keyValue = Param("FarmNo") ?? Route("FarmNo")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (($keyValue = Param("TransNo") ?? Route("TransNo")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(1) ?? $keyValues[1] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            $arKeys[] = $arKey;
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_array($key) || count($key) != 2) {
                    continue; // Just skip so other keys will still work
                }
                if (!is_numeric($key[0])) { // FarmNo
                    continue;
                }
                if (!is_numeric($key[1])) { // TransNo
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->FarmNo->CurrentValue = $key[0];
            } else {
                $this->FarmNo->OldValue = $key[0];
            }
            if ($setCurrent) {
                $this->TransNo->CurrentValue = $key[1];
            } else {
                $this->TransNo->OldValue = $key[1];
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->DistrictName->setDbValue($row['DistrictName']);
        $this->CampName->setDbValue($row['CampName']);
        $this->Village->setDbValue($row['Village']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->TransNo->setDbValue($row['TransNo']);
        $this->GRN->setDbValue($row['GRN']);
        $this->TreesAllocated->setDbValue($row['TreesAllocated']);
        $this->FarmingSeason->setDbValue($row['FarmingSeason']);
        $this->SeedType->setDbValue($row['SeedType']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->TransDate->setDbValue($row['TransDate']);
        $this->PreparedBy->setDbValue($row['PreparedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->DOB->setDbValue($row['DOB']);
        $this->Age->setDbValue($row['Age']);
        $this->Gender->setDbValue($row['Gender']);
        $this->MaritalStatus->setDbValue($row['MaritalStatus']);
        $this->PhoneNo->setDbValue($row['PhoneNo']);
        $this->_Email->setDbValue($row['Email']);
        $this->Dependants->setDbValue($row['Dependants']);
        $this->MaleChildren->setDbValue($row['MaleChildren']);
        $this->FemaleChildren->setDbValue($row['FemaleChildren']);
        $this->HouseholdHead->setDbValue($row['HouseholdHead']);
        $this->FarmerOrg->setDbValue($row['FarmerOrg']);
        $this->FarmerOrgPosition->setDbValue($row['FarmerOrgPosition']);
        $this->JoiningDate->setDbValue($row['JoiningDate']);
        $this->NurseryName->setDbValue($row['NurseryName']);
        $this->NurseryType->setDbValue($row['NurseryType']);
        $this->NurseryOwnership->setDbValue($row['NurseryOwnership']);
        $this->NumberOfMembers->setDbValue($row['NumberOfMembers']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->Latitude->setDbValue($row['Latitude']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "SeedAllocateViewList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // DistrictName

        // CampName

        // Village

        // FieldType

        // Ownership

        // FarmSize

        // FarmSizeEstimated

        // TreesPlantedEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // FarmNo

        // TransNo

        // GRN

        // TreesAllocated

        // FarmingSeason

        // SeedType

        // SourcesOfSeedlings

        // TransDate

        // PreparedBy

        // AuthorisedBy

        // NRC

        // FarmerName

        // DOB

        // Age

        // Gender

        // MaritalStatus

        // PhoneNo

        // Email

        // Dependants

        // MaleChildren

        // FemaleChildren

        // HouseholdHead

        // FarmerOrg

        // FarmerOrgPosition

        // JoiningDate

        // NurseryName

        // NurseryType

        // NurseryOwnership

        // NumberOfMembers

        // Longitude

        // Latitude

        // DistrictName
        $this->DistrictName->ViewValue = $this->DistrictName->CurrentValue;

        // CampName
        $this->CampName->ViewValue = $this->CampName->CurrentValue;

        // Village
        $this->Village->ViewValue = $this->Village->CurrentValue;

        // FieldType
        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;

        // Ownership
        $this->Ownership->ViewValue = $this->Ownership->CurrentValue;

        // FarmSize
        $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

        // FarmSizeEstimated
        $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
        $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
        $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

        // FarmSizeVerified
        $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
        $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

        // TreesPlantedVerified
        $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
        $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

        // FarmNo
        $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

        // TransNo
        $this->TransNo->ViewValue = $this->TransNo->CurrentValue;

        // GRN
        $this->GRN->ViewValue = $this->GRN->CurrentValue;

        // TreesAllocated
        $this->TreesAllocated->ViewValue = $this->TreesAllocated->CurrentValue;

        // FarmingSeason
        $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;

        // SeedType
        $this->SeedType->ViewValue = $this->SeedType->CurrentValue;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;

        // TransDate
        $this->TransDate->ViewValue = $this->TransDate->CurrentValue;
        $this->TransDate->ViewValue = FormatDateTime($this->TransDate->ViewValue, $this->TransDate->formatPattern());

        // PreparedBy
        $this->PreparedBy->ViewValue = $this->PreparedBy->CurrentValue;

        // AuthorisedBy
        $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

        // NRC
        $this->NRC->ViewValue = $this->NRC->CurrentValue;

        // FarmerName
        $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

        // DOB
        $this->DOB->ViewValue = $this->DOB->CurrentValue;
        $this->DOB->ViewValue = FormatDateTime($this->DOB->ViewValue, $this->DOB->formatPattern());

        // Age
        $this->Age->ViewValue = $this->Age->CurrentValue;
        $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());

        // Gender
        $this->Gender->ViewValue = $this->Gender->CurrentValue;

        // MaritalStatus
        $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;

        // PhoneNo
        $this->PhoneNo->ViewValue = $this->PhoneNo->CurrentValue;

        // Email
        $this->_Email->ViewValue = $this->_Email->CurrentValue;

        // Dependants
        $this->Dependants->ViewValue = $this->Dependants->CurrentValue;

        // MaleChildren
        $this->MaleChildren->ViewValue = $this->MaleChildren->CurrentValue;

        // FemaleChildren
        $this->FemaleChildren->ViewValue = $this->FemaleChildren->CurrentValue;

        // HouseholdHead
        $this->HouseholdHead->ViewValue = $this->HouseholdHead->CurrentValue;

        // FarmerOrg
        $this->FarmerOrg->ViewValue = $this->FarmerOrg->CurrentValue;

        // FarmerOrgPosition
        $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->CurrentValue;

        // JoiningDate
        $this->JoiningDate->ViewValue = $this->JoiningDate->CurrentValue;
        $this->JoiningDate->ViewValue = FormatDateTime($this->JoiningDate->ViewValue, $this->JoiningDate->formatPattern());

        // NurseryName
        $this->NurseryName->ViewValue = $this->NurseryName->CurrentValue;

        // NurseryType
        $this->NurseryType->ViewValue = $this->NurseryType->CurrentValue;

        // NurseryOwnership
        $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->CurrentValue;

        // NumberOfMembers
        $this->NumberOfMembers->ViewValue = $this->NumberOfMembers->CurrentValue;

        // Longitude
        $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
        $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

        // Latitude
        $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
        $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

        // DistrictName
        $this->DistrictName->HrefValue = "";
        $this->DistrictName->TooltipValue = "";

        // CampName
        $this->CampName->HrefValue = "";
        $this->CampName->TooltipValue = "";

        // Village
        $this->Village->HrefValue = "";
        $this->Village->TooltipValue = "";

        // FieldType
        $this->FieldType->HrefValue = "";
        $this->FieldType->TooltipValue = "";

        // Ownership
        $this->Ownership->HrefValue = "";
        $this->Ownership->TooltipValue = "";

        // FarmSize
        $this->FarmSize->HrefValue = "";
        $this->FarmSize->TooltipValue = "";

        // FarmSizeEstimated
        $this->FarmSizeEstimated->HrefValue = "";
        $this->FarmSizeEstimated->TooltipValue = "";

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->HrefValue = "";
        $this->TreesPlantedEstimated->TooltipValue = "";

        // FarmSizeVerified
        $this->FarmSizeVerified->HrefValue = "";
        $this->FarmSizeVerified->TooltipValue = "";

        // TreesPlantedVerified
        $this->TreesPlantedVerified->HrefValue = "";
        $this->TreesPlantedVerified->TooltipValue = "";

        // FarmNo
        $this->FarmNo->HrefValue = "";
        $this->FarmNo->TooltipValue = "";

        // TransNo
        $this->TransNo->HrefValue = "";
        $this->TransNo->TooltipValue = "";

        // GRN
        $this->GRN->HrefValue = "";
        $this->GRN->TooltipValue = "";

        // TreesAllocated
        $this->TreesAllocated->HrefValue = "";
        $this->TreesAllocated->TooltipValue = "";

        // FarmingSeason
        $this->FarmingSeason->HrefValue = "";
        $this->FarmingSeason->TooltipValue = "";

        // SeedType
        $this->SeedType->HrefValue = "";
        $this->SeedType->TooltipValue = "";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->HrefValue = "";
        $this->SourcesOfSeedlings->TooltipValue = "";

        // TransDate
        $this->TransDate->HrefValue = "";
        $this->TransDate->TooltipValue = "";

        // PreparedBy
        $this->PreparedBy->HrefValue = "";
        $this->PreparedBy->TooltipValue = "";

        // AuthorisedBy
        $this->AuthorisedBy->HrefValue = "";
        $this->AuthorisedBy->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // FarmerName
        $this->FarmerName->HrefValue = "";
        $this->FarmerName->TooltipValue = "";

        // DOB
        $this->DOB->HrefValue = "";
        $this->DOB->TooltipValue = "";

        // Age
        $this->Age->HrefValue = "";
        $this->Age->TooltipValue = "";

        // Gender
        $this->Gender->HrefValue = "";
        $this->Gender->TooltipValue = "";

        // MaritalStatus
        $this->MaritalStatus->HrefValue = "";
        $this->MaritalStatus->TooltipValue = "";

        // PhoneNo
        $this->PhoneNo->HrefValue = "";
        $this->PhoneNo->TooltipValue = "";

        // Email
        $this->_Email->HrefValue = "";
        $this->_Email->TooltipValue = "";

        // Dependants
        $this->Dependants->HrefValue = "";
        $this->Dependants->TooltipValue = "";

        // MaleChildren
        $this->MaleChildren->HrefValue = "";
        $this->MaleChildren->TooltipValue = "";

        // FemaleChildren
        $this->FemaleChildren->HrefValue = "";
        $this->FemaleChildren->TooltipValue = "";

        // HouseholdHead
        $this->HouseholdHead->HrefValue = "";
        $this->HouseholdHead->TooltipValue = "";

        // FarmerOrg
        $this->FarmerOrg->HrefValue = "";
        $this->FarmerOrg->TooltipValue = "";

        // FarmerOrgPosition
        $this->FarmerOrgPosition->HrefValue = "";
        $this->FarmerOrgPosition->TooltipValue = "";

        // JoiningDate
        $this->JoiningDate->HrefValue = "";
        $this->JoiningDate->TooltipValue = "";

        // NurseryName
        $this->NurseryName->HrefValue = "";
        $this->NurseryName->TooltipValue = "";

        // NurseryType
        $this->NurseryType->HrefValue = "";
        $this->NurseryType->TooltipValue = "";

        // NurseryOwnership
        $this->NurseryOwnership->HrefValue = "";
        $this->NurseryOwnership->TooltipValue = "";

        // NumberOfMembers
        $this->NumberOfMembers->HrefValue = "";
        $this->NumberOfMembers->TooltipValue = "";

        // Longitude
        $this->Longitude->HrefValue = "";
        $this->Longitude->TooltipValue = "";

        // Latitude
        $this->Latitude->HrefValue = "";
        $this->Latitude->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // DistrictName
        $this->DistrictName->setupEditAttributes();
        if (!$this->DistrictName->Raw) {
            $this->DistrictName->CurrentValue = HtmlDecode($this->DistrictName->CurrentValue);
        }
        $this->DistrictName->EditValue = $this->DistrictName->CurrentValue;
        $this->DistrictName->PlaceHolder = RemoveHtml($this->DistrictName->caption());

        // CampName
        $this->CampName->setupEditAttributes();
        if (!$this->CampName->Raw) {
            $this->CampName->CurrentValue = HtmlDecode($this->CampName->CurrentValue);
        }
        $this->CampName->EditValue = $this->CampName->CurrentValue;
        $this->CampName->PlaceHolder = RemoveHtml($this->CampName->caption());

        // Village
        $this->Village->setupEditAttributes();
        if (!$this->Village->Raw) {
            $this->Village->CurrentValue = HtmlDecode($this->Village->CurrentValue);
        }
        $this->Village->EditValue = $this->Village->CurrentValue;
        $this->Village->PlaceHolder = RemoveHtml($this->Village->caption());

        // FieldType
        $this->FieldType->setupEditAttributes();
        $this->FieldType->EditValue = $this->FieldType->CurrentValue;
        $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());
        if (strval($this->FieldType->EditValue) != "" && is_numeric($this->FieldType->EditValue)) {
            $this->FieldType->EditValue = $this->FieldType->EditValue;
        }

        // Ownership
        $this->Ownership->setupEditAttributes();
        $this->Ownership->EditValue = $this->Ownership->CurrentValue;
        $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());
        if (strval($this->Ownership->EditValue) != "" && is_numeric($this->Ownership->EditValue)) {
            $this->Ownership->EditValue = $this->Ownership->EditValue;
        }

        // FarmSize
        $this->FarmSize->setupEditAttributes();
        if (!$this->FarmSize->Raw) {
            $this->FarmSize->CurrentValue = HtmlDecode($this->FarmSize->CurrentValue);
        }
        $this->FarmSize->EditValue = $this->FarmSize->CurrentValue;
        $this->FarmSize->PlaceHolder = RemoveHtml($this->FarmSize->caption());

        // FarmSizeEstimated
        $this->FarmSizeEstimated->setupEditAttributes();
        $this->FarmSizeEstimated->EditValue = $this->FarmSizeEstimated->CurrentValue;
        $this->FarmSizeEstimated->PlaceHolder = RemoveHtml($this->FarmSizeEstimated->caption());
        if (strval($this->FarmSizeEstimated->EditValue) != "" && is_numeric($this->FarmSizeEstimated->EditValue)) {
            $this->FarmSizeEstimated->EditValue = FormatNumber($this->FarmSizeEstimated->EditValue, null);
        }

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->setupEditAttributes();
        $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->CurrentValue;
        $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());
        if (strval($this->TreesPlantedEstimated->EditValue) != "" && is_numeric($this->TreesPlantedEstimated->EditValue)) {
            $this->TreesPlantedEstimated->EditValue = FormatNumber($this->TreesPlantedEstimated->EditValue, null);
        }

        // FarmSizeVerified
        $this->FarmSizeVerified->setupEditAttributes();
        $this->FarmSizeVerified->EditValue = $this->FarmSizeVerified->CurrentValue;
        $this->FarmSizeVerified->PlaceHolder = RemoveHtml($this->FarmSizeVerified->caption());
        if (strval($this->FarmSizeVerified->EditValue) != "" && is_numeric($this->FarmSizeVerified->EditValue)) {
            $this->FarmSizeVerified->EditValue = FormatNumber($this->FarmSizeVerified->EditValue, null);
        }

        // TreesPlantedVerified
        $this->TreesPlantedVerified->setupEditAttributes();
        $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->CurrentValue;
        $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());
        if (strval($this->TreesPlantedVerified->EditValue) != "" && is_numeric($this->TreesPlantedVerified->EditValue)) {
            $this->TreesPlantedVerified->EditValue = FormatNumber($this->TreesPlantedVerified->EditValue, null);
        }

        // FarmNo
        $this->FarmNo->setupEditAttributes();
        $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;

        // TransNo
        $this->TransNo->setupEditAttributes();
        $this->TransNo->EditValue = $this->TransNo->CurrentValue;

        // GRN
        $this->GRN->setupEditAttributes();
        if (!$this->GRN->Raw) {
            $this->GRN->CurrentValue = HtmlDecode($this->GRN->CurrentValue);
        }
        $this->GRN->EditValue = $this->GRN->CurrentValue;
        $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

        // TreesAllocated
        $this->TreesAllocated->setupEditAttributes();
        if (!$this->TreesAllocated->Raw) {
            $this->TreesAllocated->CurrentValue = HtmlDecode($this->TreesAllocated->CurrentValue);
        }
        $this->TreesAllocated->EditValue = $this->TreesAllocated->CurrentValue;
        $this->TreesAllocated->PlaceHolder = RemoveHtml($this->TreesAllocated->caption());

        // FarmingSeason
        $this->FarmingSeason->setupEditAttributes();
        $this->FarmingSeason->EditValue = $this->FarmingSeason->CurrentValue;
        $this->FarmingSeason->PlaceHolder = RemoveHtml($this->FarmingSeason->caption());
        if (strval($this->FarmingSeason->EditValue) != "" && is_numeric($this->FarmingSeason->EditValue)) {
            $this->FarmingSeason->EditValue = $this->FarmingSeason->EditValue;
        }

        // SeedType
        $this->SeedType->setupEditAttributes();
        if (!$this->SeedType->Raw) {
            $this->SeedType->CurrentValue = HtmlDecode($this->SeedType->CurrentValue);
        }
        $this->SeedType->EditValue = $this->SeedType->CurrentValue;
        $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->setupEditAttributes();
        $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->CurrentValue;
        $this->SourcesOfSeedlings->PlaceHolder = RemoveHtml($this->SourcesOfSeedlings->caption());
        if (strval($this->SourcesOfSeedlings->EditValue) != "" && is_numeric($this->SourcesOfSeedlings->EditValue)) {
            $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->EditValue;
        }

        // TransDate
        $this->TransDate->setupEditAttributes();
        $this->TransDate->EditValue = FormatDateTime($this->TransDate->CurrentValue, $this->TransDate->formatPattern());
        $this->TransDate->PlaceHolder = RemoveHtml($this->TransDate->caption());

        // PreparedBy
        $this->PreparedBy->setupEditAttributes();
        if (!$this->PreparedBy->Raw) {
            $this->PreparedBy->CurrentValue = HtmlDecode($this->PreparedBy->CurrentValue);
        }
        $this->PreparedBy->EditValue = $this->PreparedBy->CurrentValue;
        $this->PreparedBy->PlaceHolder = RemoveHtml($this->PreparedBy->caption());

        // AuthorisedBy
        $this->AuthorisedBy->setupEditAttributes();
        if (!$this->AuthorisedBy->Raw) {
            $this->AuthorisedBy->CurrentValue = HtmlDecode($this->AuthorisedBy->CurrentValue);
        }
        $this->AuthorisedBy->EditValue = $this->AuthorisedBy->CurrentValue;
        $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());

        // NRC
        $this->NRC->setupEditAttributes();
        if (!$this->NRC->Raw) {
            $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
        }
        $this->NRC->EditValue = $this->NRC->CurrentValue;
        $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

        // FarmerName
        $this->FarmerName->setupEditAttributes();
        if (!$this->FarmerName->Raw) {
            $this->FarmerName->CurrentValue = HtmlDecode($this->FarmerName->CurrentValue);
        }
        $this->FarmerName->EditValue = $this->FarmerName->CurrentValue;
        $this->FarmerName->PlaceHolder = RemoveHtml($this->FarmerName->caption());

        // DOB
        $this->DOB->setupEditAttributes();
        $this->DOB->EditValue = FormatDateTime($this->DOB->CurrentValue, $this->DOB->formatPattern());
        $this->DOB->PlaceHolder = RemoveHtml($this->DOB->caption());

        // Age
        $this->Age->setupEditAttributes();
        $this->Age->EditValue = $this->Age->CurrentValue;
        $this->Age->PlaceHolder = RemoveHtml($this->Age->caption());
        if (strval($this->Age->EditValue) != "" && is_numeric($this->Age->EditValue)) {
            $this->Age->EditValue = FormatNumber($this->Age->EditValue, null);
        }

        // Gender
        $this->Gender->setupEditAttributes();
        if (!$this->Gender->Raw) {
            $this->Gender->CurrentValue = HtmlDecode($this->Gender->CurrentValue);
        }
        $this->Gender->EditValue = $this->Gender->CurrentValue;
        $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

        // MaritalStatus
        $this->MaritalStatus->setupEditAttributes();
        $this->MaritalStatus->EditValue = $this->MaritalStatus->CurrentValue;
        $this->MaritalStatus->PlaceHolder = RemoveHtml($this->MaritalStatus->caption());
        if (strval($this->MaritalStatus->EditValue) != "" && is_numeric($this->MaritalStatus->EditValue)) {
            $this->MaritalStatus->EditValue = $this->MaritalStatus->EditValue;
        }

        // PhoneNo
        $this->PhoneNo->setupEditAttributes();
        if (!$this->PhoneNo->Raw) {
            $this->PhoneNo->CurrentValue = HtmlDecode($this->PhoneNo->CurrentValue);
        }
        $this->PhoneNo->EditValue = $this->PhoneNo->CurrentValue;
        $this->PhoneNo->PlaceHolder = RemoveHtml($this->PhoneNo->caption());

        // Email
        $this->_Email->setupEditAttributes();
        if (!$this->_Email->Raw) {
            $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
        }
        $this->_Email->EditValue = $this->_Email->CurrentValue;
        $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

        // Dependants
        $this->Dependants->setupEditAttributes();
        $this->Dependants->EditValue = $this->Dependants->CurrentValue;
        $this->Dependants->PlaceHolder = RemoveHtml($this->Dependants->caption());
        if (strval($this->Dependants->EditValue) != "" && is_numeric($this->Dependants->EditValue)) {
            $this->Dependants->EditValue = $this->Dependants->EditValue;
        }

        // MaleChildren
        $this->MaleChildren->setupEditAttributes();
        $this->MaleChildren->EditValue = $this->MaleChildren->CurrentValue;
        $this->MaleChildren->PlaceHolder = RemoveHtml($this->MaleChildren->caption());
        if (strval($this->MaleChildren->EditValue) != "" && is_numeric($this->MaleChildren->EditValue)) {
            $this->MaleChildren->EditValue = $this->MaleChildren->EditValue;
        }

        // FemaleChildren
        $this->FemaleChildren->setupEditAttributes();
        $this->FemaleChildren->EditValue = $this->FemaleChildren->CurrentValue;
        $this->FemaleChildren->PlaceHolder = RemoveHtml($this->FemaleChildren->caption());
        if (strval($this->FemaleChildren->EditValue) != "" && is_numeric($this->FemaleChildren->EditValue)) {
            $this->FemaleChildren->EditValue = $this->FemaleChildren->EditValue;
        }

        // HouseholdHead
        $this->HouseholdHead->setupEditAttributes();
        $this->HouseholdHead->EditValue = $this->HouseholdHead->CurrentValue;
        $this->HouseholdHead->PlaceHolder = RemoveHtml($this->HouseholdHead->caption());
        if (strval($this->HouseholdHead->EditValue) != "" && is_numeric($this->HouseholdHead->EditValue)) {
            $this->HouseholdHead->EditValue = $this->HouseholdHead->EditValue;
        }

        // FarmerOrg
        $this->FarmerOrg->setupEditAttributes();
        if (!$this->FarmerOrg->Raw) {
            $this->FarmerOrg->CurrentValue = HtmlDecode($this->FarmerOrg->CurrentValue);
        }
        $this->FarmerOrg->EditValue = $this->FarmerOrg->CurrentValue;
        $this->FarmerOrg->PlaceHolder = RemoveHtml($this->FarmerOrg->caption());

        // FarmerOrgPosition
        $this->FarmerOrgPosition->setupEditAttributes();
        if (!$this->FarmerOrgPosition->Raw) {
            $this->FarmerOrgPosition->CurrentValue = HtmlDecode($this->FarmerOrgPosition->CurrentValue);
        }
        $this->FarmerOrgPosition->EditValue = $this->FarmerOrgPosition->CurrentValue;
        $this->FarmerOrgPosition->PlaceHolder = RemoveHtml($this->FarmerOrgPosition->caption());

        // JoiningDate
        $this->JoiningDate->setupEditAttributes();
        $this->JoiningDate->EditValue = FormatDateTime($this->JoiningDate->CurrentValue, $this->JoiningDate->formatPattern());
        $this->JoiningDate->PlaceHolder = RemoveHtml($this->JoiningDate->caption());

        // NurseryName
        $this->NurseryName->setupEditAttributes();
        if (!$this->NurseryName->Raw) {
            $this->NurseryName->CurrentValue = HtmlDecode($this->NurseryName->CurrentValue);
        }
        $this->NurseryName->EditValue = $this->NurseryName->CurrentValue;
        $this->NurseryName->PlaceHolder = RemoveHtml($this->NurseryName->caption());

        // NurseryType
        $this->NurseryType->setupEditAttributes();
        $this->NurseryType->EditValue = $this->NurseryType->CurrentValue;
        $this->NurseryType->PlaceHolder = RemoveHtml($this->NurseryType->caption());
        if (strval($this->NurseryType->EditValue) != "" && is_numeric($this->NurseryType->EditValue)) {
            $this->NurseryType->EditValue = $this->NurseryType->EditValue;
        }

        // NurseryOwnership
        $this->NurseryOwnership->setupEditAttributes();
        $this->NurseryOwnership->EditValue = $this->NurseryOwnership->CurrentValue;
        $this->NurseryOwnership->PlaceHolder = RemoveHtml($this->NurseryOwnership->caption());
        if (strval($this->NurseryOwnership->EditValue) != "" && is_numeric($this->NurseryOwnership->EditValue)) {
            $this->NurseryOwnership->EditValue = $this->NurseryOwnership->EditValue;
        }

        // NumberOfMembers
        $this->NumberOfMembers->setupEditAttributes();
        $this->NumberOfMembers->EditValue = $this->NumberOfMembers->CurrentValue;
        $this->NumberOfMembers->PlaceHolder = RemoveHtml($this->NumberOfMembers->caption());
        if (strval($this->NumberOfMembers->EditValue) != "" && is_numeric($this->NumberOfMembers->EditValue)) {
            $this->NumberOfMembers->EditValue = $this->NumberOfMembers->EditValue;
        }

        // Longitude
        $this->Longitude->setupEditAttributes();
        $this->Longitude->EditValue = $this->Longitude->CurrentValue;
        $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
        if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
            $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
        }

        // Latitude
        $this->Latitude->setupEditAttributes();
        $this->Latitude->EditValue = $this->Latitude->CurrentValue;
        $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
        if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
            $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->DistrictName);
                    $doc->exportCaption($this->CampName);
                    $doc->exportCaption($this->Village);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->Ownership);
                    $doc->exportCaption($this->FarmSize);
                    $doc->exportCaption($this->FarmSizeEstimated);
                    $doc->exportCaption($this->TreesPlantedEstimated);
                    $doc->exportCaption($this->FarmSizeVerified);
                    $doc->exportCaption($this->TreesPlantedVerified);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->TransNo);
                    $doc->exportCaption($this->GRN);
                    $doc->exportCaption($this->TreesAllocated);
                    $doc->exportCaption($this->FarmingSeason);
                    $doc->exportCaption($this->SeedType);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->TransDate);
                    $doc->exportCaption($this->PreparedBy);
                    $doc->exportCaption($this->AuthorisedBy);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerName);
                    $doc->exportCaption($this->DOB);
                    $doc->exportCaption($this->Age);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->MaritalStatus);
                    $doc->exportCaption($this->PhoneNo);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Dependants);
                    $doc->exportCaption($this->MaleChildren);
                    $doc->exportCaption($this->FemaleChildren);
                    $doc->exportCaption($this->HouseholdHead);
                    $doc->exportCaption($this->FarmerOrg);
                    $doc->exportCaption($this->FarmerOrgPosition);
                    $doc->exportCaption($this->JoiningDate);
                    $doc->exportCaption($this->NurseryName);
                    $doc->exportCaption($this->NurseryType);
                    $doc->exportCaption($this->NurseryOwnership);
                    $doc->exportCaption($this->NumberOfMembers);
                    $doc->exportCaption($this->Longitude);
                    $doc->exportCaption($this->Latitude);
                } else {
                    $doc->exportCaption($this->DistrictName);
                    $doc->exportCaption($this->CampName);
                    $doc->exportCaption($this->Village);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->Ownership);
                    $doc->exportCaption($this->FarmSize);
                    $doc->exportCaption($this->FarmSizeEstimated);
                    $doc->exportCaption($this->TreesPlantedEstimated);
                    $doc->exportCaption($this->FarmSizeVerified);
                    $doc->exportCaption($this->TreesPlantedVerified);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->TransNo);
                    $doc->exportCaption($this->GRN);
                    $doc->exportCaption($this->TreesAllocated);
                    $doc->exportCaption($this->FarmingSeason);
                    $doc->exportCaption($this->SeedType);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->TransDate);
                    $doc->exportCaption($this->PreparedBy);
                    $doc->exportCaption($this->AuthorisedBy);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerName);
                    $doc->exportCaption($this->DOB);
                    $doc->exportCaption($this->Age);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->MaritalStatus);
                    $doc->exportCaption($this->PhoneNo);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Dependants);
                    $doc->exportCaption($this->MaleChildren);
                    $doc->exportCaption($this->FemaleChildren);
                    $doc->exportCaption($this->HouseholdHead);
                    $doc->exportCaption($this->FarmerOrg);
                    $doc->exportCaption($this->FarmerOrgPosition);
                    $doc->exportCaption($this->JoiningDate);
                    $doc->exportCaption($this->NurseryName);
                    $doc->exportCaption($this->NurseryType);
                    $doc->exportCaption($this->NurseryOwnership);
                    $doc->exportCaption($this->NumberOfMembers);
                    $doc->exportCaption($this->Longitude);
                    $doc->exportCaption($this->Latitude);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->DistrictName);
                        $doc->exportField($this->CampName);
                        $doc->exportField($this->Village);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->Ownership);
                        $doc->exportField($this->FarmSize);
                        $doc->exportField($this->FarmSizeEstimated);
                        $doc->exportField($this->TreesPlantedEstimated);
                        $doc->exportField($this->FarmSizeVerified);
                        $doc->exportField($this->TreesPlantedVerified);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->TransNo);
                        $doc->exportField($this->GRN);
                        $doc->exportField($this->TreesAllocated);
                        $doc->exportField($this->FarmingSeason);
                        $doc->exportField($this->SeedType);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->TransDate);
                        $doc->exportField($this->PreparedBy);
                        $doc->exportField($this->AuthorisedBy);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerName);
                        $doc->exportField($this->DOB);
                        $doc->exportField($this->Age);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->MaritalStatus);
                        $doc->exportField($this->PhoneNo);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Dependants);
                        $doc->exportField($this->MaleChildren);
                        $doc->exportField($this->FemaleChildren);
                        $doc->exportField($this->HouseholdHead);
                        $doc->exportField($this->FarmerOrg);
                        $doc->exportField($this->FarmerOrgPosition);
                        $doc->exportField($this->JoiningDate);
                        $doc->exportField($this->NurseryName);
                        $doc->exportField($this->NurseryType);
                        $doc->exportField($this->NurseryOwnership);
                        $doc->exportField($this->NumberOfMembers);
                        $doc->exportField($this->Longitude);
                        $doc->exportField($this->Latitude);
                    } else {
                        $doc->exportField($this->DistrictName);
                        $doc->exportField($this->CampName);
                        $doc->exportField($this->Village);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->Ownership);
                        $doc->exportField($this->FarmSize);
                        $doc->exportField($this->FarmSizeEstimated);
                        $doc->exportField($this->TreesPlantedEstimated);
                        $doc->exportField($this->FarmSizeVerified);
                        $doc->exportField($this->TreesPlantedVerified);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->TransNo);
                        $doc->exportField($this->GRN);
                        $doc->exportField($this->TreesAllocated);
                        $doc->exportField($this->FarmingSeason);
                        $doc->exportField($this->SeedType);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->TransDate);
                        $doc->exportField($this->PreparedBy);
                        $doc->exportField($this->AuthorisedBy);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerName);
                        $doc->exportField($this->DOB);
                        $doc->exportField($this->Age);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->MaritalStatus);
                        $doc->exportField($this->PhoneNo);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Dependants);
                        $doc->exportField($this->MaleChildren);
                        $doc->exportField($this->FemaleChildren);
                        $doc->exportField($this->HouseholdHead);
                        $doc->exportField($this->FarmerOrg);
                        $doc->exportField($this->FarmerOrgPosition);
                        $doc->exportField($this->JoiningDate);
                        $doc->exportField($this->NurseryName);
                        $doc->exportField($this->NurseryType);
                        $doc->exportField($this->NurseryOwnership);
                        $doc->exportField($this->NumberOfMembers);
                        $doc->exportField($this->Longitude);
                        $doc->exportField($this->Latitude);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
