<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for season19_20
 */
class Season1920 extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $SerialNo;
    public $IPC;
    public $PageNo;
    public $Activity;
    public $District;
    public $Block;
    public $Camp;
    public $NurseryArea;
    public $Zone;
    public $ChiefArea;
    public $Date;
    public $Village;
    public $NameOfFarmer;
    public $YearOfBirth;
    public $Gender;
    public $NRC;
    public $Contact;
    public $FieldType;
    public $SeedlingsReceived19_20;
    public $Hectorage;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "season19_20";
        $this->TableName = 'season19_20';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "season19_20";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // SerialNo
        $this->SerialNo = new DbField(
            $this, // Table
            'x_SerialNo', // Variable name
            'SerialNo', // Name
            '`SerialNo`', // Expression
            '`SerialNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SerialNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SerialNo->InputTextType = "text";
        $this->SerialNo->Raw = true;
        $this->SerialNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SerialNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SerialNo'] = &$this->SerialNo;

        // IPC
        $this->IPC = new DbField(
            $this, // Table
            'x_IPC', // Variable name
            'IPC', // Name
            '`IPC`', // Expression
            '`IPC`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`IPC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->IPC->InputTextType = "text";
        $this->IPC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['IPC'] = &$this->IPC;

        // PageNo
        $this->PageNo = new DbField(
            $this, // Table
            'x_PageNo', // Variable name
            'PageNo', // Name
            '`PageNo`', // Expression
            '`PageNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PageNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PageNo->InputTextType = "text";
        $this->PageNo->Raw = true;
        $this->PageNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PageNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PageNo'] = &$this->PageNo;

        // Activity
        $this->Activity = new DbField(
            $this, // Table
            'x_Activity', // Variable name
            'Activity', // Name
            '`Activity`', // Expression
            '`Activity`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Activity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Activity->InputTextType = "text";
        $this->Activity->UseFilter = true; // Table header filter
        $this->Activity->Lookup = new Lookup($this->Activity, 'season19_20', true, 'Activity', ["Activity","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Activity->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Activity'] = &$this->Activity;

        // District
        $this->District = new DbField(
            $this, // Table
            'x_District', // Variable name
            'District', // Name
            '`District`', // Expression
            '`District`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`District`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->District->InputTextType = "text";
        $this->District->UseFilter = true; // Table header filter
        $this->District->Lookup = new Lookup($this->District, 'season19_20', true, 'District', ["District","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->District->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['District'] = &$this->District;

        // Block
        $this->Block = new DbField(
            $this, // Table
            'x_Block', // Variable name
            'Block', // Name
            '`Block`', // Expression
            '`Block`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Block`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Block->InputTextType = "text";
        $this->Block->UseFilter = true; // Table header filter
        $this->Block->Lookup = new Lookup($this->Block, 'season19_20', true, 'Block', ["Block","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Block->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Block'] = &$this->Block;

        // Camp
        $this->Camp = new DbField(
            $this, // Table
            'x_Camp', // Variable name
            'Camp', // Name
            '`Camp`', // Expression
            '`Camp`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Camp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Camp->InputTextType = "text";
        $this->Camp->UseFilter = true; // Table header filter
        $this->Camp->Lookup = new Lookup($this->Camp, 'season19_20', true, 'Camp', ["Camp","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Camp->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Camp'] = &$this->Camp;

        // NurseryArea
        $this->NurseryArea = new DbField(
            $this, // Table
            'x_NurseryArea', // Variable name
            'NurseryArea', // Name
            '`NurseryArea`', // Expression
            '`NurseryArea`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryArea`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryArea->InputTextType = "text";
        $this->NurseryArea->UseFilter = true; // Table header filter
        $this->NurseryArea->Lookup = new Lookup($this->NurseryArea, 'season19_20', true, 'NurseryArea', ["NurseryArea","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->NurseryArea->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryArea'] = &$this->NurseryArea;

        // Zone
        $this->Zone = new DbField(
            $this, // Table
            'x_Zone', // Variable name
            'Zone', // Name
            '`Zone`', // Expression
            '`Zone`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Zone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Zone->InputTextType = "text";
        $this->Zone->UseFilter = true; // Table header filter
        $this->Zone->Lookup = new Lookup($this->Zone, 'season19_20', true, 'Zone', ["Zone","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Zone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Zone'] = &$this->Zone;

        // ChiefArea
        $this->ChiefArea = new DbField(
            $this, // Table
            'x_ChiefArea', // Variable name
            'ChiefArea', // Name
            '`ChiefArea`', // Expression
            '`ChiefArea`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ChiefArea`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ChiefArea->InputTextType = "text";
        $this->ChiefArea->UseFilter = true; // Table header filter
        $this->ChiefArea->Lookup = new Lookup($this->ChiefArea, 'season19_20', true, 'ChiefArea', ["ChiefArea","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->ChiefArea->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ChiefArea'] = &$this->ChiefArea;

        // Date
        $this->Date = new DbField(
            $this, // Table
            'x_Date', // Variable name
            'Date', // Name
            '`Date`', // Expression
            '`Date`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Date->InputTextType = "text";
        $this->Date->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Date'] = &$this->Date;

        // Village
        $this->Village = new DbField(
            $this, // Table
            'x_Village', // Variable name
            'Village', // Name
            '`Village`', // Expression
            '`Village`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Village`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Village->InputTextType = "text";
        $this->Village->UseFilter = true; // Table header filter
        $this->Village->Lookup = new Lookup($this->Village, 'season19_20', true, 'Village', ["Village","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Village->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Village'] = &$this->Village;

        // NameOfFarmer
        $this->NameOfFarmer = new DbField(
            $this, // Table
            'x_NameOfFarmer', // Variable name
            'NameOfFarmer', // Name
            '`NameOfFarmer`', // Expression
            '`NameOfFarmer`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NameOfFarmer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NameOfFarmer->InputTextType = "text";
        $this->NameOfFarmer->UseFilter = true; // Table header filter
        $this->NameOfFarmer->Lookup = new Lookup($this->NameOfFarmer, 'season19_20', true, 'NameOfFarmer', ["NameOfFarmer","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->NameOfFarmer->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NameOfFarmer'] = &$this->NameOfFarmer;

        // YearOfBirth
        $this->YearOfBirth = new DbField(
            $this, // Table
            'x_YearOfBirth', // Variable name
            'YearOfBirth', // Name
            '`YearOfBirth`', // Expression
            '`YearOfBirth`', // Basic search expression
            18, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`YearOfBirth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->YearOfBirth->InputTextType = "text";
        $this->YearOfBirth->Raw = true;
        $this->YearOfBirth->UseFilter = true; // Table header filter
        $this->YearOfBirth->Lookup = new Lookup($this->YearOfBirth, 'season19_20', true, 'YearOfBirth', ["YearOfBirth","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->YearOfBirth->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->YearOfBirth->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['YearOfBirth'] = &$this->YearOfBirth;

        // Gender
        $this->Gender = new DbField(
            $this, // Table
            'x_Gender', // Variable name
            'Gender', // Name
            '`Gender`', // Expression
            '`Gender`', // Basic search expression
            200, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Gender->InputTextType = "text";
        $this->Gender->UseFilter = true; // Table header filter
        $this->Gender->Lookup = new Lookup($this->Gender, 'season19_20', true, 'Gender', ["Gender","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Gender->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Gender'] = &$this->Gender;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->UseFilter = true; // Table header filter
        $this->NRC->Lookup = new Lookup($this->NRC, 'season19_20', true, 'NRC', ["NRC","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NRC'] = &$this->NRC;

        // Contact
        $this->Contact = new DbField(
            $this, // Table
            'x_Contact', // Variable name
            'Contact', // Name
            '`Contact`', // Expression
            '`Contact`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Contact`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Contact->InputTextType = "text";
        $this->Contact->UseFilter = true; // Table header filter
        $this->Contact->Lookup = new Lookup($this->Contact, 'season19_20', true, 'Contact', ["Contact","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Contact->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Contact'] = &$this->Contact;

        // FieldType
        $this->FieldType = new DbField(
            $this, // Table
            'x_FieldType', // Variable name
            'FieldType', // Name
            '`FieldType`', // Expression
            '`FieldType`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FieldType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FieldType->InputTextType = "text";
        $this->FieldType->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FieldType'] = &$this->FieldType;

        // SeedlingsReceived19_20
        $this->SeedlingsReceived19_20 = new DbField(
            $this, // Table
            'x_SeedlingsReceived19_20', // Variable name
            'SeedlingsReceived19_20', // Name
            '`SeedlingsReceived19_20`', // Expression
            '`SeedlingsReceived19_20`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedlingsReceived19_20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedlingsReceived19_20->InputTextType = "text";
        $this->SeedlingsReceived19_20->Raw = true;
        $this->SeedlingsReceived19_20->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SeedlingsReceived19_20->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedlingsReceived19_20'] = &$this->SeedlingsReceived19_20;

        // Hectorage
        $this->Hectorage = new DbField(
            $this, // Table
            'x_Hectorage', // Variable name
            'Hectorage', // Name
            '`Hectorage`', // Expression
            '`Hectorage`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Hectorage`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Hectorage->InputTextType = "text";
        $this->Hectorage->Raw = true;
        $this->Hectorage->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Hectorage->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Hectorage'] = &$this->Hectorage;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "season19_20";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->SerialNo->DbValue = $row['SerialNo'];
        $this->IPC->DbValue = $row['IPC'];
        $this->PageNo->DbValue = $row['PageNo'];
        $this->Activity->DbValue = $row['Activity'];
        $this->District->DbValue = $row['District'];
        $this->Block->DbValue = $row['Block'];
        $this->Camp->DbValue = $row['Camp'];
        $this->NurseryArea->DbValue = $row['NurseryArea'];
        $this->Zone->DbValue = $row['Zone'];
        $this->ChiefArea->DbValue = $row['ChiefArea'];
        $this->Date->DbValue = $row['Date'];
        $this->Village->DbValue = $row['Village'];
        $this->NameOfFarmer->DbValue = $row['NameOfFarmer'];
        $this->YearOfBirth->DbValue = $row['YearOfBirth'];
        $this->Gender->DbValue = $row['Gender'];
        $this->NRC->DbValue = $row['NRC'];
        $this->Contact->DbValue = $row['Contact'];
        $this->FieldType->DbValue = $row['FieldType'];
        $this->SeedlingsReceived19_20->DbValue = $row['SeedlingsReceived19_20'];
        $this->Hectorage->DbValue = $row['Hectorage'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("Season1920List");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "Season1920View" => $Language->phrase("View"),
            "Season1920Edit" => $Language->phrase("Edit"),
            "Season1920Add" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "Season1920List";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "Season1920View",
            Config("API_ADD_ACTION") => "Season1920Add",
            Config("API_EDIT_ACTION") => "Season1920Edit",
            Config("API_DELETE_ACTION") => "Season1920Delete",
            Config("API_LIST_ACTION") => "Season1920List",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "Season1920List";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("Season1920View", $parm);
        } else {
            $url = $this->keyUrl("Season1920View", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "Season1920Add?" . $parm;
        } else {
            $url = "Season1920Add";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("Season1920Edit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("Season1920List", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("Season1920Add", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("Season1920List", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("Season1920Delete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->SerialNo->setDbValue($row['SerialNo']);
        $this->IPC->setDbValue($row['IPC']);
        $this->PageNo->setDbValue($row['PageNo']);
        $this->Activity->setDbValue($row['Activity']);
        $this->District->setDbValue($row['District']);
        $this->Block->setDbValue($row['Block']);
        $this->Camp->setDbValue($row['Camp']);
        $this->NurseryArea->setDbValue($row['NurseryArea']);
        $this->Zone->setDbValue($row['Zone']);
        $this->ChiefArea->setDbValue($row['ChiefArea']);
        $this->Date->setDbValue($row['Date']);
        $this->Village->setDbValue($row['Village']);
        $this->NameOfFarmer->setDbValue($row['NameOfFarmer']);
        $this->YearOfBirth->setDbValue($row['YearOfBirth']);
        $this->Gender->setDbValue($row['Gender']);
        $this->NRC->setDbValue($row['NRC']);
        $this->Contact->setDbValue($row['Contact']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->SeedlingsReceived19_20->setDbValue($row['SeedlingsReceived19_20']);
        $this->Hectorage->setDbValue($row['Hectorage']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "Season1920List";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // SerialNo

        // IPC

        // PageNo

        // Activity

        // District

        // Block

        // Camp

        // NurseryArea

        // Zone

        // ChiefArea

        // Date

        // Village

        // NameOfFarmer

        // YearOfBirth

        // Gender

        // NRC

        // Contact

        // FieldType

        // SeedlingsReceived19_20

        // Hectorage

        // SerialNo
        $this->SerialNo->ViewValue = $this->SerialNo->CurrentValue;
        $this->SerialNo->ViewValue = FormatNumber($this->SerialNo->ViewValue, $this->SerialNo->formatPattern());

        // IPC
        $this->IPC->ViewValue = $this->IPC->CurrentValue;

        // PageNo
        $this->PageNo->ViewValue = $this->PageNo->CurrentValue;
        $this->PageNo->ViewValue = FormatNumber($this->PageNo->ViewValue, $this->PageNo->formatPattern());

        // Activity
        $this->Activity->ViewValue = $this->Activity->CurrentValue;

        // District
        $this->District->ViewValue = $this->District->CurrentValue;

        // Block
        $this->Block->ViewValue = $this->Block->CurrentValue;

        // Camp
        $this->Camp->ViewValue = $this->Camp->CurrentValue;

        // NurseryArea
        $this->NurseryArea->ViewValue = $this->NurseryArea->CurrentValue;

        // Zone
        $this->Zone->ViewValue = $this->Zone->CurrentValue;

        // ChiefArea
        $this->ChiefArea->ViewValue = $this->ChiefArea->CurrentValue;

        // Date
        $this->Date->ViewValue = $this->Date->CurrentValue;

        // Village
        $this->Village->ViewValue = $this->Village->CurrentValue;

        // NameOfFarmer
        $this->NameOfFarmer->ViewValue = $this->NameOfFarmer->CurrentValue;

        // YearOfBirth
        $this->YearOfBirth->ViewValue = $this->YearOfBirth->CurrentValue;

        // Gender
        $this->Gender->ViewValue = $this->Gender->CurrentValue;

        // NRC
        $this->NRC->ViewValue = $this->NRC->CurrentValue;

        // Contact
        $this->Contact->ViewValue = $this->Contact->CurrentValue;

        // FieldType
        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;

        // SeedlingsReceived19_20
        $this->SeedlingsReceived19_20->ViewValue = $this->SeedlingsReceived19_20->CurrentValue;
        $this->SeedlingsReceived19_20->ViewValue = FormatNumber($this->SeedlingsReceived19_20->ViewValue, $this->SeedlingsReceived19_20->formatPattern());

        // Hectorage
        $this->Hectorage->ViewValue = $this->Hectorage->CurrentValue;
        $this->Hectorage->ViewValue = FormatNumber($this->Hectorage->ViewValue, $this->Hectorage->formatPattern());

        // SerialNo
        $this->SerialNo->HrefValue = "";
        $this->SerialNo->TooltipValue = "";

        // IPC
        $this->IPC->HrefValue = "";
        $this->IPC->TooltipValue = "";

        // PageNo
        $this->PageNo->HrefValue = "";
        $this->PageNo->TooltipValue = "";

        // Activity
        $this->Activity->HrefValue = "";
        $this->Activity->TooltipValue = "";

        // District
        $this->District->HrefValue = "";
        $this->District->TooltipValue = "";

        // Block
        $this->Block->HrefValue = "";
        $this->Block->TooltipValue = "";

        // Camp
        $this->Camp->HrefValue = "";
        $this->Camp->TooltipValue = "";

        // NurseryArea
        $this->NurseryArea->HrefValue = "";
        $this->NurseryArea->TooltipValue = "";

        // Zone
        $this->Zone->HrefValue = "";
        $this->Zone->TooltipValue = "";

        // ChiefArea
        $this->ChiefArea->HrefValue = "";
        $this->ChiefArea->TooltipValue = "";

        // Date
        $this->Date->HrefValue = "";
        $this->Date->TooltipValue = "";

        // Village
        $this->Village->HrefValue = "";
        $this->Village->TooltipValue = "";

        // NameOfFarmer
        $this->NameOfFarmer->HrefValue = "";
        $this->NameOfFarmer->TooltipValue = "";

        // YearOfBirth
        $this->YearOfBirth->HrefValue = "";
        $this->YearOfBirth->TooltipValue = "";

        // Gender
        $this->Gender->HrefValue = "";
        $this->Gender->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // Contact
        $this->Contact->HrefValue = "";
        $this->Contact->TooltipValue = "";

        // FieldType
        $this->FieldType->HrefValue = "";
        $this->FieldType->TooltipValue = "";

        // SeedlingsReceived19_20
        $this->SeedlingsReceived19_20->HrefValue = "";
        $this->SeedlingsReceived19_20->TooltipValue = "";

        // Hectorage
        $this->Hectorage->HrefValue = "";
        $this->Hectorage->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // SerialNo
        $this->SerialNo->setupEditAttributes();
        $this->SerialNo->EditValue = $this->SerialNo->CurrentValue;
        $this->SerialNo->PlaceHolder = RemoveHtml($this->SerialNo->caption());
        if (strval($this->SerialNo->EditValue) != "" && is_numeric($this->SerialNo->EditValue)) {
            $this->SerialNo->EditValue = FormatNumber($this->SerialNo->EditValue, null);
        }

        // IPC
        $this->IPC->setupEditAttributes();
        if (!$this->IPC->Raw) {
            $this->IPC->CurrentValue = HtmlDecode($this->IPC->CurrentValue);
        }
        $this->IPC->EditValue = $this->IPC->CurrentValue;
        $this->IPC->PlaceHolder = RemoveHtml($this->IPC->caption());

        // PageNo
        $this->PageNo->setupEditAttributes();
        $this->PageNo->EditValue = $this->PageNo->CurrentValue;
        $this->PageNo->PlaceHolder = RemoveHtml($this->PageNo->caption());
        if (strval($this->PageNo->EditValue) != "" && is_numeric($this->PageNo->EditValue)) {
            $this->PageNo->EditValue = FormatNumber($this->PageNo->EditValue, null);
        }

        // Activity
        $this->Activity->setupEditAttributes();
        if (!$this->Activity->Raw) {
            $this->Activity->CurrentValue = HtmlDecode($this->Activity->CurrentValue);
        }
        $this->Activity->EditValue = $this->Activity->CurrentValue;
        $this->Activity->PlaceHolder = RemoveHtml($this->Activity->caption());

        // District
        $this->District->setupEditAttributes();
        if (!$this->District->Raw) {
            $this->District->CurrentValue = HtmlDecode($this->District->CurrentValue);
        }
        $this->District->EditValue = $this->District->CurrentValue;
        $this->District->PlaceHolder = RemoveHtml($this->District->caption());

        // Block
        $this->Block->setupEditAttributes();
        if (!$this->Block->Raw) {
            $this->Block->CurrentValue = HtmlDecode($this->Block->CurrentValue);
        }
        $this->Block->EditValue = $this->Block->CurrentValue;
        $this->Block->PlaceHolder = RemoveHtml($this->Block->caption());

        // Camp
        $this->Camp->setupEditAttributes();
        if (!$this->Camp->Raw) {
            $this->Camp->CurrentValue = HtmlDecode($this->Camp->CurrentValue);
        }
        $this->Camp->EditValue = $this->Camp->CurrentValue;
        $this->Camp->PlaceHolder = RemoveHtml($this->Camp->caption());

        // NurseryArea
        $this->NurseryArea->setupEditAttributes();
        if (!$this->NurseryArea->Raw) {
            $this->NurseryArea->CurrentValue = HtmlDecode($this->NurseryArea->CurrentValue);
        }
        $this->NurseryArea->EditValue = $this->NurseryArea->CurrentValue;
        $this->NurseryArea->PlaceHolder = RemoveHtml($this->NurseryArea->caption());

        // Zone
        $this->Zone->setupEditAttributes();
        if (!$this->Zone->Raw) {
            $this->Zone->CurrentValue = HtmlDecode($this->Zone->CurrentValue);
        }
        $this->Zone->EditValue = $this->Zone->CurrentValue;
        $this->Zone->PlaceHolder = RemoveHtml($this->Zone->caption());

        // ChiefArea
        $this->ChiefArea->setupEditAttributes();
        if (!$this->ChiefArea->Raw) {
            $this->ChiefArea->CurrentValue = HtmlDecode($this->ChiefArea->CurrentValue);
        }
        $this->ChiefArea->EditValue = $this->ChiefArea->CurrentValue;
        $this->ChiefArea->PlaceHolder = RemoveHtml($this->ChiefArea->caption());

        // Date
        $this->Date->setupEditAttributes();
        if (!$this->Date->Raw) {
            $this->Date->CurrentValue = HtmlDecode($this->Date->CurrentValue);
        }
        $this->Date->EditValue = $this->Date->CurrentValue;
        $this->Date->PlaceHolder = RemoveHtml($this->Date->caption());

        // Village
        $this->Village->setupEditAttributes();
        if (!$this->Village->Raw) {
            $this->Village->CurrentValue = HtmlDecode($this->Village->CurrentValue);
        }
        $this->Village->EditValue = $this->Village->CurrentValue;
        $this->Village->PlaceHolder = RemoveHtml($this->Village->caption());

        // NameOfFarmer
        $this->NameOfFarmer->setupEditAttributes();
        if (!$this->NameOfFarmer->Raw) {
            $this->NameOfFarmer->CurrentValue = HtmlDecode($this->NameOfFarmer->CurrentValue);
        }
        $this->NameOfFarmer->EditValue = $this->NameOfFarmer->CurrentValue;
        $this->NameOfFarmer->PlaceHolder = RemoveHtml($this->NameOfFarmer->caption());

        // YearOfBirth
        $this->YearOfBirth->setupEditAttributes();
        $this->YearOfBirth->EditValue = $this->YearOfBirth->CurrentValue;
        $this->YearOfBirth->PlaceHolder = RemoveHtml($this->YearOfBirth->caption());
        if (strval($this->YearOfBirth->EditValue) != "" && is_numeric($this->YearOfBirth->EditValue)) {
            $this->YearOfBirth->EditValue = $this->YearOfBirth->EditValue;
        }

        // Gender
        $this->Gender->setupEditAttributes();
        if (!$this->Gender->Raw) {
            $this->Gender->CurrentValue = HtmlDecode($this->Gender->CurrentValue);
        }
        $this->Gender->EditValue = $this->Gender->CurrentValue;
        $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

        // NRC
        $this->NRC->setupEditAttributes();
        if (!$this->NRC->Raw) {
            $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
        }
        $this->NRC->EditValue = $this->NRC->CurrentValue;
        $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

        // Contact
        $this->Contact->setupEditAttributes();
        if (!$this->Contact->Raw) {
            $this->Contact->CurrentValue = HtmlDecode($this->Contact->CurrentValue);
        }
        $this->Contact->EditValue = $this->Contact->CurrentValue;
        $this->Contact->PlaceHolder = RemoveHtml($this->Contact->caption());

        // FieldType
        $this->FieldType->setupEditAttributes();
        if (!$this->FieldType->Raw) {
            $this->FieldType->CurrentValue = HtmlDecode($this->FieldType->CurrentValue);
        }
        $this->FieldType->EditValue = $this->FieldType->CurrentValue;
        $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

        // SeedlingsReceived19_20
        $this->SeedlingsReceived19_20->setupEditAttributes();
        $this->SeedlingsReceived19_20->EditValue = $this->SeedlingsReceived19_20->CurrentValue;
        $this->SeedlingsReceived19_20->PlaceHolder = RemoveHtml($this->SeedlingsReceived19_20->caption());
        if (strval($this->SeedlingsReceived19_20->EditValue) != "" && is_numeric($this->SeedlingsReceived19_20->EditValue)) {
            $this->SeedlingsReceived19_20->EditValue = FormatNumber($this->SeedlingsReceived19_20->EditValue, null);
        }

        // Hectorage
        $this->Hectorage->setupEditAttributes();
        $this->Hectorage->EditValue = $this->Hectorage->CurrentValue;
        $this->Hectorage->PlaceHolder = RemoveHtml($this->Hectorage->caption());
        if (strval($this->Hectorage->EditValue) != "" && is_numeric($this->Hectorage->EditValue)) {
            $this->Hectorage->EditValue = FormatNumber($this->Hectorage->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->SerialNo);
                    $doc->exportCaption($this->IPC);
                    $doc->exportCaption($this->PageNo);
                    $doc->exportCaption($this->Activity);
                    $doc->exportCaption($this->District);
                    $doc->exportCaption($this->Block);
                    $doc->exportCaption($this->Camp);
                    $doc->exportCaption($this->NurseryArea);
                    $doc->exportCaption($this->Zone);
                    $doc->exportCaption($this->ChiefArea);
                    $doc->exportCaption($this->Date);
                    $doc->exportCaption($this->Village);
                    $doc->exportCaption($this->NameOfFarmer);
                    $doc->exportCaption($this->YearOfBirth);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->Contact);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->SeedlingsReceived19_20);
                    $doc->exportCaption($this->Hectorage);
                } else {
                    $doc->exportCaption($this->SerialNo);
                    $doc->exportCaption($this->IPC);
                    $doc->exportCaption($this->PageNo);
                    $doc->exportCaption($this->Activity);
                    $doc->exportCaption($this->District);
                    $doc->exportCaption($this->Block);
                    $doc->exportCaption($this->Camp);
                    $doc->exportCaption($this->NurseryArea);
                    $doc->exportCaption($this->Zone);
                    $doc->exportCaption($this->ChiefArea);
                    $doc->exportCaption($this->Date);
                    $doc->exportCaption($this->Village);
                    $doc->exportCaption($this->NameOfFarmer);
                    $doc->exportCaption($this->YearOfBirth);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->Contact);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->SeedlingsReceived19_20);
                    $doc->exportCaption($this->Hectorage);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->SerialNo);
                        $doc->exportField($this->IPC);
                        $doc->exportField($this->PageNo);
                        $doc->exportField($this->Activity);
                        $doc->exportField($this->District);
                        $doc->exportField($this->Block);
                        $doc->exportField($this->Camp);
                        $doc->exportField($this->NurseryArea);
                        $doc->exportField($this->Zone);
                        $doc->exportField($this->ChiefArea);
                        $doc->exportField($this->Date);
                        $doc->exportField($this->Village);
                        $doc->exportField($this->NameOfFarmer);
                        $doc->exportField($this->YearOfBirth);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->Contact);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->SeedlingsReceived19_20);
                        $doc->exportField($this->Hectorage);
                    } else {
                        $doc->exportField($this->SerialNo);
                        $doc->exportField($this->IPC);
                        $doc->exportField($this->PageNo);
                        $doc->exportField($this->Activity);
                        $doc->exportField($this->District);
                        $doc->exportField($this->Block);
                        $doc->exportField($this->Camp);
                        $doc->exportField($this->NurseryArea);
                        $doc->exportField($this->Zone);
                        $doc->exportField($this->ChiefArea);
                        $doc->exportField($this->Date);
                        $doc->exportField($this->Village);
                        $doc->exportField($this->NameOfFarmer);
                        $doc->exportField($this->YearOfBirth);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->Contact);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->SeedlingsReceived19_20);
                        $doc->exportField($this->Hectorage);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
