<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class NurseryEdit extends Nursery
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "NurseryEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "NurseryEdit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->NurseryCode->setVisibility();
        $this->NurseryName->setVisibility();
        $this->NurseryType->setVisibility();
        $this->PhysicalAddress->setVisibility();
        $this->PostalAddress->setVisibility();
        $this->Phone->setVisibility();
        $this->_Email->setVisibility();
        $this->NurseryOwnership->setVisibility();
        $this->SeedVariety->setVisibility();
        $this->NumberOfMembers->setVisibility();
        $this->FemaleMembers->setVisibility();
        $this->MaleMembers->setVisibility();
        $this->YoungFemales->setVisibility();
        $this->YoungMales->setVisibility();
        $this->FemalesInManagement->setVisibility();
        $this->MalesInManagement->setVisibility();
        $this->Latitude->setVisibility();
        $this->Longitude->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'nursery';
        $this->TableName = 'nursery';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (nursery)
        if (!isset($GLOBALS["nursery"]) || $GLOBALS["nursery"]::class == PROJECT_NAMESPACE . "nursery") {
            $GLOBALS["nursery"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'nursery');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "NurseryView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['NurseryCode'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->NurseryCode->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->NurseryType);
        $this->setupLookupOptions($this->NurseryOwnership);
        $this->setupLookupOptions($this->SeedVariety);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("NurseryCode") ?? Key(0) ?? Route(2)) !== null) {
                $this->NurseryCode->setQueryStringValue($keyValue);
                $this->NurseryCode->setOldValue($this->NurseryCode->QueryStringValue);
            } elseif (Post("NurseryCode") !== null) {
                $this->NurseryCode->setFormValue(Post("NurseryCode"));
                $this->NurseryCode->setOldValue($this->NurseryCode->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("NurseryCode") ?? Route("NurseryCode")) !== null) {
                    $this->NurseryCode->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->NurseryCode->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load result set
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    $this->Recordset = $this->loadRecordset(); // Load records
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("NurseryList"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $this->fetch($this->StartRecord);
                            // Redirect to correct record
                            $this->loadRowValues($this->CurrentRow);
                            $url = $this->getCurrentUrl();
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->NurseryCode->CurrentValue != null) {
                            while ($this->fetch()) {
                                if (SameString($this->NurseryCode->CurrentValue, $this->CurrentRow['NurseryCode'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($this->CurrentRow);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("NurseryList"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("NurseryList"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "NurseryList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "NurseryList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "NurseryList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }

        // Check field name 'NurseryCode' first before field var 'x_NurseryCode'
        $val = $CurrentForm->hasValue("NurseryCode") ? $CurrentForm->getValue("NurseryCode") : $CurrentForm->getValue("x_NurseryCode");
        if (!$this->NurseryCode->IsDetailKey) {
            $this->NurseryCode->setFormValue($val);
        }

        // Check field name 'NurseryName' first before field var 'x_NurseryName'
        $val = $CurrentForm->hasValue("NurseryName") ? $CurrentForm->getValue("NurseryName") : $CurrentForm->getValue("x_NurseryName");
        if (!$this->NurseryName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryName->Visible = false; // Disable update for API request
            } else {
                $this->NurseryName->setFormValue($val);
            }
        }

        // Check field name 'NurseryType' first before field var 'x_NurseryType'
        $val = $CurrentForm->hasValue("NurseryType") ? $CurrentForm->getValue("NurseryType") : $CurrentForm->getValue("x_NurseryType");
        if (!$this->NurseryType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryType->Visible = false; // Disable update for API request
            } else {
                $this->NurseryType->setFormValue($val);
            }
        }

        // Check field name 'PhysicalAddress' first before field var 'x_PhysicalAddress'
        $val = $CurrentForm->hasValue("PhysicalAddress") ? $CurrentForm->getValue("PhysicalAddress") : $CurrentForm->getValue("x_PhysicalAddress");
        if (!$this->PhysicalAddress->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PhysicalAddress->Visible = false; // Disable update for API request
            } else {
                $this->PhysicalAddress->setFormValue($val);
            }
        }

        // Check field name 'PostalAddress' first before field var 'x_PostalAddress'
        $val = $CurrentForm->hasValue("PostalAddress") ? $CurrentForm->getValue("PostalAddress") : $CurrentForm->getValue("x_PostalAddress");
        if (!$this->PostalAddress->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PostalAddress->Visible = false; // Disable update for API request
            } else {
                $this->PostalAddress->setFormValue($val);
            }
        }

        // Check field name 'Phone' first before field var 'x_Phone'
        $val = $CurrentForm->hasValue("Phone") ? $CurrentForm->getValue("Phone") : $CurrentForm->getValue("x_Phone");
        if (!$this->Phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Phone->Visible = false; // Disable update for API request
            } else {
                $this->Phone->setFormValue($val);
            }
        }

        // Check field name 'Email' first before field var 'x__Email'
        $val = $CurrentForm->hasValue("Email") ? $CurrentForm->getValue("Email") : $CurrentForm->getValue("x__Email");
        if (!$this->_Email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Email->Visible = false; // Disable update for API request
            } else {
                $this->_Email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'NurseryOwnership' first before field var 'x_NurseryOwnership'
        $val = $CurrentForm->hasValue("NurseryOwnership") ? $CurrentForm->getValue("NurseryOwnership") : $CurrentForm->getValue("x_NurseryOwnership");
        if (!$this->NurseryOwnership->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryOwnership->Visible = false; // Disable update for API request
            } else {
                $this->NurseryOwnership->setFormValue($val);
            }
        }

        // Check field name 'SeedVariety' first before field var 'x_SeedVariety'
        $val = $CurrentForm->hasValue("SeedVariety") ? $CurrentForm->getValue("SeedVariety") : $CurrentForm->getValue("x_SeedVariety");
        if (!$this->SeedVariety->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedVariety->Visible = false; // Disable update for API request
            } else {
                $this->SeedVariety->setFormValue($val);
            }
        }

        // Check field name 'NumberOfMembers' first before field var 'x_NumberOfMembers'
        $val = $CurrentForm->hasValue("NumberOfMembers") ? $CurrentForm->getValue("NumberOfMembers") : $CurrentForm->getValue("x_NumberOfMembers");
        if (!$this->NumberOfMembers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NumberOfMembers->Visible = false; // Disable update for API request
            } else {
                $this->NumberOfMembers->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'FemaleMembers' first before field var 'x_FemaleMembers'
        $val = $CurrentForm->hasValue("FemaleMembers") ? $CurrentForm->getValue("FemaleMembers") : $CurrentForm->getValue("x_FemaleMembers");
        if (!$this->FemaleMembers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FemaleMembers->Visible = false; // Disable update for API request
            } else {
                $this->FemaleMembers->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'MaleMembers' first before field var 'x_MaleMembers'
        $val = $CurrentForm->hasValue("MaleMembers") ? $CurrentForm->getValue("MaleMembers") : $CurrentForm->getValue("x_MaleMembers");
        if (!$this->MaleMembers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MaleMembers->Visible = false; // Disable update for API request
            } else {
                $this->MaleMembers->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'YoungFemales' first before field var 'x_YoungFemales'
        $val = $CurrentForm->hasValue("YoungFemales") ? $CurrentForm->getValue("YoungFemales") : $CurrentForm->getValue("x_YoungFemales");
        if (!$this->YoungFemales->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->YoungFemales->Visible = false; // Disable update for API request
            } else {
                $this->YoungFemales->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'YoungMales' first before field var 'x_YoungMales'
        $val = $CurrentForm->hasValue("YoungMales") ? $CurrentForm->getValue("YoungMales") : $CurrentForm->getValue("x_YoungMales");
        if (!$this->YoungMales->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->YoungMales->Visible = false; // Disable update for API request
            } else {
                $this->YoungMales->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'FemalesInManagement' first before field var 'x_FemalesInManagement'
        $val = $CurrentForm->hasValue("FemalesInManagement") ? $CurrentForm->getValue("FemalesInManagement") : $CurrentForm->getValue("x_FemalesInManagement");
        if (!$this->FemalesInManagement->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FemalesInManagement->Visible = false; // Disable update for API request
            } else {
                $this->FemalesInManagement->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'MalesInManagement' first before field var 'x_MalesInManagement'
        $val = $CurrentForm->hasValue("MalesInManagement") ? $CurrentForm->getValue("MalesInManagement") : $CurrentForm->getValue("x_MalesInManagement");
        if (!$this->MalesInManagement->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MalesInManagement->Visible = false; // Disable update for API request
            } else {
                $this->MalesInManagement->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Latitude' first before field var 'x_Latitude'
        $val = $CurrentForm->hasValue("Latitude") ? $CurrentForm->getValue("Latitude") : $CurrentForm->getValue("x_Latitude");
        if (!$this->Latitude->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Latitude->Visible = false; // Disable update for API request
            } else {
                $this->Latitude->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Longitude' first before field var 'x_Longitude'
        $val = $CurrentForm->hasValue("Longitude") ? $CurrentForm->getValue("Longitude") : $CurrentForm->getValue("x_Longitude");
        if (!$this->Longitude->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Longitude->Visible = false; // Disable update for API request
            } else {
                $this->Longitude->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->NurseryCode->CurrentValue = $this->NurseryCode->FormValue;
        $this->NurseryName->CurrentValue = $this->NurseryName->FormValue;
        $this->NurseryType->CurrentValue = $this->NurseryType->FormValue;
        $this->PhysicalAddress->CurrentValue = $this->PhysicalAddress->FormValue;
        $this->PostalAddress->CurrentValue = $this->PostalAddress->FormValue;
        $this->Phone->CurrentValue = $this->Phone->FormValue;
        $this->_Email->CurrentValue = $this->_Email->FormValue;
        $this->NurseryOwnership->CurrentValue = $this->NurseryOwnership->FormValue;
        $this->SeedVariety->CurrentValue = $this->SeedVariety->FormValue;
        $this->NumberOfMembers->CurrentValue = $this->NumberOfMembers->FormValue;
        $this->FemaleMembers->CurrentValue = $this->FemaleMembers->FormValue;
        $this->MaleMembers->CurrentValue = $this->MaleMembers->FormValue;
        $this->YoungFemales->CurrentValue = $this->YoungFemales->FormValue;
        $this->YoungMales->CurrentValue = $this->YoungMales->FormValue;
        $this->FemalesInManagement->CurrentValue = $this->FemalesInManagement->FormValue;
        $this->MalesInManagement->CurrentValue = $this->MalesInManagement->FormValue;
        $this->Latitude->CurrentValue = $this->Latitude->FormValue;
        $this->Longitude->CurrentValue = $this->Longitude->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->NurseryCode->setDbValue($row['NurseryCode']);
        $this->NurseryName->setDbValue($row['NurseryName']);
        $this->NurseryType->setDbValue($row['NurseryType']);
        $this->PhysicalAddress->setDbValue($row['PhysicalAddress']);
        $this->PostalAddress->setDbValue($row['PostalAddress']);
        $this->Phone->setDbValue($row['Phone']);
        $this->_Email->setDbValue($row['Email']);
        $this->NurseryOwnership->setDbValue($row['NurseryOwnership']);
        $this->SeedVariety->setDbValue($row['SeedVariety']);
        $this->NumberOfMembers->setDbValue($row['NumberOfMembers']);
        $this->FemaleMembers->setDbValue($row['FemaleMembers']);
        $this->MaleMembers->setDbValue($row['MaleMembers']);
        $this->YoungFemales->setDbValue($row['YoungFemales']);
        $this->YoungMales->setDbValue($row['YoungMales']);
        $this->FemalesInManagement->setDbValue($row['FemalesInManagement']);
        $this->MalesInManagement->setDbValue($row['MalesInManagement']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['NurseryCode'] = $this->NurseryCode->DefaultValue;
        $row['NurseryName'] = $this->NurseryName->DefaultValue;
        $row['NurseryType'] = $this->NurseryType->DefaultValue;
        $row['PhysicalAddress'] = $this->PhysicalAddress->DefaultValue;
        $row['PostalAddress'] = $this->PostalAddress->DefaultValue;
        $row['Phone'] = $this->Phone->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['NurseryOwnership'] = $this->NurseryOwnership->DefaultValue;
        $row['SeedVariety'] = $this->SeedVariety->DefaultValue;
        $row['NumberOfMembers'] = $this->NumberOfMembers->DefaultValue;
        $row['FemaleMembers'] = $this->FemaleMembers->DefaultValue;
        $row['MaleMembers'] = $this->MaleMembers->DefaultValue;
        $row['YoungFemales'] = $this->YoungFemales->DefaultValue;
        $row['YoungMales'] = $this->YoungMales->DefaultValue;
        $row['FemalesInManagement'] = $this->FemalesInManagement->DefaultValue;
        $row['MalesInManagement'] = $this->MalesInManagement->DefaultValue;
        $row['Latitude'] = $this->Latitude->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // NurseryCode
        $this->NurseryCode->RowCssClass = "row";

        // NurseryName
        $this->NurseryName->RowCssClass = "row";

        // NurseryType
        $this->NurseryType->RowCssClass = "row";

        // PhysicalAddress
        $this->PhysicalAddress->RowCssClass = "row";

        // PostalAddress
        $this->PostalAddress->RowCssClass = "row";

        // Phone
        $this->Phone->RowCssClass = "row";

        // Email
        $this->_Email->RowCssClass = "row";

        // NurseryOwnership
        $this->NurseryOwnership->RowCssClass = "row";

        // SeedVariety
        $this->SeedVariety->RowCssClass = "row";

        // NumberOfMembers
        $this->NumberOfMembers->RowCssClass = "row";

        // FemaleMembers
        $this->FemaleMembers->RowCssClass = "row";

        // MaleMembers
        $this->MaleMembers->RowCssClass = "row";

        // YoungFemales
        $this->YoungFemales->RowCssClass = "row";

        // YoungMales
        $this->YoungMales->RowCssClass = "row";

        // FemalesInManagement
        $this->FemalesInManagement->RowCssClass = "row";

        // MalesInManagement
        $this->MalesInManagement->RowCssClass = "row";

        // Latitude
        $this->Latitude->RowCssClass = "row";

        // Longitude
        $this->Longitude->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // NurseryCode
            $this->NurseryCode->ViewValue = $this->NurseryCode->CurrentValue;

            // NurseryName
            $this->NurseryName->ViewValue = $this->NurseryName->CurrentValue;

            // NurseryType
            $curVal = strval($this->NurseryType->CurrentValue);
            if ($curVal != "") {
                $this->NurseryType->ViewValue = $this->NurseryType->lookupCacheOption($curVal);
                if ($this->NurseryType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchExpression(), "=", $curVal, $this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchDataType(), "");
                    $sqlWrk = $this->NurseryType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NurseryType->Lookup->renderViewRow($rswrk[0]);
                        $this->NurseryType->ViewValue = $this->NurseryType->displayValue($arwrk);
                    } else {
                        $this->NurseryType->ViewValue = $this->NurseryType->CurrentValue;
                    }
                }
            } else {
                $this->NurseryType->ViewValue = null;
            }

            // PhysicalAddress
            $this->PhysicalAddress->ViewValue = $this->PhysicalAddress->CurrentValue;

            // PostalAddress
            $this->PostalAddress->ViewValue = $this->PostalAddress->CurrentValue;

            // Phone
            $this->Phone->ViewValue = $this->Phone->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // NurseryOwnership
            $curVal = strval($this->NurseryOwnership->CurrentValue);
            if ($curVal != "") {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->lookupCacheOption($curVal);
                if ($this->NurseryOwnership->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchExpression(), "=", $curVal, $this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchDataType(), "");
                    $sqlWrk = $this->NurseryOwnership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NurseryOwnership->Lookup->renderViewRow($rswrk[0]);
                        $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->displayValue($arwrk);
                    } else {
                        $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->CurrentValue;
                    }
                }
            } else {
                $this->NurseryOwnership->ViewValue = null;
            }

            // SeedVariety
            $curVal = strval($this->SeedVariety->CurrentValue);
            if ($curVal != "") {
                $this->SeedVariety->ViewValue = $this->SeedVariety->lookupCacheOption($curVal);
                if ($this->SeedVariety->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                    $sqlWrk = $this->SeedVariety->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SeedVariety->Lookup->renderViewRow($rswrk[0]);
                        $this->SeedVariety->ViewValue = $this->SeedVariety->displayValue($arwrk);
                    } else {
                        $this->SeedVariety->ViewValue = $this->SeedVariety->CurrentValue;
                    }
                }
            } else {
                $this->SeedVariety->ViewValue = null;
            }

            // NumberOfMembers
            $this->NumberOfMembers->ViewValue = $this->NumberOfMembers->CurrentValue;

            // FemaleMembers
            $this->FemaleMembers->ViewValue = $this->FemaleMembers->CurrentValue;

            // MaleMembers
            $this->MaleMembers->ViewValue = $this->MaleMembers->CurrentValue;

            // YoungFemales
            $this->YoungFemales->ViewValue = $this->YoungFemales->CurrentValue;

            // YoungMales
            $this->YoungMales->ViewValue = $this->YoungMales->CurrentValue;

            // FemalesInManagement
            $this->FemalesInManagement->ViewValue = $this->FemalesInManagement->CurrentValue;

            // MalesInManagement
            $this->MalesInManagement->ViewValue = $this->MalesInManagement->CurrentValue;

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";

            // NurseryType
            $this->NurseryType->HrefValue = "";

            // PhysicalAddress
            $this->PhysicalAddress->HrefValue = "";

            // PostalAddress
            $this->PostalAddress->HrefValue = "";

            // Phone
            $this->Phone->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // NurseryOwnership
            $this->NurseryOwnership->HrefValue = "";

            // SeedVariety
            $this->SeedVariety->HrefValue = "";

            // NumberOfMembers
            $this->NumberOfMembers->HrefValue = "";

            // FemaleMembers
            $this->FemaleMembers->HrefValue = "";

            // MaleMembers
            $this->MaleMembers->HrefValue = "";

            // YoungFemales
            $this->YoungFemales->HrefValue = "";

            // YoungMales
            $this->YoungMales->HrefValue = "";

            // FemalesInManagement
            $this->FemalesInManagement->HrefValue = "";

            // MalesInManagement
            $this->MalesInManagement->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // NurseryCode
            $this->NurseryCode->setupEditAttributes();
            $this->NurseryCode->EditValue = $this->NurseryCode->CurrentValue;

            // NurseryName
            $this->NurseryName->setupEditAttributes();
            if (!$this->NurseryName->Raw) {
                $this->NurseryName->CurrentValue = HtmlDecode($this->NurseryName->CurrentValue);
            }
            $this->NurseryName->EditValue = HtmlEncode($this->NurseryName->CurrentValue);
            $this->NurseryName->PlaceHolder = RemoveHtml($this->NurseryName->caption());

            // NurseryType
            $this->NurseryType->setupEditAttributes();
            $curVal = trim(strval($this->NurseryType->CurrentValue));
            if ($curVal != "") {
                $this->NurseryType->ViewValue = $this->NurseryType->lookupCacheOption($curVal);
            } else {
                $this->NurseryType->ViewValue = $this->NurseryType->Lookup !== null && is_array($this->NurseryType->lookupOptions()) && count($this->NurseryType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NurseryType->ViewValue !== null) { // Load from cache
                $this->NurseryType->EditValue = array_values($this->NurseryType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchExpression(), "=", $this->NurseryType->CurrentValue, $this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->NurseryType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NurseryType->EditValue = $arwrk;
            }
            $this->NurseryType->PlaceHolder = RemoveHtml($this->NurseryType->caption());

            // PhysicalAddress
            $this->PhysicalAddress->setupEditAttributes();
            $this->PhysicalAddress->EditValue = HtmlEncode($this->PhysicalAddress->CurrentValue);
            $this->PhysicalAddress->PlaceHolder = RemoveHtml($this->PhysicalAddress->caption());

            // PostalAddress
            $this->PostalAddress->setupEditAttributes();
            $this->PostalAddress->EditValue = HtmlEncode($this->PostalAddress->CurrentValue);
            $this->PostalAddress->PlaceHolder = RemoveHtml($this->PostalAddress->caption());

            // Phone
            $this->Phone->setupEditAttributes();
            if (!$this->Phone->Raw) {
                $this->Phone->CurrentValue = HtmlDecode($this->Phone->CurrentValue);
            }
            $this->Phone->EditValue = HtmlEncode($this->Phone->CurrentValue);
            $this->Phone->PlaceHolder = RemoveHtml($this->Phone->caption());

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // NurseryOwnership
            $this->NurseryOwnership->setupEditAttributes();
            $curVal = trim(strval($this->NurseryOwnership->CurrentValue));
            if ($curVal != "") {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->lookupCacheOption($curVal);
            } else {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->Lookup !== null && is_array($this->NurseryOwnership->lookupOptions()) && count($this->NurseryOwnership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NurseryOwnership->ViewValue !== null) { // Load from cache
                $this->NurseryOwnership->EditValue = array_values($this->NurseryOwnership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchExpression(), "=", $this->NurseryOwnership->CurrentValue, $this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->NurseryOwnership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NurseryOwnership->EditValue = $arwrk;
            }
            $this->NurseryOwnership->PlaceHolder = RemoveHtml($this->NurseryOwnership->caption());

            // SeedVariety
            $this->SeedVariety->setupEditAttributes();
            $curVal = trim(strval($this->SeedVariety->CurrentValue));
            if ($curVal != "") {
                $this->SeedVariety->ViewValue = $this->SeedVariety->lookupCacheOption($curVal);
            } else {
                $this->SeedVariety->ViewValue = $this->SeedVariety->Lookup !== null && is_array($this->SeedVariety->lookupOptions()) && count($this->SeedVariety->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SeedVariety->ViewValue !== null) { // Load from cache
                $this->SeedVariety->EditValue = array_values($this->SeedVariety->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->SeedVariety->CurrentValue, $this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->SeedVariety->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SeedVariety->EditValue = $arwrk;
            }
            $this->SeedVariety->PlaceHolder = RemoveHtml($this->SeedVariety->caption());

            // NumberOfMembers
            $this->NumberOfMembers->setupEditAttributes();
            $this->NumberOfMembers->EditValue = $this->NumberOfMembers->CurrentValue;
            $this->NumberOfMembers->PlaceHolder = RemoveHtml($this->NumberOfMembers->caption());
            if (strval($this->NumberOfMembers->EditValue) != "" && is_numeric($this->NumberOfMembers->EditValue)) {
                $this->NumberOfMembers->EditValue = $this->NumberOfMembers->EditValue;
            }

            // FemaleMembers
            $this->FemaleMembers->setupEditAttributes();
            $this->FemaleMembers->EditValue = $this->FemaleMembers->CurrentValue;
            $this->FemaleMembers->PlaceHolder = RemoveHtml($this->FemaleMembers->caption());
            if (strval($this->FemaleMembers->EditValue) != "" && is_numeric($this->FemaleMembers->EditValue)) {
                $this->FemaleMembers->EditValue = $this->FemaleMembers->EditValue;
            }

            // MaleMembers
            $this->MaleMembers->setupEditAttributes();
            $this->MaleMembers->EditValue = $this->MaleMembers->CurrentValue;
            $this->MaleMembers->PlaceHolder = RemoveHtml($this->MaleMembers->caption());
            if (strval($this->MaleMembers->EditValue) != "" && is_numeric($this->MaleMembers->EditValue)) {
                $this->MaleMembers->EditValue = $this->MaleMembers->EditValue;
            }

            // YoungFemales
            $this->YoungFemales->setupEditAttributes();
            $this->YoungFemales->EditValue = $this->YoungFemales->CurrentValue;
            $this->YoungFemales->PlaceHolder = RemoveHtml($this->YoungFemales->caption());
            if (strval($this->YoungFemales->EditValue) != "" && is_numeric($this->YoungFemales->EditValue)) {
                $this->YoungFemales->EditValue = $this->YoungFemales->EditValue;
            }

            // YoungMales
            $this->YoungMales->setupEditAttributes();
            $this->YoungMales->EditValue = $this->YoungMales->CurrentValue;
            $this->YoungMales->PlaceHolder = RemoveHtml($this->YoungMales->caption());
            if (strval($this->YoungMales->EditValue) != "" && is_numeric($this->YoungMales->EditValue)) {
                $this->YoungMales->EditValue = $this->YoungMales->EditValue;
            }

            // FemalesInManagement
            $this->FemalesInManagement->setupEditAttributes();
            $this->FemalesInManagement->EditValue = $this->FemalesInManagement->CurrentValue;
            $this->FemalesInManagement->PlaceHolder = RemoveHtml($this->FemalesInManagement->caption());
            if (strval($this->FemalesInManagement->EditValue) != "" && is_numeric($this->FemalesInManagement->EditValue)) {
                $this->FemalesInManagement->EditValue = $this->FemalesInManagement->EditValue;
            }

            // MalesInManagement
            $this->MalesInManagement->setupEditAttributes();
            $this->MalesInManagement->EditValue = $this->MalesInManagement->CurrentValue;
            $this->MalesInManagement->PlaceHolder = RemoveHtml($this->MalesInManagement->caption());
            if (strval($this->MalesInManagement->EditValue) != "" && is_numeric($this->MalesInManagement->EditValue)) {
                $this->MalesInManagement->EditValue = $this->MalesInManagement->EditValue;
            }

            // Latitude
            $this->Latitude->setupEditAttributes();
            $this->Latitude->EditValue = $this->Latitude->CurrentValue;
            $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
            if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
                $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
            }

            // Longitude
            $this->Longitude->setupEditAttributes();
            $this->Longitude->EditValue = $this->Longitude->CurrentValue;
            $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
            if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
                $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
            }

            // Edit refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";

            // NurseryType
            $this->NurseryType->HrefValue = "";

            // PhysicalAddress
            $this->PhysicalAddress->HrefValue = "";

            // PostalAddress
            $this->PostalAddress->HrefValue = "";

            // Phone
            $this->Phone->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // NurseryOwnership
            $this->NurseryOwnership->HrefValue = "";

            // SeedVariety
            $this->SeedVariety->HrefValue = "";

            // NumberOfMembers
            $this->NumberOfMembers->HrefValue = "";

            // FemaleMembers
            $this->FemaleMembers->HrefValue = "";

            // MaleMembers
            $this->MaleMembers->HrefValue = "";

            // YoungFemales
            $this->YoungFemales->HrefValue = "";

            // YoungMales
            $this->YoungMales->HrefValue = "";

            // FemalesInManagement
            $this->FemalesInManagement->HrefValue = "";

            // MalesInManagement
            $this->MalesInManagement->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->NurseryCode->Visible && $this->NurseryCode->Required) {
                if (!$this->NurseryCode->IsDetailKey && EmptyValue($this->NurseryCode->FormValue)) {
                    $this->NurseryCode->addErrorMessage(str_replace("%s", $this->NurseryCode->caption(), $this->NurseryCode->RequiredErrorMessage));
                }
            }
            if ($this->NurseryName->Visible && $this->NurseryName->Required) {
                if (!$this->NurseryName->IsDetailKey && EmptyValue($this->NurseryName->FormValue)) {
                    $this->NurseryName->addErrorMessage(str_replace("%s", $this->NurseryName->caption(), $this->NurseryName->RequiredErrorMessage));
                }
            }
            if ($this->NurseryType->Visible && $this->NurseryType->Required) {
                if (!$this->NurseryType->IsDetailKey && EmptyValue($this->NurseryType->FormValue)) {
                    $this->NurseryType->addErrorMessage(str_replace("%s", $this->NurseryType->caption(), $this->NurseryType->RequiredErrorMessage));
                }
            }
            if ($this->PhysicalAddress->Visible && $this->PhysicalAddress->Required) {
                if (!$this->PhysicalAddress->IsDetailKey && EmptyValue($this->PhysicalAddress->FormValue)) {
                    $this->PhysicalAddress->addErrorMessage(str_replace("%s", $this->PhysicalAddress->caption(), $this->PhysicalAddress->RequiredErrorMessage));
                }
            }
            if ($this->PostalAddress->Visible && $this->PostalAddress->Required) {
                if (!$this->PostalAddress->IsDetailKey && EmptyValue($this->PostalAddress->FormValue)) {
                    $this->PostalAddress->addErrorMessage(str_replace("%s", $this->PostalAddress->caption(), $this->PostalAddress->RequiredErrorMessage));
                }
            }
            if ($this->Phone->Visible && $this->Phone->Required) {
                if (!$this->Phone->IsDetailKey && EmptyValue($this->Phone->FormValue)) {
                    $this->Phone->addErrorMessage(str_replace("%s", $this->Phone->caption(), $this->Phone->RequiredErrorMessage));
                }
            }
            if ($this->_Email->Visible && $this->_Email->Required) {
                if (!$this->_Email->IsDetailKey && EmptyValue($this->_Email->FormValue)) {
                    $this->_Email->addErrorMessage(str_replace("%s", $this->_Email->caption(), $this->_Email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_Email->FormValue)) {
                $this->_Email->addErrorMessage($this->_Email->getErrorMessage(false));
            }
            if ($this->NurseryOwnership->Visible && $this->NurseryOwnership->Required) {
                if (!$this->NurseryOwnership->IsDetailKey && EmptyValue($this->NurseryOwnership->FormValue)) {
                    $this->NurseryOwnership->addErrorMessage(str_replace("%s", $this->NurseryOwnership->caption(), $this->NurseryOwnership->RequiredErrorMessage));
                }
            }
            if ($this->SeedVariety->Visible && $this->SeedVariety->Required) {
                if (!$this->SeedVariety->IsDetailKey && EmptyValue($this->SeedVariety->FormValue)) {
                    $this->SeedVariety->addErrorMessage(str_replace("%s", $this->SeedVariety->caption(), $this->SeedVariety->RequiredErrorMessage));
                }
            }
            if ($this->NumberOfMembers->Visible && $this->NumberOfMembers->Required) {
                if (!$this->NumberOfMembers->IsDetailKey && EmptyValue($this->NumberOfMembers->FormValue)) {
                    $this->NumberOfMembers->addErrorMessage(str_replace("%s", $this->NumberOfMembers->caption(), $this->NumberOfMembers->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->NumberOfMembers->FormValue)) {
                $this->NumberOfMembers->addErrorMessage($this->NumberOfMembers->getErrorMessage(false));
            }
            if ($this->FemaleMembers->Visible && $this->FemaleMembers->Required) {
                if (!$this->FemaleMembers->IsDetailKey && EmptyValue($this->FemaleMembers->FormValue)) {
                    $this->FemaleMembers->addErrorMessage(str_replace("%s", $this->FemaleMembers->caption(), $this->FemaleMembers->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FemaleMembers->FormValue)) {
                $this->FemaleMembers->addErrorMessage($this->FemaleMembers->getErrorMessage(false));
            }
            if ($this->MaleMembers->Visible && $this->MaleMembers->Required) {
                if (!$this->MaleMembers->IsDetailKey && EmptyValue($this->MaleMembers->FormValue)) {
                    $this->MaleMembers->addErrorMessage(str_replace("%s", $this->MaleMembers->caption(), $this->MaleMembers->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->MaleMembers->FormValue)) {
                $this->MaleMembers->addErrorMessage($this->MaleMembers->getErrorMessage(false));
            }
            if ($this->YoungFemales->Visible && $this->YoungFemales->Required) {
                if (!$this->YoungFemales->IsDetailKey && EmptyValue($this->YoungFemales->FormValue)) {
                    $this->YoungFemales->addErrorMessage(str_replace("%s", $this->YoungFemales->caption(), $this->YoungFemales->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->YoungFemales->FormValue)) {
                $this->YoungFemales->addErrorMessage($this->YoungFemales->getErrorMessage(false));
            }
            if ($this->YoungMales->Visible && $this->YoungMales->Required) {
                if (!$this->YoungMales->IsDetailKey && EmptyValue($this->YoungMales->FormValue)) {
                    $this->YoungMales->addErrorMessage(str_replace("%s", $this->YoungMales->caption(), $this->YoungMales->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->YoungMales->FormValue)) {
                $this->YoungMales->addErrorMessage($this->YoungMales->getErrorMessage(false));
            }
            if ($this->FemalesInManagement->Visible && $this->FemalesInManagement->Required) {
                if (!$this->FemalesInManagement->IsDetailKey && EmptyValue($this->FemalesInManagement->FormValue)) {
                    $this->FemalesInManagement->addErrorMessage(str_replace("%s", $this->FemalesInManagement->caption(), $this->FemalesInManagement->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FemalesInManagement->FormValue)) {
                $this->FemalesInManagement->addErrorMessage($this->FemalesInManagement->getErrorMessage(false));
            }
            if ($this->MalesInManagement->Visible && $this->MalesInManagement->Required) {
                if (!$this->MalesInManagement->IsDetailKey && EmptyValue($this->MalesInManagement->FormValue)) {
                    $this->MalesInManagement->addErrorMessage(str_replace("%s", $this->MalesInManagement->caption(), $this->MalesInManagement->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->MalesInManagement->FormValue)) {
                $this->MalesInManagement->addErrorMessage($this->MalesInManagement->getErrorMessage(false));
            }
            if ($this->Latitude->Visible && $this->Latitude->Required) {
                if (!$this->Latitude->IsDetailKey && EmptyValue($this->Latitude->FormValue)) {
                    $this->Latitude->addErrorMessage(str_replace("%s", $this->Latitude->caption(), $this->Latitude->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Latitude->FormValue)) {
                $this->Latitude->addErrorMessage($this->Latitude->getErrorMessage(false));
            }
            if ($this->Longitude->Visible && $this->Longitude->Required) {
                if (!$this->Longitude->IsDetailKey && EmptyValue($this->Longitude->FormValue)) {
                    $this->Longitude->addErrorMessage(str_replace("%s", $this->Longitude->caption(), $this->Longitude->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Longitude->FormValue)) {
                $this->Longitude->addErrorMessage($this->Longitude->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        if ($this->ProvinceCode->getSessionValue() != "") {
            $this->ProvinceCode->ReadOnly = true;
        }
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, $this->ProvinceCode->ReadOnly);

        // DistrictCode
        if ($this->DistrictCode->getSessionValue() != "") {
            $this->DistrictCode->ReadOnly = true;
        }
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, $this->DistrictCode->ReadOnly);

        // NurseryName
        $this->NurseryName->setDbValueDef($rsnew, $this->NurseryName->CurrentValue, $this->NurseryName->ReadOnly);

        // NurseryType
        $this->NurseryType->setDbValueDef($rsnew, $this->NurseryType->CurrentValue, $this->NurseryType->ReadOnly);

        // PhysicalAddress
        $this->PhysicalAddress->setDbValueDef($rsnew, $this->PhysicalAddress->CurrentValue, $this->PhysicalAddress->ReadOnly);

        // PostalAddress
        $this->PostalAddress->setDbValueDef($rsnew, $this->PostalAddress->CurrentValue, $this->PostalAddress->ReadOnly);

        // Phone
        $this->Phone->setDbValueDef($rsnew, $this->Phone->CurrentValue, $this->Phone->ReadOnly);

        // Email
        $this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, $this->_Email->ReadOnly);

        // NurseryOwnership
        $this->NurseryOwnership->setDbValueDef($rsnew, $this->NurseryOwnership->CurrentValue, $this->NurseryOwnership->ReadOnly);

        // SeedVariety
        $this->SeedVariety->setDbValueDef($rsnew, $this->SeedVariety->CurrentValue, $this->SeedVariety->ReadOnly);

        // NumberOfMembers
        $this->NumberOfMembers->setDbValueDef($rsnew, $this->NumberOfMembers->CurrentValue, $this->NumberOfMembers->ReadOnly);

        // FemaleMembers
        $this->FemaleMembers->setDbValueDef($rsnew, $this->FemaleMembers->CurrentValue, $this->FemaleMembers->ReadOnly);

        // MaleMembers
        $this->MaleMembers->setDbValueDef($rsnew, $this->MaleMembers->CurrentValue, $this->MaleMembers->ReadOnly);

        // YoungFemales
        $this->YoungFemales->setDbValueDef($rsnew, $this->YoungFemales->CurrentValue, $this->YoungFemales->ReadOnly);

        // YoungMales
        $this->YoungMales->setDbValueDef($rsnew, $this->YoungMales->CurrentValue, $this->YoungMales->ReadOnly);

        // FemalesInManagement
        $this->FemalesInManagement->setDbValueDef($rsnew, $this->FemalesInManagement->CurrentValue, $this->FemalesInManagement->ReadOnly);

        // MalesInManagement
        $this->MalesInManagement->setDbValueDef($rsnew, $this->MalesInManagement->CurrentValue, $this->MalesInManagement->ReadOnly);

        // Latitude
        $this->Latitude->setDbValueDef($rsnew, $this->Latitude->CurrentValue, $this->Latitude->ReadOnly);

        // Longitude
        $this->Longitude->setDbValueDef($rsnew, $this->Longitude->CurrentValue, $this->Longitude->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->CurrentValue = $row['ProvinceCode'];
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->CurrentValue = $row['DistrictCode'];
        }
        if (isset($row['NurseryName'])) { // NurseryName
            $this->NurseryName->CurrentValue = $row['NurseryName'];
        }
        if (isset($row['NurseryType'])) { // NurseryType
            $this->NurseryType->CurrentValue = $row['NurseryType'];
        }
        if (isset($row['PhysicalAddress'])) { // PhysicalAddress
            $this->PhysicalAddress->CurrentValue = $row['PhysicalAddress'];
        }
        if (isset($row['PostalAddress'])) { // PostalAddress
            $this->PostalAddress->CurrentValue = $row['PostalAddress'];
        }
        if (isset($row['Phone'])) { // Phone
            $this->Phone->CurrentValue = $row['Phone'];
        }
        if (isset($row['Email'])) { // Email
            $this->_Email->CurrentValue = $row['Email'];
        }
        if (isset($row['NurseryOwnership'])) { // NurseryOwnership
            $this->NurseryOwnership->CurrentValue = $row['NurseryOwnership'];
        }
        if (isset($row['SeedVariety'])) { // SeedVariety
            $this->SeedVariety->CurrentValue = $row['SeedVariety'];
        }
        if (isset($row['NumberOfMembers'])) { // NumberOfMembers
            $this->NumberOfMembers->CurrentValue = $row['NumberOfMembers'];
        }
        if (isset($row['FemaleMembers'])) { // FemaleMembers
            $this->FemaleMembers->CurrentValue = $row['FemaleMembers'];
        }
        if (isset($row['MaleMembers'])) { // MaleMembers
            $this->MaleMembers->CurrentValue = $row['MaleMembers'];
        }
        if (isset($row['YoungFemales'])) { // YoungFemales
            $this->YoungFemales->CurrentValue = $row['YoungFemales'];
        }
        if (isset($row['YoungMales'])) { // YoungMales
            $this->YoungMales->CurrentValue = $row['YoungMales'];
        }
        if (isset($row['FemalesInManagement'])) { // FemalesInManagement
            $this->FemalesInManagement->CurrentValue = $row['FemalesInManagement'];
        }
        if (isset($row['MalesInManagement'])) { // MalesInManagement
            $this->MalesInManagement->CurrentValue = $row['MalesInManagement'];
        }
        if (isset($row['Latitude'])) { // Latitude
            $this->Latitude->CurrentValue = $row['Latitude'];
        }
        if (isset($row['Longitude'])) { // Longitude
            $this->Longitude->CurrentValue = $row['Longitude'];
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "district") {
                $validMaster = true;
                $masterTbl = Container("district");
                if (($parm = Get("fk_ProvinceCode", Get("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setQueryStringValue($parm);
                    $this->ProvinceCode->QueryStringValue = $masterTbl->ProvinceCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->QueryStringValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->QueryStringValue;
                    if (!is_numeric($masterTbl->ProvinceCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_DistrictCode", Get("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setQueryStringValue($parm);
                    $this->DistrictCode->QueryStringValue = $masterTbl->DistrictCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->DistrictCode->setSessionValue($this->DistrictCode->QueryStringValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->QueryStringValue;
                    if (!is_numeric($masterTbl->DistrictCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "district") {
                $validMaster = true;
                $masterTbl = Container("district");
                if (($parm = Post("fk_ProvinceCode", Post("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setFormValue($parm);
                    $this->ProvinceCode->FormValue = $masterTbl->ProvinceCode->FormValue;
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->FormValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->FormValue;
                    if (!is_numeric($masterTbl->ProvinceCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_DistrictCode", Post("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setFormValue($parm);
                    $this->DistrictCode->FormValue = $masterTbl->DistrictCode->FormValue;
                    $this->DistrictCode->setSessionValue($this->DistrictCode->FormValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->FormValue;
                    if (!is_numeric($masterTbl->DistrictCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "district") {
                if (!array_key_exists("ProvinceCode", $foreignKeys)) { // Not current foreign key
                    $this->ProvinceCode->setSessionValue("");
                }
                if (!array_key_exists("DistrictCode", $foreignKeys)) { // Not current foreign key
                    $this->DistrictCode->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("NurseryList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_NurseryType":
                    break;
                case "x_NurseryOwnership":
                    break;
                case "x_SeedVariety":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
