<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MusersAdd extends Musers
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MusersAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "MusersAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->UserCode->Visible = false;
        $this->_UserName->setVisibility();
        $this->_Password->setVisibility();
        $this->ConfirmPwd->setVisibility();
        $this->FirstName->setVisibility();
        $this->LastName->setVisibility();
        $this->Level->setVisibility();
        $this->Role->setVisibility();
        $this->Clearance->setVisibility();
        $this->Active->setVisibility();
        $this->_Email->setVisibility();
        $this->Telephone->setVisibility();
        $this->Mobile->setVisibility();
        $this->Position->setVisibility();
        $this->ReportsTo->setVisibility();
        $this->_Profile->setVisibility();
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'musers';
        $this->TableName = 'musers';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (musers)
        if (!isset($GLOBALS["musers"]) || $GLOBALS["musers"]::class == PROJECT_NAMESPACE . "musers") {
            $GLOBALS["musers"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'musers');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "MusersView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['UserCode'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->UserCode->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Level);
        $this->setupLookupOptions($this->Role);
        $this->setupLookupOptions($this->Clearance);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("UserCode") ?? Route("UserCode")) !== null) {
                $this->UserCode->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("MusersList"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "MusersList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "MusersView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "MusersList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "MusersList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->Level->DefaultValue = $this->Level->getDefault(); // PHP
        $this->Level->OldValue = $this->Level->DefaultValue;
        $this->Clearance->DefaultValue = $this->Clearance->getDefault(); // PHP
        $this->Clearance->OldValue = $this->Clearance->DefaultValue;
        $this->Active->DefaultValue = $this->Active->getDefault(); // PHP
        $this->Active->OldValue = $this->Active->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'UserName' first before field var 'x__UserName'
        $val = $CurrentForm->hasValue("UserName") ? $CurrentForm->getValue("UserName") : $CurrentForm->getValue("x__UserName");
        if (!$this->_UserName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_UserName->Visible = false; // Disable update for API request
            } else {
                $this->_UserName->setFormValue($val);
            }
        }

        // Check field name 'Password' first before field var 'x__Password'
        $val = $CurrentForm->hasValue("Password") ? $CurrentForm->getValue("Password") : $CurrentForm->getValue("x__Password");
        if (!$this->_Password->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Password->Visible = false; // Disable update for API request
            } else {
                $this->_Password->setFormValue($val);
            }
        }

        // Check field name 'ConfirmPwd' first before field var 'x_ConfirmPwd'
        $val = $CurrentForm->hasValue("ConfirmPwd") ? $CurrentForm->getValue("ConfirmPwd") : $CurrentForm->getValue("x_ConfirmPwd");
        if (!$this->ConfirmPwd->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ConfirmPwd->Visible = false; // Disable update for API request
            } else {
                $this->ConfirmPwd->setFormValue($val);
            }
        }

        // Check field name 'FirstName' first before field var 'x_FirstName'
        $val = $CurrentForm->hasValue("FirstName") ? $CurrentForm->getValue("FirstName") : $CurrentForm->getValue("x_FirstName");
        if (!$this->FirstName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FirstName->Visible = false; // Disable update for API request
            } else {
                $this->FirstName->setFormValue($val);
            }
        }

        // Check field name 'LastName' first before field var 'x_LastName'
        $val = $CurrentForm->hasValue("LastName") ? $CurrentForm->getValue("LastName") : $CurrentForm->getValue("x_LastName");
        if (!$this->LastName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->LastName->Visible = false; // Disable update for API request
            } else {
                $this->LastName->setFormValue($val);
            }
        }

        // Check field name 'Level' first before field var 'x_Level'
        $val = $CurrentForm->hasValue("Level") ? $CurrentForm->getValue("Level") : $CurrentForm->getValue("x_Level");
        if (!$this->Level->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Level->Visible = false; // Disable update for API request
            } else {
                $this->Level->setFormValue($val);
            }
        }

        // Check field name 'Role' first before field var 'x_Role'
        $val = $CurrentForm->hasValue("Role") ? $CurrentForm->getValue("Role") : $CurrentForm->getValue("x_Role");
        if (!$this->Role->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Role->Visible = false; // Disable update for API request
            } else {
                $this->Role->setFormValue($val);
            }
        }

        // Check field name 'Clearance' first before field var 'x_Clearance'
        $val = $CurrentForm->hasValue("Clearance") ? $CurrentForm->getValue("Clearance") : $CurrentForm->getValue("x_Clearance");
        if (!$this->Clearance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Clearance->Visible = false; // Disable update for API request
            } else {
                $this->Clearance->setFormValue($val);
            }
        }

        // Check field name 'Active' first before field var 'x_Active'
        $val = $CurrentForm->hasValue("Active") ? $CurrentForm->getValue("Active") : $CurrentForm->getValue("x_Active");
        if (!$this->Active->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Active->Visible = false; // Disable update for API request
            } else {
                $this->Active->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Email' first before field var 'x__Email'
        $val = $CurrentForm->hasValue("Email") ? $CurrentForm->getValue("Email") : $CurrentForm->getValue("x__Email");
        if (!$this->_Email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Email->Visible = false; // Disable update for API request
            } else {
                $this->_Email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Telephone' first before field var 'x_Telephone'
        $val = $CurrentForm->hasValue("Telephone") ? $CurrentForm->getValue("Telephone") : $CurrentForm->getValue("x_Telephone");
        if (!$this->Telephone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Telephone->Visible = false; // Disable update for API request
            } else {
                $this->Telephone->setFormValue($val);
            }
        }

        // Check field name 'Mobile' first before field var 'x_Mobile'
        $val = $CurrentForm->hasValue("Mobile") ? $CurrentForm->getValue("Mobile") : $CurrentForm->getValue("x_Mobile");
        if (!$this->Mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Mobile->Visible = false; // Disable update for API request
            } else {
                $this->Mobile->setFormValue($val);
            }
        }

        // Check field name 'Position' first before field var 'x_Position'
        $val = $CurrentForm->hasValue("Position") ? $CurrentForm->getValue("Position") : $CurrentForm->getValue("x_Position");
        if (!$this->Position->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Position->Visible = false; // Disable update for API request
            } else {
                $this->Position->setFormValue($val);
            }
        }

        // Check field name 'ReportsTo' first before field var 'x_ReportsTo'
        $val = $CurrentForm->hasValue("ReportsTo") ? $CurrentForm->getValue("ReportsTo") : $CurrentForm->getValue("x_ReportsTo");
        if (!$this->ReportsTo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ReportsTo->Visible = false; // Disable update for API request
            } else {
                $this->ReportsTo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Profile' first before field var 'x__Profile'
        $val = $CurrentForm->hasValue("Profile") ? $CurrentForm->getValue("Profile") : $CurrentForm->getValue("x__Profile");
        if (!$this->_Profile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Profile->Visible = false; // Disable update for API request
            } else {
                $this->_Profile->setFormValue($val);
            }
        }

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'UserCode' first before field var 'x_UserCode'
        $val = $CurrentForm->hasValue("UserCode") ? $CurrentForm->getValue("UserCode") : $CurrentForm->getValue("x_UserCode");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->_UserName->CurrentValue = $this->_UserName->FormValue;
        $this->_Password->CurrentValue = $this->_Password->FormValue;
        $this->ConfirmPwd->CurrentValue = $this->ConfirmPwd->FormValue;
        $this->FirstName->CurrentValue = $this->FirstName->FormValue;
        $this->LastName->CurrentValue = $this->LastName->FormValue;
        $this->Level->CurrentValue = $this->Level->FormValue;
        $this->Role->CurrentValue = $this->Role->FormValue;
        $this->Clearance->CurrentValue = $this->Clearance->FormValue;
        $this->Active->CurrentValue = $this->Active->FormValue;
        $this->_Email->CurrentValue = $this->_Email->FormValue;
        $this->Telephone->CurrentValue = $this->Telephone->FormValue;
        $this->Mobile->CurrentValue = $this->Mobile->FormValue;
        $this->Position->CurrentValue = $this->Position->FormValue;
        $this->ReportsTo->CurrentValue = $this->ReportsTo->FormValue;
        $this->_Profile->CurrentValue = $this->_Profile->FormValue;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->UserCode->setDbValue($row['UserCode']);
        $this->_UserName->setDbValue($row['UserName']);
        $this->_Password->setDbValue($row['Password']);
        $this->ConfirmPwd->setDbValue($row['ConfirmPwd']);
        $this->FirstName->setDbValue($row['FirstName']);
        $this->LastName->setDbValue($row['LastName']);
        $this->Level->setDbValue($row['Level']);
        $this->Role->setDbValue($row['Role']);
        $this->Clearance->setDbValue($row['Clearance']);
        $this->Active->setDbValue($row['Active']);
        $this->_Email->setDbValue($row['Email']);
        $this->Telephone->setDbValue($row['Telephone']);
        $this->Mobile->setDbValue($row['Mobile']);
        $this->Position->setDbValue($row['Position']);
        $this->ReportsTo->setDbValue($row['ReportsTo']);
        $this->_Profile->setDbValue($row['Profile']);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['UserCode'] = $this->UserCode->DefaultValue;
        $row['UserName'] = $this->_UserName->DefaultValue;
        $row['Password'] = $this->_Password->DefaultValue;
        $row['ConfirmPwd'] = $this->ConfirmPwd->DefaultValue;
        $row['FirstName'] = $this->FirstName->DefaultValue;
        $row['LastName'] = $this->LastName->DefaultValue;
        $row['Level'] = $this->Level->DefaultValue;
        $row['Role'] = $this->Role->DefaultValue;
        $row['Clearance'] = $this->Clearance->DefaultValue;
        $row['Active'] = $this->Active->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['Telephone'] = $this->Telephone->DefaultValue;
        $row['Mobile'] = $this->Mobile->DefaultValue;
        $row['Position'] = $this->Position->DefaultValue;
        $row['ReportsTo'] = $this->ReportsTo->DefaultValue;
        $row['Profile'] = $this->_Profile->DefaultValue;
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // UserCode
        $this->UserCode->RowCssClass = "row";

        // UserName
        $this->_UserName->RowCssClass = "row";

        // Password
        $this->_Password->RowCssClass = "row";

        // ConfirmPwd
        $this->ConfirmPwd->RowCssClass = "row";

        // FirstName
        $this->FirstName->RowCssClass = "row";

        // LastName
        $this->LastName->RowCssClass = "row";

        // Level
        $this->Level->RowCssClass = "row";

        // Role
        $this->Role->RowCssClass = "row";

        // Clearance
        $this->Clearance->RowCssClass = "row";

        // Active
        $this->Active->RowCssClass = "row";

        // Email
        $this->_Email->RowCssClass = "row";

        // Telephone
        $this->Telephone->RowCssClass = "row";

        // Mobile
        $this->Mobile->RowCssClass = "row";

        // Position
        $this->Position->RowCssClass = "row";

        // ReportsTo
        $this->ReportsTo->RowCssClass = "row";

        // Profile
        $this->_Profile->RowCssClass = "row";

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // UserCode
            $this->UserCode->ViewValue = $this->UserCode->CurrentValue;

            // UserName
            $this->_UserName->ViewValue = $this->_UserName->CurrentValue;

            // Password
            $this->_Password->ViewValue = $Language->phrase("PasswordMask");

            // ConfirmPwd
            $this->ConfirmPwd->ViewValue = $Language->phrase("PasswordMask");

            // FirstName
            $this->FirstName->ViewValue = $this->FirstName->CurrentValue;

            // LastName
            $this->LastName->ViewValue = $this->LastName->CurrentValue;

            // Level
            if ($Security->canAdmin()) { // System admin
                $curVal = strval($this->Level->CurrentValue);
                if ($curVal != "") {
                    $this->Level->ViewValue = $this->Level->lookupCacheOption($curVal);
                    if ($this->Level->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->Level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $curVal, $this->Level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                        $sqlWrk = $this->Level->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->Level->Lookup->renderViewRow($rswrk[0]);
                            $this->Level->ViewValue = $this->Level->displayValue($arwrk);
                        } else {
                            $this->Level->ViewValue = $this->Level->CurrentValue;
                        }
                    }
                } else {
                    $this->Level->ViewValue = null;
                }
            } else {
                $this->Level->ViewValue = $Language->phrase("PasswordMask");
            }

            // Role
            $curVal = strval($this->Role->CurrentValue);
            if ($curVal != "") {
                $this->Role->ViewValue = $this->Role->lookupCacheOption($curVal);
                if ($this->Role->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Role->Lookup->getTable()->Fields["Role"]->searchExpression(), "=", $curVal, $this->Role->Lookup->getTable()->Fields["Role"]->searchDataType(), "");
                    $sqlWrk = $this->Role->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Role->Lookup->renderViewRow($rswrk[0]);
                        $this->Role->ViewValue = $this->Role->displayValue($arwrk);
                    } else {
                        $this->Role->ViewValue = $this->Role->CurrentValue;
                    }
                }
            } else {
                $this->Role->ViewValue = null;
            }

            // Clearance
            $curVal = strval($this->Clearance->CurrentValue);
            if ($curVal != "") {
                $this->Clearance->ViewValue = $this->Clearance->lookupCacheOption($curVal);
                if ($this->Clearance->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Clearance->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $curVal, $this->Clearance->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                    $sqlWrk = $this->Clearance->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Clearance->Lookup->renderViewRow($rswrk[0]);
                        $this->Clearance->ViewValue = $this->Clearance->displayValue($arwrk);
                    } else {
                        $this->Clearance->ViewValue = $this->Clearance->CurrentValue;
                    }
                }
            } else {
                $this->Clearance->ViewValue = null;
            }

            // Active
            $this->Active->ViewValue = $this->Active->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // Telephone
            $this->Telephone->ViewValue = $this->Telephone->CurrentValue;

            // Mobile
            $this->Mobile->ViewValue = $this->Mobile->CurrentValue;

            // Position
            $this->Position->ViewValue = $this->Position->CurrentValue;

            // ReportsTo
            $this->ReportsTo->ViewValue = $this->ReportsTo->CurrentValue;

            // Profile
            $this->_Profile->ViewValue = $this->_Profile->CurrentValue;

            // ProvinceCode
            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;

            // DistrictCode
            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;

            // UserName
            $this->_UserName->HrefValue = "";

            // Password
            $this->_Password->HrefValue = "";

            // ConfirmPwd
            $this->ConfirmPwd->HrefValue = "";

            // FirstName
            $this->FirstName->HrefValue = "";

            // LastName
            $this->LastName->HrefValue = "";

            // Level
            $this->Level->HrefValue = "";

            // Role
            $this->Role->HrefValue = "";

            // Clearance
            $this->Clearance->HrefValue = "";

            // Active
            $this->Active->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Telephone
            $this->Telephone->HrefValue = "";

            // Mobile
            $this->Mobile->HrefValue = "";

            // Position
            $this->Position->HrefValue = "";

            // ReportsTo
            $this->ReportsTo->HrefValue = "";

            // Profile
            $this->_Profile->HrefValue = "";

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // UserName
            $this->_UserName->setupEditAttributes();
            if (!$this->_UserName->Raw) {
                $this->_UserName->CurrentValue = HtmlDecode($this->_UserName->CurrentValue);
            }
            $this->_UserName->EditValue = HtmlEncode($this->_UserName->CurrentValue);
            $this->_UserName->PlaceHolder = RemoveHtml($this->_UserName->caption());

            // Password
            $this->_Password->setupEditAttributes(["class" => "ew-password-strength"]);
            $this->_Password->PlaceHolder = RemoveHtml($this->_Password->caption());

            // ConfirmPwd
            $this->ConfirmPwd->setupEditAttributes();
            $this->ConfirmPwd->PlaceHolder = RemoveHtml($this->ConfirmPwd->caption());

            // FirstName
            $this->FirstName->setupEditAttributes();
            if (!$this->FirstName->Raw) {
                $this->FirstName->CurrentValue = HtmlDecode($this->FirstName->CurrentValue);
            }
            $this->FirstName->EditValue = HtmlEncode($this->FirstName->CurrentValue);
            $this->FirstName->PlaceHolder = RemoveHtml($this->FirstName->caption());

            // LastName
            $this->LastName->setupEditAttributes();
            if (!$this->LastName->Raw) {
                $this->LastName->CurrentValue = HtmlDecode($this->LastName->CurrentValue);
            }
            $this->LastName->EditValue = HtmlEncode($this->LastName->CurrentValue);
            $this->LastName->PlaceHolder = RemoveHtml($this->LastName->caption());

            // Level
            $this->Level->setupEditAttributes();
            if (!$Security->canAdmin()) { // System admin
                $this->Level->EditValue = $Language->phrase("PasswordMask");
            } else {
                $curVal = trim(strval($this->Level->CurrentValue));
                if ($curVal != "") {
                    $this->Level->ViewValue = $this->Level->lookupCacheOption($curVal);
                } else {
                    $this->Level->ViewValue = $this->Level->Lookup !== null && is_array($this->Level->lookupOptions()) && count($this->Level->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->Level->ViewValue !== null) { // Load from cache
                    $this->Level->EditValue = array_values($this->Level->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->Level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $this->Level->CurrentValue, $this->Level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->Level->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->Level->EditValue = $arwrk;
                }
                $this->Level->PlaceHolder = RemoveHtml($this->Level->caption());
            }

            // Role
            $this->Role->setupEditAttributes();
            $curVal = trim(strval($this->Role->CurrentValue));
            if ($curVal != "") {
                $this->Role->ViewValue = $this->Role->lookupCacheOption($curVal);
            } else {
                $this->Role->ViewValue = $this->Role->Lookup !== null && is_array($this->Role->lookupOptions()) && count($this->Role->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Role->ViewValue !== null) { // Load from cache
                $this->Role->EditValue = array_values($this->Role->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Role->Lookup->getTable()->Fields["Role"]->searchExpression(), "=", $this->Role->CurrentValue, $this->Role->Lookup->getTable()->Fields["Role"]->searchDataType(), "");
                }
                $sqlWrk = $this->Role->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Role->EditValue = $arwrk;
            }
            $this->Role->PlaceHolder = RemoveHtml($this->Role->caption());

            // Clearance
            $this->Clearance->setupEditAttributes();
            $curVal = trim(strval($this->Clearance->CurrentValue));
            if ($curVal != "") {
                $this->Clearance->ViewValue = $this->Clearance->lookupCacheOption($curVal);
            } else {
                $this->Clearance->ViewValue = $this->Clearance->Lookup !== null && is_array($this->Clearance->lookupOptions()) && count($this->Clearance->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Clearance->ViewValue !== null) { // Load from cache
                $this->Clearance->EditValue = array_values($this->Clearance->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Clearance->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $this->Clearance->CurrentValue, $this->Clearance->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                }
                $sqlWrk = $this->Clearance->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Clearance->EditValue = $arwrk;
            }
            $this->Clearance->PlaceHolder = RemoveHtml($this->Clearance->caption());

            // Active
            $this->Active->setupEditAttributes();
            $this->Active->EditValue = $this->Active->CurrentValue;
            $this->Active->PlaceHolder = RemoveHtml($this->Active->caption());
            if (strval($this->Active->EditValue) != "" && is_numeric($this->Active->EditValue)) {
                $this->Active->EditValue = $this->Active->EditValue;
            }

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // Telephone
            $this->Telephone->setupEditAttributes();
            if (!$this->Telephone->Raw) {
                $this->Telephone->CurrentValue = HtmlDecode($this->Telephone->CurrentValue);
            }
            $this->Telephone->EditValue = HtmlEncode($this->Telephone->CurrentValue);
            $this->Telephone->PlaceHolder = RemoveHtml($this->Telephone->caption());

            // Mobile
            $this->Mobile->setupEditAttributes();
            if (!$this->Mobile->Raw) {
                $this->Mobile->CurrentValue = HtmlDecode($this->Mobile->CurrentValue);
            }
            $this->Mobile->EditValue = HtmlEncode($this->Mobile->CurrentValue);
            $this->Mobile->PlaceHolder = RemoveHtml($this->Mobile->caption());

            // Position
            $this->Position->setupEditAttributes();
            if (!$this->Position->Raw) {
                $this->Position->CurrentValue = HtmlDecode($this->Position->CurrentValue);
            }
            $this->Position->EditValue = HtmlEncode($this->Position->CurrentValue);
            $this->Position->PlaceHolder = RemoveHtml($this->Position->caption());

            // ReportsTo
            $this->ReportsTo->setupEditAttributes();
            $this->ReportsTo->EditValue = $this->ReportsTo->CurrentValue;
            $this->ReportsTo->PlaceHolder = RemoveHtml($this->ReportsTo->caption());
            if (strval($this->ReportsTo->EditValue) != "" && is_numeric($this->ReportsTo->EditValue)) {
                $this->ReportsTo->EditValue = $this->ReportsTo->EditValue;
            }

            // Profile
            $this->_Profile->setupEditAttributes();
            $this->_Profile->EditValue = HtmlEncode($this->_Profile->CurrentValue);
            $this->_Profile->PlaceHolder = RemoveHtml($this->_Profile->caption());

            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            $this->ProvinceCode->EditValue = $this->ProvinceCode->CurrentValue;
            $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            if (strval($this->ProvinceCode->EditValue) != "" && is_numeric($this->ProvinceCode->EditValue)) {
                $this->ProvinceCode->EditValue = $this->ProvinceCode->EditValue;
            }

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            $this->DistrictCode->EditValue = $this->DistrictCode->CurrentValue;
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            if (strval($this->DistrictCode->EditValue) != "" && is_numeric($this->DistrictCode->EditValue)) {
                $this->DistrictCode->EditValue = $this->DistrictCode->EditValue;
            }

            // Add refer script

            // UserName
            $this->_UserName->HrefValue = "";

            // Password
            $this->_Password->HrefValue = "";

            // ConfirmPwd
            $this->ConfirmPwd->HrefValue = "";

            // FirstName
            $this->FirstName->HrefValue = "";

            // LastName
            $this->LastName->HrefValue = "";

            // Level
            $this->Level->HrefValue = "";

            // Role
            $this->Role->HrefValue = "";

            // Clearance
            $this->Clearance->HrefValue = "";

            // Active
            $this->Active->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Telephone
            $this->Telephone->HrefValue = "";

            // Mobile
            $this->Mobile->HrefValue = "";

            // Position
            $this->Position->HrefValue = "";

            // ReportsTo
            $this->ReportsTo->HrefValue = "";

            // Profile
            $this->_Profile->HrefValue = "";

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->_UserName->Visible && $this->_UserName->Required) {
                if (!$this->_UserName->IsDetailKey && EmptyValue($this->_UserName->FormValue)) {
                    $this->_UserName->addErrorMessage(str_replace("%s", $this->_UserName->caption(), $this->_UserName->RequiredErrorMessage));
                }
            }
            if (!$this->_UserName->Raw && Config("REMOVE_XSS") && CheckUsername($this->_UserName->FormValue)) {
                $this->_UserName->addErrorMessage($Language->phrase("InvalidUsernameChars"));
            }
            if ($this->_Password->Visible && $this->_Password->Required) {
                if (!$this->_Password->IsDetailKey && EmptyValue($this->_Password->FormValue)) {
                    $this->_Password->addErrorMessage(str_replace("%s", $this->_Password->caption(), $this->_Password->RequiredErrorMessage));
                }
            }
            if (!$this->_Password->Raw && Config("REMOVE_XSS") && CheckPassword($this->_Password->FormValue)) {
                $this->_Password->addErrorMessage($Language->phrase("InvalidPasswordChars"));
            }
            if ($this->ConfirmPwd->Visible && $this->ConfirmPwd->Required) {
                if (!$this->ConfirmPwd->IsDetailKey && EmptyValue($this->ConfirmPwd->FormValue)) {
                    $this->ConfirmPwd->addErrorMessage(str_replace("%s", $this->ConfirmPwd->caption(), $this->ConfirmPwd->RequiredErrorMessage));
                }
            }
            if (!$this->ConfirmPwd->Raw && Config("REMOVE_XSS") && CheckPassword($this->ConfirmPwd->FormValue)) {
                $this->ConfirmPwd->addErrorMessage($Language->phrase("InvalidPasswordChars"));
            }
            if ($this->FirstName->Visible && $this->FirstName->Required) {
                if (!$this->FirstName->IsDetailKey && EmptyValue($this->FirstName->FormValue)) {
                    $this->FirstName->addErrorMessage(str_replace("%s", $this->FirstName->caption(), $this->FirstName->RequiredErrorMessage));
                }
            }
            if ($this->LastName->Visible && $this->LastName->Required) {
                if (!$this->LastName->IsDetailKey && EmptyValue($this->LastName->FormValue)) {
                    $this->LastName->addErrorMessage(str_replace("%s", $this->LastName->caption(), $this->LastName->RequiredErrorMessage));
                }
            }
            if ($this->Level->Visible && $this->Level->Required) {
                if ($Security->canAdmin() && !$this->Level->IsDetailKey && EmptyValue($this->Level->FormValue)) {
                    $this->Level->addErrorMessage(str_replace("%s", $this->Level->caption(), $this->Level->RequiredErrorMessage));
                }
            }
            if ($this->Role->Visible && $this->Role->Required) {
                if (!$this->Role->IsDetailKey && EmptyValue($this->Role->FormValue)) {
                    $this->Role->addErrorMessage(str_replace("%s", $this->Role->caption(), $this->Role->RequiredErrorMessage));
                }
            }
            if ($this->Clearance->Visible && $this->Clearance->Required) {
                if (!$this->Clearance->IsDetailKey && EmptyValue($this->Clearance->FormValue)) {
                    $this->Clearance->addErrorMessage(str_replace("%s", $this->Clearance->caption(), $this->Clearance->RequiredErrorMessage));
                }
            }
            if ($this->Active->Visible && $this->Active->Required) {
                if (!$this->Active->IsDetailKey && EmptyValue($this->Active->FormValue)) {
                    $this->Active->addErrorMessage(str_replace("%s", $this->Active->caption(), $this->Active->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->Active->FormValue)) {
                $this->Active->addErrorMessage($this->Active->getErrorMessage(false));
            }
            if ($this->_Email->Visible && $this->_Email->Required) {
                if (!$this->_Email->IsDetailKey && EmptyValue($this->_Email->FormValue)) {
                    $this->_Email->addErrorMessage(str_replace("%s", $this->_Email->caption(), $this->_Email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_Email->FormValue)) {
                $this->_Email->addErrorMessage($this->_Email->getErrorMessage(false));
            }
            if ($this->Telephone->Visible && $this->Telephone->Required) {
                if (!$this->Telephone->IsDetailKey && EmptyValue($this->Telephone->FormValue)) {
                    $this->Telephone->addErrorMessage(str_replace("%s", $this->Telephone->caption(), $this->Telephone->RequiredErrorMessage));
                }
            }
            if ($this->Mobile->Visible && $this->Mobile->Required) {
                if (!$this->Mobile->IsDetailKey && EmptyValue($this->Mobile->FormValue)) {
                    $this->Mobile->addErrorMessage(str_replace("%s", $this->Mobile->caption(), $this->Mobile->RequiredErrorMessage));
                }
            }
            if ($this->Position->Visible && $this->Position->Required) {
                if (!$this->Position->IsDetailKey && EmptyValue($this->Position->FormValue)) {
                    $this->Position->addErrorMessage(str_replace("%s", $this->Position->caption(), $this->Position->RequiredErrorMessage));
                }
            }
            if ($this->ReportsTo->Visible && $this->ReportsTo->Required) {
                if (!$this->ReportsTo->IsDetailKey && EmptyValue($this->ReportsTo->FormValue)) {
                    $this->ReportsTo->addErrorMessage(str_replace("%s", $this->ReportsTo->caption(), $this->ReportsTo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ReportsTo->FormValue)) {
                $this->ReportsTo->addErrorMessage($this->ReportsTo->getErrorMessage(false));
            }
            if ($this->_Profile->Visible && $this->_Profile->Required) {
                if (!$this->_Profile->IsDetailKey && EmptyValue($this->_Profile->FormValue)) {
                    $this->_Profile->addErrorMessage(str_replace("%s", $this->_Profile->caption(), $this->_Profile->RequiredErrorMessage));
                }
            }
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ProvinceCode->FormValue)) {
                $this->ProvinceCode->addErrorMessage($this->ProvinceCode->getErrorMessage(false));
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->DistrictCode->FormValue)) {
                $this->DistrictCode->addErrorMessage($this->DistrictCode->getErrorMessage(false));
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("SecurityMatrixGrid");
        if (in_array("security_matrix", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check if valid User ID
        if (
            !EmptyValue($Security->currentUserID()) &&
            !$Security->isAdmin() && // Non system admin
            !$Security->isValidUserID($this->UserCode->CurrentValue)
        ) {
            $userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
            $userIdMsg = str_replace("%u", strval($this->UserCode->CurrentValue), $userIdMsg);
            $this->setFailureMessage($userIdMsg);
            return false;
        }

        // Check if valid Parent User ID
        if (
            !EmptyValue($Security->currentUserID()) &&
            !EmptyValue($this->UserCode->CurrentValue) && // Allow empty value
            !$Security->isAdmin() && // Non system admin
            !$Security->isValidUserID($this->UserCode->CurrentValue)
        ) {
            $parentUserIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedParentUserID"));
            $parentUserIdMsg = str_replace("%p", strval($this->UserCode->CurrentValue), $parentUserIdMsg);
            $this->setFailureMessage($parentUserIdMsg);
            return false;
        }
        if ($this->_UserName->CurrentValue != "") { // Check field with unique index
            $filter = "(`UserName` = '" . AdjustSql($this->_UserName->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->_UserName->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->_UserName->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("SecurityMatrixGrid");
            if (in_array("security_matrix", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->UserCode->setSessionValue($this->UserCode->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "security_matrix"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->UserCode->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    if ($conn->isTransactionActive()) {
                        $conn->commit();
                    }
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    if ($conn->isTransactionActive()) {
                        $conn->rollback();
                    }
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // UserName
        $this->_UserName->setDbValueDef($rsnew, $this->_UserName->CurrentValue, false);

        // Password
        if (!IsMaskedPassword($this->_Password->CurrentValue)) {
            $this->_Password->setDbValueDef($rsnew, $this->_Password->CurrentValue, false);
        }

        // ConfirmPwd
        if (!IsMaskedPassword($this->ConfirmPwd->CurrentValue)) {
            $this->ConfirmPwd->setDbValueDef($rsnew, $this->ConfirmPwd->CurrentValue, false);
        }

        // FirstName
        $this->FirstName->setDbValueDef($rsnew, $this->FirstName->CurrentValue, false);

        // LastName
        $this->LastName->setDbValueDef($rsnew, $this->LastName->CurrentValue, false);

        // Level
        if ($Security->canAdmin()) { // System admin
            $this->Level->setDbValueDef($rsnew, $this->Level->CurrentValue, strval($this->Level->CurrentValue) == "");
        }

        // Role
        $this->Role->setDbValueDef($rsnew, $this->Role->CurrentValue, false);

        // Clearance
        $this->Clearance->setDbValueDef($rsnew, $this->Clearance->CurrentValue, strval($this->Clearance->CurrentValue) == "");

        // Active
        $this->Active->setDbValueDef($rsnew, $this->Active->CurrentValue, strval($this->Active->CurrentValue) == "");

        // Email
        $this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, false);

        // Telephone
        $this->Telephone->setDbValueDef($rsnew, $this->Telephone->CurrentValue, false);

        // Mobile
        $this->Mobile->setDbValueDef($rsnew, $this->Mobile->CurrentValue, false);

        // Position
        $this->Position->setDbValueDef($rsnew, $this->Position->CurrentValue, false);

        // ReportsTo
        $this->ReportsTo->setDbValueDef($rsnew, $this->ReportsTo->CurrentValue, false);

        // Profile
        $this->_Profile->setDbValueDef($rsnew, $this->_Profile->CurrentValue, false);

        // ProvinceCode
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, false);

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, false);

        // UserCode
        if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin
            $rsnew['UserCode'] = CurrentUserID();
        }
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['UserName'])) { // UserName
            $this->_UserName->setFormValue($row['UserName']);
        }
        if (isset($row['Password'])) { // Password
            $this->_Password->setFormValue($row['Password']);
        }
        if (isset($row['ConfirmPwd'])) { // ConfirmPwd
            $this->ConfirmPwd->setFormValue($row['ConfirmPwd']);
        }
        if (isset($row['FirstName'])) { // FirstName
            $this->FirstName->setFormValue($row['FirstName']);
        }
        if (isset($row['LastName'])) { // LastName
            $this->LastName->setFormValue($row['LastName']);
        }
        if (isset($row['Level'])) { // Level
            $this->Level->setFormValue($row['Level']);
        }
        if (isset($row['Role'])) { // Role
            $this->Role->setFormValue($row['Role']);
        }
        if (isset($row['Clearance'])) { // Clearance
            $this->Clearance->setFormValue($row['Clearance']);
        }
        if (isset($row['Active'])) { // Active
            $this->Active->setFormValue($row['Active']);
        }
        if (isset($row['Email'])) { // Email
            $this->_Email->setFormValue($row['Email']);
        }
        if (isset($row['Telephone'])) { // Telephone
            $this->Telephone->setFormValue($row['Telephone']);
        }
        if (isset($row['Mobile'])) { // Mobile
            $this->Mobile->setFormValue($row['Mobile']);
        }
        if (isset($row['Position'])) { // Position
            $this->Position->setFormValue($row['Position']);
        }
        if (isset($row['ReportsTo'])) { // ReportsTo
            $this->ReportsTo->setFormValue($row['ReportsTo']);
        }
        if (isset($row['Profile'])) { // Profile
            $this->_Profile->setFormValue($row['Profile']);
        }
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->setFormValue($row['ProvinceCode']);
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['UserCode'])) { // UserCode
            $this->UserCode->setFormValue($row['UserCode']);
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->UserCode->CurrentValue);
        }
        return true;
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("security_matrix", $detailTblVar)) {
                $detailPageObj = Container("SecurityMatrixGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->UserCode->IsDetailKey = true;
                    $detailPageObj->UserCode->CurrentValue = $this->UserCode->CurrentValue;
                    $detailPageObj->UserCode->setSessionValue($detailPageObj->UserCode->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("MusersList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Level":
                    break;
                case "x_Role":
                    break;
                case "x_Clearance":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
