<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GoodsReceivedNoteSearch extends GoodsReceivedNote
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GoodsReceivedNoteSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "GoodsReceivedNoteSearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->SupplierCode->setVisibility();
        $this->GRN->setVisibility();
        $this->District->setVisibility();
        $this->FarmingSeason->setVisibility();
        $this->SeedlingsReceived->setVisibility();
        $this->SeedsReceived->setVisibility();
        $this->SeedType->setVisibility();
        $this->GoodsDescription->setVisibility();
        $this->DateReceived->setVisibility();
        $this->ReceivedBy->setVisibility();
        $this->AuthorizedBy->setVisibility();
        $this->GoodsReceived->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'goods_received_note';
        $this->TableName = 'goods_received_note';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (goods_received_note)
        if (!isset($GLOBALS["goods_received_note"]) || $GLOBALS["goods_received_note"]::class == PROJECT_NAMESPACE . "goods_received_note") {
            $GLOBALS["goods_received_note"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'goods_received_note');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "GoodsReceivedNoteView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['SupplierCode'] . Config("COMPOSITE_KEY_SEPARATOR");
            $key .= @$ar['GRN'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->SupplierCode);
        $this->setupLookupOptions($this->District);
        $this->setupLookupOptions($this->FarmingSeason);
        $this->setupLookupOptions($this->SeedType);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "GoodsReceivedNoteList" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->SupplierCode); // SupplierCode
        $this->buildSearchUrl($srchUrl, $this->GRN); // GRN
        $this->buildSearchUrl($srchUrl, $this->District); // District
        $this->buildSearchUrl($srchUrl, $this->FarmingSeason); // FarmingSeason
        $this->buildSearchUrl($srchUrl, $this->SeedlingsReceived); // SeedlingsReceived
        $this->buildSearchUrl($srchUrl, $this->SeedsReceived); // SeedsReceived
        $this->buildSearchUrl($srchUrl, $this->SeedType); // SeedType
        $this->buildSearchUrl($srchUrl, $this->GoodsDescription); // GoodsDescription
        $this->buildSearchUrl($srchUrl, $this->DateReceived); // DateReceived
        $this->buildSearchUrl($srchUrl, $this->ReceivedBy); // ReceivedBy
        $this->buildSearchUrl($srchUrl, $this->AuthorizedBy); // AuthorizedBy
        $this->buildSearchUrl($srchUrl, $this->GoodsReceived); // GoodsReceived
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // SupplierCode
        if ($this->SupplierCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // GRN
        if ($this->GRN->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // District
        if ($this->District->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmingSeason
        if ($this->FarmingSeason->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SeedlingsReceived
        if ($this->SeedlingsReceived->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SeedsReceived
        if ($this->SeedsReceived->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SeedType
        if ($this->SeedType->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // GoodsDescription
        if ($this->GoodsDescription->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // DateReceived
        if ($this->DateReceived->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ReceivedBy
        if ($this->ReceivedBy->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // AuthorizedBy
        if ($this->AuthorizedBy->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // GoodsReceived
        if ($this->GoodsReceived->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // SupplierCode
        $this->SupplierCode->RowCssClass = "row";

        // GRN
        $this->GRN->RowCssClass = "row";

        // District
        $this->District->RowCssClass = "row";

        // FarmingSeason
        $this->FarmingSeason->RowCssClass = "row";

        // SeedlingsReceived
        $this->SeedlingsReceived->RowCssClass = "row";

        // SeedsReceived
        $this->SeedsReceived->RowCssClass = "row";

        // SeedType
        $this->SeedType->RowCssClass = "row";

        // GoodsDescription
        $this->GoodsDescription->RowCssClass = "row";

        // DateReceived
        $this->DateReceived->RowCssClass = "row";

        // ReceivedBy
        $this->ReceivedBy->RowCssClass = "row";

        // AuthorizedBy
        $this->AuthorizedBy->RowCssClass = "row";

        // GoodsReceived
        $this->GoodsReceived->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // SupplierCode
            $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
            $curVal = strval($this->SupplierCode->CurrentValue);
            if ($curVal != "") {
                $this->SupplierCode->ViewValue = $this->SupplierCode->lookupCacheOption($curVal);
                if ($this->SupplierCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                        $this->SupplierCode->ViewValue = $this->SupplierCode->displayValue($arwrk);
                    } else {
                        $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
                    }
                }
            } else {
                $this->SupplierCode->ViewValue = null;
            }

            // GRN
            $this->GRN->ViewValue = $this->GRN->CurrentValue;

            // District
            $curVal = strval($this->District->CurrentValue);
            if ($curVal != "") {
                $this->District->ViewValue = $this->District->lookupCacheOption($curVal);
                if ($this->District->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->District->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->District->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->District->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->District->Lookup->renderViewRow($rswrk[0]);
                        $this->District->ViewValue = $this->District->displayValue($arwrk);
                    } else {
                        $this->District->ViewValue = $this->District->CurrentValue;
                    }
                }
            } else {
                $this->District->ViewValue = null;
            }

            // FarmingSeason
            $curVal = strval($this->FarmingSeason->CurrentValue);
            if ($curVal != "") {
                $this->FarmingSeason->ViewValue = $this->FarmingSeason->lookupCacheOption($curVal);
                if ($this->FarmingSeason->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchExpression(), "=", $curVal, $this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchDataType(), "");
                    $sqlWrk = $this->FarmingSeason->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FarmingSeason->Lookup->renderViewRow($rswrk[0]);
                        $this->FarmingSeason->ViewValue = $this->FarmingSeason->displayValue($arwrk);
                    } else {
                        $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;
                    }
                }
            } else {
                $this->FarmingSeason->ViewValue = null;
            }

            // SeedlingsReceived
            $this->SeedlingsReceived->ViewValue = $this->SeedlingsReceived->CurrentValue;
            $this->SeedlingsReceived->ViewValue = FormatNumber($this->SeedlingsReceived->ViewValue, $this->SeedlingsReceived->formatPattern());
            $this->SeedlingsReceived->CellCssStyle .= "text-align: right;";

            // SeedsReceived
            $this->SeedsReceived->ViewValue = $this->SeedsReceived->CurrentValue;
            $this->SeedsReceived->ViewValue = FormatNumber($this->SeedsReceived->ViewValue, $this->SeedsReceived->formatPattern());
            $this->SeedsReceived->CellCssStyle .= "text-align: right;";

            // SeedType
            $curVal = strval($this->SeedType->CurrentValue);
            if ($curVal != "") {
                $this->SeedType->ViewValue = $this->SeedType->lookupCacheOption($curVal);
                if ($this->SeedType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                    $sqlWrk = $this->SeedType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SeedType->Lookup->renderViewRow($rswrk[0]);
                        $this->SeedType->ViewValue = $this->SeedType->displayValue($arwrk);
                    } else {
                        $this->SeedType->ViewValue = $this->SeedType->CurrentValue;
                    }
                }
            } else {
                $this->SeedType->ViewValue = null;
            }

            // GoodsDescription
            $this->GoodsDescription->ViewValue = $this->GoodsDescription->CurrentValue;

            // DateReceived
            $this->DateReceived->ViewValue = $this->DateReceived->CurrentValue;
            $this->DateReceived->ViewValue = FormatDateTime($this->DateReceived->ViewValue, $this->DateReceived->formatPattern());

            // ReceivedBy
            $this->ReceivedBy->ViewValue = $this->ReceivedBy->CurrentValue;

            // AuthorizedBy
            $this->AuthorizedBy->ViewValue = $this->AuthorizedBy->CurrentValue;

            // GoodsReceived
            $this->GoodsReceived->ViewValue = $this->GoodsReceived->CurrentValue;

            // SupplierCode
            $this->SupplierCode->HrefValue = "";
            $this->SupplierCode->TooltipValue = "";

            // GRN
            $this->GRN->HrefValue = "";
            $this->GRN->TooltipValue = "";

            // District
            $this->District->HrefValue = "";
            $this->District->TooltipValue = "";

            // FarmingSeason
            $this->FarmingSeason->HrefValue = "";
            $this->FarmingSeason->TooltipValue = "";

            // SeedlingsReceived
            $this->SeedlingsReceived->HrefValue = "";
            $this->SeedlingsReceived->TooltipValue = "";

            // SeedsReceived
            $this->SeedsReceived->HrefValue = "";
            $this->SeedsReceived->TooltipValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";
            $this->SeedType->TooltipValue = "";

            // GoodsDescription
            $this->GoodsDescription->HrefValue = "";
            $this->GoodsDescription->TooltipValue = "";

            // DateReceived
            $this->DateReceived->HrefValue = "";
            $this->DateReceived->TooltipValue = "";

            // ReceivedBy
            $this->ReceivedBy->HrefValue = "";
            $this->ReceivedBy->TooltipValue = "";

            // AuthorizedBy
            $this->AuthorizedBy->HrefValue = "";
            $this->AuthorizedBy->TooltipValue = "";

            // GoodsReceived
            $this->GoodsReceived->HrefValue = "";
            $this->GoodsReceived->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // SupplierCode
            $this->SupplierCode->setupEditAttributes();
            $this->SupplierCode->EditValue = $this->SupplierCode->AdvancedSearch->SearchValue;
            $curVal = strval($this->SupplierCode->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->SupplierCode->EditValue = $this->SupplierCode->lookupCacheOption($curVal);
                if ($this->SupplierCode->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                        $this->SupplierCode->EditValue = $this->SupplierCode->displayValue($arwrk);
                    } else {
                        $this->SupplierCode->EditValue = HtmlEncode($this->SupplierCode->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->SupplierCode->EditValue = null;
            }
            $this->SupplierCode->PlaceHolder = RemoveHtml($this->SupplierCode->caption());

            // GRN
            $this->GRN->setupEditAttributes();
            if (!$this->GRN->Raw) {
                $this->GRN->AdvancedSearch->SearchValue = HtmlDecode($this->GRN->AdvancedSearch->SearchValue);
            }
            $this->GRN->EditValue = HtmlEncode($this->GRN->AdvancedSearch->SearchValue);
            $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

            // District
            $curVal = trim(strval($this->District->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->District->AdvancedSearch->ViewValue = $this->District->lookupCacheOption($curVal);
            } else {
                $this->District->AdvancedSearch->ViewValue = $this->District->Lookup !== null && is_array($this->District->lookupOptions()) && count($this->District->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->District->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->District->EditValue = array_values($this->District->lookupOptions());
                if ($this->District->AdvancedSearch->ViewValue == "") {
                    $this->District->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->District->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->District->AdvancedSearch->SearchValue, $this->District->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->District->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->District->Lookup->renderViewRow($rswrk[0]);
                    $this->District->AdvancedSearch->ViewValue = $this->District->displayValue($arwrk);
                } else {
                    $this->District->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->District->EditValue = $arwrk;
            }
            $this->District->PlaceHolder = RemoveHtml($this->District->caption());

            // FarmingSeason
            $curVal = trim(strval($this->FarmingSeason->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->FarmingSeason->AdvancedSearch->ViewValue = $this->FarmingSeason->lookupCacheOption($curVal);
            } else {
                $this->FarmingSeason->AdvancedSearch->ViewValue = $this->FarmingSeason->Lookup !== null && is_array($this->FarmingSeason->lookupOptions()) && count($this->FarmingSeason->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FarmingSeason->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->FarmingSeason->EditValue = array_values($this->FarmingSeason->lookupOptions());
                if ($this->FarmingSeason->AdvancedSearch->ViewValue == "") {
                    $this->FarmingSeason->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchExpression(), "=", $this->FarmingSeason->AdvancedSearch->SearchValue, $this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchDataType(), "");
                }
                $sqlWrk = $this->FarmingSeason->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->FarmingSeason->Lookup->renderViewRow($rswrk[0]);
                    $this->FarmingSeason->AdvancedSearch->ViewValue = $this->FarmingSeason->displayValue($arwrk);
                } else {
                    $this->FarmingSeason->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->FarmingSeason->EditValue = $arwrk;
            }
            $this->FarmingSeason->PlaceHolder = RemoveHtml($this->FarmingSeason->caption());

            // SeedlingsReceived
            $this->SeedlingsReceived->setupEditAttributes();
            $this->SeedlingsReceived->EditValue = $this->SeedlingsReceived->AdvancedSearch->SearchValue;
            $this->SeedlingsReceived->PlaceHolder = RemoveHtml($this->SeedlingsReceived->caption());

            // SeedsReceived
            $this->SeedsReceived->setupEditAttributes();
            $this->SeedsReceived->EditValue = $this->SeedsReceived->AdvancedSearch->SearchValue;
            $this->SeedsReceived->PlaceHolder = RemoveHtml($this->SeedsReceived->caption());

            // SeedType
            $this->SeedType->setupEditAttributes();
            $curVal = trim(strval($this->SeedType->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->SeedType->AdvancedSearch->ViewValue = $this->SeedType->lookupCacheOption($curVal);
            } else {
                $this->SeedType->AdvancedSearch->ViewValue = $this->SeedType->Lookup !== null && is_array($this->SeedType->lookupOptions()) && count($this->SeedType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SeedType->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->SeedType->EditValue = array_values($this->SeedType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->SeedType->AdvancedSearch->SearchValue, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->SeedType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SeedType->EditValue = $arwrk;
            }
            $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

            // GoodsDescription
            $this->GoodsDescription->setupEditAttributes();
            if (!$this->GoodsDescription->Raw) {
                $this->GoodsDescription->AdvancedSearch->SearchValue = HtmlDecode($this->GoodsDescription->AdvancedSearch->SearchValue);
            }
            $this->GoodsDescription->EditValue = HtmlEncode($this->GoodsDescription->AdvancedSearch->SearchValue);
            $this->GoodsDescription->PlaceHolder = RemoveHtml($this->GoodsDescription->caption());

            // DateReceived
            $this->DateReceived->setupEditAttributes();
            $this->DateReceived->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->DateReceived->AdvancedSearch->SearchValue, $this->DateReceived->formatPattern()), $this->DateReceived->formatPattern()));
            $this->DateReceived->PlaceHolder = RemoveHtml($this->DateReceived->caption());

            // ReceivedBy
            $this->ReceivedBy->setupEditAttributes();
            if (!$this->ReceivedBy->Raw) {
                $this->ReceivedBy->AdvancedSearch->SearchValue = HtmlDecode($this->ReceivedBy->AdvancedSearch->SearchValue);
            }
            $this->ReceivedBy->EditValue = HtmlEncode($this->ReceivedBy->AdvancedSearch->SearchValue);
            $this->ReceivedBy->PlaceHolder = RemoveHtml($this->ReceivedBy->caption());

            // AuthorizedBy
            $this->AuthorizedBy->setupEditAttributes();
            if (!$this->AuthorizedBy->Raw) {
                $this->AuthorizedBy->AdvancedSearch->SearchValue = HtmlDecode($this->AuthorizedBy->AdvancedSearch->SearchValue);
            }
            $this->AuthorizedBy->EditValue = HtmlEncode($this->AuthorizedBy->AdvancedSearch->SearchValue);
            $this->AuthorizedBy->PlaceHolder = RemoveHtml($this->AuthorizedBy->caption());

            // GoodsReceived
            $this->GoodsReceived->setupEditAttributes();
            $this->GoodsReceived->EditValue = HtmlEncode($this->GoodsReceived->AdvancedSearch->SearchValue);
            $this->GoodsReceived->PlaceHolder = RemoveHtml($this->GoodsReceived->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->SupplierCode->AdvancedSearch->SearchValue)) {
            $this->SupplierCode->addErrorMessage($this->SupplierCode->getErrorMessage(false));
        }
        if (!CheckNumber($this->SeedlingsReceived->AdvancedSearch->SearchValue)) {
            $this->SeedlingsReceived->addErrorMessage($this->SeedlingsReceived->getErrorMessage(false));
        }
        if (!CheckNumber($this->SeedsReceived->AdvancedSearch->SearchValue)) {
            $this->SeedsReceived->addErrorMessage($this->SeedsReceived->getErrorMessage(false));
        }
        if (!CheckDate($this->DateReceived->AdvancedSearch->SearchValue, $this->DateReceived->formatPattern())) {
            $this->DateReceived->addErrorMessage($this->DateReceived->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->SupplierCode->AdvancedSearch->load();
        $this->GRN->AdvancedSearch->load();
        $this->District->AdvancedSearch->load();
        $this->FarmingSeason->AdvancedSearch->load();
        $this->SeedlingsReceived->AdvancedSearch->load();
        $this->SeedsReceived->AdvancedSearch->load();
        $this->SeedType->AdvancedSearch->load();
        $this->GoodsDescription->AdvancedSearch->load();
        $this->DateReceived->AdvancedSearch->load();
        $this->ReceivedBy->AdvancedSearch->load();
        $this->AuthorizedBy->AdvancedSearch->load();
        $this->GoodsReceived->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("GoodsReceivedNoteList"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_SupplierCode":
                    break;
                case "x_District":
                    break;
                case "x_FarmingSeason":
                    break;
                case "x_SeedType":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
