<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for farms_extra
 */
class FarmsExtra extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;
    public $NRC;
    public $FarmerNo;
    public $FarmNo;
    public $Coordinates;
    public $Latitude;
    public $Longitude;
    public $FieldType;
    public $Ownership;
    public $FarmSize;
    public $FarmSizeEstimated;
    public $TreesPlantedEstimated;
    public $FarmSizeVerified;
    public $TreesPlantedVerified;
    public $SourcesOfSeedlings;
    public $InspecationReport;
    public $ClearedLand;
    public $SeedlingsAllocated;
    public $OldTrees;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "farms_extra";
        $this->TableName = 'farms_extra';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "farms_extra";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProvinceCode->addMethod("getDefault", fn() => 0);
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictCode->addMethod("getDefault", fn() => 0);
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->Nullable = false; // NOT NULL field
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new DbField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new DbField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerNo
        $this->FarmerNo = new DbField(
            $this, // Table
            'x_FarmerNo', // Variable name
            'FarmerNo', // Name
            '`FarmerNo`', // Expression
            '`FarmerNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerNo->InputTextType = "text";
        $this->FarmerNo->Raw = true;
        $this->FarmerNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerNo'] = &$this->FarmerNo;

        // FarmNo
        $this->FarmNo = new DbField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmNo->addMethod("getDefault", fn() => 0);
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // Coordinates
        $this->Coordinates = new DbField(
            $this, // Table
            'x_Coordinates', // Variable name
            'Coordinates', // Name
            '`Coordinates`', // Expression
            '`Coordinates`', // Basic search expression
            200, // Type
            0, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Coordinates`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Coordinates->InputTextType = "text";
        $this->Coordinates->Raw = true;
        $this->Coordinates->CustomDataType = new GeometryType();
        $this->Coordinates->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Coordinates'] = &$this->Coordinates;

        // Latitude
        $this->Latitude = new DbField(
            $this, // Table
            'x_Latitude', // Variable name
            'Latitude', // Name
            '`Latitude`', // Expression
            '`Latitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Latitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Latitude->InputTextType = "text";
        $this->Latitude->Raw = true;
        $this->Latitude->Nullable = false; // NOT NULL field
        $this->Latitude->Required = true; // Required field
        $this->Latitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Latitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Latitude'] = &$this->Latitude;

        // Longitude
        $this->Longitude = new DbField(
            $this, // Table
            'x_Longitude', // Variable name
            'Longitude', // Name
            '`Longitude`', // Expression
            '`Longitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Longitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Longitude->InputTextType = "text";
        $this->Longitude->Raw = true;
        $this->Longitude->Nullable = false; // NOT NULL field
        $this->Longitude->Required = true; // Required field
        $this->Longitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Longitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Longitude'] = &$this->Longitude;

        // FieldType
        $this->FieldType = new DbField(
            $this, // Table
            'x_FieldType', // Variable name
            'FieldType', // Name
            '`FieldType`', // Expression
            '`FieldType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FieldType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FieldType->InputTextType = "text";
        $this->FieldType->Raw = true;
        $this->FieldType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FieldType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FieldType'] = &$this->FieldType;

        // Ownership
        $this->Ownership = new DbField(
            $this, // Table
            'x_Ownership', // Variable name
            'Ownership', // Name
            '`Ownership`', // Expression
            '`Ownership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Ownership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Ownership->InputTextType = "text";
        $this->Ownership->Raw = true;
        $this->Ownership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Ownership->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Ownership'] = &$this->Ownership;

        // FarmSize
        $this->FarmSize = new DbField(
            $this, // Table
            'x_FarmSize', // Variable name
            'FarmSize', // Name
            '`FarmSize`', // Expression
            '`FarmSize`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSize`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSize->InputTextType = "text";
        $this->FarmSize->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSize'] = &$this->FarmSize;

        // FarmSizeEstimated
        $this->FarmSizeEstimated = new DbField(
            $this, // Table
            'x_FarmSizeEstimated', // Variable name
            'FarmSizeEstimated', // Name
            '`FarmSizeEstimated`', // Expression
            '`FarmSizeEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeEstimated->InputTextType = "text";
        $this->FarmSizeEstimated->Raw = true;
        $this->FarmSizeEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSizeEstimated'] = &$this->FarmSizeEstimated;

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated = new DbField(
            $this, // Table
            'x_TreesPlantedEstimated', // Variable name
            'TreesPlantedEstimated', // Name
            '`TreesPlantedEstimated`', // Expression
            '`TreesPlantedEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedEstimated->InputTextType = "text";
        $this->TreesPlantedEstimated->Raw = true;
        $this->TreesPlantedEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesPlantedEstimated'] = &$this->TreesPlantedEstimated;

        // FarmSizeVerified
        $this->FarmSizeVerified = new DbField(
            $this, // Table
            'x_FarmSizeVerified', // Variable name
            'FarmSizeVerified', // Name
            '`FarmSizeVerified`', // Expression
            '`FarmSizeVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeVerified->InputTextType = "text";
        $this->FarmSizeVerified->Raw = true;
        $this->FarmSizeVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSizeVerified'] = &$this->FarmSizeVerified;

        // TreesPlantedVerified
        $this->TreesPlantedVerified = new DbField(
            $this, // Table
            'x_TreesPlantedVerified', // Variable name
            'TreesPlantedVerified', // Name
            '`TreesPlantedVerified`', // Expression
            '`TreesPlantedVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedVerified->InputTextType = "text";
        $this->TreesPlantedVerified->Raw = true;
        $this->TreesPlantedVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesPlantedVerified'] = &$this->TreesPlantedVerified;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings = new DbField(
            $this, // Table
            'x_SourcesOfSeedlings', // Variable name
            'SourcesOfSeedlings', // Name
            '`SourcesOfSeedlings`', // Expression
            '`SourcesOfSeedlings`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SourcesOfSeedlings`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SourcesOfSeedlings->InputTextType = "text";
        $this->SourcesOfSeedlings->Raw = true;
        $this->SourcesOfSeedlings->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SourcesOfSeedlings->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SourcesOfSeedlings'] = &$this->SourcesOfSeedlings;

        // InspecationReport
        $this->InspecationReport = new DbField(
            $this, // Table
            'x_InspecationReport', // Variable name
            'InspecationReport', // Name
            '`InspecationReport`', // Expression
            '`InspecationReport`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspecationReport`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->InspecationReport->InputTextType = "text";
        $this->InspecationReport->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['InspecationReport'] = &$this->InspecationReport;

        // ClearedLand
        $this->ClearedLand = new DbField(
            $this, // Table
            'x_ClearedLand', // Variable name
            'ClearedLand', // Name
            '`ClearedLand`', // Expression
            '`ClearedLand`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ClearedLand`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ClearedLand->InputTextType = "text";
        $this->ClearedLand->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ClearedLand'] = &$this->ClearedLand;

        // SeedlingsAllocated
        $this->SeedlingsAllocated = new DbField(
            $this, // Table
            'x_SeedlingsAllocated', // Variable name
            'SeedlingsAllocated', // Name
            '`SeedlingsAllocated`', // Expression
            '`SeedlingsAllocated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedlingsAllocated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedlingsAllocated->InputTextType = "text";
        $this->SeedlingsAllocated->Raw = true;
        $this->SeedlingsAllocated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->SeedlingsAllocated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedlingsAllocated'] = &$this->SeedlingsAllocated;

        // OldTrees
        $this->OldTrees = new DbField(
            $this, // Table
            'x_OldTrees', // Variable name
            'OldTrees', // Name
            '`OldTrees`', // Expression
            '`OldTrees`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OldTrees`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OldTrees->InputTextType = "text";
        $this->OldTrees->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['OldTrees'] = &$this->OldTrees;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "farms_extra";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->CampCode->DbValue = $row['CampCode'];
        $this->VillageCode->DbValue = $row['VillageCode'];
        $this->NRC->DbValue = $row['NRC'];
        $this->FarmerNo->DbValue = $row['FarmerNo'];
        $this->FarmNo->DbValue = $row['FarmNo'];
        $this->Coordinates->DbValue = $row['Coordinates'];
        $this->Latitude->DbValue = $row['Latitude'];
        $this->Longitude->DbValue = $row['Longitude'];
        $this->FieldType->DbValue = $row['FieldType'];
        $this->Ownership->DbValue = $row['Ownership'];
        $this->FarmSize->DbValue = $row['FarmSize'];
        $this->FarmSizeEstimated->DbValue = $row['FarmSizeEstimated'];
        $this->TreesPlantedEstimated->DbValue = $row['TreesPlantedEstimated'];
        $this->FarmSizeVerified->DbValue = $row['FarmSizeVerified'];
        $this->TreesPlantedVerified->DbValue = $row['TreesPlantedVerified'];
        $this->SourcesOfSeedlings->DbValue = $row['SourcesOfSeedlings'];
        $this->InspecationReport->DbValue = $row['InspecationReport'];
        $this->ClearedLand->DbValue = $row['ClearedLand'];
        $this->SeedlingsAllocated->DbValue = $row['SeedlingsAllocated'];
        $this->OldTrees->DbValue = $row['OldTrees'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("FarmsExtraList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "FarmsExtraView" => $Language->phrase("View"),
            "FarmsExtraEdit" => $Language->phrase("Edit"),
            "FarmsExtraAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "FarmsExtraList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "FarmsExtraView",
            Config("API_ADD_ACTION") => "FarmsExtraAdd",
            Config("API_EDIT_ACTION") => "FarmsExtraEdit",
            Config("API_DELETE_ACTION") => "FarmsExtraDelete",
            Config("API_LIST_ACTION") => "FarmsExtraList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "FarmsExtraList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmsExtraView", $parm);
        } else {
            $url = $this->keyUrl("FarmsExtraView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "FarmsExtraAdd?" . $parm;
        } else {
            $url = "FarmsExtraAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("FarmsExtraEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("FarmsExtraList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("FarmsExtraAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("FarmsExtraList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("FarmsExtraDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->Coordinates->setDbValue($row['Coordinates']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->InspecationReport->setDbValue($row['InspecationReport']);
        $this->ClearedLand->setDbValue($row['ClearedLand']);
        $this->SeedlingsAllocated->setDbValue($row['SeedlingsAllocated']);
        $this->OldTrees->setDbValue($row['OldTrees']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "FarmsExtraList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // NRC

        // FarmerNo

        // FarmNo

        // Coordinates

        // Latitude

        // Longitude

        // FieldType

        // Ownership

        // FarmSize

        // FarmSizeEstimated

        // TreesPlantedEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // SourcesOfSeedlings

        // InspecationReport

        // ClearedLand

        // SeedlingsAllocated

        // OldTrees

        // ProvinceCode
        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->ViewValue = FormatNumber($this->ProvinceCode->ViewValue, $this->ProvinceCode->formatPattern());

        // DistrictCode
        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->ViewValue = FormatNumber($this->DistrictCode->ViewValue, $this->DistrictCode->formatPattern());

        // CampCode
        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
        $this->CampCode->ViewValue = FormatNumber($this->CampCode->ViewValue, $this->CampCode->formatPattern());

        // VillageCode
        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
        $this->VillageCode->ViewValue = FormatNumber($this->VillageCode->ViewValue, $this->VillageCode->formatPattern());

        // NRC
        $this->NRC->ViewValue = $this->NRC->CurrentValue;

        // FarmerNo
        $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->ViewValue = FormatNumber($this->FarmerNo->ViewValue, $this->FarmerNo->formatPattern());

        // FarmNo
        $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;
        $this->FarmNo->ViewValue = FormatNumber($this->FarmNo->ViewValue, $this->FarmNo->formatPattern());

        // Coordinates
        $this->Coordinates->ViewValue = $this->Coordinates->CurrentValue;

        // Latitude
        $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
        $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

        // Longitude
        $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
        $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

        // FieldType
        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
        $this->FieldType->ViewValue = FormatNumber($this->FieldType->ViewValue, $this->FieldType->formatPattern());

        // Ownership
        $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
        $this->Ownership->ViewValue = FormatNumber($this->Ownership->ViewValue, $this->Ownership->formatPattern());

        // FarmSize
        $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

        // FarmSizeEstimated
        $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
        $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
        $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

        // FarmSizeVerified
        $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
        $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

        // TreesPlantedVerified
        $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
        $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
        $this->SourcesOfSeedlings->ViewValue = FormatNumber($this->SourcesOfSeedlings->ViewValue, $this->SourcesOfSeedlings->formatPattern());

        // InspecationReport
        $this->InspecationReport->ViewValue = $this->InspecationReport->CurrentValue;

        // ClearedLand
        $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;

        // SeedlingsAllocated
        $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
        $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());

        // OldTrees
        $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // CampCode
        $this->CampCode->HrefValue = "";
        $this->CampCode->TooltipValue = "";

        // VillageCode
        $this->VillageCode->HrefValue = "";
        $this->VillageCode->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // FarmerNo
        $this->FarmerNo->HrefValue = "";
        $this->FarmerNo->TooltipValue = "";

        // FarmNo
        $this->FarmNo->HrefValue = "";
        $this->FarmNo->TooltipValue = "";

        // Coordinates
        $this->Coordinates->HrefValue = "";
        $this->Coordinates->TooltipValue = "";

        // Latitude
        $this->Latitude->HrefValue = "";
        $this->Latitude->TooltipValue = "";

        // Longitude
        $this->Longitude->HrefValue = "";
        $this->Longitude->TooltipValue = "";

        // FieldType
        $this->FieldType->HrefValue = "";
        $this->FieldType->TooltipValue = "";

        // Ownership
        $this->Ownership->HrefValue = "";
        $this->Ownership->TooltipValue = "";

        // FarmSize
        $this->FarmSize->HrefValue = "";
        $this->FarmSize->TooltipValue = "";

        // FarmSizeEstimated
        $this->FarmSizeEstimated->HrefValue = "";
        $this->FarmSizeEstimated->TooltipValue = "";

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->HrefValue = "";
        $this->TreesPlantedEstimated->TooltipValue = "";

        // FarmSizeVerified
        $this->FarmSizeVerified->HrefValue = "";
        $this->FarmSizeVerified->TooltipValue = "";

        // TreesPlantedVerified
        $this->TreesPlantedVerified->HrefValue = "";
        $this->TreesPlantedVerified->TooltipValue = "";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->HrefValue = "";
        $this->SourcesOfSeedlings->TooltipValue = "";

        // InspecationReport
        $this->InspecationReport->HrefValue = "";
        $this->InspecationReport->TooltipValue = "";

        // ClearedLand
        $this->ClearedLand->HrefValue = "";
        $this->ClearedLand->TooltipValue = "";

        // SeedlingsAllocated
        $this->SeedlingsAllocated->HrefValue = "";
        $this->SeedlingsAllocated->TooltipValue = "";

        // OldTrees
        $this->OldTrees->HrefValue = "";
        $this->OldTrees->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        $this->ProvinceCode->EditValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
        if (strval($this->ProvinceCode->EditValue) != "" && is_numeric($this->ProvinceCode->EditValue)) {
            $this->ProvinceCode->EditValue = FormatNumber($this->ProvinceCode->EditValue, null);
        }

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        $this->DistrictCode->EditValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
        if (strval($this->DistrictCode->EditValue) != "" && is_numeric($this->DistrictCode->EditValue)) {
            $this->DistrictCode->EditValue = FormatNumber($this->DistrictCode->EditValue, null);
        }

        // CampCode
        $this->CampCode->setupEditAttributes();
        $this->CampCode->EditValue = $this->CampCode->CurrentValue;
        $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
        if (strval($this->CampCode->EditValue) != "" && is_numeric($this->CampCode->EditValue)) {
            $this->CampCode->EditValue = FormatNumber($this->CampCode->EditValue, null);
        }

        // VillageCode
        $this->VillageCode->setupEditAttributes();
        $this->VillageCode->EditValue = $this->VillageCode->CurrentValue;
        $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
        if (strval($this->VillageCode->EditValue) != "" && is_numeric($this->VillageCode->EditValue)) {
            $this->VillageCode->EditValue = FormatNumber($this->VillageCode->EditValue, null);
        }

        // NRC
        $this->NRC->setupEditAttributes();
        if (!$this->NRC->Raw) {
            $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
        }
        $this->NRC->EditValue = $this->NRC->CurrentValue;
        $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

        // FarmerNo
        $this->FarmerNo->setupEditAttributes();
        $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
        if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
            $this->FarmerNo->EditValue = FormatNumber($this->FarmerNo->EditValue, null);
        }

        // FarmNo
        $this->FarmNo->setupEditAttributes();
        $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;
        $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());
        if (strval($this->FarmNo->EditValue) != "" && is_numeric($this->FarmNo->EditValue)) {
            $this->FarmNo->EditValue = FormatNumber($this->FarmNo->EditValue, null);
        }

        // Coordinates
        $this->Coordinates->setupEditAttributes();
        if (!$this->Coordinates->Raw) {
            $this->Coordinates->CurrentValue = HtmlDecode($this->Coordinates->CurrentValue);
        }
        $this->Coordinates->EditValue = $this->Coordinates->CurrentValue;
        $this->Coordinates->PlaceHolder = RemoveHtml($this->Coordinates->caption());

        // Latitude
        $this->Latitude->setupEditAttributes();
        $this->Latitude->EditValue = $this->Latitude->CurrentValue;
        $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
        if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
            $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
        }

        // Longitude
        $this->Longitude->setupEditAttributes();
        $this->Longitude->EditValue = $this->Longitude->CurrentValue;
        $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
        if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
            $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
        }

        // FieldType
        $this->FieldType->setupEditAttributes();
        $this->FieldType->EditValue = $this->FieldType->CurrentValue;
        $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());
        if (strval($this->FieldType->EditValue) != "" && is_numeric($this->FieldType->EditValue)) {
            $this->FieldType->EditValue = FormatNumber($this->FieldType->EditValue, null);
        }

        // Ownership
        $this->Ownership->setupEditAttributes();
        $this->Ownership->EditValue = $this->Ownership->CurrentValue;
        $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());
        if (strval($this->Ownership->EditValue) != "" && is_numeric($this->Ownership->EditValue)) {
            $this->Ownership->EditValue = FormatNumber($this->Ownership->EditValue, null);
        }

        // FarmSize
        $this->FarmSize->setupEditAttributes();
        if (!$this->FarmSize->Raw) {
            $this->FarmSize->CurrentValue = HtmlDecode($this->FarmSize->CurrentValue);
        }
        $this->FarmSize->EditValue = $this->FarmSize->CurrentValue;
        $this->FarmSize->PlaceHolder = RemoveHtml($this->FarmSize->caption());

        // FarmSizeEstimated
        $this->FarmSizeEstimated->setupEditAttributes();
        $this->FarmSizeEstimated->EditValue = $this->FarmSizeEstimated->CurrentValue;
        $this->FarmSizeEstimated->PlaceHolder = RemoveHtml($this->FarmSizeEstimated->caption());
        if (strval($this->FarmSizeEstimated->EditValue) != "" && is_numeric($this->FarmSizeEstimated->EditValue)) {
            $this->FarmSizeEstimated->EditValue = FormatNumber($this->FarmSizeEstimated->EditValue, null);
        }

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->setupEditAttributes();
        $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->CurrentValue;
        $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());
        if (strval($this->TreesPlantedEstimated->EditValue) != "" && is_numeric($this->TreesPlantedEstimated->EditValue)) {
            $this->TreesPlantedEstimated->EditValue = FormatNumber($this->TreesPlantedEstimated->EditValue, null);
        }

        // FarmSizeVerified
        $this->FarmSizeVerified->setupEditAttributes();
        $this->FarmSizeVerified->EditValue = $this->FarmSizeVerified->CurrentValue;
        $this->FarmSizeVerified->PlaceHolder = RemoveHtml($this->FarmSizeVerified->caption());
        if (strval($this->FarmSizeVerified->EditValue) != "" && is_numeric($this->FarmSizeVerified->EditValue)) {
            $this->FarmSizeVerified->EditValue = FormatNumber($this->FarmSizeVerified->EditValue, null);
        }

        // TreesPlantedVerified
        $this->TreesPlantedVerified->setupEditAttributes();
        $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->CurrentValue;
        $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());
        if (strval($this->TreesPlantedVerified->EditValue) != "" && is_numeric($this->TreesPlantedVerified->EditValue)) {
            $this->TreesPlantedVerified->EditValue = FormatNumber($this->TreesPlantedVerified->EditValue, null);
        }

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->setupEditAttributes();
        $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->CurrentValue;
        $this->SourcesOfSeedlings->PlaceHolder = RemoveHtml($this->SourcesOfSeedlings->caption());
        if (strval($this->SourcesOfSeedlings->EditValue) != "" && is_numeric($this->SourcesOfSeedlings->EditValue)) {
            $this->SourcesOfSeedlings->EditValue = FormatNumber($this->SourcesOfSeedlings->EditValue, null);
        }

        // InspecationReport
        $this->InspecationReport->setupEditAttributes();
        $this->InspecationReport->EditValue = $this->InspecationReport->CurrentValue;
        $this->InspecationReport->PlaceHolder = RemoveHtml($this->InspecationReport->caption());

        // ClearedLand
        $this->ClearedLand->setupEditAttributes();
        if (!$this->ClearedLand->Raw) {
            $this->ClearedLand->CurrentValue = HtmlDecode($this->ClearedLand->CurrentValue);
        }
        $this->ClearedLand->EditValue = $this->ClearedLand->CurrentValue;
        $this->ClearedLand->PlaceHolder = RemoveHtml($this->ClearedLand->caption());

        // SeedlingsAllocated
        $this->SeedlingsAllocated->setupEditAttributes();
        $this->SeedlingsAllocated->EditValue = $this->SeedlingsAllocated->CurrentValue;
        $this->SeedlingsAllocated->PlaceHolder = RemoveHtml($this->SeedlingsAllocated->caption());
        if (strval($this->SeedlingsAllocated->EditValue) != "" && is_numeric($this->SeedlingsAllocated->EditValue)) {
            $this->SeedlingsAllocated->EditValue = FormatNumber($this->SeedlingsAllocated->EditValue, null);
        }

        // OldTrees
        $this->OldTrees->setupEditAttributes();
        if (!$this->OldTrees->Raw) {
            $this->OldTrees->CurrentValue = HtmlDecode($this->OldTrees->CurrentValue);
        }
        $this->OldTrees->EditValue = $this->OldTrees->CurrentValue;
        $this->OldTrees->PlaceHolder = RemoveHtml($this->OldTrees->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->Latitude);
                    $doc->exportCaption($this->Longitude);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->Ownership);
                    $doc->exportCaption($this->FarmSize);
                    $doc->exportCaption($this->FarmSizeEstimated);
                    $doc->exportCaption($this->TreesPlantedEstimated);
                    $doc->exportCaption($this->FarmSizeVerified);
                    $doc->exportCaption($this->TreesPlantedVerified);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->InspecationReport);
                    $doc->exportCaption($this->ClearedLand);
                    $doc->exportCaption($this->SeedlingsAllocated);
                    $doc->exportCaption($this->OldTrees);
                } else {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->Latitude);
                    $doc->exportCaption($this->Longitude);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->Ownership);
                    $doc->exportCaption($this->FarmSize);
                    $doc->exportCaption($this->FarmSizeEstimated);
                    $doc->exportCaption($this->TreesPlantedEstimated);
                    $doc->exportCaption($this->FarmSizeVerified);
                    $doc->exportCaption($this->TreesPlantedVerified);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->ClearedLand);
                    $doc->exportCaption($this->SeedlingsAllocated);
                    $doc->exportCaption($this->OldTrees);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->Latitude);
                        $doc->exportField($this->Longitude);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->Ownership);
                        $doc->exportField($this->FarmSize);
                        $doc->exportField($this->FarmSizeEstimated);
                        $doc->exportField($this->TreesPlantedEstimated);
                        $doc->exportField($this->FarmSizeVerified);
                        $doc->exportField($this->TreesPlantedVerified);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->InspecationReport);
                        $doc->exportField($this->ClearedLand);
                        $doc->exportField($this->SeedlingsAllocated);
                        $doc->exportField($this->OldTrees);
                    } else {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->Latitude);
                        $doc->exportField($this->Longitude);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->Ownership);
                        $doc->exportField($this->FarmSize);
                        $doc->exportField($this->FarmSizeEstimated);
                        $doc->exportField($this->TreesPlantedEstimated);
                        $doc->exportField($this->FarmSizeVerified);
                        $doc->exportField($this->TreesPlantedVerified);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->ClearedLand);
                        $doc->exportField($this->SeedlingsAllocated);
                        $doc->exportField($this->OldTrees);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
