<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for farm_seed_allocate_offline
 */
class FarmSeedAllocateOffline extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;
    public $NRC;
    public $FarmerNo;
    public $FarmNo;
    public $TransNo;
    public $GRN;
    public $TreesAllocated;
    public $FarmingSeason;
    public $SeedType;
    public $SourcesOfSeedlings;
    public $TransDate;
    public $PreparedBy;
    public $AuthorisedBy;
    public $GoodsReceived;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "farm_seed_allocate_offline";
        $this->TableName = 'farm_seed_allocate_offline';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "farm_seed_allocate_offline";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new DbField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new DbField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerNo
        $this->FarmerNo = new DbField(
            $this, // Table
            'x_FarmerNo', // Variable name
            'FarmerNo', // Name
            '`FarmerNo`', // Expression
            '`FarmerNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerNo->InputTextType = "text";
        $this->FarmerNo->Raw = true;
        $this->FarmerNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerNo'] = &$this->FarmerNo;

        // FarmNo
        $this->FarmNo = new DbField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->Required = true; // Required field
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // TransNo
        $this->TransNo = new DbField(
            $this, // Table
            'x_TransNo', // Variable name
            'TransNo', // Name
            '`TransNo`', // Expression
            '`TransNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TransNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TransNo->addMethod("getDefault", fn() => 0);
        $this->TransNo->InputTextType = "text";
        $this->TransNo->Raw = true;
        $this->TransNo->Nullable = false; // NOT NULL field
        $this->TransNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->TransNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['TransNo'] = &$this->TransNo;

        // GRN
        $this->GRN = new DbField(
            $this, // Table
            'x_GRN', // Variable name
            'GRN', // Name
            '`GRN`', // Expression
            '`GRN`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`GRN`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->GRN->InputTextType = "text";
        $this->GRN->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['GRN'] = &$this->GRN;

        // TreesAllocated
        $this->TreesAllocated = new DbField(
            $this, // Table
            'x_TreesAllocated', // Variable name
            'TreesAllocated', // Name
            '`TreesAllocated`', // Expression
            '`TreesAllocated`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesAllocated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesAllocated->InputTextType = "text";
        $this->TreesAllocated->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesAllocated'] = &$this->TreesAllocated;

        // FarmingSeason
        $this->FarmingSeason = new DbField(
            $this, // Table
            'x_FarmingSeason', // Variable name
            'FarmingSeason', // Name
            '`FarmingSeason`', // Expression
            '`FarmingSeason`', // Basic search expression
            18, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmingSeason`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmingSeason->InputTextType = "text";
        $this->FarmingSeason->Raw = true;
        $this->FarmingSeason->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmingSeason->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmingSeason'] = &$this->FarmingSeason;

        // SeedType
        $this->SeedType = new DbField(
            $this, // Table
            'x_SeedType', // Variable name
            'SeedType', // Name
            '`SeedType`', // Expression
            '`SeedType`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedType->InputTextType = "text";
        $this->SeedType->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedType'] = &$this->SeedType;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings = new DbField(
            $this, // Table
            'x_SourcesOfSeedlings', // Variable name
            'SourcesOfSeedlings', // Name
            '`SourcesOfSeedlings`', // Expression
            '`SourcesOfSeedlings`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SourcesOfSeedlings`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SourcesOfSeedlings->InputTextType = "text";
        $this->SourcesOfSeedlings->Raw = true;
        $this->SourcesOfSeedlings->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SourcesOfSeedlings->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SourcesOfSeedlings'] = &$this->SourcesOfSeedlings;

        // TransDate
        $this->TransDate = new DbField(
            $this, // Table
            'x_TransDate', // Variable name
            'TransDate', // Name
            '`TransDate`', // Expression
            CastDateFieldForLike("`TransDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`TransDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TransDate->InputTextType = "text";
        $this->TransDate->Raw = true;
        $this->TransDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->TransDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TransDate'] = &$this->TransDate;

        // PreparedBy
        $this->PreparedBy = new DbField(
            $this, // Table
            'x_PreparedBy', // Variable name
            'PreparedBy', // Name
            '`PreparedBy`', // Expression
            '`PreparedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PreparedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PreparedBy->InputTextType = "text";
        $this->PreparedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PreparedBy'] = &$this->PreparedBy;

        // AuthorisedBy
        $this->AuthorisedBy = new DbField(
            $this, // Table
            'x_AuthorisedBy', // Variable name
            'AuthorisedBy', // Name
            '`AuthorisedBy`', // Expression
            '`AuthorisedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AuthorisedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AuthorisedBy->InputTextType = "text";
        $this->AuthorisedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['AuthorisedBy'] = &$this->AuthorisedBy;

        // GoodsReceived
        $this->GoodsReceived = new DbField(
            $this, // Table
            'x_GoodsReceived', // Variable name
            'GoodsReceived', // Name
            '`GoodsReceived`', // Expression
            '`GoodsReceived`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`GoodsReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->GoodsReceived->InputTextType = "text";
        $this->GoodsReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['GoodsReceived'] = &$this->GoodsReceived;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "farm_seed_allocate_offline";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->CampCode->DbValue = $row['CampCode'];
        $this->VillageCode->DbValue = $row['VillageCode'];
        $this->NRC->DbValue = $row['NRC'];
        $this->FarmerNo->DbValue = $row['FarmerNo'];
        $this->FarmNo->DbValue = $row['FarmNo'];
        $this->TransNo->DbValue = $row['TransNo'];
        $this->GRN->DbValue = $row['GRN'];
        $this->TreesAllocated->DbValue = $row['TreesAllocated'];
        $this->FarmingSeason->DbValue = $row['FarmingSeason'];
        $this->SeedType->DbValue = $row['SeedType'];
        $this->SourcesOfSeedlings->DbValue = $row['SourcesOfSeedlings'];
        $this->TransDate->DbValue = $row['TransDate'];
        $this->PreparedBy->DbValue = $row['PreparedBy'];
        $this->AuthorisedBy->DbValue = $row['AuthorisedBy'];
        $this->GoodsReceived->DbValue = $row['GoodsReceived'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("FarmSeedAllocateOfflineList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "FarmSeedAllocateOfflineView" => $Language->phrase("View"),
            "FarmSeedAllocateOfflineEdit" => $Language->phrase("Edit"),
            "FarmSeedAllocateOfflineAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "FarmSeedAllocateOfflineList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "FarmSeedAllocateOfflineView",
            Config("API_ADD_ACTION") => "FarmSeedAllocateOfflineAdd",
            Config("API_EDIT_ACTION") => "FarmSeedAllocateOfflineEdit",
            Config("API_DELETE_ACTION") => "FarmSeedAllocateOfflineDelete",
            Config("API_LIST_ACTION") => "FarmSeedAllocateOfflineList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "FarmSeedAllocateOfflineList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmSeedAllocateOfflineView", $parm);
        } else {
            $url = $this->keyUrl("FarmSeedAllocateOfflineView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "FarmSeedAllocateOfflineAdd?" . $parm;
        } else {
            $url = "FarmSeedAllocateOfflineAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("FarmSeedAllocateOfflineEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("FarmSeedAllocateOfflineList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("FarmSeedAllocateOfflineAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("FarmSeedAllocateOfflineList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("FarmSeedAllocateOfflineDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->TransNo->setDbValue($row['TransNo']);
        $this->GRN->setDbValue($row['GRN']);
        $this->TreesAllocated->setDbValue($row['TreesAllocated']);
        $this->FarmingSeason->setDbValue($row['FarmingSeason']);
        $this->SeedType->setDbValue($row['SeedType']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->TransDate->setDbValue($row['TransDate']);
        $this->PreparedBy->setDbValue($row['PreparedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
        $this->GoodsReceived->setDbValue($row['GoodsReceived']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "FarmSeedAllocateOfflineList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // NRC

        // FarmerNo

        // FarmNo

        // TransNo

        // GRN

        // TreesAllocated

        // FarmingSeason

        // SeedType

        // SourcesOfSeedlings

        // TransDate

        // PreparedBy

        // AuthorisedBy

        // GoodsReceived

        // ProvinceCode
        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->ViewValue = FormatNumber($this->ProvinceCode->ViewValue, $this->ProvinceCode->formatPattern());

        // DistrictCode
        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->ViewValue = FormatNumber($this->DistrictCode->ViewValue, $this->DistrictCode->formatPattern());

        // CampCode
        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
        $this->CampCode->ViewValue = FormatNumber($this->CampCode->ViewValue, $this->CampCode->formatPattern());

        // VillageCode
        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
        $this->VillageCode->ViewValue = FormatNumber($this->VillageCode->ViewValue, $this->VillageCode->formatPattern());

        // NRC
        $this->NRC->ViewValue = $this->NRC->CurrentValue;

        // FarmerNo
        $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->ViewValue = FormatNumber($this->FarmerNo->ViewValue, $this->FarmerNo->formatPattern());

        // FarmNo
        $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;
        $this->FarmNo->ViewValue = FormatNumber($this->FarmNo->ViewValue, $this->FarmNo->formatPattern());

        // TransNo
        $this->TransNo->ViewValue = $this->TransNo->CurrentValue;
        $this->TransNo->ViewValue = FormatNumber($this->TransNo->ViewValue, $this->TransNo->formatPattern());

        // GRN
        $this->GRN->ViewValue = $this->GRN->CurrentValue;

        // TreesAllocated
        $this->TreesAllocated->ViewValue = $this->TreesAllocated->CurrentValue;

        // FarmingSeason
        $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;
        $this->FarmingSeason->ViewValue = FormatNumber($this->FarmingSeason->ViewValue, $this->FarmingSeason->formatPattern());

        // SeedType
        $this->SeedType->ViewValue = $this->SeedType->CurrentValue;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
        $this->SourcesOfSeedlings->ViewValue = FormatNumber($this->SourcesOfSeedlings->ViewValue, $this->SourcesOfSeedlings->formatPattern());

        // TransDate
        $this->TransDate->ViewValue = $this->TransDate->CurrentValue;
        $this->TransDate->ViewValue = FormatDateTime($this->TransDate->ViewValue, $this->TransDate->formatPattern());

        // PreparedBy
        $this->PreparedBy->ViewValue = $this->PreparedBy->CurrentValue;

        // AuthorisedBy
        $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

        // GoodsReceived
        $this->GoodsReceived->ViewValue = $this->GoodsReceived->CurrentValue;

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // CampCode
        $this->CampCode->HrefValue = "";
        $this->CampCode->TooltipValue = "";

        // VillageCode
        $this->VillageCode->HrefValue = "";
        $this->VillageCode->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // FarmerNo
        $this->FarmerNo->HrefValue = "";
        $this->FarmerNo->TooltipValue = "";

        // FarmNo
        $this->FarmNo->HrefValue = "";
        $this->FarmNo->TooltipValue = "";

        // TransNo
        $this->TransNo->HrefValue = "";
        $this->TransNo->TooltipValue = "";

        // GRN
        $this->GRN->HrefValue = "";
        $this->GRN->TooltipValue = "";

        // TreesAllocated
        $this->TreesAllocated->HrefValue = "";
        $this->TreesAllocated->TooltipValue = "";

        // FarmingSeason
        $this->FarmingSeason->HrefValue = "";
        $this->FarmingSeason->TooltipValue = "";

        // SeedType
        $this->SeedType->HrefValue = "";
        $this->SeedType->TooltipValue = "";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->HrefValue = "";
        $this->SourcesOfSeedlings->TooltipValue = "";

        // TransDate
        $this->TransDate->HrefValue = "";
        $this->TransDate->TooltipValue = "";

        // PreparedBy
        $this->PreparedBy->HrefValue = "";
        $this->PreparedBy->TooltipValue = "";

        // AuthorisedBy
        $this->AuthorisedBy->HrefValue = "";
        $this->AuthorisedBy->TooltipValue = "";

        // GoodsReceived
        $this->GoodsReceived->HrefValue = "";
        $this->GoodsReceived->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        $this->ProvinceCode->EditValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
        if (strval($this->ProvinceCode->EditValue) != "" && is_numeric($this->ProvinceCode->EditValue)) {
            $this->ProvinceCode->EditValue = FormatNumber($this->ProvinceCode->EditValue, null);
        }

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        $this->DistrictCode->EditValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
        if (strval($this->DistrictCode->EditValue) != "" && is_numeric($this->DistrictCode->EditValue)) {
            $this->DistrictCode->EditValue = FormatNumber($this->DistrictCode->EditValue, null);
        }

        // CampCode
        $this->CampCode->setupEditAttributes();
        $this->CampCode->EditValue = $this->CampCode->CurrentValue;
        $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
        if (strval($this->CampCode->EditValue) != "" && is_numeric($this->CampCode->EditValue)) {
            $this->CampCode->EditValue = FormatNumber($this->CampCode->EditValue, null);
        }

        // VillageCode
        $this->VillageCode->setupEditAttributes();
        $this->VillageCode->EditValue = $this->VillageCode->CurrentValue;
        $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
        if (strval($this->VillageCode->EditValue) != "" && is_numeric($this->VillageCode->EditValue)) {
            $this->VillageCode->EditValue = FormatNumber($this->VillageCode->EditValue, null);
        }

        // NRC
        $this->NRC->setupEditAttributes();
        if (!$this->NRC->Raw) {
            $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
        }
        $this->NRC->EditValue = $this->NRC->CurrentValue;
        $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

        // FarmerNo
        $this->FarmerNo->setupEditAttributes();
        $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
        if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
            $this->FarmerNo->EditValue = FormatNumber($this->FarmerNo->EditValue, null);
        }

        // FarmNo
        $this->FarmNo->setupEditAttributes();
        $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;
        $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());
        if (strval($this->FarmNo->EditValue) != "" && is_numeric($this->FarmNo->EditValue)) {
            $this->FarmNo->EditValue = FormatNumber($this->FarmNo->EditValue, null);
        }

        // TransNo
        $this->TransNo->setupEditAttributes();
        $this->TransNo->EditValue = $this->TransNo->CurrentValue;
        $this->TransNo->PlaceHolder = RemoveHtml($this->TransNo->caption());
        if (strval($this->TransNo->EditValue) != "" && is_numeric($this->TransNo->EditValue)) {
            $this->TransNo->EditValue = FormatNumber($this->TransNo->EditValue, null);
        }

        // GRN
        $this->GRN->setupEditAttributes();
        if (!$this->GRN->Raw) {
            $this->GRN->CurrentValue = HtmlDecode($this->GRN->CurrentValue);
        }
        $this->GRN->EditValue = $this->GRN->CurrentValue;
        $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

        // TreesAllocated
        $this->TreesAllocated->setupEditAttributes();
        if (!$this->TreesAllocated->Raw) {
            $this->TreesAllocated->CurrentValue = HtmlDecode($this->TreesAllocated->CurrentValue);
        }
        $this->TreesAllocated->EditValue = $this->TreesAllocated->CurrentValue;
        $this->TreesAllocated->PlaceHolder = RemoveHtml($this->TreesAllocated->caption());

        // FarmingSeason
        $this->FarmingSeason->setupEditAttributes();
        $this->FarmingSeason->EditValue = $this->FarmingSeason->CurrentValue;
        $this->FarmingSeason->PlaceHolder = RemoveHtml($this->FarmingSeason->caption());
        if (strval($this->FarmingSeason->EditValue) != "" && is_numeric($this->FarmingSeason->EditValue)) {
            $this->FarmingSeason->EditValue = FormatNumber($this->FarmingSeason->EditValue, null);
        }

        // SeedType
        $this->SeedType->setupEditAttributes();
        if (!$this->SeedType->Raw) {
            $this->SeedType->CurrentValue = HtmlDecode($this->SeedType->CurrentValue);
        }
        $this->SeedType->EditValue = $this->SeedType->CurrentValue;
        $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->setupEditAttributes();
        $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->CurrentValue;
        $this->SourcesOfSeedlings->PlaceHolder = RemoveHtml($this->SourcesOfSeedlings->caption());
        if (strval($this->SourcesOfSeedlings->EditValue) != "" && is_numeric($this->SourcesOfSeedlings->EditValue)) {
            $this->SourcesOfSeedlings->EditValue = FormatNumber($this->SourcesOfSeedlings->EditValue, null);
        }

        // TransDate
        $this->TransDate->setupEditAttributes();
        $this->TransDate->EditValue = FormatDateTime($this->TransDate->CurrentValue, $this->TransDate->formatPattern());
        $this->TransDate->PlaceHolder = RemoveHtml($this->TransDate->caption());

        // PreparedBy
        $this->PreparedBy->setupEditAttributes();
        if (!$this->PreparedBy->Raw) {
            $this->PreparedBy->CurrentValue = HtmlDecode($this->PreparedBy->CurrentValue);
        }
        $this->PreparedBy->EditValue = $this->PreparedBy->CurrentValue;
        $this->PreparedBy->PlaceHolder = RemoveHtml($this->PreparedBy->caption());

        // AuthorisedBy
        $this->AuthorisedBy->setupEditAttributes();
        if (!$this->AuthorisedBy->Raw) {
            $this->AuthorisedBy->CurrentValue = HtmlDecode($this->AuthorisedBy->CurrentValue);
        }
        $this->AuthorisedBy->EditValue = $this->AuthorisedBy->CurrentValue;
        $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());

        // GoodsReceived
        $this->GoodsReceived->setupEditAttributes();
        $this->GoodsReceived->EditValue = $this->GoodsReceived->CurrentValue;
        $this->GoodsReceived->PlaceHolder = RemoveHtml($this->GoodsReceived->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->TransNo);
                    $doc->exportCaption($this->GRN);
                    $doc->exportCaption($this->TreesAllocated);
                    $doc->exportCaption($this->FarmingSeason);
                    $doc->exportCaption($this->SeedType);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->TransDate);
                    $doc->exportCaption($this->PreparedBy);
                    $doc->exportCaption($this->AuthorisedBy);
                    $doc->exportCaption($this->GoodsReceived);
                } else {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->TransNo);
                    $doc->exportCaption($this->GRN);
                    $doc->exportCaption($this->TreesAllocated);
                    $doc->exportCaption($this->FarmingSeason);
                    $doc->exportCaption($this->SeedType);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->TransDate);
                    $doc->exportCaption($this->PreparedBy);
                    $doc->exportCaption($this->AuthorisedBy);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->TransNo);
                        $doc->exportField($this->GRN);
                        $doc->exportField($this->TreesAllocated);
                        $doc->exportField($this->FarmingSeason);
                        $doc->exportField($this->SeedType);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->TransDate);
                        $doc->exportField($this->PreparedBy);
                        $doc->exportField($this->AuthorisedBy);
                        $doc->exportField($this->GoodsReceived);
                    } else {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->TransNo);
                        $doc->exportField($this->GRN);
                        $doc->exportField($this->TreesAllocated);
                        $doc->exportField($this->FarmingSeason);
                        $doc->exportField($this->SeedType);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->TransDate);
                        $doc->exportField($this->PreparedBy);
                        $doc->exportField($this->AuthorisedBy);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
