<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FarmSearch extends Farm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "FarmSearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmNo->setVisibility();
        $this->FarmerNo->Visible = false;
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->SeedlingsAllocated->setVisibility();
        $this->TreesPlantedEstimated->setVisibility();
        $this->FarmSizeEstimated->setVisibility();
        $this->FarmSizeVerified->setVisibility();
        $this->TreesPlantedVerified->setVisibility();
        $this->SourcesOfSeedlings->setVisibility();
        $this->InspecationReport->setVisibility();
        $this->ClearedLand->setVisibility();
        $this->OldTrees->setVisibility();
        $this->FarmSize->setVisibility();
        $this->Latitude->setVisibility();
        $this->Longitude->setVisibility();
        $this->Coordinates->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'farm';
        $this->TableName = 'farm';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm)
        if (!isset($GLOBALS["farm"]) || $GLOBALS["farm"]::class == PROJECT_NAMESPACE . "farm") {
            $GLOBALS["farm"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "FarmView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->FieldType);
        $this->setupLookupOptions($this->Ownership);
        $this->setupLookupOptions($this->SourcesOfSeedlings);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "FarmList" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->ProvinceCode); // ProvinceCode
        $this->buildSearchUrl($srchUrl, $this->DistrictCode); // DistrictCode
        $this->buildSearchUrl($srchUrl, $this->CampCode); // CampCode
        $this->buildSearchUrl($srchUrl, $this->VillageCode); // VillageCode
        $this->buildSearchUrl($srchUrl, $this->NRC); // NRC
        $this->buildSearchUrl($srchUrl, $this->FarmNo); // FarmNo
        $this->buildSearchUrl($srchUrl, $this->FieldType); // FieldType
        $this->buildSearchUrl($srchUrl, $this->Ownership); // Ownership
        $this->buildSearchUrl($srchUrl, $this->SeedlingsAllocated); // SeedlingsAllocated
        $this->buildSearchUrl($srchUrl, $this->TreesPlantedEstimated); // TreesPlantedEstimated
        $this->buildSearchUrl($srchUrl, $this->FarmSizeEstimated); // FarmSizeEstimated
        $this->buildSearchUrl($srchUrl, $this->FarmSizeVerified); // FarmSizeVerified
        $this->buildSearchUrl($srchUrl, $this->TreesPlantedVerified); // TreesPlantedVerified
        $this->buildSearchUrl($srchUrl, $this->SourcesOfSeedlings); // SourcesOfSeedlings
        $this->buildSearchUrl($srchUrl, $this->InspecationReport); // InspecationReport
        $this->buildSearchUrl($srchUrl, $this->ClearedLand); // ClearedLand
        $this->buildSearchUrl($srchUrl, $this->OldTrees); // OldTrees
        $this->buildSearchUrl($srchUrl, $this->FarmSize); // FarmSize
        $this->buildSearchUrl($srchUrl, $this->Latitude); // Latitude
        $this->buildSearchUrl($srchUrl, $this->Longitude); // Longitude
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // ProvinceCode
        if ($this->ProvinceCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // DistrictCode
        if ($this->DistrictCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // CampCode
        if ($this->CampCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // VillageCode
        if ($this->VillageCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // NRC
        if ($this->NRC->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmNo
        if ($this->FarmNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FieldType
        if ($this->FieldType->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Ownership
        if ($this->Ownership->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SeedlingsAllocated
        if ($this->SeedlingsAllocated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // TreesPlantedEstimated
        if ($this->TreesPlantedEstimated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmSizeEstimated
        if ($this->FarmSizeEstimated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmSizeVerified
        if ($this->FarmSizeVerified->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // TreesPlantedVerified
        if ($this->TreesPlantedVerified->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SourcesOfSeedlings
        if ($this->SourcesOfSeedlings->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // InspecationReport
        if ($this->InspecationReport->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ClearedLand
        if ($this->ClearedLand->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // OldTrees
        if ($this->OldTrees->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmSize
        if ($this->FarmSize->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Latitude
        if ($this->Latitude->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Longitude
        if ($this->Longitude->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmNo
        $this->FarmNo->RowCssClass = "row";

        // FarmerNo
        $this->FarmerNo->RowCssClass = "row";

        // FieldType
        $this->FieldType->RowCssClass = "row";

        // Ownership
        $this->Ownership->RowCssClass = "row";

        // SeedlingsAllocated
        $this->SeedlingsAllocated->RowCssClass = "row";

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->RowCssClass = "row";

        // FarmSizeEstimated
        $this->FarmSizeEstimated->RowCssClass = "row";

        // FarmSizeVerified
        $this->FarmSizeVerified->RowCssClass = "row";

        // TreesPlantedVerified
        $this->TreesPlantedVerified->RowCssClass = "row";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->RowCssClass = "row";

        // InspecationReport
        $this->InspecationReport->RowCssClass = "row";

        // ClearedLand
        $this->ClearedLand->RowCssClass = "row";

        // OldTrees
        $this->OldTrees->RowCssClass = "row";

        // FarmSize
        $this->FarmSize->RowCssClass = "row";

        // Latitude
        $this->Latitude->RowCssClass = "row";

        // Longitude
        $this->Longitude->RowCssClass = "row";

        // Coordinates
        $this->Coordinates->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // FieldType
            $curVal = strval($this->FieldType->CurrentValue);
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
                if ($this->FieldType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $curVal, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                    $sqlWrk = $this->FieldType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FieldType->Lookup->renderViewRow($rswrk[0]);
                        $this->FieldType->ViewValue = $this->FieldType->displayValue($arwrk);
                    } else {
                        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
                    }
                }
            } else {
                $this->FieldType->ViewValue = null;
            }

            // Ownership
            $curVal = strval($this->Ownership->CurrentValue);
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
                if ($this->Ownership->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $curVal, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                    $sqlWrk = $this->Ownership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Ownership->Lookup->renderViewRow($rswrk[0]);
                        $this->Ownership->ViewValue = $this->Ownership->displayValue($arwrk);
                    } else {
                        $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
                    }
                }
            } else {
                $this->Ownership->ViewValue = null;
            }

            // SeedlingsAllocated
            $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

            // FarmSizeEstimated
            $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
            $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

            // SourcesOfSeedlings
            $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
            if ($curVal != "") {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
                if ($this->SourcesOfSeedlings->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                    } else {
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
                    }
                }
            } else {
                $this->SourcesOfSeedlings->ViewValue = null;
            }

            // InspecationReport
            $this->InspecationReport->ViewValue = $this->InspecationReport->CurrentValue;

            // ClearedLand
            $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;

            // OldTrees
            $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";
            $this->ProvinceCode->TooltipValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
            $this->DistrictCode->TooltipValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";
            $this->CampCode->TooltipValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";
            $this->VillageCode->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";
            $this->FarmNo->TooltipValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";
            $this->Ownership->TooltipValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";
            $this->SeedlingsAllocated->TooltipValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";
            $this->TreesPlantedEstimated->TooltipValue = "";

            // FarmSizeEstimated
            $this->FarmSizeEstimated->HrefValue = "";
            $this->FarmSizeEstimated->TooltipValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";
            $this->FarmSizeVerified->TooltipValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
            $this->TreesPlantedVerified->TooltipValue = "";

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->HrefValue = "";
            $this->SourcesOfSeedlings->TooltipValue = "";

            // InspecationReport
            $this->InspecationReport->HrefValue = "";
            $this->InspecationReport->TooltipValue = "";

            // ClearedLand
            $this->ClearedLand->HrefValue = "";
            $this->ClearedLand->TooltipValue = "";

            // OldTrees
            $this->OldTrees->HrefValue = "";
            $this->OldTrees->TooltipValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";
            $this->FarmSize->TooltipValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";
            $this->Latitude->TooltipValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
            $this->Longitude->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            $curVal = trim(strval($this->ProvinceCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->ProvinceCode->AdvancedSearch->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
            } else {
                $this->ProvinceCode->AdvancedSearch->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ProvinceCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->AdvancedSearch->SearchValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                }
                $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ProvinceCode->EditValue = $arwrk;
            }
            $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());

            // DistrictCode
            $curVal = trim(strval($this->DistrictCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->DistrictCode->AdvancedSearch->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            } else {
                $this->DistrictCode->AdvancedSearch->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->DistrictCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                if ($this->DistrictCode->AdvancedSearch->ViewValue == "") {
                    $this->DistrictCode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->AdvancedSearch->SearchValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                    $this->DistrictCode->AdvancedSearch->ViewValue = $this->DistrictCode->displayValue($arwrk);
                } else {
                    $this->DistrictCode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->DistrictCode->EditValue = $arwrk;
            }
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());

            // CampCode
            $curVal = trim(strval($this->CampCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->CampCode->AdvancedSearch->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            } else {
                $this->CampCode->AdvancedSearch->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->CampCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                if ($this->CampCode->AdvancedSearch->ViewValue == "") {
                    $this->CampCode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->AdvancedSearch->SearchValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                    $this->CampCode->AdvancedSearch->ViewValue = $this->CampCode->displayValue($arwrk);
                } else {
                    $this->CampCode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->CampCode->EditValue = $arwrk;
            }
            $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());

            // VillageCode
            $curVal = trim(strval($this->VillageCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->VillageCode->AdvancedSearch->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
            } else {
                $this->VillageCode->AdvancedSearch->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->VillageCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                if ($this->VillageCode->AdvancedSearch->ViewValue == "") {
                    $this->VillageCode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->AdvancedSearch->SearchValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                    $this->VillageCode->AdvancedSearch->ViewValue = $this->VillageCode->displayValue($arwrk);
                } else {
                    $this->VillageCode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->VillageCode->EditValue = $arwrk;
            }
            $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->AdvancedSearch->SearchValue = HtmlDecode($this->NRC->AdvancedSearch->SearchValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->AdvancedSearch->SearchValue);
            $curVal = strval($this->NRC->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->NRC->EditValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->EditValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->EditValue = HtmlEncode($this->NRC->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->NRC->EditValue = null;
            }
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // FarmNo
            $this->FarmNo->setupEditAttributes();
            $this->FarmNo->EditValue = $this->FarmNo->AdvancedSearch->SearchValue;
            $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());

            // FieldType
            $this->FieldType->setupEditAttributes();
            $curVal = trim(strval($this->FieldType->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->FieldType->AdvancedSearch->ViewValue = $this->FieldType->lookupCacheOption($curVal);
            } else {
                $this->FieldType->AdvancedSearch->ViewValue = $this->FieldType->Lookup !== null && is_array($this->FieldType->lookupOptions()) && count($this->FieldType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FieldType->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->FieldType->EditValue = array_values($this->FieldType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $this->FieldType->AdvancedSearch->SearchValue, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                }
                $sqlWrk = $this->FieldType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->FieldType->EditValue = $arwrk;
            }
            $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

            // Ownership
            $this->Ownership->setupEditAttributes();
            $curVal = trim(strval($this->Ownership->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Ownership->AdvancedSearch->ViewValue = $this->Ownership->lookupCacheOption($curVal);
            } else {
                $this->Ownership->AdvancedSearch->ViewValue = $this->Ownership->Lookup !== null && is_array($this->Ownership->lookupOptions()) && count($this->Ownership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Ownership->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Ownership->EditValue = array_values($this->Ownership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $this->Ownership->AdvancedSearch->SearchValue, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                }
                $sqlWrk = $this->Ownership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Ownership->EditValue = $arwrk;
            }
            $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());

            // SeedlingsAllocated
            $this->SeedlingsAllocated->setupEditAttributes();
            $this->SeedlingsAllocated->EditValue = $this->SeedlingsAllocated->AdvancedSearch->SearchValue;
            $this->SeedlingsAllocated->PlaceHolder = RemoveHtml($this->SeedlingsAllocated->caption());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->setupEditAttributes();
            $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->AdvancedSearch->SearchValue;
            $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());

            // FarmSizeEstimated
            $this->FarmSizeEstimated->setupEditAttributes();
            $this->FarmSizeEstimated->EditValue = $this->FarmSizeEstimated->AdvancedSearch->SearchValue;
            $this->FarmSizeEstimated->PlaceHolder = RemoveHtml($this->FarmSizeEstimated->caption());

            // FarmSizeVerified
            $this->FarmSizeVerified->setupEditAttributes();
            $this->FarmSizeVerified->EditValue = $this->FarmSizeVerified->AdvancedSearch->SearchValue;
            $this->FarmSizeVerified->PlaceHolder = RemoveHtml($this->FarmSizeVerified->caption());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->setupEditAttributes();
            $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->AdvancedSearch->SearchValue;
            $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->setupEditAttributes();
            $curVal = trim(strval($this->SourcesOfSeedlings->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->SourcesOfSeedlings->AdvancedSearch->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
            } else {
                $this->SourcesOfSeedlings->AdvancedSearch->ViewValue = $this->SourcesOfSeedlings->Lookup !== null && is_array($this->SourcesOfSeedlings->lookupOptions()) && count($this->SourcesOfSeedlings->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SourcesOfSeedlings->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->SourcesOfSeedlings->EditValue = array_values($this->SourcesOfSeedlings->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $this->SourcesOfSeedlings->AdvancedSearch->SearchValue, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SourcesOfSeedlings->EditValue = $arwrk;
            }
            $this->SourcesOfSeedlings->PlaceHolder = RemoveHtml($this->SourcesOfSeedlings->caption());

            // InspecationReport
            $this->InspecationReport->setupEditAttributes();
            $this->InspecationReport->EditValue = HtmlEncode($this->InspecationReport->AdvancedSearch->SearchValue);
            $this->InspecationReport->PlaceHolder = RemoveHtml($this->InspecationReport->caption());

            // ClearedLand
            $this->ClearedLand->setupEditAttributes();
            if (!$this->ClearedLand->Raw) {
                $this->ClearedLand->AdvancedSearch->SearchValue = HtmlDecode($this->ClearedLand->AdvancedSearch->SearchValue);
            }
            $this->ClearedLand->EditValue = HtmlEncode($this->ClearedLand->AdvancedSearch->SearchValue);
            $this->ClearedLand->PlaceHolder = RemoveHtml($this->ClearedLand->caption());

            // OldTrees
            $this->OldTrees->setupEditAttributes();
            if (!$this->OldTrees->Raw) {
                $this->OldTrees->AdvancedSearch->SearchValue = HtmlDecode($this->OldTrees->AdvancedSearch->SearchValue);
            }
            $this->OldTrees->EditValue = HtmlEncode($this->OldTrees->AdvancedSearch->SearchValue);
            $this->OldTrees->PlaceHolder = RemoveHtml($this->OldTrees->caption());

            // FarmSize
            $this->FarmSize->setupEditAttributes();
            if (!$this->FarmSize->Raw) {
                $this->FarmSize->AdvancedSearch->SearchValue = HtmlDecode($this->FarmSize->AdvancedSearch->SearchValue);
            }
            $this->FarmSize->EditValue = HtmlEncode($this->FarmSize->AdvancedSearch->SearchValue);
            $this->FarmSize->PlaceHolder = RemoveHtml($this->FarmSize->caption());

            // Latitude
            $this->Latitude->setupEditAttributes();
            $this->Latitude->EditValue = $this->Latitude->AdvancedSearch->SearchValue;
            $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());

            // Longitude
            $this->Longitude->setupEditAttributes();
            $this->Longitude->EditValue = $this->Longitude->AdvancedSearch->SearchValue;
            $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->FarmNo->AdvancedSearch->SearchValue)) {
            $this->FarmNo->addErrorMessage($this->FarmNo->getErrorMessage(false));
        }
        if (!CheckNumber($this->SeedlingsAllocated->AdvancedSearch->SearchValue)) {
            $this->SeedlingsAllocated->addErrorMessage($this->SeedlingsAllocated->getErrorMessage(false));
        }
        if (!CheckNumber($this->TreesPlantedEstimated->AdvancedSearch->SearchValue)) {
            $this->TreesPlantedEstimated->addErrorMessage($this->TreesPlantedEstimated->getErrorMessage(false));
        }
        if (!CheckNumber($this->FarmSizeEstimated->AdvancedSearch->SearchValue)) {
            $this->FarmSizeEstimated->addErrorMessage($this->FarmSizeEstimated->getErrorMessage(false));
        }
        if (!CheckNumber($this->FarmSizeVerified->AdvancedSearch->SearchValue)) {
            $this->FarmSizeVerified->addErrorMessage($this->FarmSizeVerified->getErrorMessage(false));
        }
        if (!CheckNumber($this->TreesPlantedVerified->AdvancedSearch->SearchValue)) {
            $this->TreesPlantedVerified->addErrorMessage($this->TreesPlantedVerified->getErrorMessage(false));
        }
        if (!CheckNumber($this->Latitude->AdvancedSearch->SearchValue)) {
            $this->Latitude->addErrorMessage($this->Latitude->getErrorMessage(false));
        }
        if (!CheckNumber($this->Longitude->AdvancedSearch->SearchValue)) {
            $this->Longitude->addErrorMessage($this->Longitude->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->ProvinceCode->AdvancedSearch->load();
        $this->DistrictCode->AdvancedSearch->load();
        $this->CampCode->AdvancedSearch->load();
        $this->VillageCode->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->FarmNo->AdvancedSearch->load();
        $this->FieldType->AdvancedSearch->load();
        $this->Ownership->AdvancedSearch->load();
        $this->SeedlingsAllocated->AdvancedSearch->load();
        $this->TreesPlantedEstimated->AdvancedSearch->load();
        $this->FarmSizeEstimated->AdvancedSearch->load();
        $this->FarmSizeVerified->AdvancedSearch->load();
        $this->TreesPlantedVerified->AdvancedSearch->load();
        $this->SourcesOfSeedlings->AdvancedSearch->load();
        $this->InspecationReport->AdvancedSearch->load();
        $this->ClearedLand->AdvancedSearch->load();
        $this->OldTrees->AdvancedSearch->load();
        $this->FarmSize->AdvancedSearch->load();
        $this->Latitude->AdvancedSearch->load();
        $this->Longitude->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FarmList"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_NRC":
                    break;
                case "x_FieldType":
                    break;
                case "x_Ownership":
                    break;
                case "x_SourcesOfSeedlings":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
