<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FarmList extends Farm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "ffarmlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "FarmList";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmNo->Visible = false;
        $this->FarmerNo->Visible = false;
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->SeedlingsAllocated->setVisibility();
        $this->TreesPlantedEstimated->setVisibility();
        $this->FarmSizeEstimated->Visible = false;
        $this->FarmSizeVerified->Visible = false;
        $this->TreesPlantedVerified->setVisibility();
        $this->SourcesOfSeedlings->Visible = false;
        $this->InspecationReport->Visible = false;
        $this->ClearedLand->Visible = false;
        $this->OldTrees->Visible = false;
        $this->FarmSize->Visible = false;
        $this->Latitude->Visible = false;
        $this->Longitude->Visible = false;
        $this->Coordinates->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'farm';
        $this->TableName = 'farm';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm)
        if (!isset($GLOBALS["farm"]) || $GLOBALS["farm"]::class == PROJECT_NAMESPACE . "farm") {
            $GLOBALS["farm"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "FarmAdd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "FarmDelete";
        $this->MultiUpdateUrl = "FarmUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "FarmView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->FieldType);
        $this->setupLookupOptions($this->Ownership);
        $this->setupLookupOptions($this->SourcesOfSeedlings);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "ffarmgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);
        if ($this->Filter == "") {
            $this->Filter = "0=101";
            $this->SearchWhere = $this->Filter;
        }

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "farmer") {
            $masterTbl = Container("farmer");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("FarmerList"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "village") {
            $masterTbl = Container("village");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("VillageList"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("ffarmsrch");
        }
        $filterList = Concat($filterList, $this->ProvinceCode->AdvancedSearch->toJson(), ","); // Field ProvinceCode
        $filterList = Concat($filterList, $this->DistrictCode->AdvancedSearch->toJson(), ","); // Field DistrictCode
        $filterList = Concat($filterList, $this->CampCode->AdvancedSearch->toJson(), ","); // Field CampCode
        $filterList = Concat($filterList, $this->VillageCode->AdvancedSearch->toJson(), ","); // Field VillageCode
        $filterList = Concat($filterList, $this->NRC->AdvancedSearch->toJson(), ","); // Field NRC
        $filterList = Concat($filterList, $this->FarmNo->AdvancedSearch->toJson(), ","); // Field FarmNo
        $filterList = Concat($filterList, $this->FieldType->AdvancedSearch->toJson(), ","); // Field FieldType
        $filterList = Concat($filterList, $this->Ownership->AdvancedSearch->toJson(), ","); // Field Ownership
        $filterList = Concat($filterList, $this->SeedlingsAllocated->AdvancedSearch->toJson(), ","); // Field SeedlingsAllocated
        $filterList = Concat($filterList, $this->TreesPlantedEstimated->AdvancedSearch->toJson(), ","); // Field TreesPlantedEstimated
        $filterList = Concat($filterList, $this->FarmSizeEstimated->AdvancedSearch->toJson(), ","); // Field FarmSizeEstimated
        $filterList = Concat($filterList, $this->FarmSizeVerified->AdvancedSearch->toJson(), ","); // Field FarmSizeVerified
        $filterList = Concat($filterList, $this->TreesPlantedVerified->AdvancedSearch->toJson(), ","); // Field TreesPlantedVerified
        $filterList = Concat($filterList, $this->SourcesOfSeedlings->AdvancedSearch->toJson(), ","); // Field SourcesOfSeedlings
        $filterList = Concat($filterList, $this->InspecationReport->AdvancedSearch->toJson(), ","); // Field InspecationReport
        $filterList = Concat($filterList, $this->ClearedLand->AdvancedSearch->toJson(), ","); // Field ClearedLand
        $filterList = Concat($filterList, $this->OldTrees->AdvancedSearch->toJson(), ","); // Field OldTrees
        $filterList = Concat($filterList, $this->FarmSize->AdvancedSearch->toJson(), ","); // Field FarmSize
        $filterList = Concat($filterList, $this->Latitude->AdvancedSearch->toJson(), ","); // Field Latitude
        $filterList = Concat($filterList, $this->Longitude->AdvancedSearch->toJson(), ","); // Field Longitude
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("ffarmsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field ProvinceCode
        $this->ProvinceCode->AdvancedSearch->SearchValue = @$filter["x_ProvinceCode"];
        $this->ProvinceCode->AdvancedSearch->SearchOperator = @$filter["z_ProvinceCode"];
        $this->ProvinceCode->AdvancedSearch->SearchCondition = @$filter["v_ProvinceCode"];
        $this->ProvinceCode->AdvancedSearch->SearchValue2 = @$filter["y_ProvinceCode"];
        $this->ProvinceCode->AdvancedSearch->SearchOperator2 = @$filter["w_ProvinceCode"];
        $this->ProvinceCode->AdvancedSearch->save();

        // Field DistrictCode
        $this->DistrictCode->AdvancedSearch->SearchValue = @$filter["x_DistrictCode"];
        $this->DistrictCode->AdvancedSearch->SearchOperator = @$filter["z_DistrictCode"];
        $this->DistrictCode->AdvancedSearch->SearchCondition = @$filter["v_DistrictCode"];
        $this->DistrictCode->AdvancedSearch->SearchValue2 = @$filter["y_DistrictCode"];
        $this->DistrictCode->AdvancedSearch->SearchOperator2 = @$filter["w_DistrictCode"];
        $this->DistrictCode->AdvancedSearch->save();

        // Field CampCode
        $this->CampCode->AdvancedSearch->SearchValue = @$filter["x_CampCode"];
        $this->CampCode->AdvancedSearch->SearchOperator = @$filter["z_CampCode"];
        $this->CampCode->AdvancedSearch->SearchCondition = @$filter["v_CampCode"];
        $this->CampCode->AdvancedSearch->SearchValue2 = @$filter["y_CampCode"];
        $this->CampCode->AdvancedSearch->SearchOperator2 = @$filter["w_CampCode"];
        $this->CampCode->AdvancedSearch->save();

        // Field VillageCode
        $this->VillageCode->AdvancedSearch->SearchValue = @$filter["x_VillageCode"];
        $this->VillageCode->AdvancedSearch->SearchOperator = @$filter["z_VillageCode"];
        $this->VillageCode->AdvancedSearch->SearchCondition = @$filter["v_VillageCode"];
        $this->VillageCode->AdvancedSearch->SearchValue2 = @$filter["y_VillageCode"];
        $this->VillageCode->AdvancedSearch->SearchOperator2 = @$filter["w_VillageCode"];
        $this->VillageCode->AdvancedSearch->save();

        // Field NRC
        $this->NRC->AdvancedSearch->SearchValue = @$filter["x_NRC"];
        $this->NRC->AdvancedSearch->SearchOperator = @$filter["z_NRC"];
        $this->NRC->AdvancedSearch->SearchCondition = @$filter["v_NRC"];
        $this->NRC->AdvancedSearch->SearchValue2 = @$filter["y_NRC"];
        $this->NRC->AdvancedSearch->SearchOperator2 = @$filter["w_NRC"];
        $this->NRC->AdvancedSearch->save();

        // Field FarmNo
        $this->FarmNo->AdvancedSearch->SearchValue = @$filter["x_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchOperator = @$filter["z_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchCondition = @$filter["v_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchValue2 = @$filter["y_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchOperator2 = @$filter["w_FarmNo"];
        $this->FarmNo->AdvancedSearch->save();

        // Field FieldType
        $this->FieldType->AdvancedSearch->SearchValue = @$filter["x_FieldType"];
        $this->FieldType->AdvancedSearch->SearchOperator = @$filter["z_FieldType"];
        $this->FieldType->AdvancedSearch->SearchCondition = @$filter["v_FieldType"];
        $this->FieldType->AdvancedSearch->SearchValue2 = @$filter["y_FieldType"];
        $this->FieldType->AdvancedSearch->SearchOperator2 = @$filter["w_FieldType"];
        $this->FieldType->AdvancedSearch->save();

        // Field Ownership
        $this->Ownership->AdvancedSearch->SearchValue = @$filter["x_Ownership"];
        $this->Ownership->AdvancedSearch->SearchOperator = @$filter["z_Ownership"];
        $this->Ownership->AdvancedSearch->SearchCondition = @$filter["v_Ownership"];
        $this->Ownership->AdvancedSearch->SearchValue2 = @$filter["y_Ownership"];
        $this->Ownership->AdvancedSearch->SearchOperator2 = @$filter["w_Ownership"];
        $this->Ownership->AdvancedSearch->save();

        // Field SeedlingsAllocated
        $this->SeedlingsAllocated->AdvancedSearch->SearchValue = @$filter["x_SeedlingsAllocated"];
        $this->SeedlingsAllocated->AdvancedSearch->SearchOperator = @$filter["z_SeedlingsAllocated"];
        $this->SeedlingsAllocated->AdvancedSearch->SearchCondition = @$filter["v_SeedlingsAllocated"];
        $this->SeedlingsAllocated->AdvancedSearch->SearchValue2 = @$filter["y_SeedlingsAllocated"];
        $this->SeedlingsAllocated->AdvancedSearch->SearchOperator2 = @$filter["w_SeedlingsAllocated"];
        $this->SeedlingsAllocated->AdvancedSearch->save();

        // Field TreesPlantedEstimated
        $this->TreesPlantedEstimated->AdvancedSearch->SearchValue = @$filter["x_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchOperator = @$filter["z_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchCondition = @$filter["v_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchValue2 = @$filter["y_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchOperator2 = @$filter["w_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->save();

        // Field FarmSizeEstimated
        $this->FarmSizeEstimated->AdvancedSearch->SearchValue = @$filter["x_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchOperator = @$filter["z_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchCondition = @$filter["v_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchValue2 = @$filter["y_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->save();

        // Field FarmSizeVerified
        $this->FarmSizeVerified->AdvancedSearch->SearchValue = @$filter["x_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchOperator = @$filter["z_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchCondition = @$filter["v_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchValue2 = @$filter["y_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->save();

        // Field TreesPlantedVerified
        $this->TreesPlantedVerified->AdvancedSearch->SearchValue = @$filter["x_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchOperator = @$filter["z_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchCondition = @$filter["v_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchValue2 = @$filter["y_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchOperator2 = @$filter["w_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->save();

        // Field SourcesOfSeedlings
        $this->SourcesOfSeedlings->AdvancedSearch->SearchValue = @$filter["x_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchOperator = @$filter["z_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchCondition = @$filter["v_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchValue2 = @$filter["y_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchOperator2 = @$filter["w_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->save();

        // Field InspecationReport
        $this->InspecationReport->AdvancedSearch->SearchValue = @$filter["x_InspecationReport"];
        $this->InspecationReport->AdvancedSearch->SearchOperator = @$filter["z_InspecationReport"];
        $this->InspecationReport->AdvancedSearch->SearchCondition = @$filter["v_InspecationReport"];
        $this->InspecationReport->AdvancedSearch->SearchValue2 = @$filter["y_InspecationReport"];
        $this->InspecationReport->AdvancedSearch->SearchOperator2 = @$filter["w_InspecationReport"];
        $this->InspecationReport->AdvancedSearch->save();

        // Field ClearedLand
        $this->ClearedLand->AdvancedSearch->SearchValue = @$filter["x_ClearedLand"];
        $this->ClearedLand->AdvancedSearch->SearchOperator = @$filter["z_ClearedLand"];
        $this->ClearedLand->AdvancedSearch->SearchCondition = @$filter["v_ClearedLand"];
        $this->ClearedLand->AdvancedSearch->SearchValue2 = @$filter["y_ClearedLand"];
        $this->ClearedLand->AdvancedSearch->SearchOperator2 = @$filter["w_ClearedLand"];
        $this->ClearedLand->AdvancedSearch->save();

        // Field OldTrees
        $this->OldTrees->AdvancedSearch->SearchValue = @$filter["x_OldTrees"];
        $this->OldTrees->AdvancedSearch->SearchOperator = @$filter["z_OldTrees"];
        $this->OldTrees->AdvancedSearch->SearchCondition = @$filter["v_OldTrees"];
        $this->OldTrees->AdvancedSearch->SearchValue2 = @$filter["y_OldTrees"];
        $this->OldTrees->AdvancedSearch->SearchOperator2 = @$filter["w_OldTrees"];
        $this->OldTrees->AdvancedSearch->save();

        // Field FarmSize
        $this->FarmSize->AdvancedSearch->SearchValue = @$filter["x_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchOperator = @$filter["z_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchCondition = @$filter["v_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchValue2 = @$filter["y_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSize"];
        $this->FarmSize->AdvancedSearch->save();

        // Field Latitude
        $this->Latitude->AdvancedSearch->SearchValue = @$filter["x_Latitude"];
        $this->Latitude->AdvancedSearch->SearchOperator = @$filter["z_Latitude"];
        $this->Latitude->AdvancedSearch->SearchCondition = @$filter["v_Latitude"];
        $this->Latitude->AdvancedSearch->SearchValue2 = @$filter["y_Latitude"];
        $this->Latitude->AdvancedSearch->SearchOperator2 = @$filter["w_Latitude"];
        $this->Latitude->AdvancedSearch->save();

        // Field Longitude
        $this->Longitude->AdvancedSearch->SearchValue = @$filter["x_Longitude"];
        $this->Longitude->AdvancedSearch->SearchOperator = @$filter["z_Longitude"];
        $this->Longitude->AdvancedSearch->SearchCondition = @$filter["v_Longitude"];
        $this->Longitude->AdvancedSearch->SearchValue2 = @$filter["y_Longitude"];
        $this->Longitude->AdvancedSearch->SearchOperator2 = @$filter["w_Longitude"];
        $this->Longitude->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->ProvinceCode, $default, false); // ProvinceCode
        $this->buildSearchSql($where, $this->DistrictCode, $default, false); // DistrictCode
        $this->buildSearchSql($where, $this->CampCode, $default, false); // CampCode
        $this->buildSearchSql($where, $this->VillageCode, $default, false); // VillageCode
        $this->buildSearchSql($where, $this->NRC, $default, false); // NRC
        $this->buildSearchSql($where, $this->FarmNo, $default, false); // FarmNo
        $this->buildSearchSql($where, $this->FieldType, $default, false); // FieldType
        $this->buildSearchSql($where, $this->Ownership, $default, false); // Ownership
        $this->buildSearchSql($where, $this->SeedlingsAllocated, $default, false); // SeedlingsAllocated
        $this->buildSearchSql($where, $this->TreesPlantedEstimated, $default, false); // TreesPlantedEstimated
        $this->buildSearchSql($where, $this->FarmSizeEstimated, $default, false); // FarmSizeEstimated
        $this->buildSearchSql($where, $this->FarmSizeVerified, $default, false); // FarmSizeVerified
        $this->buildSearchSql($where, $this->TreesPlantedVerified, $default, false); // TreesPlantedVerified
        $this->buildSearchSql($where, $this->SourcesOfSeedlings, $default, false); // SourcesOfSeedlings
        $this->buildSearchSql($where, $this->InspecationReport, $default, false); // InspecationReport
        $this->buildSearchSql($where, $this->ClearedLand, $default, false); // ClearedLand
        $this->buildSearchSql($where, $this->OldTrees, $default, false); // OldTrees
        $this->buildSearchSql($where, $this->FarmSize, $default, false); // FarmSize
        $this->buildSearchSql($where, $this->Latitude, $default, false); // Latitude
        $this->buildSearchSql($where, $this->Longitude, $default, false); // Longitude

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->ProvinceCode->AdvancedSearch->save(); // ProvinceCode
            $this->DistrictCode->AdvancedSearch->save(); // DistrictCode
            $this->CampCode->AdvancedSearch->save(); // CampCode
            $this->VillageCode->AdvancedSearch->save(); // VillageCode
            $this->NRC->AdvancedSearch->save(); // NRC
            $this->FarmNo->AdvancedSearch->save(); // FarmNo
            $this->FieldType->AdvancedSearch->save(); // FieldType
            $this->Ownership->AdvancedSearch->save(); // Ownership
            $this->SeedlingsAllocated->AdvancedSearch->save(); // SeedlingsAllocated
            $this->TreesPlantedEstimated->AdvancedSearch->save(); // TreesPlantedEstimated
            $this->FarmSizeEstimated->AdvancedSearch->save(); // FarmSizeEstimated
            $this->FarmSizeVerified->AdvancedSearch->save(); // FarmSizeVerified
            $this->TreesPlantedVerified->AdvancedSearch->save(); // TreesPlantedVerified
            $this->SourcesOfSeedlings->AdvancedSearch->save(); // SourcesOfSeedlings
            $this->InspecationReport->AdvancedSearch->save(); // InspecationReport
            $this->ClearedLand->AdvancedSearch->save(); // ClearedLand
            $this->OldTrees->AdvancedSearch->save(); // OldTrees
            $this->FarmSize->AdvancedSearch->save(); // FarmSize
            $this->Latitude->AdvancedSearch->save(); // Latitude
            $this->Longitude->AdvancedSearch->save(); // Longitude

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field ProvinceCode
        $filter = $this->queryBuilderWhere("ProvinceCode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ProvinceCode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ProvinceCode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field DistrictCode
        $filter = $this->queryBuilderWhere("DistrictCode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->DistrictCode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->DistrictCode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field CampCode
        $filter = $this->queryBuilderWhere("CampCode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->CampCode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->CampCode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field VillageCode
        $filter = $this->queryBuilderWhere("VillageCode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->VillageCode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->VillageCode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NRC
        $filter = $this->queryBuilderWhere("NRC");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NRC, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NRC->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FieldType
        $filter = $this->queryBuilderWhere("FieldType");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FieldType, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FieldType->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Ownership
        $filter = $this->queryBuilderWhere("Ownership");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Ownership, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Ownership->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field SeedlingsAllocated
        $filter = $this->queryBuilderWhere("SeedlingsAllocated");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->SeedlingsAllocated, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->SeedlingsAllocated->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TreesPlantedEstimated
        $filter = $this->queryBuilderWhere("TreesPlantedEstimated");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TreesPlantedEstimated, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TreesPlantedEstimated->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TreesPlantedVerified
        $filter = $this->queryBuilderWhere("TreesPlantedVerified");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TreesPlantedVerified, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TreesPlantedVerified->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->NRC;
        $searchFlds[] = &$this->InspecationReport;
        $searchFlds[] = &$this->ClearedLand;
        $searchFlds[] = &$this->OldTrees;
        $searchFlds[] = &$this->FarmSize;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->ProvinceCode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->DistrictCode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->CampCode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->VillageCode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NRC->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmNo->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FieldType->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Ownership->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->SeedlingsAllocated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TreesPlantedEstimated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmSizeEstimated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmSizeVerified->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TreesPlantedVerified->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->SourcesOfSeedlings->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->InspecationReport->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ClearedLand->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->OldTrees->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmSize->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Latitude->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Longitude->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->ProvinceCode->AdvancedSearch->unsetSession();
        $this->DistrictCode->AdvancedSearch->unsetSession();
        $this->CampCode->AdvancedSearch->unsetSession();
        $this->VillageCode->AdvancedSearch->unsetSession();
        $this->NRC->AdvancedSearch->unsetSession();
        $this->FarmNo->AdvancedSearch->unsetSession();
        $this->FieldType->AdvancedSearch->unsetSession();
        $this->Ownership->AdvancedSearch->unsetSession();
        $this->SeedlingsAllocated->AdvancedSearch->unsetSession();
        $this->TreesPlantedEstimated->AdvancedSearch->unsetSession();
        $this->FarmSizeEstimated->AdvancedSearch->unsetSession();
        $this->FarmSizeVerified->AdvancedSearch->unsetSession();
        $this->TreesPlantedVerified->AdvancedSearch->unsetSession();
        $this->SourcesOfSeedlings->AdvancedSearch->unsetSession();
        $this->InspecationReport->AdvancedSearch->unsetSession();
        $this->ClearedLand->AdvancedSearch->unsetSession();
        $this->OldTrees->AdvancedSearch->unsetSession();
        $this->FarmSize->AdvancedSearch->unsetSession();
        $this->Latitude->AdvancedSearch->unsetSession();
        $this->Longitude->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->ProvinceCode->AdvancedSearch->load();
        $this->DistrictCode->AdvancedSearch->load();
        $this->CampCode->AdvancedSearch->load();
        $this->VillageCode->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->FarmNo->AdvancedSearch->load();
        $this->FieldType->AdvancedSearch->load();
        $this->Ownership->AdvancedSearch->load();
        $this->SeedlingsAllocated->AdvancedSearch->load();
        $this->TreesPlantedEstimated->AdvancedSearch->load();
        $this->FarmSizeEstimated->AdvancedSearch->load();
        $this->FarmSizeVerified->AdvancedSearch->load();
        $this->TreesPlantedVerified->AdvancedSearch->load();
        $this->SourcesOfSeedlings->AdvancedSearch->load();
        $this->InspecationReport->AdvancedSearch->load();
        $this->ClearedLand->AdvancedSearch->load();
        $this->OldTrees->AdvancedSearch->load();
        $this->FarmSize->AdvancedSearch->load();
        $this->Latitude->AdvancedSearch->load();
        $this->Longitude->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->ProvinceCode); // ProvinceCode
            $this->updateSort($this->DistrictCode); // DistrictCode
            $this->updateSort($this->CampCode); // CampCode
            $this->updateSort($this->VillageCode); // VillageCode
            $this->updateSort($this->NRC); // NRC
            $this->updateSort($this->FieldType); // FieldType
            $this->updateSort($this->Ownership); // Ownership
            $this->updateSort($this->SeedlingsAllocated); // SeedlingsAllocated
            $this->updateSort($this->TreesPlantedEstimated); // TreesPlantedEstimated
            $this->updateSort($this->TreesPlantedVerified); // TreesPlantedVerified
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->NRC->setSessionValue("");
                        $this->ProvinceCode->setSessionValue("");
                        $this->DistrictCode->setSessionValue("");
                        $this->CampCode->setSessionValue("");
                        $this->VillageCode->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->ProvinceCode->setSort("");
                $this->DistrictCode->setSort("");
                $this->CampCode->setSort("");
                $this->VillageCode->setSort("");
                $this->NRC->setSort("");
                $this->FarmNo->setSort("");
                $this->FarmerNo->setSort("");
                $this->FieldType->setSort("");
                $this->Ownership->setSort("");
                $this->SeedlingsAllocated->setSort("");
                $this->TreesPlantedEstimated->setSort("");
                $this->FarmSizeEstimated->setSort("");
                $this->FarmSizeVerified->setSort("");
                $this->TreesPlantedVerified->setSort("");
                $this->SourcesOfSeedlings->setSort("");
                $this->InspecationReport->setSort("");
                $this->ClearedLand->setSort("");
                $this->OldTrees->setSort("");
                $this->FarmSize->setSort("");
                $this->Latitude->setSort("");
                $this->Longitude->setSort("");
                $this->Coordinates->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // "detail_farm_seed_allocate"
        $item = &$this->ListOptions->add("detail_farm_seed_allocate");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'farm_seed_allocate');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_farm_inspection"
        $item = &$this->ListOptions->add("detail_farm_inspection");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'farm_inspection');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_production_sales"
        $item = &$this->ListOptions->add("detail_production_sales");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'production_sales');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = true;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("farm_seed_allocate");
        $pages->add("farm_inspection");
        $pages->add("production_sales");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"farm\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"farm\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"farm\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"ffarmlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"ffarmlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_farm_seed_allocate"
        $opt = $this->ListOptions["detail_farm_seed_allocate"];
        if ($Security->allowList(CurrentProjectID() . 'farm_seed_allocate')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("farm_seed_allocate", "TblCaption");
            if (!$this->ShowMultipleDetails) { // Skip loading record count if show multiple details
                $detailTbl = Container("farm_seed_allocate");
                $detailFilter = $detailTbl->getDetailFilter($this);
                $detailTbl->setCurrentMasterTable($this->TableVar);
                $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $body .= "&nbsp;" . str_replace(["%c", "%s"], [Container("farm_seed_allocate")->Count, "blue"], $Language->phrase("DetailCount"));
            }
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("FarmSeedAllocateList?" . Config("TABLE_SHOW_MASTER") . "=farm&" . GetForeignKeyUrl("fk_ProvinceCode", $this->ProvinceCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_DistrictCode", $this->DistrictCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_CampCode", $this->CampCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_VillageCode", $this->VillageCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("FarmSeedAllocateGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "farm_seed_allocate";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "farm_seed_allocate";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "farm_seed_allocate";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_farm_inspection"
        $opt = $this->ListOptions["detail_farm_inspection"];
        if ($Security->allowList(CurrentProjectID() . 'farm_inspection')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("farm_inspection", "TblCaption");
            if (!$this->ShowMultipleDetails) { // Skip loading record count if show multiple details
                $detailTbl = Container("farm_inspection");
                $detailFilter = $detailTbl->getDetailFilter($this);
                $detailTbl->setCurrentMasterTable($this->TableVar);
                $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $body .= "&nbsp;" . str_replace(["%c", "%s"], [Container("farm_inspection")->Count, "blue"], $Language->phrase("DetailCount"));
            }
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("FarmInspectionList?" . Config("TABLE_SHOW_MASTER") . "=farm&" . GetForeignKeyUrl("fk_ProvinceCode", $this->ProvinceCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_DistrictCode", $this->DistrictCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_CampCode", $this->CampCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_VillageCode", $this->VillageCode->CurrentValue) . "&" . GetForeignKeyUrl("fk_NRC", $this->NRC->CurrentValue) . "&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("FarmInspectionGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "farm_inspection";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "farm_inspection";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "farm_inspection";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_production_sales"
        $opt = $this->ListOptions["detail_production_sales"];
        if ($Security->allowList(CurrentProjectID() . 'production_sales')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("production_sales", "TblCaption");
            if (!$this->ShowMultipleDetails) { // Skip loading record count if show multiple details
                $detailTbl = Container("production_sales");
                $detailFilter = $detailTbl->getDetailFilter($this);
                $detailTbl->setCurrentMasterTable($this->TableVar);
                $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $body .= "&nbsp;" . str_replace(["%c", "%s"], [Container("production_sales")->Count, "blue"], $Language->phrase("DetailCount"));
            }
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("ProductionSalesList?" . Config("TABLE_SHOW_MASTER") . "=farm&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->CurrentValue) . "&" . GetForeignKeyUrl("fk_NRC", $this->NRC->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProductionSalesGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "production_sales";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "production_sales";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "production_sales";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->FarmNo->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;

        // Preview extension
        $links = "";
        $detailFilters = [];
        $masterKeys = []; // Reset
        $masterKeys["ProvinceCode"] = strval($this->ProvinceCode->DbValue);
        $masterKeys["DistrictCode"] = strval($this->DistrictCode->DbValue);
        $masterKeys["CampCode"] = strval($this->CampCode->DbValue);
        $masterKeys["VillageCode"] = strval($this->VillageCode->DbValue);
        $masterKeys["FarmNo"] = strval($this->FarmNo->DbValue);

        // Column "detail_farm_seed_allocate"
        if ($this->DetailPages?->getItem("farm_seed_allocate")?->Visible && $Security->allowList(CurrentProjectID() . 'farm_seed_allocate')) {
            $link = "";
            $option = $this->ListOptions["detail_farm_seed_allocate"];
            $detailTbl = Container("farm_seed_allocate");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "FarmSeedAllocatePreview?t=farm&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"farm_seed_allocate\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'farm')) {
                $label = $Language->tablePhrase("farm_seed_allocate", "TblCaption");
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $detailFilters[$detailTbl->TableVar] = $detailFilter;
                $label .= "&nbsp;" . JsEncode(str_replace(["%c", "%s"], [$detailTbl->Count, "blue"], $Language->phrase("DetailCount")));
                $url .= "&detailfilters=%f";
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"farm_seed_allocate\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("FarmSeedAllocateList?" . Config("TABLE_SHOW_MASTER") . "=farm");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("farm_seed_allocate", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("FarmSeedAllocateGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["ProvinceCode"] = strval($this->ProvinceCode->DbValue);
        $masterKeys["DistrictCode"] = strval($this->DistrictCode->DbValue);
        $masterKeys["CampCode"] = strval($this->CampCode->DbValue);
        $masterKeys["VillageCode"] = strval($this->VillageCode->DbValue);
        $masterKeys["NRC"] = strval($this->NRC->DbValue);
        $masterKeys["FarmNo"] = strval($this->FarmNo->DbValue);

        // Column "detail_farm_inspection"
        if ($this->DetailPages?->getItem("farm_inspection")?->Visible && $Security->allowList(CurrentProjectID() . 'farm_inspection')) {
            $link = "";
            $option = $this->ListOptions["detail_farm_inspection"];
            $detailTbl = Container("farm_inspection");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "FarmInspectionPreview?t=farm&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"farm_inspection\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'farm')) {
                $label = $Language->tablePhrase("farm_inspection", "TblCaption");
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $detailFilters[$detailTbl->TableVar] = $detailFilter;
                $label .= "&nbsp;" . JsEncode(str_replace(["%c", "%s"], [$detailTbl->Count, "blue"], $Language->phrase("DetailCount")));
                $url .= "&detailfilters=%f";
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"farm_inspection\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("FarmInspectionList?" . Config("TABLE_SHOW_MASTER") . "=farm");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("farm_inspection", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("FarmInspectionGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["FarmNo"] = strval($this->FarmNo->DbValue);
        $masterKeys["NRC"] = strval($this->NRC->DbValue);

        // Column "detail_production_sales"
        if ($this->DetailPages?->getItem("production_sales")?->Visible && $Security->allowList(CurrentProjectID() . 'production_sales')) {
            $link = "";
            $option = $this->ListOptions["detail_production_sales"];
            $detailTbl = Container("production_sales");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "ProductionSalesPreview?t=farm&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"production_sales\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'farm')) {
                $label = $Language->tablePhrase("production_sales", "TblCaption");
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $detailFilters[$detailTbl->TableVar] = $detailFilter;
                $label .= "&nbsp;" . JsEncode(str_replace(["%c", "%s"], [$detailTbl->Count, "blue"], $Language->phrase("DetailCount")));
                $url .= "&detailfilters=%f";
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"production_sales\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("ProductionSalesList?" . Config("TABLE_SHOW_MASTER") . "=farm");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("production_sales", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProductionSalesGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        foreach ($this->ListOptions as $option) {
            if (str_starts_with($option->Name, "detail_") && str_contains($option->Body, "&detailfilters=%f")) {
                if (count($detailFilters) > 0) {
                    $encryptedFilters = Encrypt(JsonEncode($detailFilters));
                    $option->Body = str_replace("&detailfilters=%f", "&detailfilters=" . $encryptedFilters, $option->Body);
                    $links = str_replace("&detailfilters=%f", "&detailfilters=" . $encryptedFilters, $links);
                } else {
                    $option->Body = str_replace("&detailfilters=%f", "", $option->Body);
                    $links = str_replace("&detailfilters=%f", "", $links);
                }
            }
        }

        // Add row attributes for expandable row
        if ($this->RowType == RowType::VIEW) {
            $this->RowAttrs["data-widget"] = "expandable-table";
            $this->RowAttrs["aria-expanded"] = "false";
        }

        // Column "preview"
        $option = $this->ListOptions["preview"];
        if (!$option) { // Add preview column
            $option = &$this->ListOptions->add("preview");
            $option->OnLeft = true;
            $checkboxPos = $this->ListOptions->itemPos("checkbox");
            $pos = $checkboxPos === false
                ? ($option->OnLeft ? 0 : -1)
                : ($option->OnLeft ? $checkboxPos + 1 : $checkboxPos);
            $option->moveTo($pos);
            $option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit());
            $option->ShowInDropDown = false;
            $option->ShowInButtonGroup = false;
        }
        if ($option) {
            $icon = "fa-solid fa-caret-right fa-fw"; // Right
            if (property_exists($this, "MultiColumnLayout") && $this->MultiColumnLayout == "table") {
                $option->CssStyle = "width: 1%;";
                if (!$option->OnLeft) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            if (IsRTL()) { // Reverse
                if (preg_match('/\\bleft\\b/', $icon)) {
                    $icon = preg_replace('/\\bleft\\b/', "right", $icon);
                } elseif (preg_match('/\\bright\\b/', $icon)) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            $option->Body = "<i role=\"button\" class=\"ew-preview-btn expandable-table-caret ew-icon " . $icon . "\"></i>" .
                "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }

        // Column "details" (Multiple details)
        $option = $this->ListOptions["details"];
        if ($option) {
            $option->Body .= "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"farm\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
        $item = &$option->add("detailadd_farm_seed_allocate");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate");
        $detailPage = Container("FarmSeedAllocateGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'farm') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "farm_seed_allocate";
        }
        $item = &$option->add("detailadd_farm_inspection");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection");
        $detailPage = Container("FarmInspectionGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'farm') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "farm_inspection";
        }
        $item = &$option->add("detailadd_production_sales");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales");
        $detailPage = Container("ProductionSalesGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'farm') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "production_sales";
        }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "ProvinceCode");
            $this->createColumnOption($option, "DistrictCode");
            $this->createColumnOption($option, "CampCode");
            $this->createColumnOption($option, "VillageCode");
            $this->createColumnOption($option, "NRC");
            $this->createColumnOption($option, "FieldType");
            $this->createColumnOption($option, "Ownership");
            $this->createColumnOption($option, "SeedlingsAllocated");
            $this->createColumnOption($option, "TreesPlantedEstimated");
            $this->createColumnOption($option, "TreesPlantedVerified");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"ffarmsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"ffarmsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="ffarmlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_farm", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_farm",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // ProvinceCode
        if ($this->ProvinceCode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ProvinceCode->AdvancedSearch->SearchValue != "" || $this->ProvinceCode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // DistrictCode
        if ($this->DistrictCode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->DistrictCode->AdvancedSearch->SearchValue != "" || $this->DistrictCode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // CampCode
        if ($this->CampCode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->CampCode->AdvancedSearch->SearchValue != "" || $this->CampCode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // VillageCode
        if ($this->VillageCode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->VillageCode->AdvancedSearch->SearchValue != "" || $this->VillageCode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NRC
        if ($this->NRC->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NRC->AdvancedSearch->SearchValue != "" || $this->NRC->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmNo
        if ($this->FarmNo->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmNo->AdvancedSearch->SearchValue != "" || $this->FarmNo->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FieldType
        if ($this->FieldType->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FieldType->AdvancedSearch->SearchValue != "" || $this->FieldType->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Ownership
        if ($this->Ownership->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Ownership->AdvancedSearch->SearchValue != "" || $this->Ownership->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // SeedlingsAllocated
        if ($this->SeedlingsAllocated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->SeedlingsAllocated->AdvancedSearch->SearchValue != "" || $this->SeedlingsAllocated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TreesPlantedEstimated
        if ($this->TreesPlantedEstimated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TreesPlantedEstimated->AdvancedSearch->SearchValue != "" || $this->TreesPlantedEstimated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmSizeEstimated
        if ($this->FarmSizeEstimated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmSizeEstimated->AdvancedSearch->SearchValue != "" || $this->FarmSizeEstimated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmSizeVerified
        if ($this->FarmSizeVerified->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmSizeVerified->AdvancedSearch->SearchValue != "" || $this->FarmSizeVerified->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TreesPlantedVerified
        if ($this->TreesPlantedVerified->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TreesPlantedVerified->AdvancedSearch->SearchValue != "" || $this->TreesPlantedVerified->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // SourcesOfSeedlings
        if ($this->SourcesOfSeedlings->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->SourcesOfSeedlings->AdvancedSearch->SearchValue != "" || $this->SourcesOfSeedlings->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // InspecationReport
        if ($this->InspecationReport->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->InspecationReport->AdvancedSearch->SearchValue != "" || $this->InspecationReport->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ClearedLand
        if ($this->ClearedLand->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ClearedLand->AdvancedSearch->SearchValue != "" || $this->ClearedLand->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // OldTrees
        if ($this->OldTrees->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->OldTrees->AdvancedSearch->SearchValue != "" || $this->OldTrees->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmSize
        if ($this->FarmSize->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmSize->AdvancedSearch->SearchValue != "" || $this->FarmSize->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Latitude
        if ($this->Latitude->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Latitude->AdvancedSearch->SearchValue != "" || $this->Latitude->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Longitude
        if ($this->Longitude->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Longitude->AdvancedSearch->SearchValue != "" || $this->Longitude->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->SeedlingsAllocated->setDbValue($row['SeedlingsAllocated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->InspecationReport->setDbValue($row['InspecationReport']);
        $this->ClearedLand->setDbValue($row['ClearedLand']);
        $this->OldTrees->setDbValue($row['OldTrees']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->Coordinates->setDbValue($row['Coordinates']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['FarmerNo'] = $this->FarmerNo->DefaultValue;
        $row['FieldType'] = $this->FieldType->DefaultValue;
        $row['Ownership'] = $this->Ownership->DefaultValue;
        $row['SeedlingsAllocated'] = $this->SeedlingsAllocated->DefaultValue;
        $row['TreesPlantedEstimated'] = $this->TreesPlantedEstimated->DefaultValue;
        $row['FarmSizeEstimated'] = $this->FarmSizeEstimated->DefaultValue;
        $row['FarmSizeVerified'] = $this->FarmSizeVerified->DefaultValue;
        $row['TreesPlantedVerified'] = $this->TreesPlantedVerified->DefaultValue;
        $row['SourcesOfSeedlings'] = $this->SourcesOfSeedlings->DefaultValue;
        $row['InspecationReport'] = $this->InspecationReport->DefaultValue;
        $row['ClearedLand'] = $this->ClearedLand->DefaultValue;
        $row['OldTrees'] = $this->OldTrees->DefaultValue;
        $row['FarmSize'] = $this->FarmSize->DefaultValue;
        $row['Latitude'] = $this->Latitude->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        $row['Coordinates'] = $this->Coordinates->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // NRC

        // FarmNo

        // FarmerNo

        // FieldType

        // Ownership

        // SeedlingsAllocated

        // TreesPlantedEstimated

        // FarmSizeEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // SourcesOfSeedlings

        // InspecationReport

        // ClearedLand

        // OldTrees

        // FarmSize

        // Latitude

        // Longitude

        // Coordinates

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // FieldType
            $curVal = strval($this->FieldType->CurrentValue);
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
                if ($this->FieldType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $curVal, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                    $sqlWrk = $this->FieldType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FieldType->Lookup->renderViewRow($rswrk[0]);
                        $this->FieldType->ViewValue = $this->FieldType->displayValue($arwrk);
                    } else {
                        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
                    }
                }
            } else {
                $this->FieldType->ViewValue = null;
            }

            // Ownership
            $curVal = strval($this->Ownership->CurrentValue);
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
                if ($this->Ownership->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $curVal, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                    $sqlWrk = $this->Ownership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Ownership->Lookup->renderViewRow($rswrk[0]);
                        $this->Ownership->ViewValue = $this->Ownership->displayValue($arwrk);
                    } else {
                        $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
                    }
                }
            } else {
                $this->Ownership->ViewValue = null;
            }

            // SeedlingsAllocated
            $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

            // FarmSizeEstimated
            $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
            $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

            // SourcesOfSeedlings
            $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
            if ($curVal != "") {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
                if ($this->SourcesOfSeedlings->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                    } else {
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
                    }
                }
            } else {
                $this->SourcesOfSeedlings->ViewValue = null;
            }

            // ClearedLand
            $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;

            // OldTrees
            $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";
            $this->ProvinceCode->TooltipValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
            $this->DistrictCode->TooltipValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";
            $this->CampCode->TooltipValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";
            $this->VillageCode->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";
            if (!$this->isExport()) {
                $this->NRC->ViewValue = $this->highlightValue($this->NRC);
            }

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";
            $this->Ownership->TooltipValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";
            $this->SeedlingsAllocated->TooltipValue = "";
            if (!$this->isExport()) {
                $this->SeedlingsAllocated->ViewValue = $this->highlightValue($this->SeedlingsAllocated);
            }

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";
            $this->TreesPlantedEstimated->TooltipValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
            $this->TreesPlantedVerified->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->ProvinceCode->AdvancedSearch->load();
        $this->DistrictCode->AdvancedSearch->load();
        $this->CampCode->AdvancedSearch->load();
        $this->VillageCode->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->FarmNo->AdvancedSearch->load();
        $this->FieldType->AdvancedSearch->load();
        $this->Ownership->AdvancedSearch->load();
        $this->SeedlingsAllocated->AdvancedSearch->load();
        $this->TreesPlantedEstimated->AdvancedSearch->load();
        $this->FarmSizeEstimated->AdvancedSearch->load();
        $this->FarmSizeVerified->AdvancedSearch->load();
        $this->TreesPlantedVerified->AdvancedSearch->load();
        $this->SourcesOfSeedlings->AdvancedSearch->load();
        $this->InspecationReport->AdvancedSearch->load();
        $this->ClearedLand->AdvancedSearch->load();
        $this->OldTrees->AdvancedSearch->load();
        $this->FarmSize->AdvancedSearch->load();
        $this->Latitude->AdvancedSearch->load();
        $this->Longitude->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"ffarmlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"ffarmlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"ffarmlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="ffarmlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = true;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"ffarmsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ResetSearch") . "\" data-caption=\"" . $Language->phrase("ResetSearch") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ResetSearchBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ResetSearch") . "\" data-caption=\"" . $Language->phrase("ResetSearch") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ResetSearchBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"farm\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"FarmSearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"FarmSearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"ffarmsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Export master record
        if (Config("EXPORT_MASTER_RECORD") && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "farmer") {
            $farmer = new FarmerList();
            $rsmaster = $farmer->loadRs($this->DbMasterFilter); // Load master record
            if ($rsmaster) {
                if (!$this->isExport("csv") || Config("EXPORT_MASTER_RECORD_FOR_CSV")) {
                    $doc->setTable($farmer);
                    $farmer->exportDocument($doc, $rsmaster);
                    $doc->exportEmptyRow();
                    $doc->setTable($this);
                }
            }
        }

        // Export master record
        if (Config("EXPORT_MASTER_RECORD") && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "village") {
            $village = new VillageList();
            $rsmaster = $village->loadRs($this->DbMasterFilter); // Load master record
            if ($rsmaster) {
                if (!$this->isExport("csv") || Config("EXPORT_MASTER_RECORD_FOR_CSV")) {
                    $doc->setTable($village);
                    $village->exportDocument($doc, $rsmaster);
                    $doc->exportEmptyRow();
                    $doc->setTable($this);
                }
            }
        }

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "farmer") {
                $validMaster = true;
                $masterTbl = Container("farmer");
                if (($parm = Get("fk_NRC", Get("NRC"))) !== null) {
                    $masterTbl->NRC->setQueryStringValue($parm);
                    $this->NRC->QueryStringValue = $masterTbl->NRC->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->NRC->setSessionValue($this->NRC->QueryStringValue);
                    $foreignKeys["NRC"] = $this->NRC->QueryStringValue;
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "village") {
                $validMaster = true;
                $masterTbl = Container("village");
                if (($parm = Get("fk_ProvinceCode", Get("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setQueryStringValue($parm);
                    $this->ProvinceCode->QueryStringValue = $masterTbl->ProvinceCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->QueryStringValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->QueryStringValue;
                    if (!is_numeric($masterTbl->ProvinceCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_DistrictCode", Get("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setQueryStringValue($parm);
                    $this->DistrictCode->QueryStringValue = $masterTbl->DistrictCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->DistrictCode->setSessionValue($this->DistrictCode->QueryStringValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->QueryStringValue;
                    if (!is_numeric($masterTbl->DistrictCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_CampCode", Get("CampCode"))) !== null) {
                    $masterTbl->CampCode->setQueryStringValue($parm);
                    $this->CampCode->QueryStringValue = $masterTbl->CampCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->CampCode->setSessionValue($this->CampCode->QueryStringValue);
                    $foreignKeys["CampCode"] = $this->CampCode->QueryStringValue;
                    if (!is_numeric($masterTbl->CampCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_VillageCode", Get("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setQueryStringValue($parm);
                    $this->VillageCode->QueryStringValue = $masterTbl->VillageCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->VillageCode->setSessionValue($this->VillageCode->QueryStringValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->QueryStringValue;
                    if (!is_numeric($masterTbl->VillageCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "farmer") {
                $validMaster = true;
                $masterTbl = Container("farmer");
                if (($parm = Post("fk_NRC", Post("NRC"))) !== null) {
                    $masterTbl->NRC->setFormValue($parm);
                    $this->NRC->FormValue = $masterTbl->NRC->FormValue;
                    $this->NRC->setSessionValue($this->NRC->FormValue);
                    $foreignKeys["NRC"] = $this->NRC->FormValue;
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "village") {
                $validMaster = true;
                $masterTbl = Container("village");
                if (($parm = Post("fk_ProvinceCode", Post("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setFormValue($parm);
                    $this->ProvinceCode->FormValue = $masterTbl->ProvinceCode->FormValue;
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->FormValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->FormValue;
                    if (!is_numeric($masterTbl->ProvinceCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_DistrictCode", Post("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setFormValue($parm);
                    $this->DistrictCode->FormValue = $masterTbl->DistrictCode->FormValue;
                    $this->DistrictCode->setSessionValue($this->DistrictCode->FormValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->FormValue;
                    if (!is_numeric($masterTbl->DistrictCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_CampCode", Post("CampCode"))) !== null) {
                    $masterTbl->CampCode->setFormValue($parm);
                    $this->CampCode->FormValue = $masterTbl->CampCode->FormValue;
                    $this->CampCode->setSessionValue($this->CampCode->FormValue);
                    $foreignKeys["CampCode"] = $this->CampCode->FormValue;
                    if (!is_numeric($masterTbl->CampCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_VillageCode", Post("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setFormValue($parm);
                    $this->VillageCode->FormValue = $masterTbl->VillageCode->FormValue;
                    $this->VillageCode->setSessionValue($this->VillageCode->FormValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->FormValue;
                    if (!is_numeric($masterTbl->VillageCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Update URL
            $this->AddUrl = $this->addMasterUrl($this->AddUrl);
            $this->InlineAddUrl = $this->addMasterUrl($this->InlineAddUrl);
            $this->GridAddUrl = $this->addMasterUrl($this->GridAddUrl);
            $this->GridEditUrl = $this->addMasterUrl($this->GridEditUrl);
            $this->MultiEditUrl = $this->addMasterUrl($this->MultiEditUrl);

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb(); // Set up breadcrumb again for the master table
            }

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "farmer") {
                if (!array_key_exists("NRC", $foreignKeys)) { // Not current foreign key
                    $this->NRC->setSessionValue("");
                }
            }
            if ($masterTblVar != "village") {
                if (!array_key_exists("ProvinceCode", $foreignKeys)) { // Not current foreign key
                    $this->ProvinceCode->setSessionValue("");
                }
                if (!array_key_exists("DistrictCode", $foreignKeys)) { // Not current foreign key
                    $this->DistrictCode->setSessionValue("");
                }
                if (!array_key_exists("CampCode", $foreignKeys)) { // Not current foreign key
                    $this->CampCode->setSessionValue("");
                }
                if (!array_key_exists("VillageCode", $foreignKeys)) { // Not current foreign key
                    $this->VillageCode->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_NRC":
                    break;
                case "x_FieldType":
                    break;
                case "x_Ownership":
                    break;
                case "x_SourcesOfSeedlings":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && ($rule["value"] ?? false) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        ConvertSearchValue($fldVal, $fldOpr, $fld), // $fldVal
                                        $fldOpr,
                                        "", // $fldCond not used
                                        ConvertSearchValue($fldVal2, $fldOpr, $fld), // $fldVal2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
