<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class AwpSearch extends Awp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "AwpSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "AwpSearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->Component->setVisibility();
        $this->Subcomponent->setVisibility();
        $this->InvestmentCost->setVisibility();
        $this->Type->setVisibility();
        $this->CategoryofExpenditure->setVisibility();
        $this->Activity->setVisibility();
        $this->Implementer->setVisibility();
        $this->Indicator->setVisibility();
        $this->ProjectTarget->setVisibility();
        $this->_2017Target->setVisibility();
        $this->ProjectBudget->setVisibility();
        $this->StartMonth->setVisibility();
        $this->EndMonth->setVisibility();
        $this->LineNo->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'awp';
        $this->TableName = 'awp';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (awp)
        if (!isset($GLOBALS["awp"]) || $GLOBALS["awp"]::class == PROJECT_NAMESPACE . "awp") {
            $GLOBALS["awp"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'awp');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "AwpView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['LineNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->LineNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->StartMonth);
        $this->setupLookupOptions($this->EndMonth);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "AwpList" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->Component); // Component
        $this->buildSearchUrl($srchUrl, $this->Subcomponent); // Sub component
        $this->buildSearchUrl($srchUrl, $this->InvestmentCost); // Investment Cost
        $this->buildSearchUrl($srchUrl, $this->Type); // Type
        $this->buildSearchUrl($srchUrl, $this->CategoryofExpenditure); // Category of Expenditure
        $this->buildSearchUrl($srchUrl, $this->Activity); // Activity
        $this->buildSearchUrl($srchUrl, $this->Implementer); // Implementer
        $this->buildSearchUrl($srchUrl, $this->Indicator); // Indicator
        $this->buildSearchUrl($srchUrl, $this->ProjectTarget); // Project Target
        $this->buildSearchUrl($srchUrl, $this->_2017Target); // 2017 Target
        $this->buildSearchUrl($srchUrl, $this->ProjectBudget); // Project Budget
        $this->buildSearchUrl($srchUrl, $this->StartMonth); // StartMonth
        $this->buildSearchUrl($srchUrl, $this->EndMonth); // EndMonth
        $this->buildSearchUrl($srchUrl, $this->LineNo); // LineNo
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Component
        if ($this->Component->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Sub component
        if ($this->Subcomponent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Investment Cost
        if ($this->InvestmentCost->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Type
        if ($this->Type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Category of Expenditure
        if ($this->CategoryofExpenditure->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Activity
        if ($this->Activity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Implementer
        if ($this->Implementer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Indicator
        if ($this->Indicator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Project Target
        if ($this->ProjectTarget->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 2017 Target
        if ($this->_2017Target->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Project Budget
        if ($this->ProjectBudget->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // StartMonth
        if ($this->StartMonth->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // EndMonth
        if ($this->EndMonth->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // LineNo
        if ($this->LineNo->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Component
        $this->Component->RowCssClass = "row";

        // Sub component
        $this->Subcomponent->RowCssClass = "row";

        // Investment Cost
        $this->InvestmentCost->RowCssClass = "row";

        // Type
        $this->Type->RowCssClass = "row";

        // Category of Expenditure
        $this->CategoryofExpenditure->RowCssClass = "row";

        // Activity
        $this->Activity->RowCssClass = "row";

        // Implementer
        $this->Implementer->RowCssClass = "row";

        // Indicator
        $this->Indicator->RowCssClass = "row";

        // Project Target
        $this->ProjectTarget->RowCssClass = "row";

        // 2017 Target
        $this->_2017Target->RowCssClass = "row";

        // Project Budget
        $this->ProjectBudget->RowCssClass = "row";

        // StartMonth
        $this->StartMonth->RowCssClass = "row";

        // EndMonth
        $this->EndMonth->RowCssClass = "row";

        // LineNo
        $this->LineNo->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // Component
            $this->Component->ViewValue = $this->Component->CurrentValue;

            // Sub component
            $this->Subcomponent->ViewValue = $this->Subcomponent->CurrentValue;

            // Investment Cost
            $this->InvestmentCost->ViewValue = $this->InvestmentCost->CurrentValue;

            // Type
            $this->Type->ViewValue = $this->Type->CurrentValue;

            // Category of Expenditure
            $this->CategoryofExpenditure->ViewValue = $this->CategoryofExpenditure->CurrentValue;

            // Activity
            $this->Activity->ViewValue = $this->Activity->CurrentValue;

            // Implementer
            $this->Implementer->ViewValue = $this->Implementer->CurrentValue;

            // Indicator
            $this->Indicator->ViewValue = $this->Indicator->CurrentValue;

            // Project Target
            $this->ProjectTarget->ViewValue = $this->ProjectTarget->CurrentValue;
            $this->ProjectTarget->ViewValue = FormatNumber($this->ProjectTarget->ViewValue, $this->ProjectTarget->formatPattern());
            $this->ProjectTarget->CellCssStyle .= "text-align: right;";

            // 2017 Target
            $this->_2017Target->ViewValue = $this->_2017Target->CurrentValue;
            $this->_2017Target->ViewValue = FormatNumber($this->_2017Target->ViewValue, $this->_2017Target->formatPattern());
            $this->_2017Target->CellCssStyle .= "text-align: right;";

            // Project Budget
            $this->ProjectBudget->ViewValue = $this->ProjectBudget->CurrentValue;
            $this->ProjectBudget->ViewValue = FormatNumber($this->ProjectBudget->ViewValue, $this->ProjectBudget->formatPattern());
            $this->ProjectBudget->CellCssStyle .= "text-align: right;";

            // StartMonth
            $curVal = strval($this->StartMonth->CurrentValue);
            if ($curVal != "") {
                $this->StartMonth->ViewValue = $this->StartMonth->lookupCacheOption($curVal);
                if ($this->StartMonth->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $curVal, $this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                    $sqlWrk = $this->StartMonth->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->StartMonth->Lookup->renderViewRow($rswrk[0]);
                        $this->StartMonth->ViewValue = $this->StartMonth->displayValue($arwrk);
                    } else {
                        $this->StartMonth->ViewValue = $this->StartMonth->CurrentValue;
                    }
                }
            } else {
                $this->StartMonth->ViewValue = null;
            }

            // EndMonth
            $curVal = strval($this->EndMonth->CurrentValue);
            if ($curVal != "") {
                $this->EndMonth->ViewValue = $this->EndMonth->lookupCacheOption($curVal);
                if ($this->EndMonth->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $curVal, $this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                    $sqlWrk = $this->EndMonth->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->EndMonth->Lookup->renderViewRow($rswrk[0]);
                        $this->EndMonth->ViewValue = $this->EndMonth->displayValue($arwrk);
                    } else {
                        $this->EndMonth->ViewValue = $this->EndMonth->CurrentValue;
                    }
                }
            } else {
                $this->EndMonth->ViewValue = null;
            }

            // LineNo
            $this->LineNo->ViewValue = $this->LineNo->CurrentValue;

            // Component
            $this->Component->HrefValue = "";
            $this->Component->TooltipValue = "";

            // Sub component
            $this->Subcomponent->HrefValue = "";
            $this->Subcomponent->TooltipValue = "";

            // Investment Cost
            $this->InvestmentCost->HrefValue = "";
            $this->InvestmentCost->TooltipValue = "";

            // Type
            $this->Type->HrefValue = "";
            $this->Type->TooltipValue = "";

            // Category of Expenditure
            $this->CategoryofExpenditure->HrefValue = "";
            $this->CategoryofExpenditure->TooltipValue = "";

            // Activity
            $this->Activity->HrefValue = "";
            $this->Activity->TooltipValue = "";

            // Implementer
            $this->Implementer->HrefValue = "";
            $this->Implementer->TooltipValue = "";

            // Indicator
            $this->Indicator->HrefValue = "";
            $this->Indicator->TooltipValue = "";

            // Project Target
            $this->ProjectTarget->HrefValue = "";
            $this->ProjectTarget->TooltipValue = "";

            // 2017 Target
            $this->_2017Target->HrefValue = "";
            $this->_2017Target->TooltipValue = "";

            // Project Budget
            $this->ProjectBudget->HrefValue = "";
            $this->ProjectBudget->TooltipValue = "";

            // StartMonth
            $this->StartMonth->HrefValue = "";
            $this->StartMonth->TooltipValue = "";

            // EndMonth
            $this->EndMonth->HrefValue = "";
            $this->EndMonth->TooltipValue = "";

            // LineNo
            $this->LineNo->HrefValue = "";
            $this->LineNo->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // Component
            $this->Component->setupEditAttributes();
            $this->Component->EditValue = HtmlEncode($this->Component->AdvancedSearch->SearchValue);
            $this->Component->PlaceHolder = RemoveHtml($this->Component->caption());

            // Sub component
            $this->Subcomponent->setupEditAttributes();
            $this->Subcomponent->EditValue = HtmlEncode($this->Subcomponent->AdvancedSearch->SearchValue);
            $this->Subcomponent->PlaceHolder = RemoveHtml($this->Subcomponent->caption());

            // Investment Cost
            $this->InvestmentCost->setupEditAttributes();
            if (!$this->InvestmentCost->Raw) {
                $this->InvestmentCost->AdvancedSearch->SearchValue = HtmlDecode($this->InvestmentCost->AdvancedSearch->SearchValue);
            }
            $this->InvestmentCost->EditValue = HtmlEncode($this->InvestmentCost->AdvancedSearch->SearchValue);
            $this->InvestmentCost->PlaceHolder = RemoveHtml($this->InvestmentCost->caption());

            // Type
            $this->Type->setupEditAttributes();
            if (!$this->Type->Raw) {
                $this->Type->AdvancedSearch->SearchValue = HtmlDecode($this->Type->AdvancedSearch->SearchValue);
            }
            $this->Type->EditValue = HtmlEncode($this->Type->AdvancedSearch->SearchValue);
            $this->Type->PlaceHolder = RemoveHtml($this->Type->caption());

            // Category of Expenditure
            $this->CategoryofExpenditure->setupEditAttributes();
            $this->CategoryofExpenditure->EditValue = HtmlEncode($this->CategoryofExpenditure->AdvancedSearch->SearchValue);
            $this->CategoryofExpenditure->PlaceHolder = RemoveHtml($this->CategoryofExpenditure->caption());

            // Activity
            $this->Activity->setupEditAttributes();
            $this->Activity->EditValue = HtmlEncode($this->Activity->AdvancedSearch->SearchValue);
            $this->Activity->PlaceHolder = RemoveHtml($this->Activity->caption());

            // Implementer
            $this->Implementer->setupEditAttributes();
            if (!$this->Implementer->Raw) {
                $this->Implementer->AdvancedSearch->SearchValue = HtmlDecode($this->Implementer->AdvancedSearch->SearchValue);
            }
            $this->Implementer->EditValue = HtmlEncode($this->Implementer->AdvancedSearch->SearchValue);
            $this->Implementer->PlaceHolder = RemoveHtml($this->Implementer->caption());

            // Indicator
            $this->Indicator->setupEditAttributes();
            if (!$this->Indicator->Raw) {
                $this->Indicator->AdvancedSearch->SearchValue = HtmlDecode($this->Indicator->AdvancedSearch->SearchValue);
            }
            $this->Indicator->EditValue = HtmlEncode($this->Indicator->AdvancedSearch->SearchValue);
            $this->Indicator->PlaceHolder = RemoveHtml($this->Indicator->caption());

            // Project Target
            $this->ProjectTarget->setupEditAttributes();
            $this->ProjectTarget->EditValue = $this->ProjectTarget->AdvancedSearch->SearchValue;
            $this->ProjectTarget->PlaceHolder = RemoveHtml($this->ProjectTarget->caption());

            // 2017 Target
            $this->_2017Target->setupEditAttributes();
            $this->_2017Target->EditValue = $this->_2017Target->AdvancedSearch->SearchValue;
            $this->_2017Target->PlaceHolder = RemoveHtml($this->_2017Target->caption());

            // Project Budget
            $this->ProjectBudget->setupEditAttributes();
            $this->ProjectBudget->EditValue = $this->ProjectBudget->AdvancedSearch->SearchValue;
            $this->ProjectBudget->PlaceHolder = RemoveHtml($this->ProjectBudget->caption());

            // StartMonth
            $this->StartMonth->setupEditAttributes();
            $curVal = trim(strval($this->StartMonth->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->StartMonth->AdvancedSearch->ViewValue = $this->StartMonth->lookupCacheOption($curVal);
            } else {
                $this->StartMonth->AdvancedSearch->ViewValue = $this->StartMonth->Lookup !== null && is_array($this->StartMonth->lookupOptions()) && count($this->StartMonth->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->StartMonth->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->StartMonth->EditValue = array_values($this->StartMonth->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $this->StartMonth->AdvancedSearch->SearchValue, $this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->StartMonth->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->StartMonth->EditValue = $arwrk;
            }
            $this->StartMonth->PlaceHolder = RemoveHtml($this->StartMonth->caption());

            // EndMonth
            $this->EndMonth->setupEditAttributes();
            $curVal = trim(strval($this->EndMonth->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->EndMonth->AdvancedSearch->ViewValue = $this->EndMonth->lookupCacheOption($curVal);
            } else {
                $this->EndMonth->AdvancedSearch->ViewValue = $this->EndMonth->Lookup !== null && is_array($this->EndMonth->lookupOptions()) && count($this->EndMonth->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->EndMonth->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->EndMonth->EditValue = array_values($this->EndMonth->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $this->EndMonth->AdvancedSearch->SearchValue, $this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->EndMonth->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->EndMonth->EditValue = $arwrk;
            }
            $this->EndMonth->PlaceHolder = RemoveHtml($this->EndMonth->caption());

            // LineNo
            $this->LineNo->setupEditAttributes();
            $this->LineNo->EditValue = $this->LineNo->AdvancedSearch->SearchValue;
            $this->LineNo->PlaceHolder = RemoveHtml($this->LineNo->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckNumber($this->ProjectTarget->AdvancedSearch->SearchValue)) {
            $this->ProjectTarget->addErrorMessage($this->ProjectTarget->getErrorMessage(false));
        }
        if (!CheckNumber($this->_2017Target->AdvancedSearch->SearchValue)) {
            $this->_2017Target->addErrorMessage($this->_2017Target->getErrorMessage(false));
        }
        if (!CheckNumber($this->ProjectBudget->AdvancedSearch->SearchValue)) {
            $this->ProjectBudget->addErrorMessage($this->ProjectBudget->getErrorMessage(false));
        }
        if (!CheckInteger($this->LineNo->AdvancedSearch->SearchValue)) {
            $this->LineNo->addErrorMessage($this->LineNo->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->Component->AdvancedSearch->load();
        $this->Subcomponent->AdvancedSearch->load();
        $this->InvestmentCost->AdvancedSearch->load();
        $this->Type->AdvancedSearch->load();
        $this->CategoryofExpenditure->AdvancedSearch->load();
        $this->Activity->AdvancedSearch->load();
        $this->Implementer->AdvancedSearch->load();
        $this->Indicator->AdvancedSearch->load();
        $this->ProjectTarget->AdvancedSearch->load();
        $this->_2017Target->AdvancedSearch->load();
        $this->ProjectBudget->AdvancedSearch->load();
        $this->StartMonth->AdvancedSearch->load();
        $this->EndMonth->AdvancedSearch->load();
        $this->LineNo->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("AwpList"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_StartMonth":
                    break;
                case "x_EndMonth":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
